/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.yoUtilities.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGenerator;
import us.ihmc.robotics.math.functionGenerator.YoFunctionGeneratorMode;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.yoVariables.filters.AccelerationLimitedYoVariable;
import us.ihmc.yoVariables.filters.FilteredFiniteDifferenceYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class AccelerationLimitedYoVariableSCSTest {
    private static final boolean VISUALIZE = false;
    private static final boolean KEEPWINDOWSOPEN = false;
    private static final long SLEEPTIME = 10000L;
    private static final double EPSILON = 1.0E-8;
    private static double maxRate = 10.0;
    private static double maxAcceleration = 10.0;
    private static final double dt = 0.001;
    private static final double totalTime = 10.0;
    YoDouble raw;
    YoDouble alphaVariable;
    FilteredFiniteDifferenceYoVariable rawRate;
    FilteredFiniteDifferenceYoVariable rawAcceleration;
    private static double amplitude = 1.0;
    private static double frequency = 1.0;
    private static final double permissibleErrorRatio = 0.1;
    private static final boolean notifyListeners = true;
    private static final int bufferSize = 10005;
    private final Robot robot = new Robot("generic_robot");
    private String nameYo = "processed";
    private SimulationConstructionSet scs;
    private YoRegistry registry;
    private Random random = new Random(4546556L);

    private void setupSCSStuff() {
        this.registry = new YoRegistry("generic_registry");
        this.raw = new YoDouble("raw", this.registry);
        this.alphaVariable = new YoDouble("alpha", this.registry);
        this.alphaVariable.set(0.0);
        this.rawRate = new FilteredFiniteDifferenceYoVariable("rawRate", "", (DoubleProvider)this.alphaVariable, (DoubleProvider)this.raw, 0.001, this.registry);
        this.rawAcceleration = new FilteredFiniteDifferenceYoVariable("rawAcceleration", "", (DoubleProvider)this.alphaVariable, (DoubleProvider)this.rawRate, 0.001, this.registry);
    }

    @Test
    public void makeSureGUIIsNotUpWhenRunning() {
    }

    private void shutdownSCSStuff(SimulationConstructionSet scs) {
    }

    @Test
    public void test_ZeroVelocity() {
        this.setupSCSStuff();
        maxRate = Double.POSITIVE_INFINITY;
        maxAcceleration = Double.POSITIVE_INFINITY;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable("processed", this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, 0.001);
        try {
            YoDouble yoDouble = new YoDouble(this.nameYo, this.registry);
            Assert.fail();
        }
        catch (RuntimeException rte) {
            System.err.println("The previous namespace error was part of the AccelerationLimitedYoVariableTest.");
        }
        Assert.assertEquals((Object)this.nameYo, (Object)processed.getName());
        double constant = this.random.nextDouble();
        for (double time = 0.0; time < 10.0; time += 0.001) {
            this.raw.set(constant);
            this.rawRate.update(this.raw.getDoubleValue());
            this.rawAcceleration.update(this.rawRate.getDoubleValue());
            processed.update(this.raw.getDoubleValue());
            Assert.assertTrue((maxRate >= processed.getSmoothedRate().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((maxAcceleration >= processed.getSmoothedAcceleration().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertEquals((double)0.0, (double)processed.getSmoothedRate().getDoubleValue(), (double)1.0E-8);
            Assert.assertEquals((double)0.0, (double)processed.getSmoothedAcceleration().getDoubleValue(), (double)1.0E-8);
        }
        this.shutdownSCSStuff(this.scs);
    }

    @Test
    public void test_ConstantVelocity() {
        this.setupSCSStuff();
        maxRate = 5.0;
        maxAcceleration = 5.0;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable("processed", this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, 0.001);
        double value = this.random.nextDouble();
        for (double time = 0.0; time < 10.0; time += 0.001) {
            this.raw.set(value * time);
            this.rawRate.update(this.raw.getDoubleValue());
            this.rawAcceleration.update(this.rawRate.getDoubleValue());
            processed.update(this.raw.getDoubleValue());
            Assert.assertTrue((maxRate >= processed.getSmoothedRate().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((maxAcceleration >= processed.getSmoothedAcceleration().getDoubleValue() ? 1 : 0) != 0);
            if (!(time > 3.0)) continue;
            Assert.assertEquals((double)value, (double)processed.getSmoothedRate().getDoubleValue(), (double)1.0E-8);
            Assert.assertEquals((double)0.0, (double)processed.getSmoothedAcceleration().getDoubleValue(), (double)1.0E-8);
        }
        this.shutdownSCSStuff(this.scs);
    }

    @Test
    public void test_ConstantAcceleration_PlusInitialize() {
        this.setupSCSStuff();
        double arbitraryMultiplier = 10.0;
        double constant = arbitraryMultiplier * this.random.nextDouble();
        maxRate = 2.0 * constant * 10.0;
        maxAcceleration = 2.0 * constant;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable("processed", this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, 0.001);
        Assert.assertEquals((Object)this.nameYo, (Object)processed.getName());
        for (double time = 0.0; time < 10.0; time += 0.001) {
            this.raw.set(constant * time * time);
            this.rawRate.update(this.raw.getDoubleValue());
            this.rawAcceleration.update(this.rawRate.getDoubleValue());
            processed.update(this.raw.getDoubleValue());
            Assert.assertTrue((maxRate >= processed.getSmoothedRate().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((maxAcceleration >= processed.getSmoothedAcceleration().getDoubleValue() ? 1 : 0) != 0);
            if (time > 10.0) {
                Assert.assertEquals((double)(2.0 * constant * time), (double)processed.getSmoothedRate().getDoubleValue(), (double)1.0E-8);
                Assert.assertEquals((double)(2.0 * constant), (double)processed.getSmoothedAcceleration().getDoubleValue(), (double)1.0E-8);
            }
            processed.initialize(3.0);
            Assert.assertEquals((double)3.0, (double)processed.getDoubleValue(), (double)1.0E-8);
            Assert.assertTrue((boolean)processed.hasBeenInitialized());
            Assert.assertEquals((double)0.0, (double)processed.getSmoothedRate().getDoubleValue(), (double)1.0E-8);
            Assert.assertEquals((double)0.0, (double)processed.getSmoothedAcceleration().getDoubleValue(), (double)1.0E-8);
        }
        this.shutdownSCSStuff(this.scs);
    }

    @Test
    public void test_Sine_Plus_Reset_Plus_Update() {
        this.setupSCSStuff();
        maxRate = 1.0;
        maxAcceleration = 1.0;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable(this.nameYo, this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, 0.001);
        YoDouble timeYo = new YoDouble("time", this.registry);
        YoFunctionGenerator sineFunction = new YoFunctionGenerator("sineFunction", (DoubleProvider)timeYo, this.registry);
        sineFunction.setMode(YoFunctionGeneratorMode.SINE);
        frequency = 1.0;
        amplitude = 1.0;
        sineFunction.setFrequency(frequency);
        sineFunction.setAmplitude(amplitude);
        double value = 0.0;
        for (double time = 0.0; time < 10.0; time += 0.001) {
            timeYo.set(time);
            value = sineFunction.getValue();
            this.raw.set(value);
            this.rawRate.update(this.raw.getDoubleValue());
            this.rawAcceleration.update(this.rawRate.getDoubleValue());
            processed.update(this.raw.getDoubleValue());
            Assert.assertTrue((maxRate >= processed.getSmoothedRate().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((maxAcceleration >= processed.getSmoothedAcceleration().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getDoubleValue()) <= amplitude ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getSmoothedRate().getDoubleValue()) <= maxRate ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getSmoothedAcceleration().getDoubleValue()) <= maxAcceleration ? 1 : 0) != 0);
            processed.reset();
            Assert.assertFalse((boolean)processed.hasBeenInitialized());
            Assert.assertEquals((double)0.0, (double)processed.getSmoothedRate().getDoubleValue(), (double)1.0E-8);
            Assert.assertEquals((double)0.0, (double)processed.getSmoothedAcceleration().getDoubleValue(), (double)1.0E-8);
        }
        this.shutdownSCSStuff(this.scs);
    }

    @Test
    public void test_RiseTimeSquareWave() {
        this.setupSCSStuff();
        maxRate = 10000.0;
        maxAcceleration = 1000.0;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable(this.nameYo, this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, 0.001);
        YoDouble timeYo = new YoDouble("time", this.registry);
        amplitude = 1.0;
        double value = 0.0;
        for (double time = 0.0; time < 10.0; time += 0.001) {
            timeYo.set(time);
            value = time < 2.5 ? 0.0 : (time < 5.0 ? 1.0 : 0.0);
            this.raw.set(value);
            this.rawRate.update(this.raw.getDoubleValue());
            this.rawAcceleration.update(this.rawRate.getDoubleValue());
            processed.update(this.raw.getDoubleValue());
            Assert.assertTrue((maxRate >= processed.getSmoothedRate().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((maxAcceleration >= processed.getSmoothedAcceleration().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getDoubleValue()) <= amplitude ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getSmoothedRate().getDoubleValue()) <= maxRate ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getSmoothedAcceleration().getDoubleValue()) <= maxAcceleration ? 1 : 0) != 0);
        }
        this.shutdownSCSStuff(this.scs);
    }

    @Test
    public void test_SquareWaves() {
        this.setupSCSStuff();
        maxRate = 10000.0;
        maxAcceleration = 1000.0;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable(this.nameYo, this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, 0.001);
        YoDouble timeYo = new YoDouble("time", this.registry);
        YoFunctionGenerator squareFunction = new YoFunctionGenerator("sineFunction", (DoubleProvider)timeYo, this.registry);
        squareFunction.setMode(YoFunctionGeneratorMode.SQUARE);
        squareFunction.setFrequency(frequency);
        squareFunction.setAmplitude(amplitude);
        double value = 0.0;
        for (double time = 0.0; time < 10.0; time += 0.001) {
            timeYo.set(time);
            value = squareFunction.getValue();
            this.raw.set(value);
            this.rawRate.update(this.raw.getDoubleValue());
            this.rawAcceleration.update(this.rawRate.getDoubleValue());
            processed.update(this.raw.getDoubleValue());
            Assert.assertTrue((maxRate >= processed.getSmoothedRate().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((maxAcceleration >= processed.getSmoothedAcceleration().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getSmoothedRate().getDoubleValue()) <= maxRate ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getSmoothedAcceleration().getDoubleValue()) <= maxAcceleration ? 1 : 0) != 0);
        }
        this.shutdownSCSStuff(this.scs);
    }

    @Test
    public void test_Chirp_Plus_UpdateWithoutNoArguments() {
        this.setupSCSStuff();
        maxRate = 10000.0;
        maxAcceleration = 1000.0;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        YoDouble inputVariable = new YoDouble("inputVariable", this.registry);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable(this.nameYo, this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, (DoubleProvider)inputVariable, 0.001);
        YoDouble timeYo = new YoDouble("time", this.registry);
        YoFunctionGenerator chirpFunction = new YoFunctionGenerator("sineFunction", (DoubleProvider)timeYo, this.registry);
        chirpFunction.setMode(YoFunctionGeneratorMode.CHIRP_LINEAR);
        chirpFunction.setAmplitude(amplitude);
        double value = 0.0;
        for (double time = 0.0; time < 10.0; time += 0.001) {
            timeYo.set(time);
            value = chirpFunction.getValue();
            this.raw.set(value);
            this.rawRate.update(this.raw.getDoubleValue());
            this.rawAcceleration.update(this.rawRate.getDoubleValue());
            inputVariable.set(this.raw.getDoubleValue());
            double beforeValue = processed.getDoubleValue();
            processed.update();
            double afterValue = processed.getDoubleValue();
            if (beforeValue - afterValue == 0.0 && time > 0.0) {
                Assert.fail();
            }
            if (processed.getSmoothedRate().getDoubleValue() > maxRate) {
                Assert.fail();
            }
            Assert.assertTrue((maxRate >= processed.getSmoothedRate().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((maxAcceleration >= processed.getSmoothedAcceleration().getDoubleValue() ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getDoubleValue()) <= amplitude || this.isValueWithinMarginOfError(amplitude, processed.getDoubleValue(), 0.1) ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getSmoothedRate().getDoubleValue()) <= maxRate ? 1 : 0) != 0);
            Assert.assertTrue((Math.abs(processed.getSmoothedAcceleration().getDoubleValue()) <= maxAcceleration ? 1 : 0) != 0);
        }
        this.shutdownSCSStuff(this.scs);
    }

    @Test
    public void testSetAndGetGainsByPolePlacement() {
        this.setupSCSStuff();
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable(this.nameYo, this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, 0.001);
        double positionGain = this.random.nextDouble();
        double velocityGain = this.random.nextDouble();
        processed.setGainsByPolePlacement(positionGain, velocityGain);
        double positionGainResult = positionGain * positionGain;
        double velocityGainResult = 2.0 * positionGain * velocityGain;
        Assert.assertEquals((double)positionGainResult, (double)processed.getPositionGain().getDoubleValue(), (double)1.0E-8);
        Assert.assertEquals((double)velocityGainResult, (double)processed.getVelocityGain().getDoubleValue(), (double)1.0E-8);
    }

    @Test
    public void testUpdate() {
        this.setupSCSStuff();
        maxRate = 10.0;
        maxAcceleration = 7.0;
        double dT = 1.0;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable(this.nameYo, this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, dT);
        maxRateYo.set(maxRate);
        maxAccelerationYo.set(maxAcceleration);
        for (double displacement = 1.0; displacement < 10000.0; displacement += 1000.0) {
            processed.update(displacement);
            Assert.assertTrue((processed.getSmoothedRate().getDoubleValue() <= maxRate ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetAndSetMaximumRateaAndAcceleration() {
        this.setupSCSStuff();
        maxRate = 1.0;
        maxAcceleration = 1.0;
        YoDouble maxRateYo = new YoDouble("max_Rate", this.registry);
        maxRateYo.set(maxRate, true);
        YoDouble maxAccelerationYo = new YoDouble("max_Acceleration", this.registry);
        maxAccelerationYo.set(maxAcceleration, true);
        AccelerationLimitedYoVariable processed = new AccelerationLimitedYoVariable(this.nameYo, this.registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, 0.001);
        maxRateYo.set(maxRate);
        maxAccelerationYo.set(maxAcceleration);
        Assert.assertEquals((double)maxRate, (double)processed.getMaximumRate(), (double)1.0E-8);
        Assert.assertEquals((double)maxAcceleration, (double)processed.getMaximumAcceleration(), (double)1.0E-8);
        maxRate = 8.5;
        maxAcceleration = 4.5;
        maxRateYo.set(maxRate);
        maxAccelerationYo.set(maxAcceleration);
        Assert.assertEquals((double)maxRate, (double)processed.getMaximumRate(), (double)1.0E-8);
        Assert.assertEquals((double)maxAcceleration, (double)processed.getMaximumAcceleration(), (double)1.0E-8);
    }

    @Disabled
    @Test
    public void testDump() {
        double dt = 0.006;
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot("test"));
        scs.startOnAThread();
        YoRegistry registry = scs.getRootRegistry();
        YoDouble time = new YoDouble("time", registry);
        YoDouble maxRateYo = new YoDouble("maxRate", registry);
        YoDouble maxAccelerationYo = new YoDouble("maxAcceleration", registry);
        YoDouble variable = new YoDouble("variable", registry);
        AccelerationLimitedYoVariable smoothedYoVariable = new AccelerationLimitedYoVariable("smoothedVariable", registry, (DoubleProvider)maxRateYo, (DoubleProvider)maxAccelerationYo, dt);
        double breakFrequencyHertz = 20.0;
        smoothedYoVariable.setGainsByPolePlacement(Math.PI * 2 * breakFrequencyHertz, 1.0);
        maxAccelerationYo.set(400.0);
        maxRateYo.set(12.0);
        YoFunctionGenerator functionGenerator = new YoFunctionGenerator("functionGenerator", registry);
        functionGenerator.setMode(YoFunctionGeneratorMode.CHIRP_LINEAR);
        functionGenerator.setChirpFrequencyMaxHz(30.0);
        functionGenerator.setResetTime(20.0);
        double maximumOmega0 = 33.333333333333336;
        System.out.println("maximumOmega0 = " + maximumOmega0 + " = " + maximumOmega0 / (Math.PI * 2) + " hertz.");
        smoothedYoVariable.update(0.0);
        double amplitude = 0.1;
        variable.set(amplitude);
        functionGenerator.setAmplitude(amplitude);
        time.set(0.0);
        while (time.getDoubleValue() < 0.2) {
            smoothedYoVariable.update(variable.getDoubleValue());
            scs.tickAndUpdate();
            time.add(dt);
        }
        variable.set(0.0);
        while (time.getDoubleValue() < 1.0) {
            smoothedYoVariable.update(variable.getDoubleValue());
            scs.tickAndUpdate();
            time.add(dt);
        }
        while (time.getDoubleValue() < 20.0) {
            variable.set(functionGenerator.getValue(time.getDoubleValue()));
            smoothedYoVariable.update(variable.getDoubleValue());
            scs.tickAndUpdate();
            time.add(dt);
        }
        scs.cropBuffer();
        ThreadTools.sleepForever();
    }

    @Test
    public void testErrorTooHigh() {
        Assert.assertFalse((boolean)this.isValueWithinMarginOfError(1.0, 0.0, 0.1));
        Assert.assertTrue((boolean)this.isValueWithinMarginOfError(1.0, 0.9, 0.11));
    }

    private boolean isValueWithinMarginOfError(double correctValue, double valueInQuestion, double permissibleErrorRatio) {
        double denominator = correctValue == 0.0 ? 1.0E-8 : correctValue;
        double result = Math.abs(correctValue - valueInQuestion) / denominator;
        if (result <= permissibleErrorRatio) {
            return true;
        }
        System.out.println("result = " + result);
        return false;
    }
}

