/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.utilities.screwTheory;

import java.util.LinkedHashMap;
import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.mecano.algorithms.CentroidalMomentumCalculator;
import us.ihmc.mecano.frames.CenterOfMassReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.utilities.screwTheory.InverseDynamicsCalculatorSCSTest;

public class CentroidalMomentumMatrixSCSTest {
    @Test
    public void testTree() {
        Random random = new Random(167L);
        Robot robot = new Robot("robot");
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        LinkedHashMap<RevoluteJoint, PinJoint> jointMap = new LinkedHashMap<RevoluteJoint, PinJoint>();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        double gravity = 0.0;
        int numberOfJoints = 3;
        InverseDynamicsCalculatorSCSTest.createRandomTreeRobotAndSetJointPositionsAndVelocities(robot, jointMap, worldFrame, (RigidBodyBasics)elevator, numberOfJoints, gravity, true, true, random);
        robot.updateVelocities();
        CenterOfMassReferenceFrame centerOfMassFrame = new CenterOfMassReferenceFrame("com", worldFrame, (RigidBodyReadOnly)elevator);
        centerOfMassFrame.update();
        CentroidalMomentumCalculator centroidalMomentumMatrix = new CentroidalMomentumCalculator((RigidBodyReadOnly)elevator, (ReferenceFrame)centerOfMassFrame);
        centroidalMomentumMatrix.reset();
        Momentum comMomentum = CentroidalMomentumMatrixSCSTest.computeCoMMomentum((RigidBodyBasics)elevator, (ReferenceFrame)centerOfMassFrame, centroidalMomentumMatrix);
        Point3D comPoint = new Point3D();
        Vector3D linearMomentum = new Vector3D();
        Vector3D angularMomentum = new Vector3D();
        robot.computeCOMMomentum((Point3DBasics)comPoint, (Vector3DBasics)linearMomentum, (Vector3DBasics)angularMomentum);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearMomentum, (EuclidGeometry)comMomentum.getLinearPart(), (double)1.0E-12);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)angularMomentum, (EuclidGeometry)comMomentum.getAngularPart(), (double)1.0E-12);
    }

    @Test
    public void testFloatingBody() {
        Random random = new Random(167L);
        double mass = random.nextDouble();
        Matrix3D momentOfInertia = EuclidCoreRandomTools.nextDiagonalMatrix3D((Random)random);
        Vector3D comOffset = EuclidCoreRandomTools.nextVector3D((Random)random);
        Robot robot = new Robot("robot");
        FloatingJoint rootJoint = new FloatingJoint("rootJoint", (Tuple3DReadOnly)new Vector3D(), robot);
        Link link = new Link("link");
        link.setMass(mass);
        link.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia);
        link.setComOffset((Vector3DReadOnly)comOffset);
        rootJoint.setLink(link);
        robot.addRootJoint((Joint)rootJoint);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        RigidBody elevator = new RigidBody("elevator", worldFrame);
        SixDoFJoint sixDoFJoint = new SixDoFJoint("sixDoFJoint", (RigidBodyBasics)elevator);
        new RigidBody("rigidBody", (JointBasics)sixDoFJoint, (Matrix3DReadOnly)momentOfInertia, mass, (Tuple3DReadOnly)comOffset);
        CenterOfMassReferenceFrame centerOfMassFrame = new CenterOfMassReferenceFrame("com", worldFrame, (RigidBodyReadOnly)elevator);
        CentroidalMomentumCalculator centroidalMomentumMatrix = new CentroidalMomentumCalculator((RigidBodyReadOnly)elevator, (ReferenceFrame)centerOfMassFrame);
        int nTests = 10;
        for (int i = 0; i < nTests; ++i) {
            Vector3D position = EuclidCoreRandomTools.nextVector3D((Random)random);
            RotationMatrix rotation = new RotationMatrix();
            rotation.setYawPitchRoll(random.nextDouble(), random.nextDouble(), random.nextDouble());
            Vector3D linearVelocityInBody = EuclidCoreRandomTools.nextVector3D((Random)random);
            Vector3D linearVelocityInWorld = new Vector3D((Tuple3DReadOnly)linearVelocityInBody);
            rotation.transform((Tuple3DBasics)linearVelocityInWorld);
            Vector3D angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            rootJoint.setPosition((Tuple3DReadOnly)position);
            rootJoint.setRotation((RotationMatrixReadOnly)rotation);
            rootJoint.setVelocity((Tuple3DReadOnly)linearVelocityInWorld);
            rootJoint.setAngularVelocityInBody((Vector3DReadOnly)angularVelocity);
            robot.updateVelocities();
            Point3D comPoint = new Point3D();
            Vector3D linearMomentum = new Vector3D();
            Vector3D angularMomentum = new Vector3D();
            robot.computeCOMMomentum((Point3DBasics)comPoint, (Vector3DBasics)linearMomentum, (Vector3DBasics)angularMomentum);
            sixDoFJoint.setJointPosition((Tuple3DReadOnly)position);
            sixDoFJoint.setJointOrientation((Orientation3DReadOnly)rotation);
            Twist jointTwist = new Twist();
            jointTwist.setIncludingFrame((SpatialMotionReadOnly)sixDoFJoint.getJointTwist());
            jointTwist.getAngularPart().set((Tuple3DReadOnly)angularVelocity);
            jointTwist.getLinearPart().set((Tuple3DReadOnly)linearVelocityInBody);
            sixDoFJoint.setJointTwist((TwistReadOnly)jointTwist);
            elevator.updateFramesRecursively();
            centerOfMassFrame.update();
            centroidalMomentumMatrix.reset();
            Momentum comMomentum = CentroidalMomentumMatrixSCSTest.computeCoMMomentum((RigidBodyBasics)elevator, (ReferenceFrame)centerOfMassFrame, centroidalMomentumMatrix);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)linearMomentum, (EuclidGeometry)comMomentum.getLinearPart(), (double)1.0E-12);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)angularMomentum, (EuclidGeometry)comMomentum.getAngularPart(), (double)1.0E-12);
        }
    }

    public static Momentum computeCoMMomentum(RigidBodyBasics elevator, ReferenceFrame centerOfMassFrame, CentroidalMomentumCalculator centroidalMomentumMatrix) {
        DMatrixRMaj mat = centroidalMomentumMatrix.getCentroidalMomentumMatrix();
        JointBasics[] jointList = MultiBodySystemTools.collectSubtreeJoints((RigidBodyBasics[])new RigidBodyBasics[]{elevator});
        DMatrixRMaj jointVelocities = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom((JointReadOnly[])jointList), 1);
        MultiBodySystemTools.extractJointsState((JointReadOnly[])jointList, (JointStateType)JointStateType.VELOCITY, (DMatrix)jointVelocities);
        DMatrixRMaj comMomentumMatrix = MatrixTools.mult((DMatrix1Row)mat, (DMatrix1Row)jointVelocities);
        Momentum comMomentum = new Momentum(centerOfMassFrame, (DMatrix)comMomentumMatrix);
        return comMomentum;
    }
}

