/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.simulationrunner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opentest4j.AssertionFailedError;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.testing.GoalOrientedTestGoal;
import us.ihmc.robotics.testing.YoVariableTestGoal;
import us.ihmc.scs2.SimulationConstructionSet2;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class GoalOrientedTestConductor {
    private final SimulationConstructionSet2 scs;
    private final SimulationTestingParameters simulationTestingParameters;
    private boolean yoTimeChangedListenerActive = false;
    private List<GoalOrientedTestGoal> sustainGoals = new ArrayList<GoalOrientedTestGoal>();
    private List<GoalOrientedTestGoal> waypointGoals = new ArrayList<GoalOrientedTestGoal>();
    private List<GoalOrientedTestGoal> terminalGoals = new ArrayList<GoalOrientedTestGoal>();
    private List<GoalOrientedTestGoal> sustainGoalsNotMeeting = new ArrayList<GoalOrientedTestGoal>();
    private List<GoalOrientedTestGoal> waypointGoalsNotMet = new ArrayList<GoalOrientedTestGoal>();
    private List<GoalOrientedTestGoal> terminalGoalsNotMeeting = new ArrayList<GoalOrientedTestGoal>();
    private final AtomicBoolean createAssertionFailedException = new AtomicBoolean();
    private final AtomicBoolean printSuccessMessage = new AtomicBoolean();
    private final AtomicBoolean scsHasCrashed = new AtomicBoolean();
    private String assertionFailedMessage = null;
    private String scsCrashedException = null;

    public GoalOrientedTestConductor(SimulationConstructionSet2 scs, SimulationTestingParameters simulationTestingParameters) {
        this.scs = scs;
        this.simulationTestingParameters = simulationTestingParameters;
        YoDouble yoTime = scs.getTime();
        yoTime.addListener(this::notifyOfVariableChange);
        scs.start(true, false, true);
        scs.addSimulationThrowableListener(t -> this.simulationDoneWithException((Throwable)t));
    }

    public void notifyOfVariableChange(YoVariable v) {
        if (this.yoTimeChangedListenerActive) {
            int i;
            this.sustainGoalsNotMeeting.clear();
            this.waypointGoalsNotMet.clear();
            this.terminalGoalsNotMeeting.clear();
            for (i = 0; i < this.sustainGoals.size(); ++i) {
                if (this.sustainGoals.get(i).currentlyMeetsGoal()) continue;
                this.sustainGoalsNotMeeting.add(this.sustainGoals.get(i));
            }
            for (i = 0; i < this.waypointGoals.size(); ++i) {
                if (this.waypointGoals.get(i).hasMetGoal()) continue;
                this.waypointGoalsNotMet.add(this.waypointGoals.get(i));
            }
            for (i = 0; i < this.terminalGoals.size(); ++i) {
                if (this.terminalGoals.get(i).currentlyMeetsGoal()) continue;
                this.terminalGoalsNotMeeting.add(this.terminalGoals.get(i));
            }
            if (this.sustainGoalsNotMeeting.size() > 0) {
                this.createAssertionFailedException.set(true);
            } else if (this.terminalGoalsNotMeeting.isEmpty()) {
                if (this.waypointGoalsNotMet.size() > 0) {
                    this.createAssertionFailedException.set(true);
                } else {
                    this.printSuccessMessage.set(true);
                }
            }
        }
    }

    private void printSuccessMessage() {
        StringBuffer message = new StringBuffer();
        message.append("Success:");
        for (GoalOrientedTestGoal goal : this.sustainGoals) {
            message.append("\nGoal sustained: ");
            message.append(goal.toString());
        }
        for (GoalOrientedTestGoal goal : this.waypointGoals) {
            message.append("\nWaypoint met: ");
            message.append(goal.toString());
        }
        for (GoalOrientedTestGoal goal : this.terminalGoals) {
            message.append("\nTerminal goal met: ");
            message.append(goal.toString());
        }
        LogTools.info((String)message.toString());
    }

    private void printSimulatingMessage() {
        StringBuffer message = new StringBuffer();
        message.append("Simulating with goals:");
        for (GoalOrientedTestGoal goal : this.sustainGoals) {
            message.append("\nSustain goal: ");
            message.append(goal.toString());
        }
        for (GoalOrientedTestGoal goal : this.waypointGoals) {
            message.append("\nWaypoint goal: ");
            message.append(goal.toString());
        }
        for (GoalOrientedTestGoal goal : this.terminalGoals) {
            message.append("\nTerminal goal: ");
            message.append(goal.toString());
        }
        LogTools.info((String)message.toString());
    }

    private void createAssertionFailedException() {
        int i;
        StringBuffer message = new StringBuffer();
        message.append("Assertion failed:");
        for (i = 0; i < this.sustainGoalsNotMeeting.size(); ++i) {
            message.append("\nGoal not sustained: ");
            message.append(this.sustainGoalsNotMeeting.get(i).toString());
        }
        for (i = 0; i < this.waypointGoalsNotMet.size(); ++i) {
            message.append("\nWaypoint not met: ");
            message.append(this.waypointGoalsNotMet.get(i).toString());
        }
        for (i = 0; i < this.terminalGoalsNotMeeting.size(); ++i) {
            message.append("\nTerminal goal not met: ");
            message.append(this.terminalGoalsNotMeeting.get(i).toString());
        }
        this.assertionFailedMessage = message.toString();
    }

    public void setTerrainObject3D(TerrainObject3D terrainObject3D) {
    }

    private void stop() {
        this.yoTimeChangedListenerActive = false;
        this.sustainGoals.clear();
        this.waypointGoals.clear();
        this.terminalGoals.clear();
        this.scs.pause();
    }

    public void simulate() {
        this.assertionFailedMessage = null;
        this.yoTimeChangedListenerActive = true;
        this.createAssertionFailedException.set(false);
        this.printSuccessMessage.set(false);
        this.scsHasCrashed.set(false);
        this.printSimulatingMessage();
        this.scs.simulate();
        while (!(this.createAssertionFailedException.get() || this.printSuccessMessage.get() || this.scsHasCrashed.get())) {
            Thread.yield();
        }
        if (this.createAssertionFailedException.get()) {
            this.createAssertionFailedException();
            this.stop();
        } else if (this.printSuccessMessage.get()) {
            this.printSuccessMessage();
            this.stop();
        } else if (this.scsHasCrashed.get()) {
            this.stop();
            LogTools.error((String)this.scsCrashedException);
            Assert.fail((String)("SCS crashed.\n" + this.scsCrashedException));
        }
        ThreadTools.sleep((long)10L);
        if (this.assertionFailedMessage != null) {
            LogTools.error((String)this.assertionFailedMessage);
            throw new AssertionFailedError(this.assertionFailedMessage);
        }
    }

    public void concludeTesting(int additionalStackDepthForRelevantCallingMethod) {
        if (this.simulationTestingParameters.getKeepSCSUp()) {
            this.scs.waitUntilVisualizerDown();
        }
        if (this.simulationTestingParameters.getCreateSCSVideos()) {
            // empty if block
        }
        ThreadTools.sleep((long)200L);
        this.scs.shutdownSession();
    }

    public void concludeTesting(String videoName) {
        if (this.simulationTestingParameters.getKeepSCSUp()) {
            this.scs.waitUntilVisualizerDown();
        }
        if (this.simulationTestingParameters.getCreateSCSVideos()) {
            // empty if block
        }
        ThreadTools.sleep((long)200L);
        this.scs.shutdownSession();
    }

    public void concludeTesting() {
        this.concludeTesting(2);
    }

    public void addTimeLimit(YoDouble timeYoVariable, double timeLimit) {
        this.sustainGoals.add((GoalOrientedTestGoal)YoVariableTestGoal.doubleLessThan((YoDouble)timeYoVariable, (double)(timeYoVariable.getDoubleValue() + timeLimit)));
    }

    public void addDurationGoal(YoDouble timeYoVariable, double durationFromNow) {
        this.terminalGoals.add((GoalOrientedTestGoal)YoVariableTestGoal.timeInFuture((YoDouble)timeYoVariable, (double)durationFromNow));
    }

    public void addSustainGoal(GoalOrientedTestGoal yoVariableTestGoal) {
        this.sustainGoals.add(yoVariableTestGoal);
    }

    public void addWaypointGoal(GoalOrientedTestGoal yoVariableTestGoal) {
        this.waypointGoals.add(yoVariableTestGoal);
    }

    public void addTerminalGoal(GoalOrientedTestGoal yoVariableTestGoal) {
        this.terminalGoals.add(yoVariableTestGoal);
    }

    public SimulationConstructionSet2 getScs() {
        return this.scs;
    }

    public void setKeepSCSUp(boolean keepSCSUp) {
        this.simulationTestingParameters.setKeepSCSUp(keepSCSUp);
    }

    public void simulationDoneWithException(Throwable throwable) {
        if (this.simulationTestingParameters.getKeepSCSUp()) {
            LogTools.error((String)throwable.getMessage());
        }
        this.scsCrashedException = throwable.getMessage();
        this.scsHasCrashed.set(true);
    }
}

