/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import java.util.ArrayList;
import java.util.Collection;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.ControllerFailureException;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.simulationconstructionset.util.simulationRunner.StateFileComparer;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariableDifference;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoBoolean;

public class SimulationRunsSameWayTwiceVerifier {
    private final SimulationConstructionSet scsOne;
    private final SimulationConstructionSet scsTwo;
    private final BlockingSimulationRunner blockingSimulationRunnerOne;
    private final BlockingSimulationRunner blockingSimulationRunnerTwo;
    private final double walkingTimeDuration;
    private final double standingTimeDuration;

    public SimulationRunsSameWayTwiceVerifier(SimulationConstructionSet scsOne, SimulationConstructionSet scsTwo, double standingTimeDuration, double walkingTimeDuration) {
        this.scsOne = scsOne;
        this.scsTwo = scsTwo;
        this.standingTimeDuration = standingTimeDuration;
        this.walkingTimeDuration = walkingTimeDuration;
        this.blockingSimulationRunnerOne = new BlockingSimulationRunner(scsOne, 3000.0);
        this.blockingSimulationRunnerTwo = new BlockingSimulationRunner(scsTwo, 3000.0);
        ThreadTools.sleep((long)1000L);
    }

    public boolean verifySimRunsSameWayTwice(double maxPercentDifference, ArrayList<String> stringsToIgnore) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, ControllerFailureException {
        boolean secondSimDone = false;
        boolean firstSimDone = false;
        this.initiateMotion(this.scsOne, this.standingTimeDuration, this.blockingSimulationRunnerOne);
        this.initiateMotion(this.scsTwo, this.standingTimeDuration, this.blockingSimulationRunnerTwo);
        while (!firstSimDone && !secondSimDone) {
            this.blockingSimulationRunnerOne.simulateAndBlock(1.0);
            this.blockingSimulationRunnerTwo.simulateAndBlock(1.0);
            if (!this.compareSCSInstances(maxPercentDifference, stringsToIgnore)) {
                System.err.println("Mismatch in sim states!");
                return false;
            }
            firstSimDone = this.scsOne.getTime() - this.standingTimeDuration >= this.walkingTimeDuration;
            if (firstSimDone == (secondSimDone = this.scsTwo.getTime() - this.standingTimeDuration >= this.walkingTimeDuration)) continue;
            System.err.println("Sims did not finish at the same time!");
            return false;
        }
        return true;
    }

    private boolean compareSCSInstances(double maxPercentDifference, ArrayList<String> stringsToIgnore) {
        YoVariableList listOne = new YoVariableList("SimOneList");
        YoVariableList listTwo = new YoVariableList("SimTwoList");
        listOne.addAll((Collection)this.scsOne.getVariables());
        listTwo.addAll((Collection)this.scsTwo.getVariables());
        ArrayList variableDifferences = StateFileComparer.compareVarLists((YoVariableList)listOne, (YoVariableList)listTwo, (double)maxPercentDifference, (boolean)true, stringsToIgnore);
        if (variableDifferences.isEmpty()) {
            return true;
        }
        for (VariableDifference difference : variableDifferences) {
            System.err.println("Variable One: " + String.valueOf(difference.getVariableOne()));
            System.err.println("Variable Two: " + String.valueOf(difference.getVariableTwo()));
            System.err.println(difference.toString());
        }
        return false;
    }

    private void initiateMotion(SimulationConstructionSet scs, double standingTimeDuration, BlockingSimulationRunner runner) throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, ControllerFailureException {
        YoBoolean walk = (YoBoolean)scs.findVariable("walkCSG");
        if (walk != null) {
            walk.set(false);
        }
        runner.simulateAndBlock(standingTimeDuration);
        if (walk != null) {
            walk.set(true);
        }
    }
}

