/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.simulationTesting.AllYoVariablesSimulationComparer;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.tools.MemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class AllYoVariablesSimulationComparerTest {
    Robot robot1;
    Robot robot2;
    YoRegistry rootRegistry1;
    YoRegistry rootRegistry2;
    YoDouble yoDouble1;
    YoDouble yoDouble2;
    YoDouble yoDouble3;
    YoDouble yoDouble4;
    YoDouble yoDoubleA12;

    @BeforeEach
    public void showMemoryUsageBeforeTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " before test."));
    }

    @AfterEach
    public void showMemoryUsageAfterTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " after test."));
    }

    @BeforeEach
    public void setUp() {
        this.robot1 = this.createSimpleRobotOne("robot");
        this.robot2 = this.createSimpleRobotTwo("robot");
        this.rootRegistry1 = new YoRegistry("rootRegistry");
        this.rootRegistry2 = new YoRegistry("rootRegistry");
        this.yoDouble1 = new YoDouble("doubleYoVariableA1", this.rootRegistry1);
        this.yoDouble2 = new YoDouble("doubleYoVariableA2", this.rootRegistry1);
        this.yoDoubleA12 = new YoDouble("yoDoubleA12", this.rootRegistry1);
        this.yoDouble3 = new YoDouble("doubleYoVariableA1", this.rootRegistry2);
        this.yoDouble4 = new YoDouble("doubleYoVariableA2", this.rootRegistry2);
        new YoDouble("aIgnore", this.rootRegistry2);
        new YoDouble("zIgnore", this.rootRegistry2);
    }

    private Robot createSimpleRobotOne(String name) {
        Robot robot = new Robot(name);
        PinJoint joint1 = new PinJoint("joint", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), robot, (Vector3DReadOnly)Axis3D.Y);
        Link link1 = this.link1();
        joint1.setLink(link1);
        robot.addRootJoint((Joint)joint1);
        joint1.setInitialState(0.11, 0.22);
        joint1.setTau(33.3);
        return robot;
    }

    private Robot createSimpleRobotTwo(String name) {
        Robot robot = new Robot(name);
        PinJoint joint2 = new PinJoint("joint", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), robot, (Vector3DReadOnly)Axis3D.Y);
        Link link2 = this.link2();
        joint2.setLink(link2);
        robot.addRootJoint((Joint)joint2);
        joint2.setInitialState(0.11, 0.22);
        joint2.setTau(33.3);
        return robot;
    }

    private Link link1() {
        Link ret = new Link("link1");
        ret.setMass(1.0);
        ret.setComOffset(2.0, 0.0, 0.0);
        ret.setMomentOfInertia(0.0, 3.0, 0.0);
        return ret;
    }

    private Link link2() {
        Link ret = new Link("link2");
        ret.setMass(2.0);
        ret.setComOffset(2.0, 0.0, 0.0);
        ret.setMomentOfInertia(0.0, 5.0, 0.0);
        return ret;
    }

    @Test
    public void testCompareWithZeroEpsilon() {
        AllYoVariablesSimulationComparer comparerWithZeroEpsilon = new AllYoVariablesSimulationComparer(0.0);
        SimulationConstructionSetParameters scsParameters = new SimulationConstructionSetParameters();
        scsParameters.setCreateGUI(false);
        SimulationConstructionSet scs1 = new SimulationConstructionSet(this.robot1, scsParameters);
        SimulationConstructionSet scs2 = new SimulationConstructionSet(this.robot2, scsParameters);
        scs1.getRootRegistry().addChild(this.rootRegistry1);
        scs2.getRootRegistry().addChild(this.rootRegistry2);
        this.yoDouble1.set(1.0);
        this.yoDouble2.set(2.0);
        this.yoDouble3.set(1.0);
        this.yoDouble4.set(2.0);
        Assert.assertFalse((boolean)comparerWithZeroEpsilon.compare(scs1, scs2));
        comparerWithZeroEpsilon.addException("yoDoubleA12");
        comparerWithZeroEpsilon.addException("Ignore");
        Assert.assertTrue((boolean)comparerWithZeroEpsilon.compare(scs1, scs2));
        this.yoDouble1.set(1.0);
        this.yoDouble2.set(3.0);
        this.yoDouble3.set(1.0);
        this.yoDouble4.set(2.0);
        Assert.assertFalse((boolean)comparerWithZeroEpsilon.compare(scs1, scs2));
        List<YoVariable[]> differences = comparerWithZeroEpsilon.getDifferences();
        Assert.assertEquals((long)1L, (long)differences.size());
        Assert.assertEquals((Object)this.yoDouble2, (Object)differences.get(0)[0]);
        Assert.assertEquals((Object)this.yoDouble4, (Object)differences.get(0)[1]);
    }

    @Test
    public void testWithLowEpsilon() {
        AllYoVariablesSimulationComparer comparerWithLowEpsilon = new AllYoVariablesSimulationComparer(0.01);
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs1 = new SimulationConstructionSet(this.robot1, parameters);
        SimulationConstructionSet scs2 = new SimulationConstructionSet(this.robot2, parameters);
        scs1.getRootRegistry().addChild(this.rootRegistry1);
        scs2.getRootRegistry().addChild(this.rootRegistry2);
        this.yoDouble1.set(1.8);
        this.yoDouble2.set(2.0);
        this.yoDouble3.set(1.791);
        this.yoDouble4.set(2.009);
        Assert.assertFalse((boolean)comparerWithLowEpsilon.compare(scs1, scs2));
        comparerWithLowEpsilon.addException("yoDoubleA12");
        comparerWithLowEpsilon.addException("Ignore");
        Assert.assertTrue((boolean)comparerWithLowEpsilon.compare(scs1, scs2));
        this.yoDouble1.set(1.8);
        this.yoDouble2.set(2.0);
        this.yoDouble3.set(1.79);
        this.yoDouble4.set(2.009);
        Assert.assertFalse((boolean)comparerWithLowEpsilon.compare(scs1, scs2));
    }

    @Test
    public void testWithHighEpsilon() {
        AllYoVariablesSimulationComparer comparerWithLargeEpsilon = new AllYoVariablesSimulationComparer(5.0);
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs1 = new SimulationConstructionSet(this.robot1, parameters);
        SimulationConstructionSet scs2 = new SimulationConstructionSet(this.robot2, parameters);
        scs1.getRootRegistry().addChild(this.rootRegistry1);
        scs2.getRootRegistry().addChild(this.rootRegistry2);
        this.yoDouble1.set(98.56);
        this.yoDouble2.set(97.01);
        this.yoDouble3.set(94.98);
        this.yoDouble4.set(92.02);
        Assert.assertFalse((boolean)comparerWithLargeEpsilon.compare(scs1, scs2));
        comparerWithLargeEpsilon.addException("yoDoubleA12");
        comparerWithLargeEpsilon.addException("Ignore");
        Assert.assertTrue((boolean)comparerWithLargeEpsilon.compare(scs1, scs2));
        this.yoDouble1.set(97.02);
        this.yoDouble2.set(95.01);
        this.yoDouble3.set(9.0);
        this.yoDouble4.set(92.02);
        Assert.assertFalse((boolean)comparerWithLargeEpsilon.compare(scs1, scs2));
    }
}

