/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.globalParameters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.BooleanGlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameterChangedListener;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.OrBooleanGlobalParameter;

public class OrBooleanGlobalParameterTest {
    private static final boolean VERBOSE = false;

    @BeforeEach
    public void setUp() {
        GlobalParameter.clearGlobalRegistry();
    }

    @AfterEach
    public void tearDown() {
        GlobalParameter.clearGlobalRegistry();
    }

    @Test
    public void testSetThrowsException() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        boolean valueA = true;
        boolean valueB = false;
        BooleanGlobalParameter booleanGlobalParameterA = new BooleanGlobalParameter("testParameterA", "test description", valueA, systemOutGlobalParameterChangedListener);
        BooleanGlobalParameter booleanGlobalParameterB = new BooleanGlobalParameter("testParameterB", "test description", valueB, systemOutGlobalParameterChangedListener);
        OrBooleanGlobalParameter multiplicativeDoubleGlobalParameter = new OrBooleanGlobalParameter("testMulti", "multiplicative parameter", new BooleanGlobalParameter[]{booleanGlobalParameterA, booleanGlobalParameterB}, systemOutGlobalParameterChangedListener);
        try {
            multiplicativeDoubleGlobalParameter.set(false);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testAndBooleanGlobalParameter() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        boolean valueA = true;
        boolean valueB = false;
        BooleanGlobalParameter booleanGlobalParameterA = new BooleanGlobalParameter("testParameterA", "test description", valueA, systemOutGlobalParameterChangedListener);
        BooleanGlobalParameter booleanGlobalParameterB = new BooleanGlobalParameter("testParameterB", "test description", valueB, systemOutGlobalParameterChangedListener);
        OrBooleanGlobalParameter multiplicativeDoubleGlobalParameter = new OrBooleanGlobalParameter("testMulti", "multiplicative parameter", new BooleanGlobalParameter[]{booleanGlobalParameterA, booleanGlobalParameterB}, systemOutGlobalParameterChangedListener);
        Assert.assertEquals((Object)(valueA || valueB ? 1 : 0), (Object)multiplicativeDoubleGlobalParameter.getValue());
    }

    @Test
    public void testAndBooleanGlobalParameterUpdate() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        boolean valueA = true;
        boolean valueB = false;
        BooleanGlobalParameter booleanGlobalParameterA = new BooleanGlobalParameter("testParameterA", "test description", valueA, systemOutGlobalParameterChangedListener);
        BooleanGlobalParameter booleanGlobalParameterB = new BooleanGlobalParameter("testParameterB", "test description", valueB, systemOutGlobalParameterChangedListener);
        OrBooleanGlobalParameter multiplicativeDoubleGlobalParameter = new OrBooleanGlobalParameter("testMulti", "multiplicative parameter", new BooleanGlobalParameter[]{booleanGlobalParameterA, booleanGlobalParameterB}, systemOutGlobalParameterChangedListener);
        valueA = false;
        booleanGlobalParameterA.set(valueA);
        Assert.assertEquals((Object)(valueA || valueB ? 1 : 0), (Object)multiplicativeDoubleGlobalParameter.getValue());
        valueB = true;
        booleanGlobalParameterB.set(valueB);
        Assert.assertEquals((Object)(valueA || valueB ? 1 : 0), (Object)multiplicativeDoubleGlobalParameter.getValue());
        valueA = true;
        valueB = true;
        booleanGlobalParameterA.set(valueA);
        booleanGlobalParameterB.set(valueB);
        Assert.assertEquals((Object)(valueA || valueB ? 1 : 0), (Object)multiplicativeDoubleGlobalParameter.getValue());
    }

    @Test
    public void testFamilyTree() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        boolean valueA = false;
        boolean valueB = true;
        BooleanGlobalParameter grandParentA = new BooleanGlobalParameter("grandParentA", "test descriptionA", valueA, systemOutGlobalParameterChangedListener);
        BooleanGlobalParameter grandParentB = new BooleanGlobalParameter("grandParentB", "test descriptionB", valueB, systemOutGlobalParameterChangedListener);
        OrBooleanGlobalParameter parentA = new OrBooleanGlobalParameter("parentA", "multiplicative parameter", new BooleanGlobalParameter[]{grandParentA}, systemOutGlobalParameterChangedListener);
        OrBooleanGlobalParameter parentB = new OrBooleanGlobalParameter("parentB", "multiplicative parameter", new BooleanGlobalParameter[]{grandParentB}, systemOutGlobalParameterChangedListener);
        OrBooleanGlobalParameter childA = new OrBooleanGlobalParameter("childA", "multiplicative parameter", new BooleanGlobalParameter[]{grandParentA, parentA}, systemOutGlobalParameterChangedListener);
        OrBooleanGlobalParameter childB = new OrBooleanGlobalParameter("childB", "multiplicative parameter", new BooleanGlobalParameter[]{grandParentA, grandParentB, parentA, parentB}, systemOutGlobalParameterChangedListener);
        boolean expectedParentA = valueA;
        Assert.assertEquals((Object)expectedParentA, (Object)parentA.getValue());
        boolean expectedParentB = valueB;
        Assert.assertEquals((Object)expectedParentB, (Object)parentB.getValue());
        boolean expectedChildA = false;
        Assert.assertEquals((Object)expectedChildA, (Object)childA.getValue());
        boolean expectedChildB = valueA || valueB || valueA || valueB;
        Assert.assertEquals((Object)expectedChildB, (Object)childB.getValue());
        valueA = !valueA;
        grandParentA.set(valueA);
        expectedParentA = valueA;
        Assert.assertEquals((Object)expectedParentA, (Object)parentA.getValue());
        expectedParentB = valueB;
        Assert.assertEquals((Object)expectedParentB, (Object)parentB.getValue());
        expectedChildA = true;
        Assert.assertEquals((Object)expectedChildA, (Object)childA.getValue());
        expectedChildB = valueA || valueB || valueA || valueB;
        Assert.assertEquals((Object)expectedChildB, (Object)childB.getValue());
        valueA = !valueA;
        valueB = !valueB;
        grandParentA.set(valueA);
        grandParentB.set(valueB);
        expectedParentA = valueA;
        Assert.assertEquals((Object)expectedParentA, (Object)parentA.getValue());
        expectedParentB = valueB;
        Assert.assertEquals((Object)expectedParentB, (Object)parentB.getValue());
        expectedChildA = false;
        Assert.assertEquals((Object)expectedChildA, (Object)childA.getValue());
        expectedChildB = valueA || valueB || valueA || valueB;
        Assert.assertEquals((Object)expectedChildB, (Object)childB.getValue());
    }
}

