/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.environments;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.robotController.ContactController;
import us.ihmc.simulationConstructionSetTools.util.environments.ValveType;
import us.ihmc.simulationConstructionSetTools.util.environments.environmentRobots.ContactableValveRobot;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.ground.Contactable;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ContactableValveRobotTest {
    private Robot[] robots = new Robot[2];
    private RobotController floatingRobotController;
    private SliderJoint horizontalJoint;
    private SliderJoint verticalJoint;
    private YoRegistry valveTestRegistry;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testValveIsClosing() {
        boolean isValveClosed = false;
        this.valveTestRegistry = new YoRegistry("valveTestRegistry");
        this.createValveRobot();
        this.createFloatingRobot();
        this.floatingRobotController.initialize();
        this.createContactPoints(this.robots[0]);
        SimulationTestingParameters simulationTestingParameters = SimulationTestingParameters.createFromSystemProperties();
        SimulationConstructionSet scs = new SimulationConstructionSet(this.robots, (SimulationConstructionSetParameters)simulationTestingParameters);
        scs.addYoRegistry(this.valveTestRegistry);
        Thread myThread = new Thread((Runnable)scs);
        myThread.start();
        BlockingSimulationRunner blockingSimulationRunner = new BlockingSimulationRunner(scs, 4.0);
        try {
            blockingSimulationRunner.simulateAndBlock(4.0);
        }
        catch (Exception e) {
            PrintTools.error((Object)this, (String)e.getMessage());
        }
        if (this.robots[1].findVariable("valveClosePercentage").getValueAsDouble() >= 99.0) {
            isValveClosed = true;
        }
        Assert.assertTrue((boolean)isValveClosed);
        if (simulationTestingParameters.getKeepSCSUp()) {
            ThreadTools.sleepForever();
        }
        blockingSimulationRunner.destroySimulation();
    }

    @Test
    public void testGetValveTransformToWorld() {
        Random random = new Random(1235125L);
        double valveX = RandomNumbers.nextDouble((Random)random, (double)-2.0, (double)2.0);
        double valveY = RandomNumbers.nextDouble((Random)random, (double)-2.0, (double)2.0);
        double valveZ = RandomNumbers.nextDouble((Random)random, (double)0.1, (double)2.0);
        double valveYaw_degrees = RandomNumbers.nextDouble((Random)random, (double)-100.0, (double)100.0);
        ContactableValveRobot valveRobot = this.createValveRobot(valveX, valveY, valveZ, valveYaw_degrees);
        RigidBodyTransform valveTransformToWorld = new RigidBodyTransform();
        valveRobot.getBodyTransformToWorld(valveTransformToWorld);
        FramePose3D valvePose = new FramePose3D(ReferenceFrame.getWorldFrame(), (RigidBodyTransformReadOnly)valveTransformToWorld);
        Assert.assertEquals((double)valveX, (double)valvePose.getX(), (double)1.0E-7);
        Assert.assertEquals((double)valveY, (double)valvePose.getY(), (double)1.0E-7);
        Assert.assertEquals((double)valveZ, (double)valvePose.getZ(), (double)1.0E-7);
        Assert.assertEquals((double)valveYaw_degrees, (double)Math.toDegrees(valvePose.getYaw()), (double)1.0E-7);
    }

    private void createFloatingRobot() {
        Robot floatingRobot = new Robot("floatingRobot");
        Vector3D position = new Vector3D(0.0, 0.02, 1.1);
        double length = 0.01;
        floatingRobot.setGravity(0.0, 0.0, 0.0);
        this.horizontalJoint = new SliderJoint("y", (Tuple3DReadOnly)position, floatingRobot, (Vector3DReadOnly)Axis3D.Y);
        floatingRobot.addRootJoint((Joint)this.horizontalJoint);
        Link linkHorizontal = new Link("linkHorizontal");
        linkHorizontal.setMass(0.5);
        linkHorizontal.setComOffset(length / 2.0, 0.0, 0.0);
        linkHorizontal.setMomentOfInertia(0.0, 0.01, 0.0);
        Graphics3DObject linkHorizontalGraphics = new Graphics3DObject();
        linkHorizontalGraphics.addCylinder(length * 10.0, 0.005, YoAppearance.Orange());
        linkHorizontal.setLinkGraphics(linkHorizontalGraphics);
        this.horizontalJoint.setLink(linkHorizontal);
        this.verticalJoint = new SliderJoint("z", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), floatingRobot, (Vector3DReadOnly)Axis3D.Z);
        Link linkVertical = new Link("linkVertical");
        linkVertical.setMass(0.5);
        linkVertical.setComOffset(length / 2.0, 0.0, 0.0);
        linkVertical.setMomentOfInertia(0.0, 0.01, 0.0);
        Graphics3DObject linkVerticalGraphics = new Graphics3DObject();
        linkVerticalGraphics.addCylinder(length, 0.005, YoAppearance.Blue());
        linkVertical.setLinkGraphics(linkVerticalGraphics);
        this.verticalJoint.setLink(linkVertical);
        this.horizontalJoint.addJoint((Joint)this.verticalJoint);
        this.createFloatingRobotController();
        this.robots[0] = floatingRobot;
        this.robots[0].setController(this.floatingRobotController);
    }

    private void createContactPoints(Robot floatingRobot) {
        GroundContactPoint contactPoint1 = new GroundContactPoint("contactPoint1", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), floatingRobot);
        this.verticalJoint.addGroundContactPoint(1, contactPoint1);
        GroundContactPoint contactPoint2 = new GroundContactPoint("contactPoint2", (Tuple3DReadOnly)new Vector3D(-0.002, 0.0, 0.0), floatingRobot);
        this.verticalJoint.addGroundContactPoint(1, contactPoint2);
        GroundContactPoint contactPoint3 = new GroundContactPoint("contactPoint3", (Tuple3DReadOnly)new Vector3D(0.002, 0.0, 0.0), floatingRobot);
        this.verticalJoint.addGroundContactPoint(1, contactPoint3);
        ContactController contactController = new ContactController();
        contactController.setContactParameters(10000.0, 1000.0, 0.5, 0.3);
        contactController.addContactPoints(this.robots[0].getAllGroundContactPoints());
        ArrayList<Contactable> robotList = new ArrayList<Contactable>();
        robotList.add((Contactable)this.robots[1]);
        contactController.addContactables(robotList);
        this.robots[1].setController((RobotController)contactController);
    }

    private void createFloatingRobotController() {
        this.floatingRobotController = new RobotController(){
            private YoRegistry robotControllerRegistry = new YoRegistry("robotControllerRegistry");

            public void initialize() {
                ContactableValveRobotTest.this.horizontalJoint.setKp(1000.0);
                ContactableValveRobotTest.this.horizontalJoint.setKd(50.0);
                ContactableValveRobotTest.this.verticalJoint.setKp(1000.0);
                ContactableValveRobotTest.this.verticalJoint.setKd(50.0);
            }

            public YoRegistry getYoRegistry() {
                return this.robotControllerRegistry;
            }

            public String getName() {
                return "floatingRobotController";
            }

            public String getDescription() {
                return ContactableValveRobotTest.this.floatingRobotController.getDescription();
            }

            public void doControl() {
                if (ContactableValveRobotTest.this.robots[0].getTime() < 1.0) {
                    ContactableValveRobotTest.this.horizontalJoint.setqDesired(-0.05);
                    ContactableValveRobotTest.this.verticalJoint.setqDesired(0.0);
                } else if (ContactableValveRobotTest.this.robots[0].getTime() >= 1.0 && ContactableValveRobotTest.this.robots[0].getTime() < 2.0) {
                    ContactableValveRobotTest.this.horizontalJoint.setqDesired(-0.1);
                    ContactableValveRobotTest.this.verticalJoint.setqDesired(-0.05);
                }
            }
        };
    }

    private void createValveRobot() {
        ContactableValveRobot valveRobot = this.createValveRobot(0.0, 0.0, 1.0, 0.0);
        this.robots[1] = valveRobot;
    }

    private ContactableValveRobot createValveRobot(double x, double y, double z, double yaw_degrees) {
        double forceVectorScale = 0.02;
        FramePose3D valvePoseInWorld = this.createFramePose(x, y, z, yaw_degrees);
        ContactableValveRobot valveRobot = new ContactableValveRobot("valveRobot", ValveType.SMALL_VALVE, 0.125, valvePoseInWorld);
        valveRobot.createValveRobot();
        valveRobot.createAvailableContactPoints(1, 30, forceVectorScale, true);
        return valveRobot;
    }

    private FramePose3D createFramePose(double x, double y, double z, double yaw_degrees) {
        FramePose3D framePose = new FramePose3D(ReferenceFrame.getWorldFrame());
        Point3D position = new Point3D(x, y, z);
        Quaternion orientation = new Quaternion();
        orientation.setYawPitchRoll(Math.toRadians(yaw_degrees), Math.toRadians(0.0), Math.toRadians(0.0));
        framePose.set((Tuple3DReadOnly)position, (Orientation3DReadOnly)orientation);
        return framePose;
    }
}

