/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.inputdevices;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.inputdevices.SliderBoardUtils;

public class SliderBoardUtilsTest {
    @Test
    public void testSimpleConversion() {
        int sliderBoardMax = 128;
        int sliderValue = 64;
        double max = 1.0;
        double min = 0.0;
        double exponent = 1.0;
        double hires = 0.5;
        double value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
        Assert.assertEquals((double)0.5, (double)value, (double)1.0E-7);
        int intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)value);
        Assert.assertEquals((long)intValue, (long)sliderValue);
        sliderValue = 0;
        value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
        Assert.assertEquals((double)0.0, (double)value, (double)1.0E-7);
        intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)value);
        Assert.assertEquals((long)intValue, (long)sliderValue);
        sliderValue = 128;
        value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
        Assert.assertEquals((double)1.0, (double)value, (double)1.0E-7);
        intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)value);
        Assert.assertEquals((long)intValue, (long)sliderValue);
    }

    @Test
    public void testSimpleSquareConversion() {
        int sliderBoardMax = 128;
        double max = 1.0;
        double min = 0.0;
        double exponent = 2.0;
        double hires = 0.5;
        int sliderValue = 64;
        double value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
        Assert.assertEquals((double)0.5, (double)value, (double)1.0E-7);
        int intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires, (double)value);
        Assert.assertEquals((long)intValue, (long)sliderValue);
        sliderValue = 0;
        value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
        Assert.assertEquals((double)0.0, (double)value, (double)1.0E-7);
        intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires, (double)value);
        Assert.assertEquals((long)intValue, (long)sliderValue);
        sliderValue = 128;
        value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
        Assert.assertEquals((double)1.0, (double)value, (double)1.0E-7);
        intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires, (double)value);
        Assert.assertEquals((long)intValue, (long)sliderValue);
        sliderValue = 96;
        value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
        Assert.assertEquals((double)0.625, (double)value, (double)1.0E-7);
        intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires, (double)value);
        Assert.assertEquals((long)intValue, (long)sliderValue);
        sliderValue = 32;
        value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
        Assert.assertEquals((double)0.375, (double)value, (double)1.0E-7);
        intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires, (double)value);
        Assert.assertEquals((long)intValue, (long)sliderValue);
    }

    @Test
    public void testRandomConversions() {
        Random random = new Random(1776L);
        int sliderBoardMax = random.nextInt(1000);
        double max = RandomNumbers.nextDouble((Random)random, (double)0.5, (double)10.0);
        double min = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)0.4);
        double exponent = RandomNumbers.nextDouble((Random)random, (double)0.1, (double)10.0);
        for (int sliderValue = 0; sliderValue < sliderBoardMax; ++sliderValue) {
            double value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent);
            int intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)value);
            Assert.assertEquals((long)intValue, (long)sliderValue);
        }
    }

    @Test
    public void testRandomConversionsWithHires() {
        Random random = new Random(1776L);
        int sliderBoardMax = random.nextInt(1000);
        double max = RandomNumbers.nextDouble((Random)random, (double)0.5, (double)10.0);
        double min = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)0.4);
        double exponent = RandomNumbers.nextDouble((Random)random, (double)0.1, (double)10.0);
        double hires = RandomNumbers.nextDouble((Random)random, (double)min, (double)max);
        for (int sliderValue = 0; sliderValue < sliderBoardMax; ++sliderValue) {
            double value = SliderBoardUtils.valueRatioConvertToDoubleWithExponents((int)sliderValue, (int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires);
            int intValue = SliderBoardUtils.valueRatioConvertToIntWithExponents((int)sliderBoardMax, (double)max, (double)min, (double)exponent, (double)hires, (double)value);
            Assert.assertEquals((long)intValue, (long)sliderValue);
        }
    }
}

