/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.ground;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.convexPolytope.Face3D;
import us.ihmc.euclid.shape.convexPolytope.interfaces.Face3DReadOnly;
import us.ihmc.euclid.shape.convexPolytope.tools.EuclidPolytopeFactories;
import us.ihmc.euclid.shape.tools.EuclidShapeRandomTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.simulationConstructionSetTools.util.ground.ConvexPolytopeTerrainObject;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;

public class ConvexPolytopeTerrainObjectTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;
    private static final boolean SHOW_VISUALIZATION = false;
    private SimulationConstructionSet scs = null;

    @AfterEach
    public void tearDown() {
        if (this.scs != null) {
            this.scs.closeAndDispose();
            this.scs = null;
        }
    }

    @Test
    public void testWithVisualization() {
    }

    @Test
    public void testHeightAt() {
        Random random = new Random(83432L);
        Vector3D vectorNormal = new Vector3D(0.0, 0.0, 1.0);
        ConvexPolytopeTerrainObject convexPolytopeTerrainObject = new ConvexPolytopeTerrainObject(vectorNormal, EuclidPolytopeFactories.newCube((double)1.0));
        Double heightAt = convexPolytopeTerrainObject.heightAt(0.5, 0.5, -5.0);
        Assertions.assertEquals((Double)heightAt, (double)Double.NEGATIVE_INFINITY);
        heightAt = convexPolytopeTerrainObject.heightAt(0.5, -0.5, 1.0);
        Assertions.assertEquals((Double)heightAt, (double)0.5);
        heightAt = convexPolytopeTerrainObject.heightAt(-0.5, 0.5, 0.5);
        Assertions.assertEquals((Double)heightAt, (double)0.5);
        heightAt = convexPolytopeTerrainObject.heightAt(-0.5, 0.2, -1.0);
        Assertions.assertEquals((Double)heightAt, (double)Double.NEGATIVE_INFINITY);
        heightAt = convexPolytopeTerrainObject.heightAt(-0.5, -0.5, -0.5);
        Assertions.assertEquals((Double)heightAt, (double)0.5);
        for (int i = 0; i < 1000; ++i) {
            Double x = random.nextDouble();
            Double y = random.nextDouble();
            Double z = random.nextDouble();
            Point3D point = new Point3D(x.doubleValue(), y.doubleValue(), z.doubleValue());
            ConvexPolytope3D convexPolytope = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)point);
            ConvexPolytopeTerrainObject convexPolytopeTerraian = new ConvexPolytopeTerrainObject(vectorNormal, convexPolytope);
            Double heightAtPointInsideConvexPolytope = convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), z.doubleValue());
            Assertions.assertNotEquals((Double)heightAtPointInsideConvexPolytope, (double)0.0);
            Assertions.assertTrue((boolean)ConvexPolytopeTerrainObjectTest.isPointInsideOneOfTheFaces(convexPolytope, x, y, heightAtPointInsideConvexPolytope));
            Double heightAtPointAboveConvexPolytope = convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), convexPolytopeTerraian.getBoundingBox().getMaxZ() + 1.0);
            Assertions.assertTrue((boolean)ConvexPolytopeTerrainObjectTest.isPointInsideOneOfTheFaces(convexPolytope, x, y, heightAtPointAboveConvexPolytope));
            Assertions.assertEquals((double)heightAtPointInsideConvexPolytope, (double)heightAtPointAboveConvexPolytope, (double)1.0E-12);
            Point3D pointOnFace = new Point3D(x.doubleValue(), y.doubleValue(), heightAtPointAboveConvexPolytope.doubleValue());
            Double heightAtPointOnFaceOfConvexPolytope = convexPolytopeTerraian.heightAt(pointOnFace.getX(), pointOnFace.getY(), pointOnFace.getZ());
            Assertions.assertEquals((double)heightAtPointOnFaceOfConvexPolytope, (double)pointOnFace.getZ(), (double)1.0E-12);
            Double heightAtPointUnderConvexPolytope = convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), convexPolytopeTerraian.getBoundingBox().getMinZ() - 1.0);
            Assertions.assertEquals((Double)heightAtPointUnderConvexPolytope, (double)Double.NEGATIVE_INFINITY);
            Double heightAtPointOutsideOfConvexPolytope = convexPolytopeTerraian.heightAt(x.doubleValue(), convexPolytopeTerraian.getBoundingBox().getMaxY() + 1.0, z.doubleValue());
            Assertions.assertEquals((Double)heightAtPointOutsideOfConvexPolytope, (double)Double.NEGATIVE_INFINITY);
            heightAtPointOutsideOfConvexPolytope = convexPolytopeTerraian.heightAt(x.doubleValue(), convexPolytopeTerraian.getBoundingBox().getMinY() - 1.0, z.doubleValue());
            Assertions.assertEquals((Double)heightAtPointOutsideOfConvexPolytope, (double)Double.NEGATIVE_INFINITY);
            heightAtPointOutsideOfConvexPolytope = convexPolytopeTerraian.heightAt(convexPolytopeTerraian.getBoundingBox().getMaxX() + 1.0, y.doubleValue(), z.doubleValue());
            Assertions.assertEquals((Double)heightAtPointOutsideOfConvexPolytope, (double)Double.NEGATIVE_INFINITY);
            heightAtPointOutsideOfConvexPolytope = convexPolytopeTerraian.heightAt(convexPolytopeTerraian.getBoundingBox().getMinX() - 1.0, y.doubleValue(), z.doubleValue());
            Assertions.assertEquals((Double)heightAtPointOutsideOfConvexPolytope, (double)Double.NEGATIVE_INFINITY);
        }
    }

    @Test
    public void testCheckIfInside() {
        Random random = new Random(148547L);
        Vector3D vectorNormal = new Vector3D(0.0, 0.0, 1.0);
        Point3D intersectionToPack = new Point3D();
        Vector3D normalToPack = new Vector3D();
        for (int i = 0; i < 1000; ++i) {
            Double x = random.nextDouble();
            Double y = random.nextDouble();
            Double z = random.nextDouble();
            Point3D point = new Point3D(x.doubleValue(), y.doubleValue(), z.doubleValue());
            ConvexPolytope3D convexPolytope = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)point);
            ConvexPolytopeTerrainObject convexPolytopeTerraian = new ConvexPolytopeTerrainObject(vectorNormal, convexPolytope);
            intersectionToPack.set(0.0, 0.0, 0.0);
            normalToPack.set(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)convexPolytopeTerraian.checkIfInside(x.doubleValue(), y.doubleValue(), z.doubleValue(), (Point3DBasics)intersectionToPack, (Vector3DBasics)normalToPack));
            Assertions.assertEquals((Double)x, (double)intersectionToPack.getX());
            Assertions.assertEquals((Double)y, (double)intersectionToPack.getY());
            Assertions.assertEquals((double)convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), z.doubleValue()), (double)intersectionToPack.getZ());
            Assertions.assertEquals((Object)((Face3D)convexPolytope.getClosestFace((Point3DReadOnly)intersectionToPack)).getNormal(), (Object)normalToPack);
            Double zAboveConvexPolytope = z + convexPolytopeTerraian.getBoundingBox().getMaxZ() + 1.0;
            intersectionToPack.set(0.0, 0.0, 0.0);
            normalToPack.set(0.0, 0.0, 0.0);
            Assertions.assertFalse((boolean)convexPolytopeTerraian.checkIfInside(x.doubleValue(), y.doubleValue(), zAboveConvexPolytope.doubleValue(), (Point3DBasics)intersectionToPack, (Vector3DBasics)normalToPack));
            Assertions.assertEquals((Double)x, (double)intersectionToPack.getX());
            Assertions.assertEquals((Double)y, (double)intersectionToPack.getY());
            Assertions.assertEquals((double)convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), z.doubleValue()), (double)intersectionToPack.getZ(), (double)1.0E-12);
            Assertions.assertEquals((Object)((Face3D)convexPolytope.getClosestFace((Point3DReadOnly)intersectionToPack)).getNormal(), (Object)normalToPack);
            Double zBelowConvexPolytope = z + convexPolytopeTerraian.getBoundingBox().getMinZ() - 1.0;
            intersectionToPack.set(0.0, 0.0, 0.0);
            normalToPack.set(0.0, 0.0, 0.0);
            Assertions.assertFalse((boolean)convexPolytopeTerraian.checkIfInside(x.doubleValue(), y.doubleValue(), zBelowConvexPolytope.doubleValue(), (Point3DBasics)intersectionToPack, (Vector3DBasics)normalToPack));
            Assertions.assertEquals((Double)x, (double)intersectionToPack.getX());
            Assertions.assertEquals((Double)y, (double)intersectionToPack.getY());
            Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)intersectionToPack.getZ());
            Assertions.assertEquals((double)normalToPack.getX(), (double)0.0);
            Assertions.assertEquals((double)normalToPack.getY(), (double)0.0);
            Assertions.assertEquals((double)normalToPack.getZ(), (double)0.0);
            Double xOutsideConvexPolytope = x + convexPolytopeTerraian.getBoundingBox().getMaxX() + 1.0;
            intersectionToPack.set(0.0, 0.0, 0.0);
            normalToPack.set(0.0, 0.0, 0.0);
            Assertions.assertFalse((boolean)convexPolytopeTerraian.checkIfInside(xOutsideConvexPolytope.doubleValue(), y.doubleValue(), z.doubleValue(), (Point3DBasics)intersectionToPack, (Vector3DBasics)normalToPack));
            Assertions.assertEquals((Double)xOutsideConvexPolytope, (double)intersectionToPack.getX());
            Assertions.assertEquals((Double)y, (double)intersectionToPack.getY());
            Assertions.assertEquals((double)Double.NEGATIVE_INFINITY, (double)intersectionToPack.getZ());
            Assertions.assertEquals((double)normalToPack.getX(), (double)0.0);
            Assertions.assertEquals((double)normalToPack.getY(), (double)0.0);
            Assertions.assertEquals((double)normalToPack.getZ(), (double)0.0);
            intersectionToPack.set(0.0, 0.0, 0.0);
            normalToPack.set(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)convexPolytopeTerraian.checkIfInside(x.doubleValue(), y.doubleValue(), z.doubleValue(), null, (Vector3DBasics)normalToPack));
            intersectionToPack.set(x.doubleValue(), y.doubleValue(), convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), z.doubleValue()));
            Assertions.assertEquals((Object)((Face3D)convexPolytope.getClosestFace((Point3DReadOnly)intersectionToPack)).getNormal(), (Object)normalToPack);
            intersectionToPack.set(0.0, 0.0, 0.0);
            normalToPack.set(0.0, 0.0, 0.0);
            Assertions.assertTrue((boolean)convexPolytopeTerraian.checkIfInside(x.doubleValue(), y.doubleValue(), z.doubleValue(), (Point3DBasics)intersectionToPack, null));
            intersectionToPack.set(x.doubleValue(), y.doubleValue(), convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), z.doubleValue()));
            Assertions.assertEquals((Double)x, (double)intersectionToPack.getX());
            Assertions.assertEquals((Double)y, (double)intersectionToPack.getY());
            Assertions.assertEquals((double)convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), z.doubleValue()), (double)intersectionToPack.getZ());
            Assertions.assertTrue((boolean)convexPolytopeTerraian.checkIfInside(x.doubleValue(), y.doubleValue(), z.doubleValue(), null, null));
        }
    }

    @Test
    public void testHeightAndNormalAt() {
        Random random = new Random(52141L);
        Vector3D vectorNormal = new Vector3D(0.0, 0.0, 1.0);
        Vector3D normalToPack = new Vector3D();
        for (int i = 0; i < 1000; ++i) {
            Double x = random.nextDouble();
            Double y = random.nextDouble();
            Double z = random.nextDouble();
            Point3D point = new Point3D(x.doubleValue(), y.doubleValue(), z.doubleValue());
            ConvexPolytope3D convexPolytope = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)point);
            ConvexPolytopeTerrainObject convexPolytopeTerraian = new ConvexPolytopeTerrainObject(vectorNormal, convexPolytope);
            normalToPack.set(0.0, 0.0, 0.0);
            Double heightAt = convexPolytopeTerraian.heightAndNormalAt(x.doubleValue(), y.doubleValue(), z.doubleValue(), (Vector3DBasics)normalToPack);
            Assertions.assertEquals((Double)heightAt, (double)convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), z.doubleValue()));
            Assertions.assertEquals((Object)((Face3D)convexPolytope.getClosestFace((Point3DReadOnly)new Point3D(x.doubleValue(), y.doubleValue(), heightAt.doubleValue()))).getNormal(), (Object)normalToPack);
            Double zAboveConvexPolytope = z + convexPolytopeTerraian.getBoundingBox().getMaxZ() + 1.0;
            normalToPack.set(0.0, 0.0, 0.0);
            heightAt = convexPolytopeTerraian.heightAndNormalAt(x.doubleValue(), y.doubleValue(), zAboveConvexPolytope.doubleValue(), (Vector3DBasics)normalToPack);
            Assertions.assertNotEquals((Double)heightAt, (double)Double.NEGATIVE_INFINITY);
            Assertions.assertEquals((double)heightAt, (double)convexPolytopeTerraian.heightAt(x.doubleValue(), y.doubleValue(), z.doubleValue()), (double)1.0E-12);
            Assertions.assertEquals((Object)((Face3D)convexPolytope.getClosestFace((Point3DReadOnly)new Point3D(x.doubleValue(), y.doubleValue(), heightAt.doubleValue()))).getNormal(), (Object)normalToPack);
            Double zBelowConvexPolytope = z + convexPolytopeTerraian.getBoundingBox().getMinZ() - 1.0;
            normalToPack.set(0.0, 0.0, 0.0);
            heightAt = convexPolytopeTerraian.heightAndNormalAt(x.doubleValue(), y.doubleValue(), zBelowConvexPolytope.doubleValue(), (Vector3DBasics)normalToPack);
            Assertions.assertEquals((Double)heightAt, (double)Double.NEGATIVE_INFINITY);
            Assertions.assertEquals((double)normalToPack.getX(), (double)0.0);
            Assertions.assertEquals((double)normalToPack.getY(), (double)0.0);
            Assertions.assertEquals((double)normalToPack.getZ(), (double)0.0);
            Double xOutsideConvexPolytope = x + convexPolytopeTerraian.getBoundingBox().getMaxX() + 1.0;
            normalToPack.set(0.0, 0.0, 0.0);
            heightAt = convexPolytopeTerraian.heightAndNormalAt(xOutsideConvexPolytope.doubleValue(), y.doubleValue(), z.doubleValue(), (Vector3DBasics)normalToPack);
            Assertions.assertEquals((Double)heightAt, (double)Double.NEGATIVE_INFINITY);
            Assertions.assertEquals((double)normalToPack.getX(), (double)0.0);
            Assertions.assertEquals((double)normalToPack.getY(), (double)0.0);
            Assertions.assertEquals((double)normalToPack.getZ(), (double)0.0);
        }
    }

    @Test
    public void testIsClose() {
        Random random = new Random(22512L);
        Vector3D vectorNormal = new Vector3D(0.0, 0.0, 1.0);
        for (int i = 0; i < 1000; ++i) {
            Double x = random.nextDouble();
            Double y = random.nextDouble();
            Double z = random.nextDouble();
            Point3D point = new Point3D(x.doubleValue(), y.doubleValue(), z.doubleValue());
            ConvexPolytope3D convexPolytope = EuclidShapeRandomTools.nextTetrahedronContainingPoint3D((Random)random, (Point3DReadOnly)point);
            ConvexPolytopeTerrainObject convexPolytopeTerraian = new ConvexPolytopeTerrainObject(vectorNormal, convexPolytope);
            Assertions.assertTrue((boolean)convexPolytopeTerraian.isClose(x.doubleValue(), y.doubleValue(), z.doubleValue()));
            Assertions.assertTrue((boolean)convexPolytopeTerraian.isClose(convexPolytope.getBoundingBox().getMaxX(), convexPolytope.getBoundingBox().getMaxY(), convexPolytope.getBoundingBox().getMaxZ()));
            Assertions.assertFalse((boolean)convexPolytopeTerraian.isClose(x.doubleValue(), y.doubleValue(), convexPolytope.getBoundingBox().getMaxZ() + 1.0));
            Assertions.assertFalse((boolean)convexPolytopeTerraian.isClose(x.doubleValue(), y.doubleValue(), convexPolytope.getBoundingBox().getMinZ() - 1.0));
            Assertions.assertFalse((boolean)convexPolytopeTerraian.isClose(convexPolytope.getBoundingBox().getMaxX() + 1.0, y.doubleValue(), z.doubleValue()));
            Assertions.assertFalse((boolean)convexPolytopeTerraian.isClose(convexPolytope.getBoundingBox().getMinX() - 1.0, y.doubleValue(), z.doubleValue()));
            Assertions.assertFalse((boolean)convexPolytopeTerraian.isClose(x.doubleValue(), convexPolytope.getBoundingBox().getMaxY() + 1.0, z.doubleValue()));
            Assertions.assertFalse((boolean)convexPolytopeTerraian.isClose(x.doubleValue(), convexPolytope.getBoundingBox().getMinY() - 1.0, z.doubleValue()));
        }
    }

    private static Boolean isPointInsideOneOfTheFaces(ConvexPolytope3D convexPolytope, Double x, Double y, Double z) {
        Point3D point = new Point3D(x.doubleValue(), y.doubleValue(), z.doubleValue());
        for (Face3DReadOnly face : convexPolytope.getFaces()) {
            if (!face.isPointInside((Point3DReadOnly)point, 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    private static void addGraphicWithTestPoints(Graphics3DObject viz, ConvexPolytopeTerrainObject convexPolytopeTerrainObject, Double xPoint, Double yPoint, Double zPoint, AppearanceDefinition lineAppearance) {
        double result = convexPolytopeTerrainObject.heightAt(xPoint.doubleValue(), yPoint.doubleValue(), zPoint.doubleValue());
        if (result != Double.NEGATIVE_INFINITY) {
            viz.identity();
            viz.translate(xPoint.doubleValue(), yPoint.doubleValue(), zPoint.doubleValue());
            viz.addSphere(0.04, YoAppearance.Red());
            viz.identity();
            viz.translate(xPoint.doubleValue(), yPoint.doubleValue(), result);
            viz.addSphere(0.04, YoAppearance.Yellow());
        } else {
            viz.identity();
            viz.translate(xPoint.doubleValue(), yPoint.doubleValue(), zPoint.doubleValue());
            viz.addCube(0.08, 0.08, 0.08, YoAppearance.Red());
        }
        viz.identity();
        viz.translate(xPoint.doubleValue(), yPoint.doubleValue(), -500.0);
        viz.addCylinder(1000.0, 0.008, lineAppearance);
    }
}

