/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.globalParameters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.BooleanGlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameter;
import us.ihmc.simulationConstructionSetTools.util.globalParameters.GlobalParameterChangedListener;

public class BooleanGlobalParameterTest {
    private static final boolean VERBOSE = false;
    private final boolean DEFAULT_VALUE = true;

    @BeforeEach
    public void setUp() throws Exception {
        GlobalParameter.clearGlobalRegistry();
    }

    @AfterEach
    public void tearDown() throws Exception {
        GlobalParameter.clearGlobalRegistry();
    }

    @Test
    public void testGetValue() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        BooleanGlobalParameter booleanGlobalParameter = new BooleanGlobalParameter("testParameter", "test description", true, systemOutGlobalParameterChangedListener);
        Assert.assertEquals((Object)true, (Object)booleanGlobalParameter.getValue());
    }

    @Test
    public void testSetValue() {
        GlobalParameterChangedListener systemOutGlobalParameterChangedListener = null;
        BooleanGlobalParameter booleanGlobalParameter = new BooleanGlobalParameter("testParameter", "test description", true, systemOutGlobalParameterChangedListener);
        boolean newValue = false;
        booleanGlobalParameter.set(newValue);
        Assert.assertEquals((Object)newValue, (Object)booleanGlobalParameter.getValue());
        newValue = false;
        booleanGlobalParameter.set(newValue, "setting");
        Assert.assertEquals((Object)newValue, (Object)booleanGlobalParameter.getValue());
        newValue = true;
        booleanGlobalParameter.setOnlyIfChange(newValue, "setting");
        Assert.assertEquals((Object)newValue, (Object)booleanGlobalParameter.getValue());
        newValue = false;
        booleanGlobalParameter.setOnlyIfChange(newValue, "setting");
        Assert.assertEquals((Object)newValue, (Object)booleanGlobalParameter.getValue());
    }

    @Test
    public void testThatCantHaveParentsUnlessOverwriteUpdateMethodOne() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            BooleanGlobalParameter parent = new BooleanGlobalParameter("parent", "parent", true, null);
            BooleanGlobalParameter invalidChild = new BooleanGlobalParameter("invalidChild", "test description", new GlobalParameter[]{parent}, null);
            parent.set(false);
        });
    }

    @Test
    public void testCantSetChild() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            BooleanGlobalParameter parent = new BooleanGlobalParameter("parent", "", true, null);
            BooleanGlobalParameter child = new BooleanGlobalParameter("child", "", new GlobalParameter[]{parent}, null);
            child.set(false, "Shouldn't be able to change this!");
        });
    }
}

