/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.gui;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.simulationconstructionset.gui.BodePlotConstructor;
import us.ihmc.simulationconstructionset.gui.FFTPlotter;
import us.ihmc.simulationconstructionset.gui.HumanAssistedTestFrame;

public class BodePlotConstructorTest {
    @Disabled
    @Test
    public void testSimpleFilter() {
        double T = 5.0;
        double DT = 0.0025;
        int n = (int)(T / DT);
        double[] time = BodePlotConstructorTest.generateLinearSpace(n, 0.0, DT);
        double freqHz = 10.0;
        double amplitude = 1.0;
        double[] input = BodePlotConstructorTest.generateChirp(time, freqHz);
        double[] output = BodePlotConstructorTest.filter(BodePlotConstructorTest.filter(BodePlotConstructorTest.filter(input)));
        double[][] timeAndInputAndOutput = new double[][]{time, input, output};
        BodePlotConstructorTest.plotTimeInputOutputBode(timeAndInputAndOutput);
        HumanAssistedTestFrame humanAssistedTestFrame = new HumanAssistedTestFrame("HumanAssistedTestFrame");
        humanAssistedTestFrame.waitForButtonPush();
        humanAssistedTestFrame.setVisible(false);
    }

    @Disabled
    @Test
    public void testSingleFreqPhaseShift() {
        double T = 5.0;
        double DT = 0.0025;
        int n = (int)(T / DT);
        double[] time = BodePlotConstructorTest.generateLinearSpace(n, 0.0, DT);
        double freqHz = 10.0;
        double amplitude = 1.0;
        double phaseShiftDegrees = 90.0;
        double[] input = BodePlotConstructorTest.generateSineWave(time, amplitude, freqHz, 0.0);
        double[] output = BodePlotConstructorTest.generateSineWave(time, amplitude, freqHz, phaseShiftDegrees);
        double[][] timeAndInputAndOutput = new double[][]{time, input, output};
        BodePlotConstructorTest.plotTimeInputOutputBode(timeAndInputAndOutput);
        HumanAssistedTestFrame humanAssistedTestFrame = new HumanAssistedTestFrame("HumanAssistedTestFrame");
        humanAssistedTestFrame.waitForButtonPush();
        humanAssistedTestFrame.setVisible(false);
    }

    @Disabled
    @Test
    public void testSecondOrderResponse() {
        double T = 5.0;
        double DT = 0.0025;
        int n = (int)(T / DT);
        double[] time = BodePlotConstructorTest.generateLinearSpace(n, 0.0, DT);
        double freqHz = 10.0;
        double[] input = BodePlotConstructorTest.generateChirp(time, freqHz);
        double wn = 62.83185307179586;
        double zeta = 0.1;
        double[] output = BodePlotConstructorTest.produceSecondOrderResponse(wn, zeta, input, DT);
        double[][] timeAndInputAndOutput = new double[][]{time, input, output};
        BodePlotConstructorTest.plotTimeInputOutputBode(timeAndInputAndOutput);
        BodePlotConstructorTest.deriveSecondOrderResponseUsingTransferFunctions(wn, zeta);
        HumanAssistedTestFrame humanAssistedTestFrame = new HumanAssistedTestFrame("HumanAssistedTestFrame");
        humanAssistedTestFrame.waitForButtonPush();
        humanAssistedTestFrame.setVisible(false);
    }

    private static void deriveSecondOrderResponseUsingTransferFunctions(double wn, double zeta) {
        double[] numerator = new double[]{wn * wn};
        double[] denominator = new double[]{1.0, 2.0 * zeta * wn, wn * wn};
        TransferFunction secondOrderTransferFunction = new TransferFunction(numerator, denominator);
        int numFreqs = 10000;
        double w0 = 0.2;
        double wIncrement = 0.2;
        int wnIndex = (int)((wn - w0) / wIncrement);
        double[] ws = BodePlotConstructorTest.generateLinearSpace(numFreqs, w0, wIncrement);
        double[] magnitudes = secondOrderTransferFunction.getMagnitude(ws);
        double[] phases = secondOrderTransferFunction.getPhase(ws);
        double wnMagnitude = magnitudes[wnIndex];
        double wnPhase = phases[wnIndex];
        double wnMagnitudeDecibels = 20.0 * Math.log10(wnMagnitude);
        double wnPhaseDegrees = wnPhase * 180.0 / Math.PI;
        System.out.println("wnIndex = " + wnIndex + ", wnMagnitude = " + wnMagnitude + ", wnPhase = " + wnPhase);
        System.out.println("wnMagnitudeDecibels = " + wnMagnitudeDecibels + ", wnPhaseDegrees = " + wnPhaseDegrees);
        BodePlotConstructorTest.plotBodeForTransferFunction("2nd order Transfer Function", secondOrderTransferFunction, ws);
    }

    private static double[] generateChirp(double[] time, double freqHz) {
        double[] ret = new double[time.length];
        for (int i = 0; i < time.length; ++i) {
            ret[i] = Math.sin(Math.PI * 2 * freqHz * time[i] * time[i]);
        }
        return ret;
    }

    private static double[] generateSineWave(double[] time, double amplitude, double freqHz, double phaseDegrees) {
        double[] ret = new double[time.length];
        for (int i = 0; i < time.length; ++i) {
            ret[i] = amplitude * Math.sin(Math.PI * 2 * freqHz * time[i] + phaseDegrees * Math.PI / 180.0);
        }
        return ret;
    }

    private static double[] generateLinearSpace(int numPoints, double x0, double xIncrement) {
        double[] ret = new double[numPoints];
        for (int i = 0; i < numPoints; ++i) {
            ret[i] = x0 + xIncrement * (double)i;
        }
        return ret;
    }

    private static double[] filter(double[] input) {
        int n = input.length;
        double[] output = new double[n];
        double alpha = 0.5;
        double previousOutput = 0.0;
        for (int i = 0; i < n; ++i) {
            output[i] = alpha * previousOutput + (1.0 - alpha) * input[i];
            previousOutput = output[i];
        }
        return output;
    }

    private static double[] produceSecondOrderResponse(double wn, double zeta, double[] input, double DT) {
        double[] output = new double[input.length];
        double ydd = 0.0;
        double yd = 0.0;
        double y = 0.0;
        for (int i = 0; i < input.length; ++i) {
            double x = input[i];
            ydd = -2.0 * zeta * wn * yd - wn * wn * y + wn * wn * x;
            output[i] = y += DT * (yd += DT * ydd);
        }
        return output;
    }

    private static void plotTimeInputOutputBode(double[][] timeAndInputAndOutput) {
        double[] time = timeAndInputAndOutput[0];
        double[] input = timeAndInputAndOutput[1];
        double[] output = timeAndInputAndOutput[2];
        BodePlotConstructor.plotFFT((String)"input", (double[])time, (double[])input);
        BodePlotConstructor.plotFFT((String)"output", (double[])time, (double[])output);
        BodePlotConstructor.plotBodeFromInputToOutput((String)"input", (String)"output", (double[])time, (double[])input, (double[])output);
    }

    public static void plotBodeForTransferFunction(String name, TransferFunction transferFunction, double[] omega) {
        double[] bodeMagnitude = transferFunction.getMagnitude(omega);
        for (int i = 0; i < bodeMagnitude.length; ++i) {
            bodeMagnitude[i] = Conversions.amplitudeToDecibels((double)bodeMagnitude[i]);
        }
        double[] bodePhase = transferFunction.getPhase(omega);
        for (int i = 0; i < bodePhase.length; ++i) {
            bodePhase[i] = Math.toDegrees(bodePhase[i]);
        }
        double[] bodeFrequency = new double[omega.length];
        for (int i = 0; i < omega.length; ++i) {
            bodeFrequency[i] = Conversions.radiansPerSecondToHertz((double)omega[i]);
        }
        double[][] bodeData = new double[][]{bodeFrequency, bodeMagnitude, bodePhase};
        FFTPlotter plot = new FFTPlotter((double[][])bodeData, name + " Bode Plot", "(Hz)", "(dB)", "(deg)");
        plot.packAndDisplayFrame(0, 0);
    }
}

