/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.robotController;

import us.ihmc.commons.Conversions;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.simulationConstructionSetTools.robotController.DoublePendulum;
import us.ihmc.simulationConstructionSetTools.robotController.MultiThreadedRobotControlElement;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class DoublePendulumController
implements MultiThreadedRobotControlElement {
    private final YoRegistry registry = new YoRegistry("DoublePendulumController");
    private final YoDouble q_j1 = new YoDouble("q_j1", this.registry);
    private final YoDouble qd_j1 = new YoDouble("qd_j1", this.registry);
    private final YoDouble q_j2 = new YoDouble("q_j2", this.registry);
    private final YoDouble qd_j2 = new YoDouble("qd_j2", this.registry);
    private final YoDouble tau_j1 = new YoDouble("tau_j1", this.registry);
    private final YoDouble tau_j2 = new YoDouble("tau_j2", this.registry);
    private final YoDouble q_j1_d = new YoDouble("q_j1_d", this.registry);
    private final YoDouble q_j2_d = new YoDouble("q_j2_d", this.registry);
    private final YoDouble kp = new YoDouble("kp", this.registry);
    private final YoDouble kd = new YoDouble("kd", this.registry);
    private final YoLong tick = new YoLong("tick", this.registry);
    private final DoublePendulum doublePendulum;

    public DoublePendulumController(DoublePendulum doublePendulum) {
        this.doublePendulum = doublePendulum;
    }

    public void initialize() {
        this.kp.set(100.0);
        this.kd.set(10.0);
        this.doublePendulum.getJ1().setQ(0.1);
    }

    public void read(long currentClockTime) {
        this.q_j1.set(this.doublePendulum.getJ1().getQYoVariable().getDoubleValue());
        this.qd_j1.set(this.doublePendulum.getJ1().getQDYoVariable().getDoubleValue());
        this.q_j2.set(this.doublePendulum.getJ2().getQYoVariable().getDoubleValue());
        this.qd_j2.set(this.doublePendulum.getJ2().getQDYoVariable().getDoubleValue());
    }

    public void run() {
        this.q_j1_d.set(this.q_j1_d.getDoubleValue() + 0.1);
        this.q_j2_d.set(this.q_j2_d.getDoubleValue() + 0.05);
        this.tau_j1.set(this.kp.getDoubleValue() * (this.q_j1_d.getDoubleValue() - this.q_j1.getDoubleValue()) + this.kd.getDoubleValue() * -this.qd_j1.getDoubleValue());
        this.tau_j2.set(this.kp.getDoubleValue() * (this.q_j2_d.getDoubleValue() - this.q_j2.getDoubleValue()) + this.kd.getDoubleValue() * -this.qd_j2.getDoubleValue());
        this.tick.increment();
        long start = System.nanoTime();
        while (System.nanoTime() - start < Conversions.millisecondsToNanoseconds((long)10L)) {
        }
    }

    public void write(long timestamp) {
        this.doublePendulum.getJ1().setTau(this.tau_j1.getDoubleValue());
        this.doublePendulum.getJ2().setTau(this.tau_j2.getDoubleValue());
    }

    public YoRegistry getYoVariableRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public YoGraphicsListRegistry getYoGraphicsListRegistry() {
        return null;
    }

    public long nextWakeupTime() {
        return 0L;
    }
}

