/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.environments;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.environments.environmentRobots.ContactableDoorRobot;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ContactableDoorRobotTest {
    private YoRegistry doorTestRegistry;
    private Robot[] robots;
    private final SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
    private final SimulationTestingParameters testingParams = new SimulationTestingParameters();
    RigidBodyTransform doorToWorldTransform = new RigidBodyTransform();

    @Test
    public void testPointIsClose() {
        double epsilon = 1.0E-4;
        Point3D pos = new Point3D(5.0, -5.0, 10.0);
        ContactableDoorRobot door = this.createDefaultDoor(pos, 0);
        Point3D tempPos = new Point3D((Tuple3DReadOnly)pos);
        Assert.assertFalse((boolean)door.isClose(new Point3D()));
        Assert.assertFalse((boolean)door.isClose(new Point3D(10000.0, -10000.0, 10000.0)));
        Assert.assertTrue((boolean)door.isPointOnOrInside(tempPos));
        Point3D diagonal = new Point3D(tempPos.getX() + (1.0 - epsilon) * ContactableDoorRobot.DEFAULT_DOOR_DIMENSIONS.getX(), tempPos.getY() + (1.0 - epsilon) * ContactableDoorRobot.DEFAULT_DOOR_DIMENSIONS.getY(), tempPos.getZ() + (1.0 - epsilon) * ContactableDoorRobot.DEFAULT_DOOR_DIMENSIONS.getZ());
        Assert.assertTrue((boolean)door.isPointOnOrInside(diagonal));
    }

    @Test
    public void testDoorIsClosing() {
        this.doorTestRegistry = new YoRegistry("doorTestRegistry");
        this.robots = new Robot[1];
        Point3D pos = new Point3D(2.0, 1.0, 0.0);
        int id = 1;
        ContactableDoorRobot door = this.createDefaultDoor(pos, id);
        this.robots[0] = door;
        door.setYaw(0.3);
        door.setKdDoor(1.0);
        door.setKpDoor(0.1);
        SimulationConstructionSet scs = new SimulationConstructionSet(this.robots, this.parameters);
        scs.addYoRegistry(this.doorTestRegistry);
        Thread myThread = new Thread((Runnable)scs);
        myThread.start();
        BlockingSimulationRunner blockingSimulationRunner = new BlockingSimulationRunner(scs, 60.0);
        try {
            blockingSimulationRunner.simulateAndBlock(60.0);
        }
        catch (Exception e) {
            PrintTools.error((Object)this, (String)e.getMessage());
        }
        Assert.assertTrue((Math.abs(door.getHingeYaw()) < 0.001 ? 1 : 0) != 0);
        if (this.testingParams.getKeepSCSUp()) {
            ThreadTools.sleepForever();
        }
    }

    private ContactableDoorRobot createDefaultDoor(Point3D positionInWorld, int id) {
        return new ContactableDoorRobot("robotDoor" + id, positionInWorld);
    }
}

