/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.utilities.math.geometry;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.plotting.artifact.PolygonArtifact;
import us.ihmc.plotting.PlotterPanel;
import us.ihmc.robotics.geometry.BoundingBoxKDTree2D;
import us.ihmc.robotics.geometry.ConvexPolygon2dIntersectionSetCalculator;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.simulationConstructionSetTools.util.ground.steppingStones.SteppingStones;

public class FindTentativeListOfPolygonsIntersectingTargetPolygonTest {
    private static final boolean VERBOSE = false;
    private static final boolean SHOW_PLOTTER = false;

    @Test
    public void testFindTentativeListOfPolygonsIntersectingTargetPolygon() {
        PlotterPanel plotterpanel = this.createPlotterPanel();
        Random random = new Random(1776L);
        ArrayList<ConvexPolygon2D> convexPolygon2ds = new ArrayList<ConvexPolygon2D>();
        ArrayList<ConvexPolygon2D> intersectingPolygon2ds = new ArrayList<ConvexPolygon2D>();
        ArrayList steppintStonesIntersectingCaptureRegion = new ArrayList();
        ArrayList<PolygonArtifact> polygon1 = new ArrayList<PolygonArtifact>();
        int numberOfPolygons = 200;
        for (int i = 0; i < numberOfPolygons; ++i) {
            Point2D randomPoint1 = new Point2D(this.generateRandomDouble(random, -100.0, 200.0), this.generateRandomDouble(random, -100.0, 100.0));
            Point2D randomPoint2 = new Point2D(this.generateRandomDouble(random, randomPoint1.getX(), 200.0), this.generateRandomDouble(random, randomPoint1.getY(), 100.0));
            ArrayList<Point2D> points = this.generateRandomCircularPoints(randomPoint1.getX(), randomPoint2.getX(), randomPoint1.getY(), randomPoint2.getY(), 10);
            ConvexPolygon2D polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
            convexPolygon2ds.add(polygon);
            polygon1.add(new PolygonArtifact("polygon" + i, false, Color.BLACK, polygon));
        }
        ArrayList<Point2D> points = this.generateRandomCircularPoints(-50.0, 50.0, -50.0, 50.0, 7);
        ConvexPolygon2D captureRegionPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
        polygon1.add(new PolygonArtifact("captureRegionPolygon", false, Color.red, captureRegionPolygon));
        ConvexPolygon2dIntersectionSetCalculator convexPolygon2dIntersectionSetCalculator = new ConvexPolygon2dIntersectionSetCalculator(convexPolygon2ds);
        steppintStonesIntersectingCaptureRegion = convexPolygon2dIntersectionSetCalculator.findIntersectionPolygonList(captureRegionPolygon);
        if (steppintStonesIntersectingCaptureRegion != null && !steppintStonesIntersectingCaptureRegion.isEmpty()) {
            for (int i = 0; i < steppintStonesIntersectingCaptureRegion.size(); ++i) {
                polygon1.add(new PolygonArtifact("steppintStonesIntersectingCaptureRegion" + i, true, Color.green, (ConvexPolygon2D)steppintStonesIntersectingCaptureRegion.get(i)));
            }
        }
        this.displayPolygons(plotterpanel, polygon1);
        int count = 0;
        for (int i = 0; i < convexPolygon2ds.size(); ++i) {
            ConvexPolygon2D intersection = new ConvexPolygon2D();
            boolean success = new ConvexPolygonTools().computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon2ds.get(i), (ConvexPolygon2DReadOnly)captureRegionPolygon, (ConvexPolygon2DBasics)intersection);
            if (success) {
                intersectingPolygon2ds.add(intersection);
                ++count;
                continue;
            }
            intersectingPolygon2ds.add(null);
        }
        if (count != steppintStonesIntersectingCaptureRegion.size()) {
            throw new RuntimeException("Bug Alert! Not equal number of intersections");
        }
        ArrayList steppingtStonesIntersectingCaptureRegionCopy = new ArrayList(steppintStonesIntersectingCaptureRegion);
        for (int i = 0; i < convexPolygon2ds.size(); ++i) {
            if (intersectingPolygon2ds.get(i) == null) continue;
            boolean matchingPolygonFound = false;
            for (int j = 0; j < steppingtStonesIntersectingCaptureRegionCopy.size(); ++j) {
                if (!((ConvexPolygon2D)intersectingPolygon2ds.get(i)).epsilonEquals((ConvexPolygon2D)steppingtStonesIntersectingCaptureRegionCopy.get(j), 1.0E-7)) continue;
                matchingPolygonFound = true;
                steppingtStonesIntersectingCaptureRegionCopy.remove(j);
                break;
            }
            if (matchingPolygonFound) continue;
            throw new RuntimeException("Bug Alert! matching Polygon not found");
        }
        if (!steppingtStonesIntersectingCaptureRegionCopy.isEmpty()) {
            throw new RuntimeException("Bug Alert! Same intersections not found");
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void testFindTentativeListOfPolygonsIntersectingTargetPolygonTwo() {
        PlotterPanel plotterpanel = this.createPlotterPanel();
        ArrayList<ConvexPolygon2D> convexPolygon2ds = new ArrayList<ConvexPolygon2D>();
        ArrayList steppintStonesIntersectingCaptureRegion = new ArrayList();
        ArrayList<PolygonArtifact> polygon1 = new ArrayList<PolygonArtifact>();
        ArrayList<Point2D> points1 = new ArrayList<Point2D>();
        ArrayList<Point2D> points2 = new ArrayList<Point2D>();
        points1.add(new Point2D(-6.0, -2.0));
        points1.add(new Point2D(-6.0, 2.0));
        points1.add(new Point2D(6.0, 2.0));
        points1.add(new Point2D(6.0, -2.0));
        ConvexPolygon2D convexPolygon2d = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points1));
        polygon1.add(new PolygonArtifact("polygon1", false, Color.BLACK, points1));
        convexPolygon2ds.add(convexPolygon2d);
        points2.add(new Point2D(-5.0, -5.0));
        points2.add(new Point2D(-5.0, 5.0));
        points2.add(new Point2D(5.0, 5.0));
        points2.add(new Point2D(5.0, -5.0));
        ConvexPolygon2D captureRegionPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points2));
        polygon1.add(new PolygonArtifact("captureRegionPolygon", false, Color.red, points2));
        ConvexPolygon2dIntersectionSetCalculator convexPolygon2dIntersectionSetCalculator = new ConvexPolygon2dIntersectionSetCalculator(convexPolygon2ds);
        steppintStonesIntersectingCaptureRegion = convexPolygon2dIntersectionSetCalculator.findIntersectionPolygonList(captureRegionPolygon);
        ConvexPolygon2D correctAnswer = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])new double[][]{{-5.0, 2.0}, {5.0, 2.0}, {5.0, -2.0}, {-5.0, -2.0}}));
        if (!((ConvexPolygon2D)steppintStonesIntersectingCaptureRegion.get(0)).epsilonEquals(correctAnswer, 1.0E-7)) {
            throw new RuntimeException("Bug Alert!");
        }
        for (int i = 0; i < steppintStonesIntersectingCaptureRegion.size(); ++i) {
            polygon1.add(new PolygonArtifact("steppintStonesIntersectingCaptureRegion" + i, true, Color.green, (ConvexPolygon2D)steppintStonesIntersectingCaptureRegion.get(i)));
        }
        this.displayPolygons(plotterpanel, polygon1);
        try {
            Thread.sleep(500L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void testFindTentativeListOfPolygonsIntersectingTargetPolygonThree() {
        PlotterPanel plotterpanel = this.createPlotterPanel();
        ArrayList convexPolygon2ds = new ArrayList();
        ArrayList steppintStonesIntersectingCaptureRegion = new ArrayList();
        ArrayList<ConvexPolygon2D> intersectingPolygon2ds = new ArrayList<ConvexPolygon2D>();
        ArrayList<PolygonArtifact> polygon1 = new ArrayList<PolygonArtifact>();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D(-0.5, -0.5));
        points.add(new Point2D(-0.5, 0.5));
        points.add(new Point2D(0.5, 0.5));
        points.add(new Point2D(0.5, -0.5));
        ConvexPolygon2D convexPolygon2d = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
        SteppingStones steppingStones = new SteppingStones();
        steppingStones = SteppingStones.generateRectangularUniformSteppingStones((double)-15.0, (double)-10.0, (double)2.0, (double)2.0, (double)0.5, (double)0.5, (double)-0.1, (double)0.0, (int)9, (int)13, (ConvexPolygon2D)convexPolygon2d, (boolean)false);
        for (int i = 0; i < 117; ++i) {
            convexPolygon2ds.add(steppingStones.getConvexPolygons().get(i));
            polygon1.add(new PolygonArtifact("polygon" + i, false, Color.BLACK, (ConvexPolygon2D)steppingStones.getConvexPolygons().get(i)));
        }
        points.clear();
        points.add(new Point2D(-5.0, -5.0));
        points.add(new Point2D(-5.0, 5.0));
        points.add(new Point2D(5.0, 5.0));
        points.add(new Point2D(5.0, -5.0));
        ConvexPolygon2D captureRegionPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
        polygon1.add(new PolygonArtifact("captureRegionPolygon", false, Color.blue, points));
        ConvexPolygon2dIntersectionSetCalculator convexPolygon2dIntersectionSetCalculator = new ConvexPolygon2dIntersectionSetCalculator(convexPolygon2ds);
        steppintStonesIntersectingCaptureRegion = convexPolygon2dIntersectionSetCalculator.findIntersectionPolygonList(captureRegionPolygon);
        for (int i = 0; i < steppintStonesIntersectingCaptureRegion.size(); ++i) {
            ConvexPolygon2D convexPolygon2d2 = (ConvexPolygon2D)steppintStonesIntersectingCaptureRegion.get(i);
            polygon1.add(new PolygonArtifact("steppintStonesIntersectingCaptureRegion" + i, true, Color.green, convexPolygon2d2));
        }
        this.displayPolygons(plotterpanel, polygon1);
        int count = 0;
        for (int i = 0; i < convexPolygon2ds.size(); ++i) {
            ConvexPolygon2D intersection = new ConvexPolygon2D();
            boolean success = new ConvexPolygonTools().computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon2ds.get(i), (ConvexPolygon2DReadOnly)captureRegionPolygon, (ConvexPolygon2DBasics)intersection);
            if (success) {
                intersectingPolygon2ds.add(intersection);
                ++count;
                continue;
            }
            intersectingPolygon2ds.add(null);
        }
        if (count != steppintStonesIntersectingCaptureRegion.size()) {
            throw new RuntimeException("Bug Alert! Not equal number of intersections");
        }
        ArrayList steppintStonesIntersectingCaptureRegionCopy = new ArrayList(steppintStonesIntersectingCaptureRegion);
        for (int i = 0; i < convexPolygon2ds.size(); ++i) {
            if (intersectingPolygon2ds.get(i) == null) continue;
            boolean matchingPolygonFound = false;
            for (int j = 0; j < steppintStonesIntersectingCaptureRegionCopy.size(); ++j) {
                if (!((ConvexPolygon2D)intersectingPolygon2ds.get(i)).epsilonEquals((ConvexPolygon2D)steppintStonesIntersectingCaptureRegionCopy.get(j), 1.0E-7)) continue;
                matchingPolygonFound = true;
                steppintStonesIntersectingCaptureRegionCopy.remove(j);
                break;
            }
            if (matchingPolygonFound) continue;
            throw new RuntimeException("Bug Alert! matching Polygon not found");
        }
        if (!steppintStonesIntersectingCaptureRegionCopy.isEmpty()) {
            throw new RuntimeException("Bug Alert! Same intersections not found");
        }
        try {
            Thread.sleep(500L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void testFindTentativeListOfPolygonsIntersectingTargetPolygonTiming() {
        int i;
        int i2;
        Random random = new Random(1776L);
        ArrayList<ConvexPolygon2D> convexPolygon2ds = new ArrayList<ConvexPolygon2D>();
        ArrayList<ConvexPolygon2D> captureRegionPolygon = new ArrayList<ConvexPolygon2D>();
        ArrayList intersectingBoundingBoxes = new ArrayList();
        ArrayList<BoundingBox2D> boundingBoxes = new ArrayList<BoundingBox2D>();
        ArrayList tentativeListofSteppintStonesIntersectingCaptureRegion = new ArrayList();
        ArrayList steppintStonesIntersectingCaptureRegion = new ArrayList();
        for (i2 = 0; i2 < 200; ++i2) {
            Point2D randomPoint1 = new Point2D(this.generateRandomDouble(random, -200.0, 200.0), this.generateRandomDouble(random, -200.0, 200.0));
            Point2D randomPoint2 = new Point2D(this.generateRandomDouble(random, randomPoint1.getX(), 200.0), this.generateRandomDouble(random, randomPoint1.getY(), 200.0));
            ArrayList<Point2D> points = this.generateRandomCircularPoints(randomPoint1.getX(), randomPoint2.getX(), randomPoint1.getY(), randomPoint2.getY(), 15);
            ConvexPolygon2D polygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
            convexPolygon2ds.add(polygon);
        }
        for (i2 = 0; i2 < convexPolygon2ds.size(); ++i2) {
            ConvexPolygon2D convexPolygon2d = (ConvexPolygon2D)convexPolygon2ds.get(i2);
            boundingBoxes.add(convexPolygon2d.getBoundingBox());
        }
        ArrayList convexPolygon2dObjects = new ArrayList(convexPolygon2ds);
        long startTime = System.currentTimeMillis();
        BoundingBoxKDTree2D kdTree = new BoundingBoxKDTree2D(boundingBoxes, convexPolygon2dObjects);
        long endTime = System.currentTimeMillis();
        double timeToBuildKDTree = endTime - startTime;
        startTime = System.currentTimeMillis();
        ConvexPolygon2dIntersectionSetCalculator convexPolygon2dIntersectionSetCalculator = new ConvexPolygon2dIntersectionSetCalculator(convexPolygon2ds);
        endTime = System.currentTimeMillis();
        timeToBuildKDTree = endTime - startTime;
        int numTests = 10000;
        for (i = 0; i < numTests; ++i) {
            Point2D randomPoint1 = new Point2D(this.generateRandomDouble(random, -50.0, 50.0), this.generateRandomDouble(random, -50.0, 50.0));
            Point2D randomPoint2 = new Point2D(this.generateRandomDouble(random, randomPoint1.getX(), 50.0), this.generateRandomDouble(random, randomPoint1.getY(), 50.0));
            ArrayList<Point2D> points = this.generateRandomCircularPoints(randomPoint1.getX(), randomPoint2.getX(), randomPoint1.getY(), randomPoint2.getY(), 10);
            captureRegionPolygon.add(new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points)));
        }
        startTime = System.currentTimeMillis();
        for (i = 0; i < numTests; ++i) {
            intersectingBoundingBoxes.clear();
            ConvexPolygon2D convexPolygon2d = (ConvexPolygon2D)captureRegionPolygon.get(i);
            intersectingBoundingBoxes = kdTree.getIntersectingBoundingBoxes(convexPolygon2d.getBoundingBox());
        }
        endTime = System.currentTimeMillis();
        double timePerBoundingBoxSearch = (double)(endTime - startTime) / (double)numTests;
        startTime = System.currentTimeMillis();
        for (int i3 = 0; i3 < numTests; ++i3) {
            tentativeListofSteppintStonesIntersectingCaptureRegion.clear();
            tentativeListofSteppintStonesIntersectingCaptureRegion = convexPolygon2dIntersectionSetCalculator.findTentativeListOfPolygonsIntersectingTargetPolygon((ConvexPolygon2D)captureRegionPolygon.get(i3));
        }
        endTime = System.currentTimeMillis();
        double timePerTentativeList = (double)(endTime - startTime) / (double)numTests;
        startTime = System.currentTimeMillis();
        for (int i4 = 0; i4 < numTests; ++i4) {
            steppintStonesIntersectingCaptureRegion.clear();
            steppintStonesIntersectingCaptureRegion = convexPolygon2dIntersectionSetCalculator.findIntersectionPolygonList((ConvexPolygon2D)captureRegionPolygon.get(i4));
        }
        endTime = System.currentTimeMillis();
        double timePerActualIntersectingPolygonsList = (double)(endTime - startTime) / (double)numTests;
    }

    @Test
    public void testBadCase() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D(47.213206532573494, 33.6934385384089));
        points.add(new Point2D(47.184403978806806, 33.6901486028859));
        points.add(new Point2D(47.18629896969355, 33.945259199418715));
        points.add(new Point2D(47.1996820005182, 37.28788526977694));
        points.add(new Point2D(47.20659834223872, 36.93933424308558));
        new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
    }

    private ArrayList<Point2D> generateRandomCircularPoints(double xMin, double xMax, double yMin, double yMax, int numberOfPoints) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        Random random = new Random(1972L);
        Point2D zeroPoint = new Point2D((xMax + xMin) / 2.0, (yMax + yMin) / 2.0);
        for (int i = 0; i < numberOfPoints; ++i) {
            Point2D randomPoint = new Point2D(this.generateRandomDouble(random, xMin, xMax), this.generateRandomDouble(random, yMin, yMax));
            if (randomPoint.distance((Point2DReadOnly)zeroPoint) > Math.max((xMax - xMin) / 2.0, (yMax - yMin) / 2.0)) continue;
            points.add(randomPoint);
        }
        return points;
    }

    private double generateRandomDouble(Random random, double min, double max) {
        return min + random.nextDouble() * (max - min);
    }

    private void displayPolygons(PlotterPanel plotterpanel, ArrayList<PolygonArtifact> polygonArtifacts) {
        if (plotterpanel == null) {
            return;
        }
        for (int i = 0; i < polygonArtifacts.size(); ++i) {
            plotterpanel.getPlotter().addArtifact((Artifact)polygonArtifacts.get(i));
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private PlotterPanel createPlotterPanel() {
        return null;
    }
}

