/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.dataProcessors;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.yoVariables.variable.YoDouble;

public class TwoLinkRobotForTesting
extends Robot {
    private final boolean SHOW_COORDINATE_SYSTEM = true;
    public static final boolean SHOW_MASS_BASED_GRAPHICS = true;
    public static final double linkLength = 0.3;
    public static final double bodyLength = 0.6;
    public static final double upperArmMass = 9.0;
    public static double lowerArmMass = 3.0;
    public static double bodyMass = 128.0;
    private final double activeLegLength = 1.0;
    private final double hopperBodyRadius = 0.25;
    private final double gravity;
    private final PinJoint upperJoint;
    private final PinJoint elbowJoint;
    private YoDouble bodyPitch;

    public TwoLinkRobotForTesting() {
        super("TwoLink");
        this.gravity = 9.81;
        this.setGravity(0.0, 0.0, -this.gravity);
        this.upperJoint = new PinJoint("upper", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 1.2), (Robot)this, (Vector3DReadOnly)Axis3D.Y);
        Link upperArmLink = this.upperArm();
        this.upperJoint.setLink(upperArmLink);
        this.upperJoint.setLimitStops(-2.0, 5.0, 2.0, 1000.0);
        this.upperJoint.setVelocityLimits(7.0, 1000.0);
        this.upperJoint.setDynamic(true);
        this.addRootJoint((Joint)this.upperJoint);
        this.elbowJoint = new PinJoint("elbow", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.3), (Robot)this, (Vector3DReadOnly)Axis3D.Y);
        this.upperJoint.addJoint((Joint)this.elbowJoint);
        Link lowerArmLink = this.lowerArm();
        this.elbowJoint.setLink(lowerArmLink);
        this.elbowJoint.setLimitStops(-4.0, 3.0, 2.0, 1.0);
        this.elbowJoint.setVelocityLimits(4.0, 1.0);
    }

    public double getGravity() {
        return this.gravity;
    }

    public double getBodyPitch() {
        return this.bodyPitch.getValueAsDouble();
    }

    private Link upperArm() {
        Link link = new Link("upperArm");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        link.setLinkGraphics(linkGraphics);
        link.setMass(9.0);
        link.setComOffset(0.0, 0.0, -0.15);
        link.setMomentOfInertia(0.5625, 0.5625, 0.5625);
        linkGraphics.addCoordinateSystem(0.09);
        linkGraphics.addCube(0.03, 0.03, -0.3, YoAppearance.Red());
        return link;
    }

    public double getElbowAngle() {
        return this.elbowJoint.getQYoVariable().getDoubleValue();
    }

    public double getElbowVelocity() {
        return this.elbowJoint.getQDYoVariable().getDoubleValue();
    }

    public double getElbowTorque() {
        return this.elbowJoint.getTauYoVariable().getDoubleValue();
    }

    public void setElbowTorque(double torque) {
        this.elbowJoint.setTau(torque);
    }

    public void setElbowPosition(double value) {
        this.elbowJoint.setQ(value);
    }

    public void setUpperPosition(double value) {
        this.upperJoint.setQ(value);
    }

    public void setElbowVelocity(double velocity) {
        this.elbowJoint.setQd(velocity);
    }

    public void setUpperVelocity(double velocity) {
        this.upperJoint.setQd(velocity);
    }

    public void setElbowAcceleration(double value) {
        this.elbowJoint.setQdd(value);
    }

    public void setUpperAcceleration(double value) {
        this.upperJoint.setQdd(value);
    }

    private Link lowerArm() {
        Link link = new Link("upperArm");
        Graphics3DObject linkGraphics = new Graphics3DObject();
        link.setLinkGraphics(linkGraphics);
        link.setMass(lowerArmMass);
        link.setComOffset(0.0, 0.0, -0.15);
        link.setMomentOfInertia(lowerArmMass * 0.25 * 0.25, lowerArmMass * 0.25 * 0.25, lowerArmMass * 0.25 * 0.25);
        linkGraphics.addCoordinateSystem(0.09);
        linkGraphics.addCube(0.03, 0.03, -0.3, YoAppearance.White());
        return link;
    }
}

