/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.featherstone;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.RobotTest;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;

public class PinnedFloatingJointTest {
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testPinnedFloatingJoint() throws Exception, UnreasonableAccelerationException {
        Random random = new Random(39847534L);
        double dt = 0.001;
        for (int iteration = 0; iteration < 50; ++iteration) {
            int i;
            int numberOneDoFJoints = random.nextInt(15) + 1;
            Robot robotA = new Robot("pinnedRobot");
            FloatingJoint pinnedJointA = new FloatingJoint("pinned", (Tuple3DReadOnly)new Vector3D(), robotA);
            pinnedJointA.setPinned(true);
            pinnedJointA.setLink(PinnedFloatingJointTest.nextLink(random.nextLong()));
            robotA.addRootJoint((Joint)pinnedJointA);
            Robot robotB = new Robot("robotWithoutFloatingJoint");
            FloatingJoint parentJointA = pinnedJointA;
            OneDegreeOfFreedomJoint parentJointB = null;
            OneDegreeOfFreedomJoint[] oneDoFJointsA = new OneDegreeOfFreedomJoint[numberOneDoFJoints];
            OneDegreeOfFreedomJoint[] oneDoFJointsB = new OneDegreeOfFreedomJoint[numberOneDoFJoints];
            for (i = 0; i < numberOneDoFJoints; ++i) {
                long seed = random.nextLong();
                OneDegreeOfFreedomJoint nextJointA = PinnedFloatingJointTest.nextOneDegreeOfFreedomJoint(seed, robotA);
                OneDegreeOfFreedomJoint nextJointB = PinnedFloatingJointTest.nextOneDegreeOfFreedomJoint(seed, robotB);
                nextJointA.setLink(PinnedFloatingJointTest.nextLink(seed));
                nextJointB.setLink(PinnedFloatingJointTest.nextLink(seed));
                parentJointA.addJoint((Joint)nextJointA);
                if (parentJointB == null) {
                    robotB.addRootJoint((Joint)nextJointB);
                } else {
                    parentJointB.addJoint((Joint)nextJointB);
                }
                oneDoFJointsA[i] = nextJointA;
                oneDoFJointsB[i] = nextJointB;
                parentJointA = nextJointA;
                parentJointB = nextJointB;
            }
            for (i = 0; i < 100; ++i) {
                int jointIndex;
                pinnedJointA.setVelocity((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                pinnedJointA.setAngularVelocityInBody((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                pinnedJointA.setAcceleration((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                pinnedJointA.setAngularAccelerationInBody((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                for (jointIndex = 0; jointIndex < numberOneDoFJoints; ++jointIndex) {
                    double tau = random.nextDouble();
                    oneDoFJointsA[jointIndex].setTau(tau);
                    oneDoFJointsB[jointIndex].setTau(tau);
                }
                robotA.doDynamicsAndIntegrate(dt);
                robotB.doDynamicsAndIntegrate(dt);
                Assert.assertEquals(0.0, pinnedJointA.getQx().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getQy().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getQz().getValue(), 1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)new Quaternion(), (EuclidGeometry)pinnedJointA.getQuaternion(), (double)1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getQdx().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getQdy().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getQdz().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getAngularVelocityX().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getAngularVelocityY().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getAngularVelocityZ().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getQddx().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getQddy().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getQddz().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getAngularAccelerationX().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getAngularAccelerationY().getValue(), 1.0E-12);
                Assert.assertEquals(0.0, pinnedJointA.getAngularAccelerationZ().getValue(), 1.0E-12);
                for (jointIndex = 0; jointIndex < numberOneDoFJoints; ++jointIndex) {
                    Assert.assertEquals(oneDoFJointsA[jointIndex].getQ(), oneDoFJointsB[jointIndex].getQ(), 1.0E-12);
                    Assert.assertEquals(oneDoFJointsA[jointIndex].getQD(), oneDoFJointsB[jointIndex].getQD(), 1.0E-12);
                    Assert.assertEquals(oneDoFJointsA[jointIndex].getQDD(), oneDoFJointsB[jointIndex].getQDD(), 1.0E-12);
                }
            }
        }
    }

    @Test
    public void testUnpinningFloatingJoint() throws Exception, UnreasonableAccelerationException {
        Random random = new Random(39847534L);
        double dt = 0.001;
        for (int iteration = 0; iteration < 50; ++iteration) {
            double tau;
            int i;
            int numberOneDoFJoints = random.nextInt(15) + 1;
            Robot robotA = new Robot("unpinningRobot");
            FloatingJoint floatingJointA = new FloatingJoint("unpinning", (Tuple3DReadOnly)new Vector3D(), robotA);
            floatingJointA.setPinned(true);
            long rootLinkSeed = random.nextLong();
            floatingJointA.setLink(PinnedFloatingJointTest.nextLink(rootLinkSeed));
            robotA.addRootJoint((Joint)floatingJointA);
            Robot robotB = new Robot("robotWithFloatingJoint");
            FloatingJoint floatingJointB = new FloatingJoint("unpinning", (Tuple3DReadOnly)new Vector3D(), robotB);
            floatingJointB.setLink(PinnedFloatingJointTest.nextLink(rootLinkSeed));
            robotB.addRootJoint((Joint)floatingJointB);
            FloatingJoint parentJointA = floatingJointA;
            FloatingJoint parentJointB = floatingJointB;
            OneDegreeOfFreedomJoint[] oneDoFJointsA = new OneDegreeOfFreedomJoint[numberOneDoFJoints];
            OneDegreeOfFreedomJoint[] oneDoFJointsB = new OneDegreeOfFreedomJoint[numberOneDoFJoints];
            for (i = 0; i < numberOneDoFJoints; ++i) {
                long seed = random.nextLong();
                OneDegreeOfFreedomJoint nextJointA = PinnedFloatingJointTest.nextOneDegreeOfFreedomJoint(seed, robotA);
                OneDegreeOfFreedomJoint nextJointB = PinnedFloatingJointTest.nextOneDegreeOfFreedomJoint(seed, robotB);
                nextJointA.setLink(PinnedFloatingJointTest.nextLink(seed));
                nextJointB.setLink(PinnedFloatingJointTest.nextLink(seed));
                parentJointA.addJoint((Joint)nextJointA);
                parentJointB.addJoint((Joint)nextJointB);
                oneDoFJointsA[i] = nextJointA;
                oneDoFJointsB[i] = nextJointB;
                parentJointA = nextJointA;
                parentJointB = nextJointB;
            }
            for (i = 0; i < 100; ++i) {
                floatingJointA.setVelocity((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                floatingJointA.setAngularVelocityInBody((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                floatingJointA.setAcceleration((Tuple3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                floatingJointA.setAngularAccelerationInBody((Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
                for (int jointIndex = 0; jointIndex < numberOneDoFJoints; ++jointIndex) {
                    tau = random.nextDouble();
                    oneDoFJointsA[jointIndex].setTau(tau);
                }
                robotA.doDynamicsAndIntegrate(dt);
            }
            floatingJointB.getQx().set(floatingJointA.getQx().getValue());
            floatingJointB.getQy().set(floatingJointA.getQy().getValue());
            floatingJointB.getQz().set(floatingJointA.getQz().getValue());
            floatingJointB.getQuaternionQs().set(floatingJointA.getQuaternionQs().getValue());
            floatingJointB.getQuaternionQx().set(floatingJointA.getQuaternionQx().getValue());
            floatingJointB.getQuaternionQy().set(floatingJointA.getQuaternionQy().getValue());
            floatingJointB.getQuaternionQz().set(floatingJointA.getQuaternionQz().getValue());
            for (int jointIndex = 0; jointIndex < numberOneDoFJoints; ++jointIndex) {
                oneDoFJointsB[jointIndex].setQ(oneDoFJointsA[jointIndex].getQ());
                oneDoFJointsB[jointIndex].setQd(oneDoFJointsA[jointIndex].getQD());
                oneDoFJointsB[jointIndex].setQdd(oneDoFJointsA[jointIndex].getQDD());
            }
            floatingJointA.setPinned(false);
            for (i = 0; i < 100; ++i) {
                int jointIndex;
                for (jointIndex = 0; jointIndex < numberOneDoFJoints; ++jointIndex) {
                    tau = random.nextDouble();
                    oneDoFJointsA[jointIndex].setTau(tau);
                    oneDoFJointsB[jointIndex].setTau(tau);
                }
                robotA.doDynamicsAndIntegrate(dt);
                robotB.doDynamicsAndIntegrate(dt);
                Assert.assertEquals(floatingJointB.getQx().getValue(), floatingJointA.getQx().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getQy().getValue(), floatingJointA.getQy().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getQz().getValue(), floatingJointA.getQz().getValue(), 1.0E-12);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)floatingJointB.getQuaternion(), (EuclidGeometry)floatingJointA.getQuaternion(), (double)1.0E-12);
                Assert.assertEquals(floatingJointB.getQdx().getValue(), floatingJointA.getQdx().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getQdy().getValue(), floatingJointA.getQdy().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getQdz().getValue(), floatingJointA.getQdz().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getAngularVelocityX().getValue(), floatingJointA.getAngularVelocityX().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getAngularVelocityY().getValue(), floatingJointA.getAngularVelocityY().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getAngularVelocityZ().getValue(), floatingJointA.getAngularVelocityZ().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getQddx().getValue(), floatingJointA.getQddx().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getQddy().getValue(), floatingJointA.getQddy().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getQddz().getValue(), floatingJointA.getQddz().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getAngularAccelerationX().getValue(), floatingJointA.getAngularAccelerationX().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getAngularAccelerationY().getValue(), floatingJointA.getAngularAccelerationY().getValue(), 1.0E-12);
                Assert.assertEquals(floatingJointB.getAngularAccelerationZ().getValue(), floatingJointA.getAngularAccelerationZ().getValue(), 1.0E-12);
                for (jointIndex = 0; jointIndex < numberOneDoFJoints; ++jointIndex) {
                    Assert.assertEquals(oneDoFJointsA[jointIndex].getQ(), oneDoFJointsB[jointIndex].getQ(), 1.0E-12);
                    Assert.assertEquals(oneDoFJointsA[jointIndex].getQD(), oneDoFJointsB[jointIndex].getQD(), 1.0E-12);
                    Assert.assertEquals(oneDoFJointsA[jointIndex].getQDD(), oneDoFJointsB[jointIndex].getQDD(), 1.0E-12);
                }
            }
        }
    }

    private static Link nextLink(long seed) {
        Random random = new Random(seed);
        Link link = new Link("randomLink" + random.nextInt());
        link.setMass(random.nextDouble());
        link.setComOffset(RandomNumbers.nextDouble((Random)random, (double)1.0), RandomNumbers.nextDouble((Random)random, (double)1.0), RandomNumbers.nextDouble((Random)random, (double)1.0));
        link.setMomentOfInertia((Matrix3DReadOnly)RobotTest.getRotationalInertiaMatrixOfSolidEllipsoid(link.getMass(), random.nextDouble(), random.nextDouble(), random.nextDouble()));
        return link;
    }

    private static OneDegreeOfFreedomJoint nextOneDegreeOfFreedomJoint(long seed, Robot rob) {
        Random random = new Random(seed);
        if (random.nextBoolean()) {
            return PinnedFloatingJointTest.nextPinJoint(seed, rob);
        }
        return PinnedFloatingJointTest.nextSliderJoint(seed, rob);
    }

    private static PinJoint nextPinJoint(long seed, Robot rob) {
        Random random = new Random(seed);
        String jname = "randomPinJoint" + random.nextInt();
        Vector3D offset = EuclidCoreRandomTools.nextVector3D((Random)random);
        Axis3D jaxis = Axis3D.values[random.nextInt(Axis3D.values.length)];
        PinJoint pinJoint = new PinJoint(jname, (Tuple3DReadOnly)offset, rob, (Vector3DReadOnly)jaxis);
        pinJoint.setQ(random.nextDouble());
        pinJoint.setQd(random.nextDouble());
        return pinJoint;
    }

    private static SliderJoint nextSliderJoint(long seed, Robot rob) {
        Random random = new Random(seed);
        String jname = "randomSliderJoint" + random.nextInt();
        Vector3D offset = EuclidCoreRandomTools.nextVector3D((Random)random);
        Axis3D jaxis = Axis3D.values[random.nextInt(Axis3D.values.length)];
        SliderJoint sliderJoint = new SliderJoint(jname, (Tuple3DReadOnly)offset, rob, (Vector3DReadOnly)jaxis);
        sliderJoint.setQ(random.nextDouble());
        sliderJoint.setQd(random.nextDouble());
        return sliderJoint;
    }
}

