/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import org.fest.swing.edt.FailOnThreadViolationRepaintManager;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.graphicsDescription.structure.Graphics3DNodeType;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsList;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.jMonkeyEngineToolkit.camera.CaptureDevice;
import us.ihmc.jMonkeyEngineToolkit.camera.ClassicCameraController;
import us.ihmc.jMonkeyEngineToolkit.jme.JMEGraphics3DAdapter;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.ExitActionListener;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.ExtraPanelConfiguration;
import us.ihmc.simulationconstructionset.GraphConfiguration;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.NewDataListener;
import us.ihmc.simulationconstructionset.PlayCycleListener;
import us.ihmc.simulationconstructionset.PlaybackListener;
import us.ihmc.simulationconstructionset.RewoundListener;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.SimulationDoneCriterion;
import us.ihmc.simulationconstructionset.SimulationDoneListener;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.ViewportConfiguration;
import us.ihmc.simulationconstructionset.examples.FallingBrickRobot;
import us.ihmc.simulationconstructionset.graphics.GraphicsDynamicGraphicsObject;
import us.ihmc.simulationconstructionset.gui.GraphArrayWindow;
import us.ihmc.simulationconstructionset.gui.StandardGUIActions;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.ViewportWindow;
import us.ihmc.simulationconstructionset.gui.YoGraphicMenuManager;
import us.ihmc.simulationconstructionset.gui.camera.CameraTrackAndDollyYoVariablesHolder;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupList;
import us.ihmc.simulationconstructionset.physics.CollisionArbiter;
import us.ihmc.simulationconstructionset.physics.CollisionHandler;
import us.ihmc.simulationconstructionset.physics.CollisionShapeFactory;
import us.ihmc.simulationconstructionset.physics.ScsCollisionConfigure;
import us.ihmc.simulationconstructionset.physics.ScsCollisionDetector;
import us.ihmc.simulationconstructionset.physics.ScsPhysics;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.DefaultCollisionHandler;
import us.ihmc.simulationconstructionset.physics.collision.DefaultCollisionVisualizer;
import us.ihmc.simulationconstructionset.physics.collision.simple.DoNothingCollisionArbiter;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsChangedListener;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableHolder;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.tools.YoSearchTools;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

@Tag(value="gui")
public class SimulationConstructionSetUsingDirectCallsTest {
    private static SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
    private static final long CLOSING_SLEEP_TIME = 2000L;
    private static final long THREAD_SLEEP_TIME = 1000L;
    private static final String SCS_VERSION = "12.06.22";
    private static final String TEST_DIRECTORY = "resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/";
    private static double epsilon = 1.0E-10;
    private final int recordFrequency = 10;
    private final int index = 15;
    private final int inputPoint = 10;
    private final int outputPoint = 50;
    private final int middleIndex = 49;
    private final int keyPoint = Math.round(30.0f);
    private final int nonMiddleIndex = 51;
    private final int ticksIncrease = 11;
    private final int numberOfSimulationTicks = 2000;
    private final int graphGroupNumberOfColumns = 2;
    private final int numberOfTicksBeforeUpdatingGraphs = 2;
    private final int numberOfTicksBeforeUpdatingGraphs2 = 5;
    private final int indexStep = 2;
    private final double simulateDT = 0.001;
    private final double simulateTime = 1.0;
    private final double recordDT = 0.05;
    private final double recordFreq = this.computeRecordFreq(0.05, 0.001);
    private final double realTimeRate = 0.75;
    private final double frameRate = 0.01;
    private final double recomputedSecondsPerFrameRate = this.recomputeTiming(0.001, this.recordFreq, 0.75, 0.01);
    private final double cameraFieldOfView = 1.5;
    private final double secondsOfSimulation = 10.0;
    private final double simulateDurationInSeconds = 2.5;
    private final double[] cameraDollyOffsetXYZValues = new double[]{1.2, 2.2, 3.2};
    private final double[] cameraTrackingOffsetXYZValues = new double[]{1.5, 2.5, 3.5};
    private final double[] cameraDollyXYZVarValues = new double[]{1.5, 1.6, 1.7};
    private final double[] cameraTrackingXYZVarValues = new double[]{0.5, 0.6, 0.7};
    private final double[] cameraFixXYZValues = new double[]{1.8, 2.8, 3.8};
    private final double[] cameraFixXYZValues2 = new double[]{1.1, 2.1, 3.1};
    private final double[] cameraPositionXYZValues = new double[]{1.3, 2.3, 3.3};
    private final double[] cameraClipDistancesNearFarValues = new double[]{1.75, 2.75};
    private final double[] variableGroup1Values = new double[]{1.3, 2.3, 3.3};
    private final double[] variableGroup2Values = new double[]{1.5, 1.6, 1.7};
    private final double[] variableGroup3Values = new double[]{5.5, 5.6, 5.7};
    private final double[] variableGroup4Values = new double[]{8.5, 8.6, 8.7};
    private final double[] variableGroup5Values = new double[]{9.5, 9.6, 9.7};
    private final Point location = new Point(25, 50);
    private final FallingBrickRobot simpleRobot = new FallingBrickRobot();
    private final String rootRegistryName = "root";
    private final String simpleRegistryName = "simpleRegistry";
    private final String searchString = "d";
    private final String searchStringStart = "q";
    private final String[] variableGroup1 = new String[]{"simpleVar11", "simpleVar12", "simpleVar13"};
    private final String[] variableGroup2 = new String[]{"simpleVar21", "simpleVar22", "simpleVar23"};
    private final String[] variableGroup3 = new String[]{"simpleVar31", "simpleVar32", "simpleVar33"};
    private final String[] variableGroup4 = new String[]{"simpleVar41", "simpleVar42", "simpleVar43"};
    private final String[] variableGroup5 = new String[]{"simpleVar51", "simpleVar52", "simpleVar53"};
    private final String[] cameraTrackingXYZVarNames = new String[]{"simpleCameraTrackingVarNameX", "simpleCameraTrackingVarNameY", "simpleCameraTrackingVarNameZ"};
    private final String[] cameraDollyXYZVarNames = new String[]{"simpleCameraDollyVarNameX", "simpleCameraDollyVarNameY", "simpleCameraDollyVarNameZ"};
    private final String configurationName = "simpleConfigurationName";
    private final String cameraConfigurationName = "simpleCameraConfigurationName";
    private final String viewportConfigurationName = "simpleViewportConfiguration";
    private final String varGroupName = "simpleVarGroup";
    private final String varGroupName2 = "simpleVarGroup2";
    private final String varGroupName3 = "simpleVarGroup3";
    private final String graphGroupName = "simpleGraphGroup";
    private final String graphGroupName2 = "simpleGraphGroup2";
    private final String graphGroupName3 = "simpleGraphGroup3";
    private final String graphGroupName4 = "simpleGraphGroup4";
    private final String graphGroupName5 = "simpleGraphGroup5";
    private final String entryBoxGroupName = "simpleEntryBoxGroup";
    private final String entryBoxGroupName2 = "simpleEntryBoxGroup2";
    private final String entryBoxGroupName3 = "simpleEntryBoxGroup3";
    private final String[] graphConfigurationNames = new String[]{"simpleGraphConfiguration", "simpleGraphConfiguration2"};
    private final String extraPanelConfigurationName = "simpleExtraPanelConfigurationName";
    private final String simpleComponentName = "simpleComponent";
    private final String runningName = "simpleRunningName";
    private final String yoGraphicsListName = "simpleYoGraphicsList";
    private final String[][] graphGroupVars = new String[][]{this.cameraTrackingXYZVarNames, this.cameraDollyXYZVarNames};
    private final String[][][] graphGroupVarsWithConfig = new String[][][]{{this.cameraTrackingXYZVarNames, {"config_1"}}, {this.cameraDollyXYZVarNames, {"config_2"}}};
    private final String simpleRobotFirstVariableName = this.getFirstVariableNameFromRobotRegistry((Robot)this.simpleRobot);
    private final String simpleRobotLastVariableName = this.getLastVariableNameFromRobotRegistry((Robot)this.simpleRobot);
    private final String simpleRobotRegistryNamespace = this.getRegistryNamespaceFromRobot((Robot)this.simpleRobot);
    private final String[] regularExpressions = new String[]{"gc.*.fs"};
    private final Dimension dimension = new Dimension(250, 350);
    private YoNamespace simpleRegistryNamespace;
    private YoRegistry simpleRegistry;
    private YoRegistry dummyRegistry;
    private Link staticLink;
    private Graphics3DObject staticLinkGraphics;
    private Graphics3DNodeType graphics3DNodeType;
    private ExternalForcePoint simpleExternalForcePoint;
    private YoGraphic yoGraphic;
    private YoBoolean exitActionListenerHasBeenNotified;
    private YoBoolean simulationRewoundListenerHasBeenNotified;
    private YoBoolean simulationDoneListenerHasBeenNotified;
    private YoBoolean setSimulationDoneCriterion;
    private ExtraPanelConfiguration extraPanelConfiguration;
    private CameraConfiguration cameraConfiguration;
    private ViewportConfiguration viewportConfiguration;
    private GraphConfiguration[] graphConfigurations;
    private YoDouble realTimeRateInSCS;
    private YoBoolean processDataHasBeenCalled;
    private YoBoolean toggleKeyPointModeCommandListenerHasBeenCalled;
    private YoGraphicsListRegistry yoGraphicsListRegistry;
    private YoGraphicMenuManager yoGraphicMenuManager;
    private ScsPhysics simpleScsPhysics;
    private SimulationConstructionSet scs;

    @BeforeAll
    public static void setUpOnce() {
        if (System.getProperty("java.vendor").toLowerCase().contains("oracle")) {
            FailOnThreadViolationRepaintManager.install();
        }
    }

    @BeforeEach
    public void createAndStartSCSWithRobot() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(60L), () -> {
            this.simpleRegistryNamespace = new YoNamespace("root.simpleRegistry");
            this.simpleRegistry = new YoRegistry("simpleRegistry");
            this.dummyRegistry = new YoRegistry("dummyRegistry");
            this.staticLink = new Link("simpleLink");
            this.staticLinkGraphics = this.staticLink.getLinkGraphics();
            this.graphics3DNodeType = Graphics3DNodeType.GROUND;
            this.simpleExternalForcePoint = new ExternalForcePoint("simpleExternalForcePoint", this.dummyRegistry);
            this.yoGraphic = new YoGraphicVector("simpleDynamicGraphicObject", this.simpleExternalForcePoint.getYoPosition(), this.simpleExternalForcePoint.getYoForce(), 0.02);
            this.exitActionListenerHasBeenNotified = new YoBoolean("exitActionListenerHasBeenNotified", this.dummyRegistry);
            this.simulationRewoundListenerHasBeenNotified = new YoBoolean("simulationRewoundListenerHasBeenNotified", this.dummyRegistry);
            this.simulationDoneListenerHasBeenNotified = new YoBoolean("simulationDoneListenerHasBeenNotified", this.dummyRegistry);
            this.setSimulationDoneCriterion = new YoBoolean("setSimulationDoneCriterion", this.dummyRegistry);
            this.extraPanelConfiguration = this.createExtraPanelConfigurationWithPanel("simpleExtraPanelConfigurationName");
            this.cameraConfiguration = this.createCameraConfiguration("simpleCameraConfigurationName");
            this.viewportConfiguration = this.createViewportConfiguration("simpleViewportConfiguration");
            this.viewportConfiguration.addCameraView("Back View", 0, 0, 1, 1);
            this.graphConfigurations = this.createGraphConfigurations(this.graphConfigurationNames);
            this.realTimeRateInSCS = new YoDouble("realTimeRate", this.dummyRegistry);
            this.processDataHasBeenCalled = new YoBoolean("processDataHasBeenCalled", this.dummyRegistry);
            this.toggleKeyPointModeCommandListenerHasBeenCalled = new YoBoolean("toggleKeyPointModeCommandListenerHasBeenCalled", this.dummyRegistry);
            this.yoGraphicsListRegistry = this.createYoGraphicsListRegistryWithObject();
            this.yoGraphicMenuManager = new YoGraphicMenuManager();
            this.scs = new SimulationConstructionSet((Robot)this.simpleRobot, parameters);
            this.simpleScsPhysics = this.createScsPhysics();
            this.scs.startOnAThread();
        });
    }

    @AfterEach
    public void closeSCS() {
        ThreadTools.sleep((long)2000L);
        this.scs.closeAndDispose();
        this.scs = null;
        this.simpleRegistryNamespace = null;
        this.simpleRegistry = null;
        this.dummyRegistry = null;
        this.staticLink = null;
        this.staticLinkGraphics = null;
        this.graphics3DNodeType = null;
        this.simpleExternalForcePoint = null;
        this.yoGraphic = null;
        this.exitActionListenerHasBeenNotified = null;
        this.simulationRewoundListenerHasBeenNotified = null;
        this.simulationDoneListenerHasBeenNotified = null;
        this.setSimulationDoneCriterion = null;
        this.extraPanelConfiguration = null;
        this.cameraConfiguration = null;
        this.viewportConfiguration = null;
        this.graphConfigurations = null;
        this.realTimeRateInSCS = null;
        this.processDataHasBeenCalled = null;
        this.toggleKeyPointModeCommandListenerHasBeenCalled = null;
        this.yoGraphicsListRegistry = null;
        this.yoGraphicMenuManager = null;
        this.simpleScsPhysics = null;
    }

    @Test
    public void testSimulationConstructionSetMiscellaneous() throws AWTException {
        Robot[] robotFromSCS = this.scs.getRobots();
        Assert.assertEquals(this.simpleRobot, robotFromSCS[0]);
        YoRegistry rootRegistryFromSCS = this.scs.getRootRegistry();
        String rootRegistryNameFromSCS = rootRegistryFromSCS.getName();
        Assert.assertEquals("root", rootRegistryNameFromSCS);
        this.scs.addYoRegistry(this.simpleRegistry);
        YoRegistry simpleRegistryFromSCS = this.scs.getRootRegistry().findRegistry(this.simpleRegistryNamespace);
        Assert.assertEquals(this.simpleRegistry, simpleRegistryFromSCS);
        ExitActionListener exitActionListener = this.createExitActionListener();
        this.scs.attachExitActionListener(exitActionListener);
        this.exitActionListenerHasBeenNotified.set(false);
        this.scs.notifyExitActionListeners();
        Assert.assertTrue(this.exitActionListenerHasBeenNotified.getBooleanValue());
        this.scs.setGraphsUpdatedDuringPlayback(false);
        boolean isGraphsUpdatedDuringPlaybackFromSCS = this.scs.areGraphsUpdatedDuringPlayback();
        Assert.assertFalse(isGraphsUpdatedDuringPlaybackFromSCS);
        this.scs.setGraphsUpdatedDuringPlayback(true);
        boolean isGraphsUpdatedDuringPlaybackFromSCS2 = this.scs.areGraphsUpdatedDuringPlayback();
        Assert.assertTrue(isGraphsUpdatedDuringPlaybackFromSCS2);
        this.scs.setScrollGraphsEnabled(true);
        boolean isScrollGraphsEnabled = this.scs.isSafeToScroll();
        Assert.assertTrue(isScrollGraphsEnabled);
        this.scs.setScrollGraphsEnabled(false);
        boolean isScrollGraphsEnabled2 = this.scs.isSafeToScroll();
        Assert.assertFalse(isScrollGraphsEnabled2);
        boolean initialKeyPointStatus = this.scs.areKeyPointsEnabled();
        this.scs.toggleKeyPoints();
        boolean finalKeyPointStatus = this.scs.areKeyPointsEnabled();
        this.assertBooleansAreOpposite(initialKeyPointStatus, finalKeyPointStatus);
        this.scs.setRunName("simpleRunningName");
        String runningNameFromSCS = this.scs.getRunningName();
        Assert.assertEquals("simpleRunningName", runningNameFromSCS);
        String scsVersion = SimulationConstructionSet.getVersion();
        Assert.assertEquals(SCS_VERSION, scsVersion);
        this.scs.disableSystemExit();
        this.scs.enableSystemExit();
        boolean systemExitDisabledFromSCS = this.scs.systemExitDisabled();
        Assert.assertFalse(systemExitDisabledFromSCS);
        this.scs.enableSystemExit();
        this.scs.disableSystemExit();
        boolean systemExitDisabledFromSCS2 = this.scs.systemExitDisabled();
        Assert.assertTrue(systemExitDisabledFromSCS2);
        this.scs.initPhysics(this.simpleScsPhysics);
        ScsPhysics scsPhysicsFromSCS = this.scs.getPhysics();
        Assert.assertEquals(this.simpleScsPhysics, scsPhysicsFromSCS);
    }

    @Test
    public void testSimulationManagement() {
        double startTime = this.scs.getTime();
        this.simulateForTime(this.scs, 1.0);
        double endTime = this.scs.getTime();
        Assert.assertEquals(1.0, endTime - startTime, 1.0E-7);
        this.scs.stop();
        this.scs.simulate(2000);
        boolean isSimulatingFromSCS = this.scs.isSimulating();
        Assert.assertTrue(isSimulatingFromSCS);
        this.scs.stop();
        this.scs.simulate(2000);
        this.scs.stop();
        boolean isSimulatingFromSCS2 = this.scs.isSimulating();
        Assert.assertFalse(isSimulatingFromSCS2);
        this.scs.stop();
        this.scs.simulate(10.0);
        boolean isSimulatingFromSCS3 = this.scs.isSimulating();
        Assert.assertTrue(isSimulatingFromSCS3);
        this.scs.stop();
        this.scs.simulate();
        boolean isSimulatingFromSCS4 = this.scs.isSimulating();
        Assert.assertTrue(isSimulatingFromSCS4);
        this.scs.stop();
        this.scs.play();
        boolean isPlayingFromSCS = this.scs.isPlaying();
        this.scs.stop();
        Assert.assertTrue(isPlayingFromSCS);
        this.scs.setFastSimulate(true);
        boolean isFastSimulateFromSCS = this.scs.isFastSimulateEnabled();
        Assert.assertTrue(isFastSimulateFromSCS);
        this.scs.setFastSimulate(false);
        boolean isFastSimulateFromSCS2 = this.scs.isFastSimulateEnabled();
        Assert.assertFalse(isFastSimulateFromSCS2);
        this.scs.setFastSimulate(true, 2);
        boolean isFastSimulateFromSCS3 = this.scs.isFastSimulateEnabled();
        int numberOfTicksBeforeUpdatingGraphsFromSCS = this.scs.getNumberOfTicksBeforeUpdatingGraphs();
        Assert.assertTrue(isFastSimulateFromSCS3);
        Assert.assertEquals(2L, numberOfTicksBeforeUpdatingGraphsFromSCS);
        this.scs.setFastSimulate(false, 5);
        boolean isFastSimulateFromSCS4 = this.scs.isFastSimulateEnabled();
        int numberOfTicksBeforeUpdatingGraphsFromSCS2 = this.scs.getNumberOfTicksBeforeUpdatingGraphs();
        Assert.assertFalse(isFastSimulateFromSCS4);
        Assert.assertEquals(5L, numberOfTicksBeforeUpdatingGraphsFromSCS2);
        double initialTime = this.scs.getRobots()[0].getTime();
        double DT = this.scs.getDT();
        this.callSCSMethodSimulateOneTimeStep(this.scs);
        double finalTime = this.scs.getRobots()[0].getTime();
        Assert.assertEquals(initialTime + DT, finalTime, epsilon);
        double expectedFinalTime2 = this.getExpectedFinalTime(this.scs);
        this.callSCSMethodSimulateOneRecordStep(this.scs);
        double finalTime2 = this.scs.getRobots()[0].getTime();
        Assert.assertEquals(expectedFinalTime2, finalTime2, epsilon);
        double expectedFinalTime3 = this.getExpectedFinalTime(this.scs);
        this.callSCSMethodSimulateOneRecordStepNow(this.scs);
        double finalTime3 = this.scs.getRobots()[0].getTime();
        Assert.assertEquals(expectedFinalTime3, finalTime3, epsilon);
        this.scs.setSimulateDuration(2.5);
        double simulateDurationInSecondsFromSCS = this.scs.getSimulateDuration();
        Assert.assertEquals(2.5, simulateDurationInSecondsFromSCS, epsilon);
    }

    @Disabled
    @Test
    public void testFrameMethodsThatOnlyWorkOnSomeOperatingSystems() {
        this.scs.setFrameSize(this.dimension);
        ThreadTools.sleep((long)1000L);
        Dimension dimensionFromSCS = this.scs.getJFrame().getBounds().getSize();
        Assert.assertEquals((double)this.dimension.height, (double)dimensionFromSCS.height, epsilon);
        Assert.assertEquals((double)this.dimension.width, (double)dimensionFromSCS.width, epsilon);
        this.scs.setFrameLocation(this.location.x, this.location.y);
        ThreadTools.sleep((long)1000L);
        Point locationFromSCS = this.scs.getJFrame().getLocation();
        Assert.assertEquals((double)this.location.x, (double)locationFromSCS.x, epsilon);
        Assert.assertEquals((double)this.location.y, (double)locationFromSCS.y, epsilon);
        this.scs.setFrameMaximized();
        ThreadTools.sleep((long)1000L);
        int frameStateFromSCS = this.getExtendedStateFromSCS(this.scs);
        Assert.assertEquals(6.0, (double)frameStateFromSCS, epsilon);
        this.scs.setFrameAlwaysOnTop(true);
        ThreadTools.sleep((long)1000L);
        boolean alwaysOnTopFromSCS = this.scs.getJFrame().isAlwaysOnTop();
        Assert.assertEquals(true, alwaysOnTopFromSCS);
        this.scs.setFrameAlwaysOnTop(false);
        ThreadTools.sleep((long)1000L);
        alwaysOnTopFromSCS = this.scs.getJFrame().isAlwaysOnTop();
        Assert.assertEquals(false, alwaysOnTopFromSCS);
        this.scs.maximizeMainWindow();
        ThreadTools.sleep((long)1000L);
        int frameStateFromSCS2 = this.getExtendedStateFromSCS(this.scs);
        Assert.assertEquals(6.0, (double)frameStateFromSCS2, epsilon);
    }

    @Test
    public void testFrameMethods() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(60L), () -> {
            ThreadTools.sleep((long)1000L);
            this.scs.createNewGraphWindow();
            ThreadTools.sleep((long)1000L);
            GraphArrayWindow graphArrayWindowFromSCS = this.scs.getGraphArrayWindow("Unnamed");
            Assert.assertNotNull(graphArrayWindowFromSCS);
            this.scs.createNewGraphWindow("simpleGraphArrayWindow");
            ThreadTools.sleep((long)1000L);
            GraphArrayWindow graphArrayWindowFromSCS2 = this.scs.getGraphArrayWindow("simpleGraphArrayWindow");
            Assert.assertNotNull(graphArrayWindowFromSCS2);
            this.scs.createNewGraphWindow("simpleGraphArrayWindow2", 0, false);
            ThreadTools.sleep((long)1000L);
            GraphArrayWindow graphArrayWindowFromSCS3 = this.scs.getGraphArrayWindow("simpleGraphArrayWindow2");
            Assert.assertNotNull(graphArrayWindowFromSCS3);
            this.scs.createNewViewportWindow();
            ThreadTools.sleep((long)1000L);
            ViewportWindow viewportWindowFromSCS = this.scs.getViewportWindow("Unnamed");
            Assert.assertNotNull(viewportWindowFromSCS);
            this.scs.createNewViewportWindow("simpleViewportWindow");
            ThreadTools.sleep((long)1000L);
            ViewportWindow viewportWindowFromSCS2 = this.scs.getViewportWindow("simpleViewportWindow");
            Assert.assertNotNull(viewportWindowFromSCS2);
            this.scs.createNewViewportWindow("simpleViewportWindow", 0, false);
            ThreadTools.sleep((long)1000L);
            ViewportWindow viewportWindowFromSCS3 = this.scs.getViewportWindow("simpleViewportWindow");
            Assert.assertNotNull(viewportWindowFromSCS3);
            this.scs.showViewport();
            this.scs.hideViewport();
            ThreadTools.sleep((long)1000L);
            boolean isViewportHidden = this.scs.isViewportHidden();
            Assert.assertTrue(isViewportHidden);
            this.scs.hideViewport();
            this.scs.showViewport();
            ThreadTools.sleep((long)1000L);
            boolean isViewportHidden2 = this.scs.isViewportHidden();
            Assert.assertFalse(isViewportHidden2);
            Button component = new Button();
            this.scs.addExtraJpanel((Component)component, "simpleComponent", false);
            ThreadTools.sleep((long)1000L);
            Component componentFromSCS = this.scs.getExtraPanel("simpleComponent");
            Assert.assertEquals(component, componentFromSCS);
        });
    }

    @Test
    public void testCameraMethods() {
        this.scs.setCameraTracking(true, false, false, false);
        boolean isCameraTracking = this.scs.getGUI().getCamera().isTracking();
        boolean isCameraTrackingX = this.scs.getGUI().getCamera().isTrackingX();
        boolean isCameraTrackingY = this.scs.getGUI().getCamera().isTrackingY();
        boolean isCameraTrackingZ = this.scs.getGUI().getCamera().isTrackingZ();
        Assert.assertTrue(isCameraTracking);
        Assert.assertFalse(isCameraTrackingX);
        Assert.assertFalse(isCameraTrackingY);
        Assert.assertFalse(isCameraTrackingZ);
        this.scs.setCameraTracking(false, true, false, false);
        boolean isCameraTracking2 = this.scs.getGUI().getCamera().isTracking();
        boolean isCameraTrackingX2 = this.scs.getGUI().getCamera().isTrackingX();
        boolean isCameraTrackingY2 = this.scs.getGUI().getCamera().isTrackingY();
        boolean isCameraTrackingZ2 = this.scs.getGUI().getCamera().isTrackingZ();
        Assert.assertFalse(isCameraTracking2);
        Assert.assertTrue(isCameraTrackingX2);
        Assert.assertFalse(isCameraTrackingY2);
        Assert.assertFalse(isCameraTrackingZ2);
        this.scs.setCameraTracking(false, false, true, false);
        boolean isCameraTracking3 = this.scs.getGUI().getCamera().isTracking();
        boolean isCameraTrackingX3 = this.scs.getGUI().getCamera().isTrackingX();
        boolean isCameraTrackingY3 = this.scs.getGUI().getCamera().isTrackingY();
        boolean isCameraTrackingZ3 = this.scs.getGUI().getCamera().isTrackingZ();
        Assert.assertFalse(isCameraTracking3);
        Assert.assertFalse(isCameraTrackingX3);
        Assert.assertTrue(isCameraTrackingY3);
        Assert.assertFalse(isCameraTrackingZ3);
        this.scs.setCameraTracking(false, false, false, true);
        boolean isCameraTracking4 = this.scs.getGUI().getCamera().isTracking();
        boolean isCameraTrackingX4 = this.scs.getGUI().getCamera().isTrackingX();
        boolean isCameraTrackingY4 = this.scs.getGUI().getCamera().isTrackingY();
        boolean isCameraTrackingZ4 = this.scs.getGUI().getCamera().isTrackingZ();
        Assert.assertFalse(isCameraTracking4);
        Assert.assertFalse(isCameraTrackingX4);
        Assert.assertFalse(isCameraTrackingY4);
        Assert.assertTrue(isCameraTrackingZ4);
        this.scs.setCameraDolly(true, false, false, false);
        boolean isCameraDolly = this.scs.getGUI().getCamera().isDolly();
        boolean isCameraDollyX = this.scs.getGUI().getCamera().isDollyX();
        boolean isCameraDollyY = this.scs.getGUI().getCamera().isDollyY();
        boolean isCameraDollyZ = this.scs.getGUI().getCamera().isDollyZ();
        Assert.assertTrue(isCameraDolly);
        Assert.assertFalse(isCameraDollyX);
        Assert.assertFalse(isCameraDollyY);
        Assert.assertFalse(isCameraDollyZ);
        this.scs.setCameraDolly(false, true, false, false);
        boolean isCameraDolly2 = this.scs.getGUI().getCamera().isDolly();
        boolean isCameraDollyX2 = this.scs.getGUI().getCamera().isDollyX();
        boolean isCameraDollyY2 = this.scs.getGUI().getCamera().isDollyY();
        boolean isCameraDollyZ2 = this.scs.getGUI().getCamera().isDollyZ();
        Assert.assertFalse(isCameraDolly2);
        Assert.assertTrue(isCameraDollyX2);
        Assert.assertFalse(isCameraDollyY2);
        Assert.assertFalse(isCameraDollyZ2);
        this.scs.setCameraDolly(false, false, true, false);
        boolean isCameraDolly3 = this.scs.getGUI().getCamera().isDolly();
        boolean isCameraDollyX3 = this.scs.getGUI().getCamera().isDollyX();
        boolean isCameraDollyY3 = this.scs.getGUI().getCamera().isDollyY();
        boolean isCameraDollyZ3 = this.scs.getGUI().getCamera().isDollyZ();
        Assert.assertFalse(isCameraDolly3);
        Assert.assertFalse(isCameraDollyX3);
        Assert.assertTrue(isCameraDollyY3);
        Assert.assertFalse(isCameraDollyZ3);
        this.scs.setCameraDolly(false, false, false, true);
        boolean isCameraDolly4 = this.scs.getGUI().getCamera().isDolly();
        boolean isCameraDollyX4 = this.scs.getGUI().getCamera().isDollyX();
        boolean isCameraDollyY4 = this.scs.getGUI().getCamera().isDollyY();
        boolean isCameraDollyZ4 = this.scs.getGUI().getCamera().isDollyZ();
        Assert.assertFalse(isCameraDolly4);
        Assert.assertFalse(isCameraDollyX4);
        Assert.assertFalse(isCameraDollyY4);
        Assert.assertTrue(isCameraDollyZ4);
        this.addDoubleYoVariablesInSCSRegistry(this.cameraTrackingXYZVarNames, this.cameraTrackingXYZVarValues, this.scs);
        this.scs.setCameraTrackingVars(this.cameraTrackingXYZVarNames[0], this.cameraTrackingXYZVarNames[1], this.cameraTrackingXYZVarNames[2]);
        double[] cameraTrackingXYZVarsFromSCS = this.getCameraTrackingXYZVars(this.scs);
        Assert.assertArrayEquals(this.cameraTrackingXYZVarValues, cameraTrackingXYZVarsFromSCS, epsilon);
        this.addDoubleYoVariablesInSCSRegistry(this.cameraDollyXYZVarNames, this.cameraDollyXYZVarValues, this.scs);
        this.scs.setCameraDollyVars(this.cameraDollyXYZVarNames[0], this.cameraDollyXYZVarNames[1], this.cameraDollyXYZVarNames[2]);
        double[] cameraDollyXYZVarsFromSCS = this.getCameraDollyXYZVars(this.scs);
        Assert.assertArrayEquals(this.cameraDollyXYZVarValues, cameraDollyXYZVarsFromSCS, epsilon);
        this.scs.setCameraTrackingOffsets(this.cameraTrackingOffsetXYZValues[0], this.cameraTrackingOffsetXYZValues[1], this.cameraTrackingOffsetXYZValues[2]);
        double[] cameraTrackingOffsetXYZValuesFromSCS = this.getCameraTrackingOffsetXYZValues(this.scs);
        Assert.assertArrayEquals(this.cameraTrackingOffsetXYZValues, cameraTrackingOffsetXYZValuesFromSCS, epsilon);
        this.scs.setCameraDollyOffsets(this.cameraDollyOffsetXYZValues[0], this.cameraDollyOffsetXYZValues[1], this.cameraDollyOffsetXYZValues[2]);
        double[] cameraDollyOffsetXYZValuesFromSCS = this.getCameraDollyOffsetXYZValues(this.scs);
        Assert.assertArrayEquals(this.cameraDollyOffsetXYZValues, cameraDollyOffsetXYZValuesFromSCS, epsilon);
        this.scs.setCameraFix(this.cameraFixXYZValues[0], this.cameraFixXYZValues[1], this.cameraFixXYZValues[2]);
        double[] cameraFixXYZValuesFromSCS = this.getCameraFixXYZValues(this.scs);
        Assert.assertArrayEquals(this.cameraFixXYZValues, cameraFixXYZValuesFromSCS, epsilon);
        this.scs.setCameraPosition(this.cameraPositionXYZValues[0], this.cameraPositionXYZValues[1], this.cameraPositionXYZValues[2]);
        double[] cameraPositionXYZValuesFromSCS = this.getCameraPositionXYZValues(this.scs);
        Assert.assertArrayEquals(this.cameraPositionXYZValues, cameraPositionXYZValuesFromSCS, epsilon);
        this.scs.setupCamera(this.cameraConfiguration);
        String[] cameraConfigurationNamesFromSCS = this.getCameraConfigurationNames(this.scs);
        this.assertArrayOfStringsContainsTheString(cameraConfigurationNamesFromSCS, "simpleCameraConfigurationName");
        this.scs.setupViewport(this.viewportConfiguration);
        String[] viewportConfigurationNamesFromSCS = this.getViewportConfigurationNames(this.scs);
        this.assertArrayOfStringsContainsTheString(viewportConfigurationNamesFromSCS, "simpleViewportConfiguration");
        this.scs.selectViewport("simpleViewportConfiguration");
        boolean isCurrentView = this.isCurrentView(this.scs, "simpleViewportConfiguration");
        Assert.assertTrue(isCurrentView);
        this.scs.setupGraphConfigurations(this.graphConfigurations);
        String[] graphConfigurationNamesFromSCS = this.getGraphConfigurationListNames(this.scs);
        this.assertArrayOfStringsContainsTheStrings(graphConfigurationNamesFromSCS, this.graphConfigurationNames);
        this.scs.setClipDistances(this.cameraClipDistancesNearFarValues[0], this.cameraClipDistancesNearFarValues[1]);
        double[] cameraClipDistancesNearFarValuesFromSCS = this.getCameraNearFarValues(this.scs);
        Assert.assertArrayEquals(this.cameraClipDistancesNearFarValues, cameraClipDistancesNearFarValuesFromSCS, epsilon);
        this.scs.setFieldOfView(1.5);
        double cameraFieldOfViewFromSCS = this.getCameraFieldOfView(this.scs);
        Assert.assertEquals(1.5, cameraFieldOfViewFromSCS, epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.addCameraKey();
        Integer keyPointFromSCS = (Integer)this.scs.getCameraKeyPoints().get(0);
        Assert.assertEquals((double)this.keyPoint, (double)keyPointFromSCS.intValue(), epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.addCameraKey();
        this.scs.removeCameraKey();
        List keyPointFromSCS2 = this.scs.getCameraKeyPoints();
        Assert.assertEquals(0.0, (double)keyPointFromSCS2.size(), epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCameraFix(this.cameraFixXYZValues[0], this.cameraFixXYZValues[1], this.cameraFixXYZValues[2]);
        this.scs.setCurrentIndex(10);
        this.scs.addCameraKey();
        this.scs.setCameraFix(this.cameraFixXYZValues2[0], this.cameraFixXYZValues2[1], this.cameraFixXYZValues2[2]);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.addCameraKey();
        this.scs.nextCameraKey();
        double[] cameraFixXYZValuesFromSCS2 = this.getCameraFixXYZValues(this.scs);
        Assert.assertArrayEquals(this.cameraFixXYZValues2, cameraFixXYZValuesFromSCS2, epsilon);
        this.scs.previousCameraKey();
        double[] cameraFixXYZValuesFromSCS3 = this.getCameraFixXYZValues(this.scs);
        Assert.assertArrayEquals(this.cameraFixXYZValues, cameraFixXYZValuesFromSCS3, epsilon);
        boolean initialCameraKeyModeStatus = this.getCameraKeyMode(this.scs);
        this.scs.toggleCameraKeyMode();
        boolean finalCameraKeyModeStatus = this.getCameraKeyMode(this.scs);
        this.assertBooleansAreOpposite(initialCameraKeyModeStatus, finalCameraKeyModeStatus);
    }

    @Test
    public void test3DGraphicsMethods() {
        this.scs.addYoGraphicsListRegistry(this.yoGraphicsListRegistry);
        Graphics3DNode graphics3DNodeFromSCS = this.scs.addStaticLinkGraphics(this.staticLinkGraphics);
        Assert.assertNotNull(graphics3DNodeFromSCS);
        Graphics3DNode graphics3DNodeFromSCS2 = this.scs.addStaticLinkGraphics(this.staticLinkGraphics, this.graphics3DNodeType);
        Assert.assertNotNull(graphics3DNodeFromSCS2);
        Graphics3DNode graphics3DNodeFromSCS3 = this.scs.addStaticLink(this.staticLink);
        Assert.assertNotNull(graphics3DNodeFromSCS3);
        GraphicsDynamicGraphicsObject graphicsDynamicGraphicsObjectFromSCS = this.scs.addYoGraphic(this.yoGraphic);
        Assert.assertNotNull(graphicsDynamicGraphicsObjectFromSCS);
        GraphicsDynamicGraphicsObject graphicsDynamicGraphicsObjectFromSCS2 = this.scs.addYoGraphic(this.yoGraphic, true);
        Assert.assertNotNull(graphicsDynamicGraphicsObjectFromSCS2);
        GraphicsDynamicGraphicsObject graphicsDynamicGraphicsObjectFromSCS3 = this.scs.addYoGraphic(this.yoGraphic, false);
        Assert.assertNotNull(graphicsDynamicGraphicsObjectFromSCS3);
        this.scs.setGroundVisible(false);
        boolean isGroundVisibleFromSCS = this.stateIfTerrainIsVisible(this.scs);
        Assert.assertTrue(isGroundVisibleFromSCS);
        this.scs.setGroundVisible(true);
        boolean isGroundVisibleFromSCS2 = this.stateIfTerrainIsVisible(this.scs);
        Assert.assertTrue(isGroundVisibleFromSCS2);
        List yoGraphicListRegistriesFromSCS = this.scs.getYoGraphicsListRegistries();
        this.assertArrayOfObjectsContainsTheObject(yoGraphicListRegistriesFromSCS, this.yoGraphicsListRegistry);
        this.scs.setYoGraphicsListVisible("simpleYoGraphicsList", true);
        this.scs.hideAllYoGraphics();
        boolean yoGraphicsAreShowing = this.scs.checkAllYoGraphicsListRegistriesAreShowing();
        Assert.assertFalse(yoGraphicsAreShowing);
        this.scs.hideAllYoGraphics();
        for (YoGraphicsListRegistry registry : this.scs.getYoGraphicsListRegistries()) {
            for (YoGraphicsList list : registry.getYoGraphicsLists()) {
                list.setVisible(true);
            }
        }
        boolean yoGraphicsAreShowing2 = this.scs.checkAllYoGraphicsListRegistriesAreShowing();
        Assert.assertTrue(yoGraphicsAreShowing2);
        this.scs.disableGUIComponents();
        this.assertIfGUIComponentsAreDisableOrEnabled(this.scs, false);
        this.scs.enableGUIComponents();
        this.assertIfGUIComponentsAreDisableOrEnabled(this.scs, true);
    }

    @Disabled
    @Test
    public void testGetVariableMethods() throws AWTException {
        List allVariablesFromRobot = this.simpleRobot.getRobotsYoRegistry().collectSubtreeVariables();
        List allVariablesFromSCS = this.scs.getVariables();
        Assert.assertEquals(allVariablesFromRobot, allVariablesFromSCS);
        int allVariablesArrayFromRobot = this.simpleRobot.getVariables().size();
        int allVariablesArrayFromSCS = this.scs.getVariables().size();
        Assert.assertEquals(allVariablesArrayFromRobot, allVariablesArrayFromSCS);
        YoVariable yoVariableFromSCS = this.scs.findVariable(this.simpleRobotFirstVariableName);
        String variableNameFromSCS = yoVariableFromSCS.getName();
        Assert.assertEquals(this.simpleRobotFirstVariableName, variableNameFromSCS);
        YoVariable yoVariableFromRobot = this.simpleRobot.findVariable(this.simpleRobotFirstVariableName);
        YoVariable yoVariableFromSCS2 = this.scs.findVariable(this.simpleRobotRegistryNamespace, this.simpleRobotFirstVariableName);
        Assert.assertEquals(yoVariableFromRobot, yoVariableFromSCS2);
        List yoVariableArrayFromRobot = this.simpleRobot.findVariables(this.simpleRobotRegistryNamespace, this.simpleRobotFirstVariableName);
        List yoVariableArrayFromSCS = this.scs.findVariables(this.simpleRobotRegistryNamespace, this.simpleRobotFirstVariableName);
        Assert.assertEquals(yoVariableArrayFromRobot, yoVariableArrayFromSCS);
        List yoVariableFromRobot2 = this.simpleRobot.findVariables(this.simpleRobotFirstVariableName);
        List yoVariableFromSCS3 = this.scs.findVariables(this.simpleRobotFirstVariableName);
        Assert.assertEquals(yoVariableFromRobot2, yoVariableFromSCS3);
        List yoVariableFromRobot3 = this.simpleRobot.findVariables(this.simpleRobotRegistryNamespace);
        List yoVariableFromSCS4 = this.scs.findVariables(this.simpleRobotRegistryNamespace);
        Assert.assertEquals(yoVariableFromRobot3, yoVariableFromSCS4);
        boolean hasUniqueVariableRobot = this.simpleRobot.hasUniqueVariable(this.simpleRobotFirstVariableName);
        boolean hasUniqueVariableSCS = this.scs.hasUniqueVariable(this.simpleRobotFirstVariableName);
        Assert.assertEquals(hasUniqueVariableRobot, hasUniqueVariableSCS);
        boolean hasUniqueVariableRobot2 = this.simpleRobot.hasUniqueVariable(this.simpleRobotRegistryNamespace, this.simpleRobotFirstVariableName);
        boolean hasUniqueVariableSCS2 = this.scs.hasUniqueVariable(this.simpleRobotRegistryNamespace, this.simpleRobotFirstVariableName);
        Assert.assertEquals(hasUniqueVariableRobot2, hasUniqueVariableSCS2);
    }

    @Test
    public void testTimingMethods() throws AWTException {
        this.scs.setDT(0.001, 10);
        double simulateDTFromSCS = this.scs.getDT();
        Assert.assertEquals(0.001, simulateDTFromSCS, epsilon);
        this.scs.setRecordDT(0.05);
        double recordFreqFromSCS = this.scs.getRecordFreq();
        Assert.assertEquals(this.recordFreq, recordFreqFromSCS, epsilon);
        this.scs.setPlaybackRealTimeRate(0.75);
        double realTimeRateFromSCS = this.scs.getPlaybackRealTimeRate();
        Assert.assertEquals(0.75, realTimeRateFromSCS, epsilon);
        this.scs.setPlaybackDesiredFrameRate(0.01);
        double frameRateFromSCS = this.scs.getPlaybackFrameRate();
        Assert.assertEquals(this.recomputedSecondsPerFrameRate, frameRateFromSCS, epsilon);
        int ticksPerCycle = this.computeTicksPerPlayCycle(0.001, this.recordFreq, 0.75, 0.01);
        double ticksPerCycleFromSCS = this.scs.getTicksPerPlayCycle();
        Assert.assertEquals((double)ticksPerCycle, ticksPerCycleFromSCS, epsilon);
        this.scs.setTime(Math.PI);
        double timeFromSCS = this.scs.getTime();
        Assert.assertEquals(Math.PI, timeFromSCS, epsilon);
    }

    @Test
    public void testSimulationTickControl() {
        this.scs.setCurrentIndex(15);
        int indexFromSCS = this.scs.getCurrentIndex();
        Assert.assertEquals(15.0, (double)indexFromSCS, epsilon);
        this.createSimulationRewoundListenerAndAttachToSCS(this.scs);
        this.simulateForTime(this.scs, 1.0);
        int ticksPerCycle = (int)this.scs.getTicksPerPlayCycle();
        this.scs.setCurrentIndex(0);
        this.simulationRewoundListenerHasBeenNotified.set(false);
        this.scs.tickButDoNotNotifySimulationRewoundListeners(11);
        double currentSCSIndex = this.scs.getCurrentIndex();
        Assert.assertFalse(this.simulationRewoundListenerHasBeenNotified.getBooleanValue());
        Assert.assertEquals(11.0, currentSCSIndex, epsilon);
        this.scs.setCurrentIndex(0);
        this.simulationRewoundListenerHasBeenNotified.set(false);
        this.scs.tick();
        double currentSCSIndex2 = this.scs.getCurrentIndex();
        Assert.assertTrue(this.simulationRewoundListenerHasBeenNotified.getBooleanValue());
        Assert.assertEquals((double)ticksPerCycle, currentSCSIndex2, epsilon);
        this.scs.setCurrentIndex(ticksPerCycle);
        this.simulationRewoundListenerHasBeenNotified.set(false);
        this.scs.unTick();
        int currentSCSIndex3 = this.scs.getCurrentIndex();
        Assert.assertTrue(this.simulationRewoundListenerHasBeenNotified.getBooleanValue());
        Assert.assertEquals(0.0, (double)currentSCSIndex3, epsilon);
        this.scs.setCurrentIndex(0);
        this.simulationRewoundListenerHasBeenNotified.set(false);
        this.scs.tickAndReadFromBuffer(11);
        double currentSCSIndex4 = this.scs.getCurrentIndex();
        Assert.assertTrue(this.simulationRewoundListenerHasBeenNotified.getBooleanValue());
        Assert.assertEquals(11.0, currentSCSIndex4, epsilon);
        this.scs.setCurrentIndex(0);
        this.simulationRewoundListenerHasBeenNotified.set(false);
        this.scs.setTick(11);
        double currentSCSIndex5 = this.scs.getCurrentIndex();
        Assert.assertTrue(this.simulationRewoundListenerHasBeenNotified.getBooleanValue());
        Assert.assertEquals((double)(11 * ticksPerCycle), currentSCSIndex5, epsilon);
        this.scs.setCurrentIndex(0);
        this.simulationRewoundListenerHasBeenNotified.set(false);
        this.scs.tickAndUpdate();
        double currentSCSIndex6 = this.scs.getCurrentIndex();
        Assert.assertFalse(this.simulationRewoundListenerHasBeenNotified.getBooleanValue());
        Assert.assertEquals(1.0, currentSCSIndex6, epsilon);
        this.scs.setCurrentIndex(0);
        this.simulationRewoundListenerHasBeenNotified.set(false);
        this.scs.updateAndTick();
        double currentSCSIndex7 = this.scs.getCurrentIndex();
        Assert.assertTrue(this.simulationRewoundListenerHasBeenNotified.getBooleanValue());
        Assert.assertEquals(1.0, currentSCSIndex7, epsilon);
        this.scs.setCurrentIndex(0);
        this.simulationRewoundListenerHasBeenNotified.set(false);
        this.scs.tickAndUpdateLeisurely(11);
        double currentSCSIndex8 = this.scs.getCurrentIndex();
        Assert.assertFalse(this.simulationRewoundListenerHasBeenNotified.getBooleanValue());
        Assert.assertEquals(1.0, currentSCSIndex8, epsilon);
        this.scs.stopSimulationThread();
        boolean isThreadRunningFromSCS = this.scs.isSimulationThreadRunning();
        Assert.assertFalse(isThreadRunningFromSCS);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        boolean isMiddleIndexFromSCS = this.scs.isIndexBetweenBounds(49);
        Assert.assertEquals(true, isMiddleIndexFromSCS);
        isMiddleIndexFromSCS = this.scs.isIndexBetweenBounds(51);
        Assert.assertEquals(false, isMiddleIndexFromSCS);
        this.setInputPointInSCS(this.scs, 10);
        this.scs.setCurrentIndex(50);
        this.scs.gotoInPointNow();
        int inputPointFromSCS = this.scs.getCurrentIndex();
        Assert.assertEquals(10L, inputPointFromSCS);
        this.setOutputPointInSCS(this.scs, 50);
        this.scs.setCurrentIndex(10);
        this.scs.gotoOutPointNow();
        int outputPointFromSCS = this.scs.getCurrentIndex();
        Assert.assertEquals(50L, outputPointFromSCS);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.addKeyPoint();
        Integer keyPointFromSCS = (Integer)this.scs.getKeyPoints().get(0);
        Assert.assertEquals((double)this.keyPoint, (double)keyPointFromSCS.intValue(), epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.stepBackwardNow();
        int currentIndexFromSCS = this.scs.getCurrentIndex();
        Assert.assertEquals((double)(this.keyPoint - 1), (double)currentIndexFromSCS, epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.stepForwardNow(2);
        int currentIndexFromSCS2 = this.scs.getCurrentIndex();
        Assert.assertEquals((double)(this.keyPoint + 2), (double)currentIndexFromSCS2, epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.stepForward(2);
        this.scs.run();
        int currentIndexFromSCS3 = this.scs.getCurrentIndex();
        Assert.assertEquals((double)(this.keyPoint + 2), (double)currentIndexFromSCS3, epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.stepForward();
        this.scs.run();
        int currentIndexFromSCS4 = this.scs.getCurrentIndex();
        Assert.assertEquals((double)(this.keyPoint + 1), (double)currentIndexFromSCS4, epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.stepBackward(2);
        this.scs.run();
        int currentIndexFromSCS5 = this.scs.getCurrentIndex();
        Assert.assertEquals((double)(this.keyPoint - 2), (double)currentIndexFromSCS5, epsilon);
        this.setInputAndOutputPointsWithoutCroppingInSCS(this.scs, 10, 50);
        this.scs.setCurrentIndex(this.keyPoint);
        this.scs.stepBackward();
        this.scs.run();
        int currentIndexFromSCS6 = this.scs.getCurrentIndex();
        Assert.assertEquals((double)(this.keyPoint - 1), (double)currentIndexFromSCS6, epsilon);
    }

    @Test
    public void testVariablesMethods() {
        this.addDoubleYoVariablesInSCSRegistry(this.cameraDollyXYZVarNames, this.cameraDollyXYZVarValues, this.scs);
        YoVariableList yoVariableList = this.createVarListOfDoubleYoVariableWithDummyRegistry(this.variableGroup1, this.variableGroup1Values);
        YoVariableList[] yoVariableLists = this.createTwoVarListOfDoubleYoVariablesWithDummyRegistry(this.variableGroup2, this.variableGroup2Values, this.variableGroup3, this.variableGroup3Values);
        List<YoVariableList> yoVariableArrayLists = this.createArrayListOfDoubleYoVariableWithDummyRegistry(this.variableGroup4, this.variableGroup4Values, this.variableGroup5, this.variableGroup5Values);
        this.scs.setupEntryBox(this.simpleRobotFirstVariableName);
        ThreadTools.sleep((long)1000L);
        boolean entryBoxIsInSCS = this.scsContainsTheEntryBox(this.scs, this.simpleRobotFirstVariableName);
        Assert.assertTrue(entryBoxIsInSCS);
        this.scs.setupEntryBox(this.simpleRobotLastVariableName);
        ThreadTools.sleep((long)1000L);
        boolean entryBoxIsInSCS2 = this.scsContainsTheEntryBox(this.scs, this.simpleRobotLastVariableName);
        Assert.assertTrue(entryBoxIsInSCS2);
        this.scs.setupEntryBox(this.cameraDollyXYZVarNames);
        ThreadTools.sleep((long)1000L);
        boolean entryBoxesAreInSCS = this.scsContainsTheEntryBoxes(this.scs, this.cameraDollyXYZVarNames);
        Assert.assertTrue(entryBoxesAreInSCS);
        this.scs.setupGraph(this.simpleRobotFirstVariableName);
        ThreadTools.sleep((long)1000L);
        boolean graphIsInSCS = this.scsContainsTheGraph(this.scs, this.simpleRobotFirstVariableName);
        Assert.assertTrue(graphIsInSCS);
        this.scs.setupGraph(this.simpleRobotLastVariableName);
        ThreadTools.sleep((long)1000L);
        boolean graphIsInSCS2 = this.scsContainsTheGraph(this.scs, this.simpleRobotLastVariableName);
        Assert.assertTrue(graphIsInSCS2);
        this.scs.setupGraph(this.cameraDollyXYZVarNames);
        ThreadTools.sleep((long)1000L);
        boolean graphsAreInSCS = this.scsContainsTheGraphs(this.scs, this.cameraDollyXYZVarNames);
        Assert.assertTrue(graphsAreInSCS);
        this.scs.addVarList(yoVariableList);
        YoVariableList yoVariableListFromSCS = this.scs.getCombinedVarList();
        this.assertYoVariableListContainsVariables(yoVariableListFromSCS, yoVariableList.getVariables());
        this.scs.addVarLists(yoVariableLists);
        YoVariableList yoVariableListFromSCS2 = this.scs.getCombinedVarList();
        this.assertYoVariableListContainsVariables(yoVariableListFromSCS2, yoVariableLists[0].getVariables());
        this.assertYoVariableListContainsVariables(yoVariableListFromSCS2, yoVariableLists[1].getVariables());
        this.scs.addVarLists(yoVariableArrayLists);
        YoVariableList yoVariableListFromSCS3 = this.scs.getCombinedVarList();
        this.assertYoVariableListContainsArrayListOfVariables(yoVariableListFromSCS3, yoVariableArrayLists);
    }

    @Test
    public void testGroupMethods() {
        this.addDoubleYoVariablesInSCSRegistry(this.cameraDollyXYZVarNames, this.cameraDollyXYZVarValues, this.scs);
        this.addDoubleYoVariablesInSCSRegistry(this.cameraTrackingXYZVarNames, this.cameraTrackingXYZVarValues, this.scs);
        this.scs.setupVarGroup("simpleVarGroup", this.cameraDollyXYZVarNames);
        String[] varGroupNamesFromSCS = this.getVarGroupNames(this.scs);
        this.assertArrayOfStringsContainsTheString(varGroupNamesFromSCS, "simpleVarGroup");
        this.scs.setupVarGroup("simpleVarGroup2", this.cameraDollyXYZVarNames, this.regularExpressions);
        String[] varGroupNamesFromSCS2 = this.getVarGroupNames(this.scs);
        this.assertArrayOfStringsContainsTheString(varGroupNamesFromSCS2, "simpleVarGroup2");
        this.scs.setupGraphGroup("simpleGraphGroup", this.graphGroupVars);
        String[] graphGroupNamesFromSCS = this.getGraphGroupNames(this.scs);
        this.assertArrayOfStringsContainsTheString(graphGroupNamesFromSCS, "simpleGraphGroup");
        this.scs.setupGraphGroup("simpleGraphGroup2", this.graphGroupVarsWithConfig);
        String[] graphGroupNamesFromSCS2 = this.getGraphGroupNames(this.scs);
        this.assertArrayOfStringsContainsTheString(graphGroupNamesFromSCS2, "simpleGraphGroup2");
        this.scs.setupGraphGroup("simpleGraphGroup3", this.graphGroupVars, 2);
        String[] graphGroupNamesFromSCS3 = this.getGraphGroupNames(this.scs);
        this.assertArrayOfStringsContainsTheString(graphGroupNamesFromSCS3, "simpleGraphGroup3");
        this.scs.setupGraphGroup("simpleGraphGroup4", this.graphGroupVarsWithConfig);
        String[] graphGroupNamesFromSCS4 = this.getGraphGroupNames(this.scs);
        this.assertArrayOfStringsContainsTheString(graphGroupNamesFromSCS4, "simpleGraphGroup4");
        this.scs.setupEntryBoxGroup("simpleEntryBoxGroup", this.cameraDollyXYZVarNames);
        String[] entryBoxGroupFromSCS = this.getEntryBoxGroupListNames(this.scs);
        this.assertArrayOfStringsContainsTheString(entryBoxGroupFromSCS, "simpleEntryBoxGroup");
        this.scs.setupEntryBoxGroup("simpleEntryBoxGroup2", this.cameraDollyXYZVarNames, this.regularExpressions);
        String[] entryBoxGroupFromSCS2 = this.getEntryBoxGroupListNames(this.scs);
        this.assertArrayOfStringsContainsTheString(entryBoxGroupFromSCS2, "simpleEntryBoxGroup2");
        this.scs.setupConfiguration("simpleConfigurationName", "simpleVarGroup3", "simpleGraphGroup5", "simpleEntryBoxGroup3");
        String[] configurationNameFromSCS = this.getConfigurationListNames(this.scs);
        this.assertArrayOfStringsContainsTheString(configurationNameFromSCS, "simpleConfigurationName");
        this.scs.setupExtraPanel(this.extraPanelConfiguration);
        Component extraPanelConfigurationPanelFromSCS = this.getExtraPanelConfigurationPanel(this.scs, "simpleExtraPanelConfigurationName");
        Assert.assertNotNull(extraPanelConfigurationPanelFromSCS);
    }

    @Test
    public void testSimulationListeners() {
        SimulationDoneListener simulationDoneListener = this.createSimulationDoneListener();
        SimulationDoneCriterion simulationDoneCriterion = this.createSimulationDoneCriterion();
        PlaybackListener playbackListener = this.createPlaybackListener();
        PlayCycleListener playCycleListener = this.createPlayCycleListener();
        YoBufferProcessor dataProcessingFunction = this.createDataProcessingFunction();
        KeyPointsChangedListener keyPointsChangedListener = this.createToggleKeyPointModeCommandListener();
        this.scs.attachPlayCycleListener(playCycleListener);
        this.scs.attachPlaybackListener(playbackListener);
        this.scs.addSimulateDoneListener(simulationDoneListener);
        this.scs.setSimulateDoneCriterion(simulationDoneCriterion);
        this.scs.addListener(keyPointsChangedListener);
        List playCycleListenersFromSCS = this.scs.getPlayCycleListeners();
        this.assertArrayOfObjectsContainsTheObject(playCycleListenersFromSCS, playCycleListener);
        this.simulationDoneListenerHasBeenNotified.set(false);
        this.callSCSMethodSimulateOneTimeStep(this.scs);
        ThreadTools.sleep((long)1000L);
        Assert.assertTrue(this.simulationDoneListenerHasBeenNotified.getBooleanValue());
        this.simulationDoneListenerHasBeenNotified.set(false);
        this.scs.removeSimulateDoneListener(simulationDoneListener);
        ThreadTools.sleep((long)1000L);
        Assert.assertFalse(this.simulationDoneListenerHasBeenNotified.getBooleanValue());
        this.simulationDoneListenerHasBeenNotified.set(false);
        this.scs.simulate(Double.MAX_VALUE);
        boolean isSCSSimulatingBeforeCriterion = this.scs.isSimulating();
        this.setSimulationDoneCriterion.set(true);
        ThreadTools.sleep((long)1000L);
        boolean isSCSSimulatingAfterCriterion = this.scs.isSimulating();
        Assert.assertTrue(isSCSSimulatingBeforeCriterion);
        Assert.assertFalse(isSCSSimulatingAfterCriterion);
        this.realTimeRateInSCS.set(Double.POSITIVE_INFINITY);
        this.scs.play();
        ThreadTools.sleep((long)1000L);
        double realTimeRateFromSCS = this.scs.getPlaybackRealTimeRate();
        Assert.assertEquals(realTimeRateFromSCS, this.realTimeRateInSCS.getDoubleValue(), epsilon);
        this.processDataHasBeenCalled.set(false);
        this.scs.applyDataProcessingFunction(dataProcessingFunction);
        ThreadTools.sleep((long)1000L);
        Assert.assertTrue(this.processDataHasBeenCalled.getBooleanValue());
        this.toggleKeyPointModeCommandListenerHasBeenCalled.set(false);
        this.scs.toggleKeyPoints();
        ThreadTools.sleep((long)1000L);
        Assert.assertTrue(this.toggleKeyPointModeCommandListenerHasBeenCalled.getBooleanValue());
    }

    @Test
    public void testDataExporting() {
        this.simulateForTime(this.scs, 1.0);
        int initialInPoint = this.scs.getInPoint();
        int initialOutPoint = this.scs.getOutPoint();
        int initialInOutBufferLength = this.getInOutBufferLengthFromSCS(this.scs);
        int initialBufferSize = this.getBufferSizeFromSCS(this.scs);
        CaptureDevice captureDevice = this.getCaptureDeviceFromSCS(this.scs);
        this.addDoubleYoVariablesInSCSRegistry(this.cameraTrackingXYZVarNames, this.cameraTrackingXYZVarValues, this.scs);
        this.addAndSubtractOneFromInAndOutPointIndexWithoutCrop(this.scs);
        this.scs.cropBuffer();
        int currentInPoint = this.scs.getInPoint();
        int currentBufferSize = this.scs.getDataBuffer().getBufferSize();
        Assert.assertEquals(0.0, (double)currentInPoint, epsilon);
        Assert.assertEquals((double)(initialInOutBufferLength - 2), (double)currentBufferSize, epsilon);
        this.addAndSubtractOneFromInAndOutPointIndexWithoutCrop(this.scs);
        this.scs.packBuffer();
        int currentInPoint2 = this.scs.getInPoint();
        Assert.assertEquals(0.0, (double)currentInPoint2, epsilon);
        this.scs.changeBufferSize(initialBufferSize * 2);
        int bufferSizeFromSCS = this.getBufferSizeFromSCS(this.scs);
        Assert.assertEquals((double)(initialBufferSize * 2), (double)bufferSizeFromSCS, epsilon);
        BufferedImage bufferedImage = this.scs.exportSnapshotAsBufferedImage(captureDevice);
        Assert.assertNotNull(bufferedImage);
        BufferedImage bufferedImage2 = this.scs.exportSnapshotAsBufferedImage();
        Assert.assertNotNull(bufferedImage2);
        File file = new File("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/file.csv");
        this.scs.writeSpreadsheetFormattedData("all", file);
        this.assertTheFileContainsTheVariables(file, this.cameraTrackingXYZVarNames);
        file.delete();
        File file2 = new File("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/file2.gz");
        this.scs.writeData(file2);
        SimulationConstructionSet scs2 = this.createNewSCSWithEmptyRobot("simpleRobot2");
        scs2.readData(file2);
        this.assertSCSContainsTheVariables(scs2, this.cameraTrackingXYZVarNames);
        this.closeGivenSCSAndDeleteFile(scs2, file2);
        File file3 = new File("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/file3.csv");
        this.scs.writeSpreadsheetFormattedData("all", file3);
        SimulationConstructionSet scs3 = this.createNewSCSWithEmptyRobot("simpleRobot3");
        scs3.readData(file3);
        this.assertSCSContainsTheVariables(scs3, this.cameraTrackingXYZVarNames);
        this.closeGivenSCSAndDeleteFile(scs3, file3);
        String defaultTimeVariable = this.scs.getTimeVariableName();
        this.scs.setTimeVariableName(this.cameraTrackingXYZVarNames[0]);
        String timeVariableNameFromSCS = this.scs.getTimeVariableName();
        Assert.assertEquals(this.cameraTrackingXYZVarNames[0], timeVariableNameFromSCS);
        this.scs.setTimeVariableName(defaultTimeVariable);
        File file4 = new File("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/file4.state");
        this.scs.writeState(file4);
        double initialTime = this.scs.getTime();
        this.simulateForTime(this.scs, 1.0);
        this.scs.readState(file4, false);
        double timeAfterReadState = this.scs.getTime();
        Assert.assertEquals(initialTime, timeAfterReadState, epsilon);
        file4.delete();
        File file5 = new File("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/file5.state.gz");
        this.scs.writeState("all", false, true, file5);
        double initialTime2 = this.scs.getTime();
        this.simulateForTime(this.scs, 1.0);
        this.scs.readState(file5, false);
        double timeAfterReadState2 = this.scs.getTime();
        Assert.assertEquals(initialTime2, timeAfterReadState2, epsilon);
        file5.delete();
        File file6 = new File("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/file6.csv");
        this.scs.writeSpreadsheetFormattedState("all", file6);
        this.assertTheFileContainsTheVariables(file6, this.cameraTrackingXYZVarNames);
        this.scs.writeState("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/test.state");
        double initialTime3 = this.scs.getTime();
        this.simulateForTime(this.scs, 1.0);
        this.scs.readState("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/test.state", false);
        double timeAfterReadState3 = this.scs.getTime();
        Assert.assertEquals(initialTime3, timeAfterReadState3, epsilon);
        File file7 = new File("resources/us/ihmc/simulationconstructionset/simulationConstructionSetUsingDirectCallsTest/file7.state.gz");
        this.scs.writeState("all", false, true, file7);
        double initialTime4 = this.scs.getTime();
        this.simulateForTime(this.scs, 1.0);
        this.scs.readState(file7, false);
        double timeAfterReadState4 = this.scs.getTime();
        Assert.assertEquals(initialTime4, timeAfterReadState4, epsilon);
        file7.delete();
        this.scs.closeAndDispose();
    }

    private void assertIfGUIComponentsAreDisableOrEnabled(SimulationConstructionSet scs, boolean assertAreEnabled) {
        StandardGUIActions standardGUIActions = scs.getStandardGUIActions();
        ArrayList guiActions = standardGUIActions.getGuiActions();
        for (int i = 0; i < guiActions.size(); ++i) {
            AbstractAction guiAction = (AbstractAction)guiActions.get(i);
            boolean guiActionStatus = guiAction.isEnabled();
            if (assertAreEnabled) {
                Assert.assertTrue(guiActionStatus);
                continue;
            }
            Assert.assertFalse(guiActionStatus);
        }
    }

    private ScsPhysics createScsPhysics() {
        ScsCollisionConfigure collisionConfigure = this.createScsCollisionConfigure();
        ScsCollisionDetector collisionDetector = this.createScsCollisionDetector();
        DoNothingCollisionArbiter collisionArbiter = new DoNothingCollisionArbiter();
        DefaultCollisionHandler collisionHandler = new DefaultCollisionHandler(0.3, 0.3);
        DefaultCollisionVisualizer visualize = new DefaultCollisionVisualizer(0.1, 0.1, 0.01, this.scs, 100);
        ScsPhysics physics = new ScsPhysics(collisionConfigure, collisionDetector, (CollisionArbiter)collisionArbiter, (CollisionHandler)collisionHandler, visualize);
        return physics;
    }

    private ScsCollisionDetector createScsCollisionDetector() {
        ScsCollisionDetector scsCollisionDetector = new ScsCollisionDetector(){

            public void initialize() {
            }

            public CollisionShapeFactory getShapeFactory() {
                return null;
            }

            public void performCollisionDetection(CollisionDetectionResult result) {
            }
        };
        return scsCollisionDetector;
    }

    private ScsCollisionConfigure createScsCollisionConfigure() {
        ScsCollisionConfigure scsCollisionConfigure = new ScsCollisionConfigure(){

            public void setup(Robot robot, ScsCollisionDetector collisionDetector, CollisionHandler collisionHandler) {
            }
        };
        return scsCollisionConfigure;
    }

    private YoGraphicsListRegistry createYoGraphicsListRegistryWithObject() {
        YoGraphicsListRegistry yoGraphicsListRegistry = new YoGraphicsListRegistry();
        YoGraphicsList yoGraphicsList = new YoGraphicsList("simpleYoGraphicsList");
        yoGraphicsList.add(this.yoGraphic);
        yoGraphicsListRegistry.registerYoGraphicsList(yoGraphicsList);
        return yoGraphicsListRegistry;
    }

    private KeyPointsChangedListener createToggleKeyPointModeCommandListener() {
        KeyPointsChangedListener toggleKeyPointModeCommandListener = new KeyPointsChangedListener(){

            public void changed(KeyPointsChangedListener.Change change) {
                SimulationConstructionSetUsingDirectCallsTest.this.toggleKeyPointModeCommandListenerHasBeenCalled.set(change.wasToggled());
            }
        };
        return toggleKeyPointModeCommandListener;
    }

    private void assertBooleansAreOpposite(boolean one, boolean two) {
        if (one) {
            Assert.assertFalse(two);
        } else {
            Assert.assertTrue(two);
        }
    }

    private YoBufferProcessor createDataProcessingFunction() {
        YoBufferProcessor dataProcessingFunction = new YoBufferProcessor(){

            public void process(int startIndex, int endIndex, int currentIndex) {
                SimulationConstructionSetUsingDirectCallsTest.this.processDataHasBeenCalled.set(true);
            }
        };
        return dataProcessingFunction;
    }

    private PlayCycleListener createPlayCycleListener() {
        PlayCycleListener playCycleListener = new PlayCycleListener(){

            public void update(int tick) {
            }
        };
        return playCycleListener;
    }

    private <T> void assertArrayOfObjectsContainsTheArrayOfObject(List<T> mainArrayList, List<T> arrayList) {
        int numberOfElements = arrayList.size();
        for (int i = 0; i < numberOfElements; ++i) {
            this.assertArrayOfObjectsContainsTheObject(mainArrayList, arrayList.get(i));
        }
    }

    private <T> void assertArrayOfObjectsContainsTheObject(List<T> arrayList, T object) {
        int numberOfElements = arrayList.size();
        boolean ret = false;
        for (int i = 0; i < numberOfElements; ++i) {
            ret = ret || arrayList.get(i).equals(object);
        }
        Assert.assertTrue(ret);
    }

    private void assertYoVariableListContainsArrayListOfVariables(YoVariableList yoVariableList, List<YoVariableList> arrayLists) {
        int numberOfList = arrayLists.size();
        for (int j = 0; j < numberOfList; ++j) {
            List variables = arrayLists.get(j).getVariables();
            int numberOfVariables = variables.size();
            for (int i = 0; i < numberOfVariables; ++i) {
                boolean containsTheVar = yoVariableList.contains(variables.get(i));
                Assert.assertTrue(containsTheVar);
            }
        }
    }

    private void assertYoVariableListContainsVariables(YoVariableList yoVariableList, List<YoVariable> variables) {
        int numberOfVariables = variables.size();
        for (int i = 0; i < numberOfVariables; ++i) {
            boolean containsTheVar = yoVariableList.contains((Object)variables.get(i));
            Assert.assertTrue(containsTheVar);
        }
    }

    private List<YoVariableList> createArrayListOfDoubleYoVariableWithDummyRegistry(String[] variableNames1, double[] varValues1, String[] variableNames2, double[] varValues2) {
        ArrayList<YoVariableList> arrayLists = new ArrayList<YoVariableList>();
        YoVariableList[] yoVariableList = this.createTwoVarListOfDoubleYoVariablesWithDummyRegistry(variableNames1, varValues1, variableNames2, varValues2);
        for (int i = 0; i < yoVariableList.length; ++i) {
            arrayLists.add(yoVariableList[i]);
        }
        return arrayLists;
    }

    private YoVariableList createVarListOfDoubleYoVariableWithDummyRegistry(String[] variableNames, double[] varValues) {
        List<YoDouble> yoDoubles = null;
        if (variableNames.length == varValues.length) {
            YoRegistry registry = new YoRegistry("dummy");
            yoDoubles = this.createAndSetDoubleYoVariableToRegistry(variableNames, varValues, registry);
        } else {
            System.out.print("Input arrays have different length.");
        }
        return this.createYoVariableList("yoVariableList", yoDoubles);
    }

    private YoVariableList[] createTwoVarListOfDoubleYoVariablesWithDummyRegistry(String[] variableNames1, double[] varValues1, String[] variableNames2, double[] varValues2) {
        YoRegistry registry = new YoRegistry("dummy");
        List<YoDouble> yoVariables1 = this.createAndSetDoubleYoVariableToRegistry(variableNames1, varValues1, registry);
        List<YoDouble> yoVariables2 = this.createAndSetDoubleYoVariableToRegistry(variableNames2, varValues2, registry);
        YoVariableList[] yoVariableLists = new YoVariableList[]{this.createYoVariableList("yoVariableList1", yoVariables1), this.createYoVariableList("yoVariableList2", yoVariables2)};
        return yoVariableLists;
    }

    private List<YoDouble> createAndSetDoubleYoVariableToRegistry(String[] varNames, double[] varValues, YoRegistry registry) {
        ArrayList<YoDouble> yoDoubles = new ArrayList<YoDouble>();
        for (int i = 0; i < varNames.length; ++i) {
            YoDouble yoDouble = new YoDouble(varNames[i], registry);
            yoDouble.set(varValues[i]);
            yoDoubles.add(yoDouble);
        }
        return yoDoubles;
    }

    private YoVariableList createYoVariableList(String name, List<? extends YoVariable> yoVariables) {
        YoVariableList yoVariableList = new YoVariableList(name);
        yoVariableList.addAll(yoVariables);
        return yoVariableList;
    }

    private NewDataListener createNewDataListener() {
        NewDataListener newDataListener = new NewDataListener(){

            public void newDataHasBeenSent() {
            }

            public void newDataHasBeenReceived() {
            }
        };
        return newDataListener;
    }

    private int getExtendedStateFromSCS(SimulationConstructionSet scs) {
        return scs.getGUI().getFrame().getExtendedState();
    }

    private SimulationConstructionSet createNewSCSWithEmptyRobot(String robotName) {
        return new SimulationConstructionSet(new Robot(robotName), parameters);
    }

    private void closeGivenSCSAndDeleteFile(SimulationConstructionSet scs, File file) {
        file.delete();
        this.closeGivenSCS(scs);
    }

    private void closeGivenSCS(SimulationConstructionSet scs) {
        ThreadTools.sleep((long)2000L);
        scs.closeAndDispose();
        scs = null;
    }

    private void assertSCSContainsTheVariables(SimulationConstructionSet scs, String[] variablesNames) {
        YoRegistry registry = scs.getRootRegistry();
        String[] variableNamesFromSCS = this.getAllVariableNamesFromRegistry(registry);
        this.assertArrayOfStringsContainsTheStrings(variableNamesFromSCS, variablesNames);
    }

    private String[] getAllVariableNamesFromRegistry(YoRegistry registry) {
        int numberOfVariables = registry.getNumberOfVariables();
        String[] names = new String[numberOfVariables];
        for (int i = 0; i < numberOfVariables; ++i) {
            names[i] = registry.getVariable(i).getName();
        }
        return names;
    }

    private void assertTheFileContainsTheVariables(File file, String[] variablesNames) {
        String header = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            header = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] numberOfEntries = header.split(",");
        this.assertArrayOfStringsContainsTheStrings(numberOfEntries, variablesNames);
    }

    private CaptureDevice getCaptureDeviceFromSCS(SimulationConstructionSet scs) {
        return scs.getGUI().getActiveCaptureDevice();
    }

    private int getInOutBufferLengthFromSCS(SimulationConstructionSet scs) {
        return scs.getDataBuffer().getBufferInOutLength();
    }

    private int getBufferSizeFromSCS(SimulationConstructionSet scs) {
        return scs.getDataBuffer().getBufferSize();
    }

    private void addAndSubtractOneFromInAndOutPointIndexWithoutCrop(SimulationConstructionSet scs) {
        this.addOneToInPointIndexWithoutCrop(scs);
        this.subtractOneToOutPointIndexWithoutCrop(scs);
    }

    private void addOneToInPointIndexWithoutCrop(SimulationConstructionSet scs) {
        int currentInPoint = scs.getInPoint();
        scs.setCurrentIndex(currentInPoint + 1);
        scs.setInPoint();
    }

    private void subtractOneToOutPointIndexWithoutCrop(SimulationConstructionSet scs) {
        int currentOutPoint = scs.getOutPoint();
        scs.setCurrentIndex(currentOutPoint - 1);
        scs.setOutPoint();
    }

    private PlaybackListener createPlaybackListener() {
        PlaybackListener listener = new PlaybackListener(){

            public void indexChanged(int newIndex) {
            }

            public void play(double realTimeRate) {
                SimulationConstructionSetUsingDirectCallsTest.this.realTimeRateInSCS.set(realTimeRate);
            }

            public void stop() {
            }
        };
        return listener;
    }

    private SimulationDoneCriterion createSimulationDoneCriterion() {
        SimulationDoneCriterion criterion = new SimulationDoneCriterion(){

            public boolean isSimulationDone() {
                return SimulationConstructionSetUsingDirectCallsTest.this.setSimulationDoneCriterion.getBooleanValue();
            }
        };
        return criterion;
    }

    private SimulationDoneListener createSimulationDoneListener() {
        SimulationDoneListener listener = new SimulationDoneListener(){

            public void simulationDone() {
                SimulationConstructionSetUsingDirectCallsTest.this.simulationDoneListenerHasBeenNotified.set(true);
            }

            public void simulationDoneWithException(Throwable throwable) {
            }
        };
        return listener;
    }

    private void callSCSMethodSimulateOneRecordStepNow(SimulationConstructionSet scs) {
        try {
            scs.simulateOneRecordStepNow();
        }
        catch (UnreasonableAccelerationException e) {
            e.printStackTrace();
        }
    }

    private double getExpectedFinalTime(SimulationConstructionSet scs) {
        double initialTime = scs.getRobots()[0].getTime();
        double recordFreq = scs.getRecordFreq();
        double DT = scs.getDT();
        return initialTime + recordFreq * DT;
    }

    private void callSCSMethodSimulateOneRecordStep(SimulationConstructionSet scs) {
        try {
            scs.simulateOneRecordStep();
        }
        catch (UnreasonableAccelerationException e) {
            e.printStackTrace();
        }
    }

    private void callSCSMethodSimulateOneTimeStep(SimulationConstructionSet scs) {
        try {
            scs.simulateOneTimeStep();
        }
        catch (UnreasonableAccelerationException e) {
            e.printStackTrace();
        }
    }

    private boolean stateIfTerrainIsVisible(SimulationConstructionSet scs) {
        JMEGraphics3DAdapter graphics3DAdapter = this.getGraphics3DAdapter(scs);
        return graphics3DAdapter.getRenderer().isGroundVisible();
    }

    private JMEGraphics3DAdapter getGraphics3DAdapter(SimulationConstructionSet scs) {
        return (JMEGraphics3DAdapter)scs.getGUI().getGraphics3dAdapter();
    }

    private void assertArrayOfStringsContainsTheStrings(String[] array, String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            this.assertArrayOfStringsContainsTheString(array, strings[i]);
        }
    }

    private GraphConfiguration[] createGraphConfigurations(String[] graphConfigurationNames) {
        GraphConfiguration[] graphConfigurations = new GraphConfiguration[graphConfigurationNames.length];
        for (int i = 0; i < graphConfigurationNames.length; ++i) {
            graphConfigurations[i] = new GraphConfiguration(graphConfigurationNames[i]);
        }
        return graphConfigurations;
    }

    private String[] getGraphConfigurationListNames(SimulationConstructionSet scs) {
        return scs.getGUI().getGraphConfigurationList().getGraphConfigurationNames();
    }

    private boolean isCurrentView(SimulationConstructionSet scs, String currentViewName) {
        String representationOfCurrentView = this.getRepresentationOfCurrentView(scs);
        return representationOfCurrentView.contains(currentViewName);
    }

    private String getRepresentationOfCurrentView(SimulationConstructionSet scs) {
        StandardSimulationGUI gui = scs.getGUI();
        return gui.getXMLStyleRepresentationofMultiViews();
    }

    private String[] getViewportConfigurationNames(SimulationConstructionSet scs) {
        return scs.getGUI().getViewportConfigurationList().getViewportConfigurationNames();
    }

    private ViewportConfiguration createViewportConfiguration(String name) {
        return new ViewportConfiguration(name);
    }

    private Component getExtraPanelConfigurationPanel(SimulationConstructionSet scs, String panelName) {
        return scs.getGUI().getExtraPanel(panelName);
    }

    private ExtraPanelConfiguration createExtraPanelConfigurationWithPanel(String name) {
        Button panel = new Button();
        ExtraPanelConfiguration extraPanelConfiguration = new ExtraPanelConfiguration(name, (Component)panel, false);
        return extraPanelConfiguration;
    }

    private CameraConfiguration createCameraConfiguration(String name) {
        return new CameraConfiguration(name);
    }

    private String[] getCameraConfigurationNames(SimulationConstructionSet scs) {
        return scs.getGUI().getCameraConfigurationList().getCameraConfigurationNames();
    }

    private String[] getConfigurationListNames(SimulationConstructionSet scs) {
        return scs.getGUI().getConfigurationList().getConfigurationNames();
    }

    private String[] getEntryBoxGroupListNames(SimulationConstructionSet scs) {
        return scs.getGUI().getEntryBoxGroupList().getEntryBoxGroupNames();
    }

    private void assertArrayOfStringsContainsTheString(String[] array, String string) {
        boolean ret = false;
        for (int i = 0; i < array.length; ++i) {
            ret = ret || array[i].contains(string);
        }
        Assert.assertTrue(ret);
    }

    private boolean scsContainsTheGraphs(SimulationConstructionSet scs, String[] varNames) {
        String representationOfGraphArrayPanel = scs.getGUI().getXMLStyleRepresentationOfGraphArrayPanel();
        boolean ret = true;
        for (int i = 0; i < varNames.length; ++i) {
            ret = ret && representationOfGraphArrayPanel.contains(varNames[i]);
        }
        return ret;
    }

    private boolean scsContainsTheRobot(SimulationConstructionSet scs, String robotName) {
        Robot[] robots = scs.getRobots();
        boolean ret = false;
        for (int i = 0; i < robots.length; ++i) {
            ret = ret || robots[i].getName().equals(robotName);
        }
        return ret;
    }

    private String[] getGraphGroupNames(SimulationConstructionSet scs) {
        GraphGroupList graphGroupList = this.getGraphGroupList(scs);
        return graphGroupList.getGraphGroupNames();
    }

    private String[] getVarGroupNames(SimulationConstructionSet scs) {
        return scs.getVarGroupList().getVarGroupNames();
    }

    private boolean scsContainsTheGraph(SimulationConstructionSet scs, String varName) {
        String representationOfGraphArrayPanel = scs.getGUI().getXMLStyleRepresentationOfGraphArrayPanel();
        return representationOfGraphArrayPanel.contains(varName);
    }

    private boolean scsContainsTheEntryBoxes(SimulationConstructionSet scs, String[] varNames) {
        String representationOfEntryBoxes = scs.getGUI().getXMLStyleRepresentationOfEntryBoxes();
        boolean ret = true;
        for (int i = 0; i < varNames.length; ++i) {
            ret = ret && representationOfEntryBoxes.contains(varNames[i]);
        }
        return ret;
    }

    private boolean scsContainsTheEntryBox(SimulationConstructionSet scs, String varName) {
        String representationOfEntryBoxes = scs.getGUI().getXMLStyleRepresentationOfEntryBoxes();
        return representationOfEntryBoxes.contains(varName);
    }

    private void createSimulationRewoundListenerAndAttachToSCS(SimulationConstructionSet scs) {
        RewoundListener simulationRewoundListener = this.createSimulationRewoundListener();
        scs.attachSimulationRewoundListener(simulationRewoundListener);
    }

    private void simulateForTime(SimulationConstructionSet scs, double simulateTime) {
        scs.simulate(simulateTime);
        while (scs.isSimulating()) {
            ThreadTools.sleep((long)100L);
        }
    }

    private RewoundListener createSimulationRewoundListener() {
        RewoundListener ret = new RewoundListener(){

            public void notifyOfRewind() {
                SimulationConstructionSetUsingDirectCallsTest.this.simulationRewoundListenerHasBeenNotified.set(true);
            }
        };
        return ret;
    }

    private ExitActionListener createExitActionListener() {
        ExitActionListener ret = new ExitActionListener(){

            public void exitActionPerformed() {
                SimulationConstructionSetUsingDirectCallsTest.this.exitActionListenerHasBeenNotified.set(true);
            }
        };
        return ret;
    }

    private boolean getCameraKeyMode(SimulationConstructionSet scs) {
        ClassicCameraController classicCameraController = this.getClassicCameraController(scs);
        return classicCameraController.getCameraKeyMode();
    }

    private double getCameraFieldOfView(SimulationConstructionSet scs) {
        ClassicCameraController classicCameraController = this.getClassicCameraController(scs);
        return classicCameraController.getHorizontalFieldOfViewInRadians();
    }

    private double[] getCameraTrackingXYZVars(SimulationConstructionSet scs) {
        CameraTrackAndDollyYoVariablesHolder cameraTrackAndDollyYoVariablesHolder = this.getCameraTrackAndDollyVariablesHolder(scs);
        double x = cameraTrackAndDollyYoVariablesHolder.getTrackingX();
        double y = cameraTrackAndDollyYoVariablesHolder.getTrackingY();
        double z = cameraTrackAndDollyYoVariablesHolder.getTrackingZ();
        return new double[]{x, y, z};
    }

    private double[] getCameraDollyXYZVars(SimulationConstructionSet scs) {
        CameraTrackAndDollyYoVariablesHolder cameraTrackAndDollyYoVariablesHolder = this.getCameraTrackAndDollyVariablesHolder(scs);
        double x = cameraTrackAndDollyYoVariablesHolder.getDollyX();
        double y = cameraTrackAndDollyYoVariablesHolder.getDollyY();
        double z = cameraTrackAndDollyYoVariablesHolder.getDollyZ();
        return new double[]{x, y, z};
    }

    private double[] getCameraTrackingOffsetXYZValues(SimulationConstructionSet scs) {
        ClassicCameraController classicCameraController = this.getClassicCameraController(scs);
        double dx = classicCameraController.getTrackingXOffset();
        double dy = classicCameraController.getTrackingYOffset();
        double dz = classicCameraController.getTrackingZOffset();
        return new double[]{dx, dy, dz};
    }

    private double[] getCameraDollyOffsetXYZValues(SimulationConstructionSet scs) {
        ClassicCameraController classicCameraController = this.getClassicCameraController(scs);
        double dx = classicCameraController.getDollyXOffset();
        double dy = classicCameraController.getDollyYOffset();
        double dz = classicCameraController.getDollyZOffset();
        return new double[]{dx, dy, dz};
    }

    private double[] getCameraFixXYZValues(SimulationConstructionSet scs) {
        ClassicCameraController classicCameraController = this.getClassicCameraController(scs);
        double x = classicCameraController.getFixX();
        double y = classicCameraController.getFixY();
        double z = classicCameraController.getFixZ();
        return new double[]{x, y, z};
    }

    private double[] getCameraNearFarValues(SimulationConstructionSet scs) {
        ClassicCameraController classicCameraController = this.getClassicCameraController(scs);
        double near = classicCameraController.getClipNear();
        double far = classicCameraController.getClipFar();
        return new double[]{near, far};
    }

    private double[] getCameraPositionXYZValues(SimulationConstructionSet scs) {
        ClassicCameraController classicCameraController = this.getClassicCameraController(scs);
        double x = classicCameraController.getCamX();
        double y = classicCameraController.getCamY();
        double z = classicCameraController.getCamZ();
        return new double[]{x, y, z};
    }

    private GraphGroupList getGraphGroupList(SimulationConstructionSet scs) {
        return scs.getGUI().getGraphGroupList();
    }

    private ClassicCameraController getClassicCameraController(SimulationConstructionSet scs) {
        return (ClassicCameraController)scs.getGUI().getViewportPanel().getActiveView().getCameraController();
    }

    private CameraTrackAndDollyYoVariablesHolder getCameraTrackAndDollyVariablesHolder(SimulationConstructionSet scs) {
        ClassicCameraController classicCameraController = this.getClassicCameraController(scs);
        return (CameraTrackAndDollyYoVariablesHolder)classicCameraController.getCameraTrackAndDollyVariablesHolder();
    }

    private List<YoDouble> addDoubleYoVariablesInSCSRegistry(String[] varNames, double[] varValues, SimulationConstructionSet scs) {
        List<YoDouble> yoDoubles = null;
        if (varNames.length == varValues.length) {
            YoRegistry scsRegistry = scs.getRootRegistry();
            yoDoubles = this.createAndSetDoubleYoVariableToRegistry(varNames, varValues, scsRegistry);
        } else {
            System.out.print("Input arrays have different length.");
        }
        return yoDoubles;
    }

    private String getRegistryNamespaceFromRobot(Robot robotModel) {
        return robotModel.getRobotsYoRegistry().getNamespace().getName();
    }

    private String getFirstVariableNameFromRobotRegistry(Robot robotModel) {
        return robotModel.getRobotsYoRegistry().getVariable(0).getName();
    }

    private String getLastVariableNameFromRobotRegistry(Robot robotModel) {
        int lastIndex = robotModel.getRobotsYoRegistry().getNumberOfVariables() - 1;
        return robotModel.getRobotsYoRegistry().getVariable(lastIndex).getName();
    }

    private void setInputAndOutputPointsWithoutCroppingInSCS(SimulationConstructionSet scs, int inputPointIndex, int outputPointIndex) {
        this.setInputPointInSCS(scs, inputPointIndex);
        this.setOutputPointInSCS(scs, outputPointIndex);
    }

    private void setInputPointInSCS(SimulationConstructionSet scs, int inputPointIndex) {
        scs.setCurrentIndex(inputPointIndex);
        scs.setInPoint();
    }

    private void setOutputPointInSCS(SimulationConstructionSet scs, int outputPointIndex) {
        scs.setCurrentIndex(outputPointIndex);
        scs.setOutPoint();
    }

    private List<YoVariable> getSimpleRobotVariablesThatContain(String searchString, boolean caseSensitive, Robot robotModel) {
        List currentlyMatched = robotModel.getVariables();
        ArrayList<YoVariable> ret = null;
        if (currentlyMatched != null) {
            if (!caseSensitive) {
                searchString = searchString.toLowerCase();
            }
            for (int i = 0; i < currentlyMatched.size(); ++i) {
                YoVariable entry = (YoVariable)currentlyMatched.get(i);
                if (!entry.getName().toLowerCase().contains(searchString)) continue;
                if (ret == null) {
                    ret = new ArrayList<YoVariable>();
                }
                ret.add(entry);
            }
        }
        return ret;
    }

    private List<YoVariable> getSimpleRobotVariablesThatStartWith(String searchString, Robot robotModel) {
        List currentlyMatched = robotModel.getVariables();
        ArrayList<YoVariable> ret = null;
        for (int i = 0; i < currentlyMatched.size(); ++i) {
            YoVariable Variable = (YoVariable)currentlyMatched.get(i);
            if (!Variable.getName().startsWith(searchString)) continue;
            if (ret == null) {
                ret = new ArrayList<YoVariable>();
            }
            ret.add(Variable);
        }
        return ret;
    }

    private String[] getVariableNamesGivenArrayListOfYoVariables(List<YoVariable> yoVariableList) {
        String[] ret = null;
        for (int i = 0; i < yoVariableList.size(); ++i) {
            String variableName = yoVariableList.get(i).getName();
            if (ret == null) {
                ret = new String[yoVariableList.size()];
            }
            ret[i] = variableName;
        }
        return ret;
    }

    private List<YoVariable> getSimpleRobotRegExpVariables(String[] varNames, String[] regularExpressions, Robot robotModel) {
        List currentlyMatched = robotModel.getVariables();
        YoVariableList tempList = new YoVariableList("temp");
        for (int i = 0; i < currentlyMatched.size(); ++i) {
            YoVariable var = (YoVariable)currentlyMatched.get(i);
            tempList.add(var);
        }
        ArrayList<YoVariable> variables = new ArrayList<YoVariable>();
        Arrays.asList(varNames).forEach(varName -> variables.addAll(tempList.findVariables(varName)));
        Arrays.asList(regularExpressions).forEach(regex -> variables.addAll(YoSearchTools.filterVariables((Predicate)YoSearchTools.regularExpressionFilter((String[])new String[]{regex}), (YoVariableHolder)tempList)));
        return variables;
    }

    private int computeRecordFreq(double recordDT, double simulateDT) {
        return (int)Math.round(recordDT / simulateDT);
    }

    private double recomputeTiming(double dt, double recordFreq, double realTimeRate, double frameRate) {
        int ticksPerCycle = this.computeTicksPerPlayCycle(dt, recordFreq, realTimeRate, frameRate);
        double secondsPerFrameRate = (double)ticksPerCycle * (dt * recordFreq) / realTimeRate;
        return secondsPerFrameRate;
    }

    private int computeTicksPerPlayCycle(double dt, double recordFreq, double realTimeRate, double frameRate) {
        return Math.max((int)(frameRate * realTimeRate / (dt * recordFreq)), 1);
    }
}

