/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.awt.Frame;
import java.io.File;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.examples.FallingBrickRobot;
import us.ihmc.tools.MemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

@Tag(value="gui")
public class SimulationConstructionSetMemoryReclamationTest {
    private static final boolean DEBUG = true;

    @Test
    public void testMemoryReclamationForSCSWithoutARobot() {
        boolean useRobot = false;
        int numberOfTests = 3;
        boolean createVideo = false;
        int usedMemoryMBAtStart = MemoryTools.getCurrentMemoryUsageInMB();
        int usedMemoryMBAtEnd = this.testOneAndReturnUsedMemoryMB(useRobot, numberOfTests, createVideo);
        int usedMemoryMB = usedMemoryMBAtEnd - usedMemoryMBAtStart;
        this.checkForLingeringFrames();
        Assert.assertTrue("usedMemoryMB = " + usedMemoryMB, usedMemoryMB < 100);
    }

    @Test
    public void testMemoryReclamationForSCSWithARobot() {
        boolean useRobot = true;
        int numberOfTests = 1;
        boolean createVideo = false;
        int usedMemoryMBAtStart = MemoryTools.getCurrentMemoryUsageInMB();
        int usedMemoryMBAtEnd = this.testOneAndReturnUsedMemoryMB(useRobot, numberOfTests, createVideo);
        int usedMemoryMB = usedMemoryMBAtEnd - usedMemoryMBAtStart;
        this.checkForLingeringFrames();
        Assert.assertTrue("usedMemoryMB = " + usedMemoryMB, usedMemoryMB < 100);
    }

    @Test
    public void testMemoryReclamationForSCSWithARobotAndVideo() {
        boolean useRobot = true;
        int numberOfTests = 10;
        boolean createVideo = true;
        int usedMemoryMBAtStart = MemoryTools.getCurrentMemoryUsageInMB();
        int usedMemoryMBAtEnd = this.testOneAndReturnUsedMemoryMB(useRobot, numberOfTests, createVideo);
        int usedMemoryMB = usedMemoryMBAtEnd - usedMemoryMBAtStart;
        this.checkForLingeringFrames();
        Assert.assertTrue("usedMemoryMB = " + usedMemoryMB, usedMemoryMB < 100);
    }

    private int testOneAndReturnUsedMemoryMB(boolean useARobot, int numberOfTests, boolean createVideo) {
        boolean garbageCollect = true;
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)"testOneAndReturnUsedMemoryMB start:", (boolean)true, (boolean)garbageCollect);
        for (int i = 0; i < numberOfTests; ++i) {
            SimulationConstructionSet scs = this.createAndStartSimulationConstructionSet(useARobot);
            scs.simulate(2.0);
            this.sleep(2000L);
            if (createVideo) {
                scs.gotoInPointNow();
                String videoFilename = "testOneAndReturnUsedMemoryMB.mp4";
                File file = new File(videoFilename);
                if (file.exists()) {
                    file.delete();
                }
                File videoFile = scs.createVideo(videoFilename);
                videoFile.delete();
                this.printIfDebug("Got past video creation...maybe");
            }
            scs.closeAndDispose();
            MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)"testOneAndReturnUsedMemoryMB final: ", (boolean)true, (boolean)garbageCollect);
        }
        System.gc();
        this.printIfDebug("Created and disposed of " + numberOfTests + " SCSs. Should be garbage collected now...");
        this.sleep(2000L);
        int usedMemoryMB = MemoryTools.getCurrentMemoryUsageInMB();
        this.printIfDebug("Used Memory = " + usedMemoryMB + " MB");
        return usedMemoryMB;
    }

    private void checkForLingeringFrames() {
        Frame[] frames = Frame.getFrames();
        if (frames != null) {
            this.printIfDebug("Number of Frames is still " + frames.length);
            for (Frame frame : frames) {
                this.printIfDebug("Frame " + frame.getTitle() + ": " + frame);
            }
        }
        frames = null;
    }

    private void printIfDebug(String string) {
        System.out.println(string);
    }

    private SimulationConstructionSet createAndStartSimulationConstructionSet(boolean useARobot) {
        SimulationConstructionSet scs;
        if (useARobot) {
            FallingBrickRobot robot = new FallingBrickRobot();
            YoRegistry registry = new YoRegistry("TestRegistry");
            for (int i = 0; i < 5000; ++i) {
                new YoDouble("variable" + i, registry);
            }
            robot.addYoRegistry(registry);
            SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
            parameters.setDataBufferSize(5000);
            scs = new SimulationConstructionSet((Robot)robot, parameters);
        } else {
            SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
            parameters.setCreateGUI(true);
            parameters.setDataBufferSize(5000);
            scs = new SimulationConstructionSet(parameters);
        }
        scs.setDT(1.0E-4, 100);
        Thread thread = new Thread((Runnable)scs);
        thread.start();
        while (useARobot && !scs.isSimulationThreadRunning()) {
            this.sleep(100L);
        }
        return scs;
    }

    private void sleep(long sleepMillis) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

