/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.util.ground.VaryingStairGroundProfile;
import us.ihmc.tools.MemoryTools;

public class VaryingStairGroundProfileTest {
    @BeforeEach
    public void showMemoryUsageBeforeTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " before test."));
    }

    @AfterEach
    public void showMemoryUsageAfterTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " after test."));
    }

    @Test
    public void test() {
        double startX = -0.1;
        double startZ = 3.0;
        double[] stepRises = new double[]{0.1, 0.2, 0.3};
        double[] stepTreads = new double[]{0.4, 0.5};
        VaryingStairGroundProfile groundProfile = new VaryingStairGroundProfile(startX, startZ, stepTreads, stepRises);
        double epsilonX = 0.001;
        double epsilonZ = 1.0E-14;
        int nSteps = stepRises.length;
        double currentX = startX;
        double currentHeight = startZ;
        for (int i = 0; i < nSteps; ++i) {
            Assert.assertEquals(currentHeight, groundProfile.heightAt(currentX - epsilonX, 0.0, 0.0), epsilonZ);
            Assert.assertEquals(currentHeight += stepRises[i], groundProfile.heightAt(currentX + epsilonX, 0.0, 0.0), epsilonZ);
            if (i >= stepTreads.length) continue;
            currentX += stepTreads[i];
        }
        System.out.println(currentX);
    }
}

