/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.dataBuffer;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.dataBuffer.MirroredYoVariableRegistry;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class MirroredYoVariableRegistryTest {
    private static final int TEST_VARIABLE_COUNT = 10;

    @Test
    public void testMirroredRegistryIsTheSameAsOriginalAfterCreation() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        MirroredYoVariableRegistry mirroredRegistry = new MirroredYoVariableRegistry(originalRegistry);
        Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredRegistry));
    }

    @Test
    public void testYoRegistryChildren() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        YoRegistry childRegistry = MirroredYoVariableRegistryTest.createTestRegistry("ChildRegistry", 10);
        originalRegistry.addChild(childRegistry);
        MirroredYoVariableRegistry mirroredRegistry = new MirroredYoVariableRegistry(originalRegistry);
        for (int i = 0; i < mirroredRegistry.getChildren().size(); ++i) {
            Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual((YoRegistry)originalRegistry.getChildren().get(i), (YoRegistry)mirroredRegistry.getChildren().get(i)));
        }
    }

    @Test
    public void testChangesArePropagatedFromOriginal() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        MirroredYoVariableRegistry mirroredYoRegistry = new MirroredYoVariableRegistry(originalRegistry);
        for (YoVariable yoVariable : originalRegistry.collectSubtreeVariables()) {
            yoVariable.setValueFromDouble(1.0);
        }
        Assert.assertFalse(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredYoRegistry));
        mirroredYoRegistry.updateValuesFromOriginal();
        Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredYoRegistry));
    }

    @Test
    public void testChangesArePropagatedFromMirror() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        MirroredYoVariableRegistry mirroredYoRegistry = new MirroredYoVariableRegistry(originalRegistry);
        for (YoVariable yoVariable : mirroredYoRegistry.collectSubtreeVariables()) {
            yoVariable.setValueFromDouble(2.0);
        }
        Assert.assertFalse(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredYoRegistry));
        mirroredYoRegistry.updateChangedValues();
        Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredYoRegistry));
    }

    @Test
    public void testListenerBug20220829() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        MirroredYoVariableRegistry mirroredRegistry = new MirroredYoVariableRegistry(originalRegistry);
        List originalVariables = originalRegistry.collectSubtreeVariables();
        YoVariable originalV0 = (YoVariable)originalVariables.get(0);
        YoVariable originalV1 = (YoVariable)originalVariables.get(1);
        List mirroredVariables = mirroredRegistry.collectSubtreeVariables();
        YoVariable mirroredV0 = (YoVariable)mirroredVariables.get(0);
        YoVariable mirroredV1 = (YoVariable)mirroredVariables.get(1);
        originalV0.addListener(v -> originalV1.setValueFromDouble(3.0));
        Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredRegistry));
        mirroredV0.setValueFromDouble(1.0);
        mirroredRegistry.updateMirror();
        Assert.assertTrue(MirroredYoVariableRegistryTest.areYoVariablesEqual(originalV0, mirroredV0));
        Assert.assertTrue(MirroredYoVariableRegistryTest.areYoVariablesEqual(originalV1, mirroredV1));
        Assert.assertTrue(mirroredRegistry.getMirrorPendingActions().isEmpty());
        Assert.assertTrue(mirroredRegistry.getOriginalPendingActions().isEmpty());
        Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredRegistry));
    }

    @Test
    public void testMirrorValuesArePreferredWhenConflict() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        MirroredYoVariableRegistry mirroredYoRegistry = new MirroredYoVariableRegistry(originalRegistry);
        double newValueForOriginal = 2.0;
        double newValueForMirror = 3.0;
        for (YoVariable yoVariable : originalRegistry.collectSubtreeVariables()) {
            yoVariable.setValueFromDouble(2.0);
        }
        for (YoVariable yoVariable : mirroredYoRegistry.collectSubtreeVariables()) {
            yoVariable.setValueFromDouble(3.0);
        }
        Assert.assertFalse(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredYoRegistry));
        mirroredYoRegistry.updateMirror();
        Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredYoRegistry));
        for (YoVariable yoVariable : mirroredYoRegistry.collectSubtreeVariables()) {
            Assert.assertEquals(yoVariable.getValueAsDouble(), 3.0, 1.0E-10);
        }
    }

    @Test
    public void testOriginalListenersAreCalledWhenMirrorChanges() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        MirroredYoVariableRegistry mirroredYoRegistry = new MirroredYoVariableRegistry(originalRegistry);
        ListenerCounter listenerCounter = new ListenerCounter();
        for (YoVariable yoVariable : originalRegistry.collectSubtreeVariables()) {
            yoVariable.addListener((YoVariableChangedListener)listenerCounter);
        }
        for (YoVariable yoVariable : mirroredYoRegistry.collectSubtreeVariables()) {
            yoVariable.setValueFromDouble(1.0);
        }
        mirroredYoRegistry.updateMirror();
        Assert.assertEquals(listenerCounter.callCount, originalRegistry.collectSubtreeVariables().size());
    }

    @Test
    public void testMirrorListenersAreCalledWhenOriginalChanges() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        MirroredYoVariableRegistry mirroredYoRegistry = new MirroredYoVariableRegistry(originalRegistry);
        ListenerCounter listenerCounter = new ListenerCounter();
        for (YoVariable yoVariable : mirroredYoRegistry.collectSubtreeVariables()) {
            yoVariable.addListener((YoVariableChangedListener)listenerCounter);
        }
        for (YoVariable yoVariable : originalRegistry.collectSubtreeVariables()) {
            yoVariable.setValueFromDouble(1.0);
        }
        mirroredYoRegistry.updateMirror();
        Assert.assertEquals(listenerCounter.callCount, mirroredYoRegistry.collectSubtreeVariables().size());
    }

    @Test
    public void testListenerBug20220921() {
        YoRegistry originalRegistry = MirroredYoVariableRegistryTest.createTestRegistry("OriginalRegistry", 10);
        MirroredYoVariableRegistry mirroredRegistry = new MirroredYoVariableRegistry(originalRegistry);
        List mirroredVariables = mirroredRegistry.collectSubtreeVariables();
        List originalVariables = originalRegistry.collectSubtreeVariables();
        for (YoVariable mirroredVariable : mirroredVariables) {
            mirroredVariable.setValueFromDouble(2.0);
        }
        YoVariable aOriginalVariable = (YoVariable)originalVariables.get(originalVariables.size() / 2);
        aOriginalVariable.setValueFromDouble(5.0);
        YoVariableChangedListener aOriginalVariableListener = v -> {
            if (aOriginalVariable.getValueAsDouble() != 5.0) {
                aOriginalVariable.setValueFromDouble(5.0);
            }
        };
        aOriginalVariable.addListener(aOriginalVariableListener);
        YoVariable aMirroredVariable = mirroredRegistry.findVariable(aOriginalVariable.getFullNameString());
        Assert.assertFalse(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredRegistry));
        mirroredRegistry.updateChangedValues();
        Assert.assertEquals(5.0, aOriginalVariable.getValueAsDouble());
        Assert.assertEquals(2.0, aMirroredVariable.getValueAsDouble());
        Assert.assertFalse(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredRegistry));
        mirroredRegistry.updateValuesFromOriginal();
        Assert.assertEquals(5.0, aOriginalVariable.getValueAsDouble());
        Assert.assertEquals(5.0, aMirroredVariable.getValueAsDouble());
        Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredRegistry));
        aMirroredVariable.setValueFromDouble(2.0);
        mirroredRegistry.updateChangedValues();
        Assert.assertEquals(5.0, aOriginalVariable.getValueAsDouble());
        Assert.assertEquals(2.0, aMirroredVariable.getValueAsDouble());
        Assert.assertFalse(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredRegistry));
        mirroredRegistry.updateValuesFromOriginal();
        Assert.assertEquals(5.0, aOriginalVariable.getValueAsDouble());
        Assert.assertEquals(5.0, aMirroredVariable.getValueAsDouble());
        Assert.assertTrue(MirroredYoVariableRegistryTest.areRegistryVariablesAreEqual(originalRegistry, (YoRegistry)mirroredRegistry));
    }

    private static YoRegistry createTestRegistry(String name, int variableCount) {
        YoRegistry registry = new YoRegistry(name);
        for (int i = 0; i < variableCount; ++i) {
            new YoDouble("Variable" + i, registry);
        }
        return registry;
    }

    private static boolean areRegistryVariablesAreEqual(YoRegistry registry1, YoRegistry registry2) {
        if (registry1.collectSubtreeVariables().size() != registry2.collectSubtreeVariables().size()) {
            return false;
        }
        for (int i = 0; i < registry1.collectSubtreeVariables().size(); ++i) {
            YoVariable copy;
            YoVariable original = (YoVariable)registry1.collectSubtreeVariables().get(i);
            if (MirroredYoVariableRegistryTest.areYoVariablesEqual(original, copy = (YoVariable)registry2.collectSubtreeVariables().get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean areYoVariablesEqual(YoVariable var1, YoVariable var2) {
        return StringUtils.equals((CharSequence)var1.getName(), (CharSequence)var2.getName()) && var1.getValueAsDouble() == var2.getValueAsDouble();
    }

    private static class ListenerCounter
    implements YoVariableChangedListener {
        public int callCount = 0;

        private ListenerCounter() {
        }

        public void changed(YoVariable v) {
            ++this.callCount;
        }
    }
}

