/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.config;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.gui.config.VarGroup;
import us.ihmc.yoVariables.registry.YoRegistry;

public class VarGroupTest {
    String variable1;
    String variable2;
    String variable3;
    String variable4;
    YoRegistry registry;
    VarGroup varGroup;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("regsitry");
        this.variable1 = "doubleYoVariable1";
        this.variable2 = "doubleYoVariable2";
        this.variable3 = "doubleYoVariable3";
        this.variable4 = "doubleYoVariable4";
        this.varGroup = new VarGroup("varGroup");
    }

    @Test
    public void testSetAndGetName() {
        Assert.assertTrue("varGroup" == this.varGroup.getName());
        this.varGroup.setName("varGroupTest1");
        Assert.assertTrue("varGroupTest1" == this.varGroup.getName());
        this.varGroup.setName("varGroupTestLongNameWithNumbers123456789");
        Assert.assertTrue("varGroupTestLongNameWithNumbers123456789" == this.varGroup.getName());
    }

    @Test
    public void testAddGetAndRemoveSingleVariable() {
        this.varGroup.addVar(this.variable1);
        String[] varGroupArray = this.varGroup.getVars();
        Assert.assertTrue(this.variable1 == varGroupArray[0]);
        this.varGroup.removeVar("doubleYoVariable1");
        varGroupArray = this.varGroup.getVars();
        Assert.assertTrue(0 == varGroupArray.length);
    }

    @Test
    public void testAddMultipleVariables() {
        String[] variablesToBeAdded = new String[]{this.variable1, this.variable2, this.variable3, this.variable4};
        this.varGroup.addVars(variablesToBeAdded);
        String[] varGroupArrayReturned = this.varGroup.getVars();
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue(variablesToBeAdded[i] == varGroupArrayReturned[i]);
        }
    }

    @Test
    public void testAddRemoveAndGetRegularExpressions() {
        String[] regularExpressionsToBeAdded = new String[]{this.variable1, this.variable2, this.variable3, this.variable4};
        this.varGroup.addRegularExpressions(regularExpressionsToBeAdded);
        String[] regularExpressionsReturned = this.varGroup.getRegularExpressions();
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue(regularExpressionsToBeAdded[i] == regularExpressionsReturned[i]);
        }
        this.varGroup.removeRegularExpression(this.variable1);
        regularExpressionsReturned = this.varGroup.getRegularExpressions();
        String[] regularExpressionsToBeAdded1 = new String[]{this.variable2, this.variable3, this.variable4};
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue(regularExpressionsToBeAdded1[i] == regularExpressionsReturned[i]);
        }
    }
}

