/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.List;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.RigidJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.RigidJointPhysics;

public class RigidJointTest {
    private static final boolean doDynamics = true;

    @Test
    public void testOneRigidJoint() {
        Robot robot = new Robot("Test");
        RigidJoint rigidJointOne = new RigidJoint("rigidJointOne", (Vector3DReadOnly)new Vector3D(), robot);
        Link rigidLinkOne = new Link("rigidLinkOne");
        double massOne = 1.0;
        rigidLinkOne.setMassAndRadiiOfGyration(massOne, 0.1, 0.1, 0.1);
        Vector3D centerOfMassOffset = new Vector3D(1.1, 2.2, 3.3);
        rigidLinkOne.setComOffset((Vector3DReadOnly)centerOfMassOffset);
        rigidJointOne.setLink(rigidLinkOne);
        robot.addRootJoint((Joint)rigidJointOne);
        Point3D centerOfMass = new Point3D();
        double totalMass = robot.computeCenterOfMass((Point3DBasics)centerOfMass);
        Assert.assertEquals(massOne, totalMass, 1.0E-7);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)centerOfMassOffset, (EuclidGeometry)centerOfMass, (double)1.0E-10);
    }

    @Test
    public void testOneRigidJointWithTranslation() {
        Robot robot = new Robot("Test");
        RigidJoint rigidJointOne = new RigidJoint("rigidJointOne", (Vector3DReadOnly)new Vector3D(), robot);
        Vector3D translation = new Vector3D(1.1, 2.2, 3.3);
        rigidJointOne.setRigidTranslation((Vector3DReadOnly)translation);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set((Tuple3DReadOnly)translation);
        Link rigidLinkOne = new Link("rigidLinkOne");
        double massOne = 1.0;
        rigidLinkOne.setMassAndRadiiOfGyration(massOne, 0.1, 0.1, 0.1);
        Vector3D centerOfMassOffset = new Vector3D(0.99, -0.4, 1.1);
        rigidLinkOne.setComOffset((Vector3DReadOnly)centerOfMassOffset);
        rigidJointOne.setLink(rigidLinkOne);
        robot.addRootJoint((Joint)rigidJointOne);
        robot.update();
        Point3D centerOfMass = new Point3D();
        double totalMass = robot.computeCenterOfMass((Point3DBasics)centerOfMass);
        Assert.assertEquals(massOne, totalMass, 1.0E-7);
        Point3D expectedCenterOfMass = new Point3D((Tuple3DReadOnly)centerOfMassOffset);
        expectedCenterOfMass.add((Tuple3DReadOnly)translation);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCenterOfMass, (EuclidGeometry)centerOfMass, (double)1.0E-10);
    }

    @Test
    public void testOneRigidJointWithRotation() {
        Robot robot = new Robot("Test");
        RigidJoint rigidJointOne = new RigidJoint("rigidJointOne", (Vector3DReadOnly)new Vector3D(), robot);
        RotationMatrix rotation = new RotationMatrix();
        Vector3D eulerAngles = new Vector3D(0.3, 0.1, 0.2);
        rotation.setEuler((Vector3DReadOnly)eulerAngles);
        rigidJointOne.setRigidRotation((RotationMatrixReadOnly)rotation);
        Link rigidLinkOne = new Link("rigidLinkOne");
        double massOne = 1.0;
        rigidLinkOne.setMassAndRadiiOfGyration(massOne, 0.1, 0.1, 0.1);
        Vector3D centerOfMassOffset = new Vector3D(0.3, 0.7, 1.11);
        rigidLinkOne.setComOffset((Vector3DReadOnly)centerOfMassOffset);
        rigidJointOne.setLink(rigidLinkOne);
        robot.addRootJoint((Joint)rigidJointOne);
        robot.update();
        Point3D centerOfMass = new Point3D();
        double totalMass = robot.computeCenterOfMass((Point3DBasics)centerOfMass);
        Assert.assertEquals(massOne, totalMass, 1.0E-7);
        Point3D expectedCenterOfMass = new Point3D((Tuple3DReadOnly)centerOfMassOffset);
        rotation.transform((Tuple3DBasics)expectedCenterOfMass);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCenterOfMass, (EuclidGeometry)centerOfMass, (double)1.0E-10);
    }

    @Test
    public void testOneRigidJointWithRotationAndTranslation() {
        Robot robot = new Robot("Test");
        RigidJoint rigidJointOne = new RigidJoint("rigidJointOne", (Vector3DReadOnly)new Vector3D(), robot);
        RotationMatrix rotation = new RotationMatrix();
        Vector3D eulerAngles = new Vector3D(0.3, 0.1, 0.2);
        rotation.setEuler((Vector3DReadOnly)eulerAngles);
        rigidJointOne.setRigidRotation((RotationMatrixReadOnly)rotation);
        Vector3D translation = new Vector3D(0.3, -0.99, 1.11);
        rigidJointOne.setRigidTranslation((Vector3DReadOnly)translation);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set((Tuple3DReadOnly)translation);
        transform.getRotation().set((RotationMatrixReadOnly)rotation);
        Link rigidLinkOne = new Link("rigidLinkOne");
        double massOne = 1.0;
        rigidLinkOne.setMassAndRadiiOfGyration(massOne, 0.1, 0.1, 0.1);
        Vector3D centerOfMassOffset = new Vector3D(0.3, 0.7, 1.11);
        rigidLinkOne.setComOffset((Vector3DReadOnly)centerOfMassOffset);
        rigidJointOne.setLink(rigidLinkOne);
        robot.addRootJoint((Joint)rigidJointOne);
        robot.update();
        Point3D centerOfMass = new Point3D();
        double totalMass = robot.computeCenterOfMass((Point3DBasics)centerOfMass);
        Assert.assertEquals(massOne, totalMass, 1.0E-7);
        Point3D expectedCenterOfMass = new Point3D((Tuple3DReadOnly)centerOfMassOffset);
        transform.transform((Point3DBasics)expectedCenterOfMass);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedCenterOfMass, (EuclidGeometry)centerOfMass, (double)1.0E-10);
    }

    @Test
    public void testSinglePinJoint() throws UnreasonableAccelerationException {
        Robot robotA = new Robot("RobotA");
        Robot robotB = new Robot("RobotB");
        Vector3D rigidJointOffset = new Vector3D(1.1, 2.2, 3.3);
        RotationMatrix rigidJointRotation = new RotationMatrix();
        rigidJointRotation.setEuler(0.66, 0.1, 0.776);
        Vector3D rotationAxis = new Vector3D(0.1, 1.05, 0.356);
        rotationAxis.normalize();
        Vector3D rotatedRotationAxis = new Vector3D((Tuple3DReadOnly)rotationAxis);
        rigidJointRotation.transform((Tuple3DBasics)rotatedRotationAxis);
        PinJoint pinJointA = new PinJoint("pinA", (Tuple3DReadOnly)rigidJointOffset, robotA, (Vector3DReadOnly)rotatedRotationAxis);
        RigidJoint rigidJointB = new RigidJoint("rigidJointB", (Vector3DReadOnly)new Vector3D(), robotB);
        rigidJointB.setRigidRotation((RotationMatrixReadOnly)rigidJointRotation);
        rigidJointB.setRigidTranslation((Vector3DReadOnly)rigidJointOffset);
        Link rigidLinkB = new Link("rigidLinkB");
        rigidJointB.setLink(rigidLinkB);
        PinJoint pinJointB = new PinJoint("pinB", (Tuple3DReadOnly)new Vector3D(), robotB, (Vector3DReadOnly)rotationAxis);
        Link linkOneA = new Link("linkOneA");
        Link linkOneB = new Link("linkOneB");
        double massOne = 1.056;
        Vector3D radiiOfGyrationOne = new Vector3D(0.1, 0.2, 0.3);
        linkOneA.setMass(massOne);
        linkOneB.setMassAndRadiiOfGyration(massOne, (Vector3DReadOnly)radiiOfGyrationOne);
        Matrix3D momentOfInertiaOne = new Matrix3D();
        linkOneB.getMomentOfInertia((Matrix3DBasics)momentOfInertiaOne);
        Matrix3D rotatedMomentOfInertiaOne = new Matrix3D((Matrix3DReadOnly)momentOfInertiaOne);
        rigidJointRotation.transform((Matrix3DBasics)rotatedMomentOfInertiaOne);
        linkOneA.setMomentOfInertia((Matrix3DReadOnly)rotatedMomentOfInertiaOne);
        Vector3D centerOfMassOffsetOne = new Vector3D(0.1, 0.2, 1.0);
        Vector3D rotatedCenterOfMassOffsetOne = new Vector3D((Tuple3DReadOnly)centerOfMassOffsetOne);
        rigidJointRotation.transform((Tuple3DBasics)rotatedCenterOfMassOffsetOne);
        linkOneA.setComOffset((Vector3DReadOnly)rotatedCenterOfMassOffsetOne);
        linkOneB.setComOffset((Vector3DReadOnly)centerOfMassOffsetOne);
        pinJointA.setLink(linkOneA);
        pinJointB.setLink(linkOneB);
        robotA.addRootJoint((Joint)pinJointA);
        rigidJointB.addJoint((Joint)pinJointB);
        robotB.addRootJoint((Joint)rigidJointB);
        pinJointA.setQ(0.189);
        pinJointB.setQ(0.189);
        pinJointA.setQd(0.145);
        pinJointB.setQd(0.145);
        robotA.update();
        robotB.update();
        robotA.doDynamicsButDoNotIntegrate();
        robotB.doDynamicsButDoNotIntegrate();
        this.checkRobotsHaveSameState(robotA, robotB);
        robotA.doDynamicsAndIntegrate(1.0E-4);
        robotB.doDynamicsAndIntegrate(1.0E-4);
        this.checkRobotsHaveSameState(robotA, robotB);
    }

    @Test
    public void testSingleSliderJoint() throws UnreasonableAccelerationException {
        Robot robotA = new Robot("RobotA");
        Robot robotB = new Robot("RobotB");
        Vector3D rigidJointOffset = new Vector3D(1.1, 2.2, 3.3);
        RotationMatrix rigidJointRotation = new RotationMatrix();
        rigidJointRotation.setEuler(0.5, 0.1, 0.99);
        Vector3D rotationAxis = new Vector3D(0.1, 1.0, 0.7);
        rotationAxis.normalize();
        Vector3D rotatedRotationAxis = new Vector3D((Tuple3DReadOnly)rotationAxis);
        rigidJointRotation.transform((Tuple3DBasics)rotatedRotationAxis);
        SliderJoint sliderJointA = new SliderJoint("sliderA", (Tuple3DReadOnly)rigidJointOffset, robotA, (Vector3DReadOnly)rotatedRotationAxis);
        RigidJoint rigidJointB = new RigidJoint("rigidJointB", (Vector3DReadOnly)new Vector3D(), robotB);
        rigidJointB.setRigidRotation((RotationMatrixReadOnly)rigidJointRotation);
        rigidJointB.setRigidTranslation((Vector3DReadOnly)rigidJointOffset);
        Link rigidLinkB = new Link("rigidLinkB");
        rigidJointB.setLink(rigidLinkB);
        SliderJoint sliderJointB = new SliderJoint("sliderB", (Tuple3DReadOnly)new Vector3D(), robotB, (Vector3DReadOnly)rotationAxis);
        Link linkOneA = new Link("linkOneA");
        Link linkOneB = new Link("linkOneB");
        double massOne = 1.0;
        Vector3D radiiOfGyrationOne = new Vector3D(0.1, 0.2, 0.3);
        Vector3D rotatedRadiiOfGyrationOne = new Vector3D((Tuple3DReadOnly)radiiOfGyrationOne);
        rigidJointRotation.transform((Tuple3DBasics)rotatedRadiiOfGyrationOne);
        linkOneA.setMass(massOne);
        linkOneB.setMassAndRadiiOfGyration(massOne, (Vector3DReadOnly)radiiOfGyrationOne);
        Matrix3D momentOfInertiaOne = new Matrix3D();
        linkOneB.getMomentOfInertia((Matrix3DBasics)momentOfInertiaOne);
        Matrix3D rotatedMomentOfInertiaOne = new Matrix3D((Matrix3DReadOnly)momentOfInertiaOne);
        rigidJointRotation.transform((Matrix3DBasics)rotatedMomentOfInertiaOne);
        linkOneA.setMomentOfInertia((Matrix3DReadOnly)rotatedMomentOfInertiaOne);
        Vector3D centerOfMassOffsetOne = new Vector3D(0.1, 0.2, 1.0);
        Vector3D rotatedCenterOfMassOffsetOne = new Vector3D((Tuple3DReadOnly)centerOfMassOffsetOne);
        rigidJointRotation.transform((Tuple3DBasics)rotatedCenterOfMassOffsetOne);
        linkOneA.setComOffset((Vector3DReadOnly)rotatedCenterOfMassOffsetOne);
        linkOneB.setComOffset((Vector3DReadOnly)centerOfMassOffsetOne);
        sliderJointA.setLink(linkOneA);
        sliderJointB.setLink(linkOneB);
        robotA.addRootJoint((Joint)sliderJointA);
        rigidJointB.addJoint((Joint)sliderJointB);
        robotB.addRootJoint((Joint)rigidJointB);
        sliderJointA.setQ(0.178);
        sliderJointB.setQ(0.178);
        sliderJointA.setQd(0.145);
        sliderJointB.setQd(0.145);
        robotA.update();
        robotB.update();
        robotA.doDynamicsButDoNotIntegrate();
        robotB.doDynamicsButDoNotIntegrate();
        this.checkRobotsHaveSameState(robotA, robotB);
        robotA.doDynamicsAndIntegrate(1.0E-4);
        robotB.doDynamicsAndIntegrate(1.0E-4);
        this.checkRobotsHaveSameState(robotA, robotB);
    }

    @Test
    public void testPinJointThenRigidJointThenSliderOne() throws UnreasonableAccelerationException {
        Vector3D rigidJointOffset = new Vector3D(0.0, 0.0, 0.0);
        RotationMatrix rigidJointRotation = new RotationMatrix();
        rigidJointRotation.setEuler(0.3, -0.55, 0.72);
        Vector3D centerOfMassOffsetOne = new Vector3D();
        Vector3D centerOfMassOffsetTwo = new Vector3D();
        Vector3D radiiOfGyrationOne = new Vector3D(0.25, 0.19, 0.6);
        Vector3D radiiOfGyrationTwo = new Vector3D(0.13, 0.14, 0.17);
        double qOne = 2.2;
        double qdOne = 10.145;
        double qTwo = 0.0;
        double qdTwo = 0.0;
        this.runTestWithPinThenRigidThenSliderJoints(rigidJointOffset, rigidJointRotation, centerOfMassOffsetOne, centerOfMassOffsetTwo, radiiOfGyrationOne, radiiOfGyrationTwo, qOne, qdOne, qTwo, qdTwo);
    }

    @Test
    public void testPinJointThenRigidJointThenSliderTwo() throws UnreasonableAccelerationException {
        Vector3D rigidJointOffset = new Vector3D(0.0, 0.0, 0.0);
        RotationMatrix rigidJointRotation = new RotationMatrix();
        Vector3D centerOfMassOffsetOne = new Vector3D();
        Vector3D centerOfMassOffsetTwo = new Vector3D(100.0, 0.0, 0.0);
        Vector3D radiiOfGyrationOne = new Vector3D(0.25, 0.19, 0.6);
        Vector3D radiiOfGyrationTwo = new Vector3D(0.13, 0.14, 0.17);
        double qOne = 0.0;
        double qdOne = 0.0;
        double qTwo = 0.0;
        double qdTwo = 0.0;
        this.runTestWithPinThenRigidThenSliderJoints(rigidJointOffset, rigidJointRotation, centerOfMassOffsetOne, centerOfMassOffsetTwo, radiiOfGyrationOne, radiiOfGyrationTwo, qOne, qdOne, qTwo, qdTwo);
    }

    @Test
    public void testPinJointThenRigidJointThenSliderThree() throws UnreasonableAccelerationException {
        Vector3D rigidJointOffset = new Vector3D();
        RotationMatrix rigidJointRotation = new RotationMatrix();
        Vector3D centerOfMassOffsetOne = new Vector3D();
        Vector3D centerOfMassOffsetTwo = new Vector3D();
        Vector3D radiiOfGyrationOne = new Vector3D(0.25, 0.19, 0.6);
        Vector3D radiiOfGyrationTwo = new Vector3D(0.13, 0.14, 0.17);
        double qOne = 0.0;
        double qdOne = 0.0;
        double qTwo = 100.0;
        double qdTwo = 0.0;
        this.runTestWithPinThenRigidThenSliderJoints(rigidJointOffset, rigidJointRotation, centerOfMassOffsetOne, centerOfMassOffsetTwo, radiiOfGyrationOne, radiiOfGyrationTwo, qOne, qdOne, qTwo, qdTwo);
    }

    @Test
    public void testPinJointThenRigidJointThenSliderFour() throws UnreasonableAccelerationException {
        Vector3D rigidJointOffset = new Vector3D(1.1, 2.2, 3.3);
        RotationMatrix rigidJointRotation = new RotationMatrix();
        rigidJointRotation.setEuler(0.3, -0.55, 0.72);
        Vector3D centerOfMassOffsetOne = new Vector3D(0.3, 0.7, 10.11);
        Vector3D centerOfMassOffsetTwo = new Vector3D(100.3, 0.7, 1.11);
        Vector3D radiiOfGyrationOne = new Vector3D(0.25, 0.19, 0.6);
        Vector3D radiiOfGyrationTwo = new Vector3D(0.13, 0.14, 0.17);
        double qOne = 1.378;
        double qdOne = 12.96;
        double qTwo = 109.0;
        double qdTwo = 20.45;
        this.runTestWithPinThenRigidThenSliderJoints(rigidJointOffset, rigidJointRotation, centerOfMassOffsetOne, centerOfMassOffsetTwo, radiiOfGyrationOne, radiiOfGyrationTwo, qOne, qdOne, qTwo, qdTwo);
    }

    private void runTestWithPinThenRigidThenSliderJoints(Vector3D rigidJointOffset, RotationMatrix rigidJointRotation, Vector3D centerOfMassOffsetOne, Vector3D centerOfMassOffsetTwo, Vector3D radiiOfGyrationOne, Vector3D radiiOfGyrationTwo, double qOne, double qdOne, double qTwo, double qdTwo) throws UnreasonableAccelerationException {
        Robot robotA = new Robot("RobotA");
        Robot robotB = new Robot("RobotB");
        PinJoint pinJointA = new PinJoint("pinA", (Tuple3DReadOnly)new Vector3D(), robotA, (Vector3DReadOnly)Axis3D.Y);
        PinJoint pinJointB = new PinJoint("pinB", (Tuple3DReadOnly)new Vector3D(), robotB, (Vector3DReadOnly)Axis3D.Y);
        Link linkOneA = new Link("linkOneA");
        Link linkOneB = new Link("linkOneB");
        double massOne = 1.0;
        linkOneA.setMassAndRadiiOfGyration(massOne, (Vector3DReadOnly)radiiOfGyrationOne);
        linkOneB.setMassAndRadiiOfGyration(massOne, (Vector3DReadOnly)radiiOfGyrationOne);
        linkOneA.setComOffset((Vector3DReadOnly)centerOfMassOffsetOne);
        linkOneB.setComOffset((Vector3DReadOnly)centerOfMassOffsetOne);
        pinJointA.setLink(linkOneA);
        pinJointB.setLink(linkOneB);
        Vector3D sliderAxis = new Vector3D(1.0, 0.0, 0.0);
        Vector3D rotatedSliderAxis = new Vector3D((Tuple3DReadOnly)sliderAxis);
        rigidJointRotation.transform((Tuple3DBasics)rotatedSliderAxis);
        SliderJoint sliderJointA = new SliderJoint("sliderA", (Tuple3DReadOnly)rigidJointOffset, robotA, (Vector3DReadOnly)rotatedSliderAxis);
        RigidJoint rigidJointB = new RigidJoint("rigidB", (Vector3DReadOnly)new Vector3D(), robotB);
        rigidJointB.setRigidRotation((RotationMatrixReadOnly)rigidJointRotation);
        rigidJointB.setRigidTranslation((Vector3DReadOnly)rigidJointOffset);
        Link rigidLinkB = new Link("rigidLinkB");
        rigidJointB.setLink(rigidLinkB);
        pinJointB.addJoint((Joint)rigidJointB);
        SliderJoint sliderJointB = new SliderJoint("sliderB", (Tuple3DReadOnly)new Vector3D(), robotB, (Vector3DReadOnly)sliderAxis);
        Link linkTwoA = new Link("linkTwoA");
        Link linkTwoB = new Link("linkTwoB");
        double massTwo = 1.15;
        linkTwoA.setMass(massTwo);
        linkTwoB.setMassAndRadiiOfGyration(massTwo, (Vector3DReadOnly)radiiOfGyrationTwo);
        Matrix3D momentOfInertiaTwo = new Matrix3D();
        linkTwoB.getMomentOfInertia((Matrix3DBasics)momentOfInertiaTwo);
        Matrix3D rotatedMomentOfInertiaTwo = new Matrix3D((Matrix3DReadOnly)momentOfInertiaTwo);
        rigidJointRotation.transform((Matrix3DBasics)rotatedMomentOfInertiaTwo);
        linkTwoA.setMomentOfInertia((Matrix3DReadOnly)rotatedMomentOfInertiaTwo);
        Vector3D rotatedCenterOfMassOffsetTwo = new Vector3D((Tuple3DReadOnly)centerOfMassOffsetTwo);
        rigidJointRotation.transform((Tuple3DBasics)rotatedCenterOfMassOffsetTwo);
        linkTwoA.setComOffset((Vector3DReadOnly)rotatedCenterOfMassOffsetTwo);
        linkTwoB.setComOffset((Vector3DReadOnly)centerOfMassOffsetTwo);
        sliderJointA.setLink(linkTwoA);
        sliderJointB.setLink(linkTwoB);
        pinJointA.addJoint((Joint)sliderJointA);
        rigidJointB.addJoint((Joint)sliderJointB);
        robotA.addRootJoint((Joint)pinJointA);
        robotB.addRootJoint((Joint)pinJointB);
        pinJointA.setQ(qOne);
        pinJointB.setQ(qOne);
        pinJointA.setQd(qdOne);
        pinJointB.setQd(qdOne);
        sliderJointA.setQ(qTwo);
        sliderJointB.setQ(qTwo);
        sliderJointA.setQd(qdTwo);
        sliderJointB.setQd(qdTwo);
        robotA.update();
        robotB.update();
        robotA.doDynamicsButDoNotIntegrate();
        robotB.doDynamicsButDoNotIntegrate();
        this.checkRobotsHaveSameState(robotA, robotB);
        robotA.doDynamicsAndIntegrate(1.0E-4);
        robotB.doDynamicsAndIntegrate(1.0E-4);
        this.checkRobotsHaveSameState(robotA, robotB);
    }

    private void checkRobotsHaveSameState(Robot robotA, Robot robotB) {
        Point3D centerOfMassA = new Point3D();
        Point3D centerOfMassB = new Point3D();
        double totalMassA = robotA.computeCenterOfMass((Point3DBasics)centerOfMassA);
        double totalMassB = robotB.computeCenterOfMass((Point3DBasics)centerOfMassB);
        Vector3D angularMomentumA = new Vector3D();
        Vector3D angularMomentumB = new Vector3D();
        robotA.computeAngularMomentum((Vector3DBasics)angularMomentumA);
        robotB.computeAngularMomentum((Vector3DBasics)angularMomentumB);
        Vector3D linearMomentumA = new Vector3D();
        Vector3D linearMomentumB = new Vector3D();
        robotA.computeLinearMomentum((Vector3DBasics)linearMomentumA);
        robotB.computeLinearMomentum((Vector3DBasics)linearMomentumB);
        Assert.assertEquals(totalMassA, totalMassB, 1.0E-7);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)centerOfMassA, (EuclidGeometry)centerOfMassB, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)linearMomentumA, (EuclidGeometry)linearMomentumB, (double)1.0E-10);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)angularMomentumA, (EuclidGeometry)angularMomentumB, (double)1.0E-9);
        List jointsA = robotA.getRootJoints();
        List jointsB = robotB.getRootJoints();
        this.recursivelyTestJointStateIsTheSame(jointsA, jointsB);
    }

    private void recursivelyTestJointStateIsTheSame(List<Joint> jointsA, List<Joint> jointsB) {
        int indexA = 0;
        int indexB = 0;
        while (jointsA.size() < indexA && jointsB.size() < indexB) {
            Joint jointA = jointsA.get(indexA);
            Joint jointB = jointsB.get(indexB);
            if (jointA instanceof RigidJoint) {
                ++indexA;
                continue;
            }
            if (jointB instanceof RigidJoint) {
                ++indexB;
                continue;
            }
            if (!(jointA instanceof OneDegreeOfFreedomJoint)) {
                throw new RuntimeException("Only testing OneDegreeOfFreedomJoints right now...");
            }
            OneDegreeOfFreedomJoint pinJointA = (OneDegreeOfFreedomJoint)jointA;
            OneDegreeOfFreedomJoint pinJointB = (OneDegreeOfFreedomJoint)jointB;
            Assert.assertEquals(pinJointA.getQ(), pinJointB.getQ(), 1.0E-10);
            Assert.assertEquals(pinJointA.getQD(), pinJointB.getQD(), 1.0E-10);
            Assert.assertEquals(pinJointA.getQDD(), pinJointB.getQDD(), 1.0E-10);
            List childrenJointsA = jointA.getChildrenJoints();
            List childrenJointsB = jointB.getChildrenJoints();
            this.recursivelyTestJointStateIsTheSame(childrenJointsA, childrenJointsB);
            ++indexA;
            ++indexB;
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(RigidJointPhysics.class, RigidJointTest.class);
    }
}

