/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.simulatedSensors;

import java.util.ArrayList;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.simulatedSensors.GroundContactPointBasedWrenchCalculator;
import us.ihmc.simulationconstructionset.simulatedSensors.WrenchCalculatorInterface;
import us.ihmc.yoVariables.registry.YoRegistry;

public class GroundContactPointBasedWrenchCalculatorTest {
    WrenchCalculatorInterface calculator;
    OneDegreeOfFreedomJoint joint;

    @Test
    public void testWrenchCalculation() {
        double epsilon = 1.0E-7;
        Robot robot = new Robot("testRobot");
        GroundContactPoint point0 = new GroundContactPoint("point0", (Tuple3DReadOnly)new Vector3D(), robot.getRobotsYoRegistry());
        GroundContactPoint point1 = new GroundContactPoint("point1", (Tuple3DReadOnly)new Vector3D(), robot.getRobotsYoRegistry());
        ArrayList<GroundContactPoint> contactPoints = new ArrayList<GroundContactPoint>();
        contactPoints.add(point0);
        contactPoints.add(point1);
        this.joint = new PinJoint("test", (Tuple3DReadOnly)new Vector3D(1.0, 0.0, 0.0), robot, (Vector3DReadOnly)Axis3D.X);
        robot.addRootJoint((Joint)this.joint);
        robot.update();
        this.calculator = new GroundContactPointBasedWrenchCalculator(this.joint.getName(), contactPoints, (Joint)this.joint, new RigidBodyTransform(), new YoRegistry("dummy1"));
        point0.setForce((Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0));
        point1.setForce((Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0));
        point0.getYoPosition().set((Tuple3DReadOnly)new Point3D(1.0, 1.0, 0.0));
        point1.getYoPosition().set((Tuple3DReadOnly)new Point3D(-1.0, 0.0, 0.0));
        this.calculator.calculate();
        DMatrixRMaj tauXFXAndFZ = this.calculator.getWrench();
        Assert.assertEquals(1.0, tauXFXAndFZ.get(0, 0), epsilon);
        Assert.assertEquals(0.0, tauXFXAndFZ.get(3, 0), epsilon);
        Assert.assertEquals(1.0, tauXFXAndFZ.get(5, 0), epsilon);
        PinJoint joint2 = new PinJoint("test2", (Tuple3DReadOnly)new Vector3D(-1.0, -1.0, 0.0), robot, (Vector3DReadOnly)Axis3D.X);
        robot.addRootJoint((Joint)joint2);
        robot.update();
        this.calculator = new GroundContactPointBasedWrenchCalculator(this.joint.getName(), contactPoints, (Joint)joint2, new RigidBodyTransform(), new YoRegistry("dummy2"));
        point0.setForce((Vector3DReadOnly)new Vector3D(-1.0, 1.0, 0.0));
        point1.setForce((Vector3DReadOnly)new Vector3D(-1.0, 1.0, 0.0));
        point0.getYoPosition().set((Tuple3DReadOnly)new Point3D(0.0, 0.0, 1.0));
        point1.getYoPosition().set((Tuple3DReadOnly)new Point3D(-2.0, -2.0, 1.0));
        this.calculator.calculate();
        DMatrixRMaj wholeWrench = this.calculator.getWrench();
        Assert.assertTrue(wholeWrench.getNumRows() == 6);
        Assert.assertEquals(wholeWrench.get(0, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(1, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(2, 0), 0.0, epsilon);
        Assert.assertEquals(wholeWrench.get(3, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(4, 0), 2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(5, 0), 0.0, epsilon);
        PinJoint joint3 = new PinJoint("test3", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), robot, (Vector3DReadOnly)Axis3D.X);
        robot.addRootJoint((Joint)joint3);
        robot.update();
        RigidBodyTransform transformToJoint = new RigidBodyTransform();
        transformToJoint.getTranslation().set((Tuple3DReadOnly)new Vector3D(-1.0, -1.0, 0.0));
        this.calculator = new GroundContactPointBasedWrenchCalculator(this.joint.getName(), contactPoints, (Joint)joint3, transformToJoint, new YoRegistry("dummy3"));
        this.calculator.calculate();
        wholeWrench = this.calculator.getWrench();
        Assert.assertTrue(wholeWrench.getNumRows() == 6);
        Assert.assertEquals(wholeWrench.get(0, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(1, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(2, 0), 0.0, epsilon);
        Assert.assertEquals(wholeWrench.get(3, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(4, 0), 2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(5, 0), 0.0, epsilon);
        joint3.setQ(Math.PI);
        robot.update();
        this.calculator.calculate();
        wholeWrench = this.calculator.getWrench();
        Assert.assertTrue(wholeWrench.getNumRows() == 6);
        Assert.assertEquals(wholeWrench.get(0, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(1, 0), 2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(2, 0), 4.0, epsilon);
        Assert.assertEquals(wholeWrench.get(3, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(4, 0), -2.0, epsilon);
        Assert.assertEquals(wholeWrench.get(5, 0), 0.0, epsilon);
    }
}

