/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.robotDescription.InertiaTools;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;

public class LinkTest {
    private static SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();

    @Test
    public void testLinkInertia() {
        boolean visualize = false;
        Robot robot = new Robot("linkTest");
        FloatingJoint rootJoint = new FloatingJoint("root", (Tuple3DReadOnly)new Vector3D(), robot);
        Link link = new Link("testLink");
        double mass = 1.7;
        link.setMass(mass);
        Matrix3D momentOfInertia = new Matrix3D();
        momentOfInertia.setM00(0.1);
        momentOfInertia.setM11(0.1);
        momentOfInertia.setM22(0.001);
        Vector3D rotationAxis = new Vector3D(0.0, 0.0, 1.0);
        RotationMatrix rotation = new RotationMatrix();
        rotation.setToPitchOrientation(1.0471975511965976);
        momentOfInertia = InertiaTools.rotate((RotationMatrix)rotation, (Matrix3D)momentOfInertia);
        rotation.transform((Tuple3DBasics)rotationAxis);
        rotation = new RotationMatrix();
        rotation.setToYawOrientation(0.6283185307179586);
        momentOfInertia = InertiaTools.rotate((RotationMatrix)rotation, (Matrix3D)momentOfInertia);
        rotation.transform((Tuple3DBasics)rotationAxis);
        link.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia);
        link.addEllipsoidFromMassProperties(YoAppearance.Gold());
        link.addEllipsoidFromMassProperties2(YoAppearance.Green());
        link.addCoordinateSystemToCOM(1.0);
        rootJoint.setLink(link);
        robot.addRootJoint((Joint)rootJoint);
        robot.setGravity(0.0);
        rootJoint.setAngularVelocityInBody((Vector3DReadOnly)rotationAxis);
        if (visualize) {
            SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
            scs.startOnAThread();
            scs.setSimulateDuration(1.0);
            scs.simulate();
            ThreadTools.sleepForever();
        }
    }
}

