/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.examples.FallingBrickRobot;
import us.ihmc.simulationconstructionset.gui.SimulationGUITestFixture;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;

@Tag(value="gui")
public class SimulationConstructionSetFestTest {
    private static SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();

    private boolean isGradleBuild() {
        String property = System.getProperty("bamboo.gradle");
        return property != null && property.contains("yes");
    }

    @Disabled
    @Test
    public void testSimulationConstructionSetUsingGUITestFixture() {
        int i;
        FallingBrickRobot robot = new FallingBrickRobot();
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)robot, parameters);
        YoRegistry registryOne = new YoRegistry("RegistryOne");
        YoEnum enumForTests = new YoEnum("enumForTests", registryOne, Axis3D.class);
        YoRegistry registryTwo = new YoRegistry("RegistryTwo");
        YoBoolean booleanForTests = new YoBoolean("booleanForTests", registryTwo);
        registryOne.addChild(registryTwo);
        scs.addYoRegistry(registryOne);
        scs.setFrameMaximized();
        scs.startOnAThread();
        scs.setSimulateDuration(2.0);
        SimulationGUITestFixture testFixture = new SimulationGUITestFixture(scs);
        testFixture.removeAllGraphs();
        testFixture.removeAllEntryBoxes();
        testFixture.selectNamespaceTab();
        testFixture.selectNamespace("root/RegistryOne");
        testFixture.selectVariableInOpenTab("enumForTests");
        ThreadTools.sleep((long)500L);
        testFixture.selectNamespaceTab();
        testFixture.selectNamespace("root/RegistryOne/RegistryTwo");
        testFixture.selectVariableInOpenTab("booleanForTests");
        ThreadTools.sleep((long)500L);
        testFixture.clickOnAddNumericEntryBox();
        testFixture.clickOnUnusedEntryBox();
        Assert.assertTrue(!booleanForTests.getBooleanValue());
        testFixture.findEntryBoxAndEnterValue("booleanForTests", 1.0);
        Assert.assertTrue(booleanForTests.getBooleanValue());
        testFixture.selectSearchTab();
        testFixture.enterSearchText("q_");
        testFixture.selectVariableInSearchTab("q_y");
        testFixture.clickNewGraphButton();
        testFixture.middleClickInEmptyGraph();
        testFixture.selectVariableInSearchTab("q_z");
        testFixture.clickNewGraphButton();
        testFixture.middleClickInEmptyGraph();
        testFixture.removeAllGraphs();
        enumForTests.set((Enum)Axis3D.X);
        testFixture.selectSearchTab();
        testFixture.deleteSearchText();
        testFixture.enterSearchText("enumForTests");
        testFixture.selectVariableInSearchTab("enumForTests");
        testFixture.clickOnAddNumericEntryBox();
        testFixture.clickOnUnusedEntryBox();
        Assert.assertTrue(enumForTests.getEnumValue() == Axis3D.X);
        testFixture.findEnumEntryBoxAndSelectValue("enumForTests", "Z");
        Assert.assertTrue(enumForTests.getEnumValue() == Axis3D.Z);
        testFixture.selectSearchTab();
        testFixture.deleteSearchText();
        testFixture.enterSearchText("q_");
        testFixture.selectVariableInSearchTab("q_x");
        testFixture.clickRemoveEmptyGraphButton();
        testFixture.clickNewGraphButton();
        testFixture.middleClickInEmptyGraph();
        testFixture.clickNewGraphButton();
        testFixture.clickNewGraphButton();
        testFixture.selectVariableInSearchTab("q_y");
        testFixture.middleClickInNthGraph(2);
        ThreadTools.sleep((long)500L);
        testFixture.selectVariableInSearchTab("q_z");
        testFixture.middleClickInNthGraph(2);
        testFixture.selectVariableAndSetValueInSearchTab("q_z", 1.31);
        YoDouble q_z = (YoDouble)scs.findVariable("q_z");
        Assert.assertEquals(1.31, q_z.getDoubleValue(), 1.0E-9);
        ThreadTools.sleep((long)500L);
        testFixture.clickSimulateButton();
        ThreadTools.sleep((long)500L);
        testFixture.clickStopButton();
        ThreadTools.sleep((long)500L);
        testFixture.clickPlayButton();
        ThreadTools.sleep((long)500L);
        testFixture.clickStopButton();
        ThreadTools.sleep((long)500L);
        testFixture.removeVariableFromNthGraph("q_y", 2);
        testFixture.clickRemoveEmptyGraphButton();
        testFixture.clickGotoInPointButton();
        ThreadTools.sleep((long)100L);
        int index = scs.getCurrentIndex();
        int inPoint = scs.getInPoint();
        Assert.assertEquals(index, inPoint);
        int stepsForward = 4;
        for (i = 0; i < stepsForward; ++i) {
            testFixture.clickStepForwardButton();
        }
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(stepsForward, index);
        testFixture.clickAddKeyPointButton();
        for (i = 0; i < stepsForward; ++i) {
            testFixture.clickStepForwardButton();
        }
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(2 * stepsForward, index);
        testFixture.clickAddKeyPointButton();
        for (i = 0; i < stepsForward; ++i) {
            testFixture.clickStepForwardButton();
        }
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(3 * stepsForward, index);
        testFixture.clickAddKeyPointButton();
        testFixture.clickZoomInButton();
        testFixture.clickZoomInButton();
        testFixture.clickZoomInButton();
        testFixture.clickZoomInButton();
        testFixture.clickZoomOutButton();
        testFixture.clickGotoInPointButton();
        testFixture.clickToggleKeyModeButton();
        testFixture.clickStepForwardButton();
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(stepsForward, index);
        testFixture.clickStepForwardButton();
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(2 * stepsForward, index);
        testFixture.clickAddKeyPointButton();
        testFixture.clickStepBackwardButton();
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(stepsForward, index);
        testFixture.clickSetInPointButton();
        testFixture.clickStepForwardButton();
        testFixture.clickSetOutPointButton();
        testFixture.clickGotoInPointButton();
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(stepsForward, index);
        testFixture.clickGotoOutPointButton();
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(3 * stepsForward, index);
        testFixture.clickGotoInPointButton();
        testFixture.clickToggleKeyModeButton();
        testFixture.clickStepForwardButton();
        ThreadTools.sleep((long)100L);
        index = scs.getCurrentIndex();
        Assert.assertEquals(stepsForward + 1, index);
        testFixture.closeAndDispose();
        scs.closeAndDispose();
        scs = null;
        testFixture = null;
    }

    @Disabled
    @Test
    public void testSimulationConstructionSetNewGraphWindowUsingGUITestFixture() {
        FallingBrickRobot robot = new FallingBrickRobot();
        robot.initialize();
        SimulationConstructionSet scs = new SimulationConstructionSet((Robot)robot, parameters);
        scs.setDT(1.0E-4, 100);
        scs.startOnAThread();
        SimulationGUITestFixture testFixture = new SimulationGUITestFixture(scs);
        testFixture.clickNewGraphButton();
        testFixture.focusMainSCSWindow();
        testFixture.selectSearchTab();
        testFixture.deleteSearchText();
        testFixture.enterSearchText("t");
        testFixture.selectVariableInSearchTab("t");
        testFixture.middleClickInEmptyGraph();
        testFixture.clickSimulateButton();
        ThreadTools.sleep((long)200L);
        testFixture.clickStopButton();
        testFixture.selectNewGraphWindowMenu();
        testFixture.selectNewGraphWindowMenu();
        testFixture.focusNthGraphArrayWindow(0);
        testFixture.clickNewGraphButton();
        testFixture.focusMainSCSWindow();
        testFixture.selectSearchTab();
        testFixture.deleteSearchText();
        testFixture.enterSearchText("q_");
        testFixture.selectVariableInSearchTab("q_z");
        testFixture.focusNthGraphArrayWindow(0);
        testFixture.middleClickInEmptyGraph();
        testFixture.focusMainSCSWindow();
        testFixture.selectSearchTab();
        testFixture.deleteSearchText();
        testFixture.enterSearchText("q_");
        testFixture.selectVariableInSearchTab("q_y");
        testFixture.focusNthGraphArrayWindow(1);
        testFixture.clickNewGraphButton();
        testFixture.middleClickInEmptyGraph();
        testFixture.closeAndDispose();
        scs.closeAndDispose();
        scs = null;
        testFixture = null;
    }
}

