/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.actions;

import com.google.common.base.Defaults;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraPropertiesHolder;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.ExtraPanelConfiguration;
import us.ihmc.simulationconstructionset.GotoInPointCommandExecutor;
import us.ihmc.simulationconstructionset.GotoOutPointCommandExecutor;
import us.ihmc.simulationconstructionset.commands.AddCameraKeyCommandExecutor;
import us.ihmc.simulationconstructionset.commands.AddKeyPointCommandExecutor;
import us.ihmc.simulationconstructionset.commands.CreateNewGraphWindowCommandExecutor;
import us.ihmc.simulationconstructionset.commands.CreateNewViewportWindowCommandExecutor;
import us.ihmc.simulationconstructionset.commands.CropBufferCommandExecutor;
import us.ihmc.simulationconstructionset.commands.CutBufferCommandExecutor;
import us.ihmc.simulationconstructionset.commands.NextCameraKeyCommandExecutor;
import us.ihmc.simulationconstructionset.commands.PackBufferCommandExecutor;
import us.ihmc.simulationconstructionset.commands.PlayCommandExecutor;
import us.ihmc.simulationconstructionset.commands.PreviousCameraKeyCommandExecutor;
import us.ihmc.simulationconstructionset.commands.RemoveCameraKeyCommandExecutor;
import us.ihmc.simulationconstructionset.commands.SelectGUIConfigFromFileCommandExecutor;
import us.ihmc.simulationconstructionset.commands.SelectGraphConfigurationCommandExecutor;
import us.ihmc.simulationconstructionset.commands.SetInPointCommandExecutor;
import us.ihmc.simulationconstructionset.commands.SetOutPointCommandExecutor;
import us.ihmc.simulationconstructionset.commands.SimulateCommandExecutor;
import us.ihmc.simulationconstructionset.commands.StepBackwardCommandExecutor;
import us.ihmc.simulationconstructionset.commands.StepForwardCommandExecutor;
import us.ihmc.simulationconstructionset.commands.StopCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ThinBufferCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ToggleCameraKeyModeCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandExecutor;
import us.ihmc.simulationconstructionset.commands.ViewportSelectorCommandListener;
import us.ihmc.simulationconstructionset.commands.ZoomGraphCommandExecutor;
import us.ihmc.simulationconstructionset.gui.ActiveCameraHolder;
import us.ihmc.simulationconstructionset.gui.DollyCheckBox;
import us.ihmc.simulationconstructionset.gui.TrackCheckBox;
import us.ihmc.simulationconstructionset.gui.actions.AddCameraKeyAction;
import us.ihmc.simulationconstructionset.gui.actions.AddKeyPointAction;
import us.ihmc.simulationconstructionset.gui.actions.CreateNewGraphWindowAction;
import us.ihmc.simulationconstructionset.gui.actions.CreateNewViewportWindowAction;
import us.ihmc.simulationconstructionset.gui.actions.CropBufferAction;
import us.ihmc.simulationconstructionset.gui.actions.CutBufferAction;
import us.ihmc.simulationconstructionset.gui.actions.GotoInPointAction;
import us.ihmc.simulationconstructionset.gui.actions.GotoOutPointAction;
import us.ihmc.simulationconstructionset.gui.actions.HideShowViewportAction;
import us.ihmc.simulationconstructionset.gui.actions.NextCameraKeyAction;
import us.ihmc.simulationconstructionset.gui.actions.PackBufferAction;
import us.ihmc.simulationconstructionset.gui.actions.PlayAction;
import us.ihmc.simulationconstructionset.gui.actions.PreviousCameraKeyAction;
import us.ihmc.simulationconstructionset.gui.actions.RemoveCameraKeyAction;
import us.ihmc.simulationconstructionset.gui.actions.SelectCameraAction;
import us.ihmc.simulationconstructionset.gui.actions.SelectGUIConfigFromFileAction;
import us.ihmc.simulationconstructionset.gui.actions.SetInPointAction;
import us.ihmc.simulationconstructionset.gui.actions.SetOutPointAction;
import us.ihmc.simulationconstructionset.gui.actions.SimulateAction;
import us.ihmc.simulationconstructionset.gui.actions.StepBackwardAction;
import us.ihmc.simulationconstructionset.gui.actions.StepForwardAction;
import us.ihmc.simulationconstructionset.gui.actions.StopAction;
import us.ihmc.simulationconstructionset.gui.actions.ThinBufferAction;
import us.ihmc.simulationconstructionset.gui.actions.ToggleCameraKeyModeAction;
import us.ihmc.simulationconstructionset.gui.actions.ToggleKeyPointModeAction;
import us.ihmc.simulationconstructionset.gui.actions.ZoomInAction;
import us.ihmc.simulationconstructionset.gui.actions.ZoomOutAction;
import us.ihmc.simulationconstructionset.gui.actions.configActions.SelectGraphConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.configActions.SelectGraphGroupAction;
import us.ihmc.simulationconstructionset.gui.actions.configActions.SelectVarGroupAction;
import us.ihmc.simulationconstructionset.gui.actions.configActions.SelectViewportAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.AboutAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.CameraPropertiesAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.DataBufferPropertiesAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ExportDataAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ExportSimulationTo3DMaxAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ExportSnapshotAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ImportDataAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.LoadConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.LoadGraphGroupAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.LoadRobotConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.MediaCaptureAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.PlaybackPropertiesAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.PrintGraphsAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.ResizeViewportAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SaveConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SaveGraphConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SaveRobotConfigurationAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SelectEntryBoxGroupAction;
import us.ihmc.simulationconstructionset.gui.actions.dialogActions.SelectExtraPanelAction;
import us.ihmc.simulationconstructionset.gui.camera.AbstractCameraPropertiesHolder;
import us.ihmc.simulationconstructionset.gui.config.CameraSelector;
import us.ihmc.simulationconstructionset.gui.config.EntryBoxGroupSelector;
import us.ihmc.simulationconstructionset.gui.config.ExtraPanelSelector;
import us.ihmc.simulationconstructionset.gui.config.GraphGroupSelector;
import us.ihmc.simulationconstructionset.gui.config.VarGroupSelector;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.AboutDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.CameraPropertiesDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.DataBufferPropertiesDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportDataDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportSimulationTo3DMaxDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ExportSnapshotDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ImportDataDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadGraphGroupDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.LoadRobotConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.MediaCaptureDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.PlaybackPropertiesDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.PrintGraphsDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.ResizeViewportDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveGraphConfigurationDialogConstructor;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.SaveRobotConfigurationDialogConstructor;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsChangedListener;
import us.ihmc.yoVariables.buffer.interfaces.KeyPointsHolder;

public class ActionsTest {
    private static final Map<Class<?>, Class<?>> SIMPLE_ACTIONS = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(AboutDialogConstructor.class, AboutAction.class);
            this.put(AddCameraKeyCommandExecutor.class, AddCameraKeyAction.class);
            this.put(AddKeyPointCommandExecutor.class, AddKeyPointAction.class);
            this.put(CropBufferCommandExecutor.class, CropBufferAction.class);
            this.put(CutBufferCommandExecutor.class, CutBufferAction.class);
            this.put(GotoInPointCommandExecutor.class, GotoInPointAction.class);
            this.put(GotoOutPointCommandExecutor.class, GotoOutPointAction.class);
            this.put(NextCameraKeyCommandExecutor.class, NextCameraKeyAction.class);
            this.put(PackBufferCommandExecutor.class, PackBufferAction.class);
            this.put(PlayCommandExecutor.class, PlayAction.class);
            this.put(PreviousCameraKeyCommandExecutor.class, PreviousCameraKeyAction.class);
            this.put(RemoveCameraKeyCommandExecutor.class, RemoveCameraKeyAction.class);
            this.put(SetInPointCommandExecutor.class, SetInPointAction.class);
            this.put(SetOutPointCommandExecutor.class, SetOutPointAction.class);
            this.put(StepBackwardCommandExecutor.class, StepBackwardAction.class);
            this.put(StepForwardCommandExecutor.class, StepForwardAction.class);
            this.put(StopCommandExecutor.class, StopAction.class);
            this.put(ToggleCameraKeyModeCommandExecutor.class, ToggleCameraKeyModeAction.class);
            this.put(DataBufferPropertiesDialogConstructor.class, DataBufferPropertiesAction.class);
            this.put(ExportDataDialogConstructor.class, ExportDataAction.class);
            this.put(ExportSimulationTo3DMaxDialogConstructor.class, ExportSimulationTo3DMaxAction.class);
            this.put(ExportSnapshotDialogConstructor.class, ExportSnapshotAction.class);
            this.put(ImportDataDialogConstructor.class, ImportDataAction.class);
            this.put(LoadConfigurationDialogConstructor.class, LoadConfigurationAction.class);
            this.put(LoadGraphGroupDialogConstructor.class, LoadGraphGroupAction.class);
            this.put(LoadRobotConfigurationDialogConstructor.class, LoadRobotConfigurationAction.class);
            this.put(MediaCaptureDialogConstructor.class, MediaCaptureAction.class);
            this.put(PlaybackPropertiesDialogConstructor.class, PlaybackPropertiesAction.class);
            this.put(PrintGraphsDialogConstructor.class, PrintGraphsAction.class);
            this.put(ResizeViewportDialogConstructor.class, ResizeViewportAction.class);
            this.put(SaveConfigurationDialogConstructor.class, SaveConfigurationAction.class);
            this.put(SaveGraphConfigurationDialogConstructor.class, SaveGraphConfigurationAction.class);
            this.put(SaveRobotConfigurationDialogConstructor.class, SaveRobotConfigurationAction.class);
        }
    };
    private static Comparator<Method> DISPOSE_LAST = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            String n1 = o1.getName().toLowerCase();
            String n2 = o2.getName().toLowerCase();
            if (n1.contains("dispose") || n1.contains("close")) {
                return 1;
            }
            if (n2.contains("dispose") || n2.contains("close")) {
                return -1;
            }
            return n1.compareTo(n2);
        }
    };

    @Test
    public void testSimpleActions() {
        for (Map.Entry<Class<?>, Class<?>> actionToTest : SIMPLE_ACTIONS.entrySet()) {
            ActionsTest.testActionCallingAllInterfaceMethods(actionToTest.getKey(), actionToTest.getValue());
        }
    }

    @Test
    public void testCreateNewGraphWindowAction() {
        ActionsTest.createMethodTesterForInterface(CreateNewGraphWindowCommandExecutor.class).testWithMock(new TestWithMock<CreateNewGraphWindowCommandExecutor>(){

            @Override
            public void test(CreateNewGraphWindowCommandExecutor mock) {
                new CreateNewGraphWindowAction(mock).actionPerformed(null);
            }
        }).assertMethodCalled("createNewGraphWindow", new Class[0]).assertMethodNotCalled("createNewGraphWindow", String.class).assertMethodNotCalled("createNewGraphWindow", String.class, Integer.TYPE, Point.class, Dimension.class, Boolean.TYPE).assertMethodNotCalled("getGraphArrayWindow", String.class);
    }

    @Test
    public void testCreateNewViewportWindowAction() {
        ActionsTest.createMethodTesterForInterface(CreateNewViewportWindowCommandExecutor.class).testWithMock(new TestWithMock<CreateNewViewportWindowCommandExecutor>(){

            @Override
            public void test(CreateNewViewportWindowCommandExecutor mock) {
                new CreateNewViewportWindowAction(mock).actionPerformed(null);
            }
        }).assertMethodCalled("createNewViewportWindow", new Class[0]).assertMethodNotCalled("createNewViewportWindow", String.class, Integer.TYPE, Boolean.TYPE).assertMethodNotCalled("createNewViewportWindow", String.class).assertMethodNotCalled("getViewportWindow", String.class);
    }

    @Test
    public void testHideShowViewportAction() {
        final ViewportSelectorCommandExecutor dummyExecutor = new ViewportSelectorCommandExecutor(){
            boolean visible = true;

            public void selectViewport(String name) {
            }

            public void hideViewport() {
                this.visible = false;
            }

            public void showViewport() {
                this.visible = true;
            }

            public boolean isViewportHidden() {
                return !this.visible;
            }

            public void registerViewportSelectorCommandListener(ViewportSelectorCommandListener commandListener) {
            }

            public void closeAndDispose() {
            }
        };
        ActionsTest.createMethodTesterForInterface(ViewportSelectorCommandExecutor.class, dummyExecutor).testWithMock((TestWithMock<4>)new TestWithMock<ViewportSelectorCommandExecutor>(){

            @Override
            public void test(ViewportSelectorCommandExecutor mock) {
                HideShowViewportAction action = new HideShowViewportAction(mock);
                Assert.assertFalse(dummyExecutor.isViewportHidden());
                action.actionPerformed(null);
                action.updateViewportStatus();
                Assert.assertTrue(dummyExecutor.isViewportHidden());
                Assert.assertTrue("Show Viewport".equals(action.getValue("Name")));
                action.actionPerformed(null);
                action.updateViewportStatus();
                Assert.assertTrue("Hide Viewport".equals(action.getValue("Name")));
                Assert.assertFalse(dummyExecutor.isViewportHidden());
                action.closeAndDispose();
            }
        }).assertMethodsCalledInOrder(new MethodInvocation("hideViewport", new Object[0]), new MethodInvocation("showViewport", new Object[0]), new MethodInvocation("closeAndDispose", new Object[0]));
    }

    @Test
    public void testSimulateAction() {
        ActionsTest.createMethodTesterForInterface(SimulateCommandExecutor.class).testWithMock(new TestWithMock<SimulateCommandExecutor>(){

            @Override
            public void test(SimulateCommandExecutor mock) {
                new SimulateAction(mock).actionPerformed(null);
            }
        }).assertMethodCalled("simulate", new Class[0]);
    }

    @Test
    public void testToggleKeyPointModeAction() {
        final ToggleKeyPointModeAction[] actionHolder = new ToggleKeyPointModeAction[1];
        final KeyPointsHolder dummyExecutor = new KeyPointsHolder(){
            boolean toggled = false;

            public boolean areKeyPointsEnabled() {
                return this.toggled;
            }

            public void toggleKeyPoints() {
                this.toggled = !this.toggled;
            }

            public void addListener(KeyPointsChangedListener listener) {
            }
        };
        ActionsTest.createMethodTesterForInterface(KeyPointsHolder.class, dummyExecutor).testWithMock((TestWithMock<7>)new TestWithMock<KeyPointsHolder>(){

            @Override
            public void test(KeyPointsHolder executor) {
                ToggleKeyPointModeAction action = new ToggleKeyPointModeAction(executor);
                Assert.assertFalse(dummyExecutor.areKeyPointsEnabled());
                action.actionPerformed(null);
                action.changed(new KeyPointsChangedListener.Change(){

                    public boolean wasToggled() {
                        return true;
                    }

                    public boolean areKeyPointsEnabled() {
                        return false;
                    }

                    public List<Integer> getRemovedKeyPoints() {
                        return null;
                    }

                    public List<Integer> getAddedKeyPoints() {
                        return null;
                    }
                });
                Assert.assertTrue(dummyExecutor.areKeyPointsEnabled());
                action.actionPerformed(null);
                action.changed(new KeyPointsChangedListener.Change(){

                    public boolean wasToggled() {
                        return true;
                    }

                    public boolean areKeyPointsEnabled() {
                        return false;
                    }

                    public List<Integer> getRemovedKeyPoints() {
                        return null;
                    }

                    public List<Integer> getAddedKeyPoints() {
                        return null;
                    }
                });
                Assert.assertFalse(dummyExecutor.areKeyPointsEnabled());
                action.closeAndDispose();
                actionHolder[0] = action;
            }
        }).assertMethodsCalledInOrder(new MethodInvocation("addListener", actionHolder[0]), new MethodInvocation("toggleKeyPoints", new Object[0]), new MethodInvocation("toggleKeyPoints", new Object[0]));
    }

    @Test
    public void testZoomInAction() {
        ActionsTest.createMethodTesterForInterface(ZoomGraphCommandExecutor.class).testWithMock(new TestWithMock<ZoomGraphCommandExecutor>(){

            @Override
            public void test(ZoomGraphCommandExecutor mock) {
                ActionsTest.callPublicMethods(new ZoomInAction(mock));
            }
        }).assertMethodCalled("zoomIn", new Class[0]).assertMethodNotCalled("zoomOut", new Class[0]);
    }

    @Test
    public void testZoomOutAction() {
        ActionsTest.createMethodTesterForInterface(ZoomGraphCommandExecutor.class).testWithMock(new TestWithMock<ZoomGraphCommandExecutor>(){

            @Override
            public void test(ZoomGraphCommandExecutor mock) {
                ActionsTest.callPublicMethods(new ZoomOutAction(mock));
            }
        }).assertMethodCalled("zoomOut", new Class[0]).assertMethodNotCalled("zoomIn", new Class[0]);
    }

    @Test
    public void testSelectGraphConfigurationAction() {
        ActionsTest.createMethodTesterForInterface(SelectGraphConfigurationCommandExecutor.class).testWithMock(new TestWithMock<SelectGraphConfigurationCommandExecutor>(){

            @Override
            public void test(SelectGraphConfigurationCommandExecutor mock) {
                new SelectGraphConfigurationAction(mock, "Test").actionPerformed(null);
            }
        }).assertMethodCalled("selectGraphConfiguration", "Test");
    }

    @Test
    public void testSelectGraphGroupAction() {
        ActionsTest.createMethodTesterForInterface(GraphGroupSelector.class).testWithMock(new TestWithMock<GraphGroupSelector>(){

            @Override
            public void test(GraphGroupSelector mock) {
                new SelectGraphGroupAction(mock, "Test").actionPerformed(null);
            }
        }).assertMethodCalled("selectGraphGroup", "Test");
    }

    @Test
    public void testSelectVarGroupAction() {
        ActionsTest.createMethodTesterForInterface(VarGroupSelector.class).testWithMock(new TestWithMock<VarGroupSelector>(){

            @Override
            public void test(VarGroupSelector mock) {
                ActionsTest.callPublicMethods(new SelectVarGroupAction(mock, "Test"));
            }
        }).assertMethodCalled("selectVarGroup", "Test");
    }

    @Test
    public void testSelectViewportAction() {
        ActionsTest.createMethodTesterForInterface(ViewportSelectorCommandExecutor.class).testWithMock(new TestWithMock<ViewportSelectorCommandExecutor>(){

            @Override
            public void test(ViewportSelectorCommandExecutor mock) {
                ActionsTest.callPublicMethods(new SelectViewportAction(mock, "Test"));
            }
        }).assertMethodCalled("selectViewport", "Test");
    }

    @Disabled
    @Test
    public void testCameraPropertiesAction() {
        ActiveCameraHolder holder = new ActiveCameraHolder(){

            public CameraPropertiesHolder getCameraPropertiesForActiveCamera() {
                return new AbstractCameraPropertiesHolder();
            }
        };
        final TrackCheckBox originalTrackCheckBox = new TrackCheckBox(holder);
        final DollyCheckBox originalDollyCheckBox = new DollyCheckBox(holder);
        ActionsTest.createMethodTesterForInterface(CameraPropertiesDialogConstructor.class).testWithMock(new TestWithMock<CameraPropertiesDialogConstructor>(){

            @Override
            public void test(CameraPropertiesDialogConstructor mock) {
                ActionsTest.callPublicMethods(new CameraPropertiesAction(mock, originalTrackCheckBox, originalDollyCheckBox));
            }
        }).assertAllInterfaceMethodsCalled();
    }

    @Test
    public void testSelectEntryBoxGroupAction() {
        ActionsTest.createMethodTesterForInterface(EntryBoxGroupSelector.class).testWithMock(new TestWithMock<EntryBoxGroupSelector>(){

            @Override
            public void test(EntryBoxGroupSelector mock) {
                ActionsTest.callPublicMethods(new SelectEntryBoxGroupAction(mock, "Test"));
            }
        }).assertMethodCalled("selectEntryBoxGroup", "Test").assertAllInterfaceMethodsCalled();
    }

    @Disabled
    @Test
    public void testSelectExtraPanelAction() {
        ActionsTest.createMethodTesterForInterface(ExtraPanelSelector.class).testWithMock(new TestWithMock<ExtraPanelSelector>(){

            @Override
            public void test(ExtraPanelSelector mock) {
                ActionsTest.callPublicMethods(new SelectExtraPanelAction(mock, new ExtraPanelConfiguration("Test", (Component)new JPanel(), false)));
            }
        }).assertMethodCalled("selectPanel", "Test").assertAllInterfaceMethodsCalled();
    }

    @Test
    public void testThinBufferAction() {
        ActionsTest.testActionCallingAllInterfaceMethods(ThinBufferCommandExecutor.class, ThinBufferAction.class);
    }

    @Test
    public void testSelectCameraAction() {
        ActionsTest.createMethodTesterForInterface(CameraSelector.class).testWithMock(new TestWithMock<CameraSelector>(){

            @Override
            public void test(CameraSelector mock) {
                new SelectCameraAction(mock, "Test").actionPerformed(null);
            }
        }).assertMethodCalled("selectCamera", "Test");
    }

    @Test
    public void testSelectGUIConfigFromFileAction() {
        String testPath = "TestPath";
        ActionsTest.createMethodTesterForInterface(SelectGUIConfigFromFileCommandExecutor.class).testWithMock(new TestWithMock<SelectGUIConfigFromFileCommandExecutor>(){

            @Override
            public void test(SelectGUIConfigFromFileCommandExecutor mock) {
                new SelectGUIConfigFromFileAction("TestPath", "Test", mock).actionPerformed(null);
            }
        }).assertMethodCalled("selectGUIConfigFromFile", "TestPath");
    }

    private static <Interface, Action> void testActionCallingAllInterfaceMethods(final Class<Interface> iface, final Class<Action> actionClass) {
        ActionsTest.createMethodTesterForInterface(iface).testWithMock(new TestWithMock<Interface>(){

            @Override
            public void test(Interface mock) {
                try {
                    Object action = actionClass.getConstructor(iface).newInstance(mock);
                    ActionsTest.callPublicMethodsInOrder(action, DISPOSE_LAST);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.assertTrue(e.getMessage(), false);
                }
            }
        }).assertAllInterfaceMethodsCalled();
    }

    private static List<MethodInvocation> callPublicMethods(Object object) {
        return ActionsTest.callPublicMethodsInOrder(object, DISPOSE_LAST);
    }

    private static List<MethodInvocation> callPublicMethodsInOrder(Object object, Comparator<Method> comparator) {
        try {
            ArrayList<MethodInvocation> invocations = new ArrayList<MethodInvocation>();
            Method[] methods = object.getClass().getDeclaredMethods();
            if (comparator != null) {
                Arrays.sort(methods, comparator);
            }
            for (Method method : methods) {
                if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
                Object[] params = new Object[method.getParameterTypes().length];
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    params[i] = ActionsTest.instantiateType(method.getParameterTypes()[i]);
                }
                method.invoke(object, params);
                invocations.add(new MethodInvocation(method.getName(), params));
            }
            return invocations;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("Error calling public methods on object " + object + " (" + object.getClass().getSimpleName() + ")", false);
            return new ArrayList<MethodInvocation>();
        }
    }

    private static Object instantiateType(Class<?> type) throws Exception {
        if (type.isPrimitive()) {
            return Defaults.defaultValue(type);
        }
        if (type == File.class) {
            return new File(".");
        }
        if (type == Void.class) {
            return null;
        }
        if (type.isArray()) {
            return Array.newInstance(type, 0);
        }
        if (type.isInterface()) {
            return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return null;
                }
            });
        }
        Constructor<?> constructor = type.getDeclaredConstructors()[0];
        for (Constructor<?> c : type.getDeclaredConstructors()) {
            if (c.getParameterTypes().length >= constructor.getParameterTypes().length || !Modifier.isPublic(c.getModifiers())) continue;
            constructor = c;
        }
        Object[] params = new Object[constructor.getParameterTypes().length];
        for (int i = 0; i < constructor.getParameterTypes().length; ++i) {
            params[i] = ActionsTest.instantiateType(constructor.getParameterTypes()[i]);
        }
        return constructor.newInstance(params);
    }

    private static <T> MethodCallTester<T> createMethodTesterForInterface(Class<T> interfaceClass) {
        return ActionsTest.createMethodTesterForInterface(interfaceClass, null);
    }

    private static <T> MethodCallTester<T> createMethodTesterForInterface(Class<T> interfaceClass, final T forwardInstance) {
        final ArrayList<MethodInvocation> invocations = new ArrayList<MethodInvocation>();
        Object mock = Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                invocations.add(new MethodInvocation(method.getName(), args));
                if (forwardInstance != null) {
                    return method.invoke(forwardInstance, args);
                }
                return null;
            }
        });
        return new MethodCallTester<Object>(mock, interfaceClass, invocations);
    }

    private static interface TestWithMock<Interface> {
        public void test(Interface var1);
    }

    public static class MethodCallTester<MonitoredClass> {
        private final MonitoredClass mock;
        private final Class<MonitoredClass> mockClass;
        private final List<MethodInvocation> invocations;

        MethodCallTester(MonitoredClass mock, Class<MonitoredClass> mockClass, List<MethodInvocation> invocations) {
            this.mock = mock;
            this.mockClass = mockClass;
            this.invocations = invocations;
        }

        public boolean wasMethodCalled(String name, Object ... expectedParamValues) {
            MethodInvocation expected = new MethodInvocation(name, expectedParamValues);
            for (MethodInvocation invocation : this.invocations) {
                if (!invocation.equals(expected)) continue;
                return true;
            }
            return false;
        }

        public boolean wasMethodCalled(String name, Class<?> ... paramTypes) {
            for (MethodInvocation invocation : this.invocations) {
                if (!invocation.method.equals(name) || !invocation.paramTypesMatch(paramTypes)) continue;
                return true;
            }
            return false;
        }

        public boolean wereMethodsCalledInOrder(MethodInvocation ... methodInvocations) {
            if (methodInvocations == null || methodInvocations.length == 0) {
                return true;
            }
            int i = 0;
            for (MethodInvocation invocation : this.invocations) {
                if (!invocation.equals(methodInvocations[i]) || ++i < methodInvocations.length) continue;
                return true;
            }
            return false;
        }

        public MethodCallTester<MonitoredClass> assertMethodCalled(String name, Object ... expectedParamValues) {
            Assert.assertTrue("Method " + this.mockClass.getSimpleName() + "." + name + "(" + Arrays.toString(expectedParamValues) + ") was not called", this.wasMethodCalled(name, expectedParamValues));
            return this;
        }

        public MethodCallTester<MonitoredClass> assertMethodNotCalled(String name, Object ... expectedParamValues) {
            Assert.assertFalse("Method " + this.mockClass.getSimpleName() + "." + name + "(" + Arrays.toString(expectedParamValues) + ") was called but no call was expected", this.wasMethodCalled(name, expectedParamValues));
            return this;
        }

        public MethodCallTester<MonitoredClass> assertMethodCalled(String name, Class<?> ... paramTypes) {
            Assert.assertTrue("Method " + this.mockClass.getSimpleName() + "." + name + "(" + Arrays.toString(paramTypes) + ") was not called", this.wasMethodCalled(name, paramTypes));
            return this;
        }

        public MethodCallTester<MonitoredClass> assertMethodNotCalled(String name, Class<?> ... paramTypes) {
            Assert.assertFalse("Method " + this.mockClass.getSimpleName() + "." + name + "(" + Arrays.toString(paramTypes) + ") was called but no call was expected", this.wasMethodCalled(name, paramTypes));
            return this;
        }

        public void assertMethodsCalledInOrder(MethodInvocation ... methods) {
            Assert.assertTrue("Methods were not called in the correct oder", this.wereMethodsCalledInOrder(methods));
        }

        public MethodCallTester<MonitoredClass> assertAllInterfaceMethodsCalled() {
            ArrayList<MethodInvocation> currentInvocation = new ArrayList<MethodInvocation>(this.invocations);
            for (Method method : this.mockClass.getDeclaredMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
                boolean called = false;
                for (MethodInvocation invocation : currentInvocation) {
                    if (!invocation.method.equals(method.getName())) continue;
                    called = true;
                    break;
                }
                Assert.assertTrue("Method " + this.mockClass.getSimpleName() + "." + method.getName() + " was not called", called);
            }
            return this;
        }

        public MethodCallTester<MonitoredClass> testWithMock(TestWithMock<MonitoredClass> test) {
            test.test(this.mock);
            return this;
        }
    }

    public static class MethodInvocation {
        public final String method;
        public final Object[] params;

        public MethodInvocation(String method, Object ... params) {
            this.method = method;
            this.params = params;
        }

        public boolean paramTypesMatch(Class<?>[] types) {
            Object[] params = this.params == null ? new Object[]{} : this.params;
            Class<Object>[] classArray = types = types == null ? new Class[]{} : types;
            if (types.length != params.length) {
                return false;
            }
            for (int i = 0; i < types.length; ++i) {
                if (!(params[i] == null ? types[i].isPrimitive() : !types[i].isAssignableFrom(params[i].getClass()))) continue;
                return false;
            }
            return true;
        }

        private boolean parametersEqual(Object[] params1, Object[] params2) {
            if (params1 == null) {
                params1 = new Object[]{};
            }
            if (params2 == null) {
                params2 = new Object[]{};
            }
            return Arrays.equals(params1, params2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodInvocation that = (MethodInvocation)o;
            return this.method.equals(that.method) && this.parametersEqual(this.params, that.params);
        }

        public int hashCode() {
            int result = this.method.hashCode();
            result = 31 * result + Arrays.hashCode(this.params);
            return result;
        }
    }
}

