/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimulationConstructionSetRootRegistryTest {
    private static final boolean SHOW_GUI = false;

    @Test
    public void testRootRegistryNothingFancy() {
        Robot robot = new Robot("RobotsRootRegistry");
        YoRegistry registryOne = new YoRegistry("RegistryOne");
        robot.getRobotsYoRegistry().addChild(registryOne);
        YoDouble variableOne = new YoDouble("variableOne", registryOne);
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        SimulationConstructionSetRootRegistryTest.sleep(1000L);
        scs.startOnAThread();
        YoRegistry rootRegistry = scs.getRootRegistry();
        YoBuffer dataBuffer = scs.getDataBuffer();
        Assert.assertTrue(variableOne == rootRegistry.findVariable("variableOne"));
        Assert.assertTrue(variableOne == dataBuffer.findVariable("variableOne"));
        scs.closeAndDispose();
    }

    @Test
    public void testVarGroups() {
        Robot robot = new Robot("testVarGroups");
        YoRegistry registryOne = new YoRegistry("registryOne");
        YoRegistry registryTwo = new YoRegistry("registryTwo");
        YoDouble variableOneA = new YoDouble("variableOneA", registryOne);
        YoDouble variableOneB = new YoDouble("variableOneB", registryOne);
        YoDouble variableTwoA = new YoDouble("variableTwoA", registryTwo);
        YoDouble variableTwoB = new YoDouble("variableTwoB", registryTwo);
        robot.getRobotsYoRegistry().addChild(registryOne);
        robot.getRobotsYoRegistry().addChild(registryTwo);
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        scs.setupVarGroup("VarGroupToTest", new String[]{"variableOneA", "variableTwoB"});
        scs.startOnAThread();
        scs.closeAndDispose();
    }

    @Test
    public void testRootRegistryAddYoVariablesAfterConstruction() {
        Robot robot = new Robot("TestAfterConstruction");
        YoRegistry registryBeforeConstructionOne = new YoRegistry("RegistryBeforeConstructionOne");
        robot.getRobotsYoRegistry().addChild(registryBeforeConstructionOne);
        YoDouble variableBeforeConstructionOne = new YoDouble("variableBeforeConstructionOne", registryBeforeConstructionOne);
        YoRegistry registryBeforeConstructionOneOne = new YoRegistry("RegistryBeforeConstructionOneOne");
        registryBeforeConstructionOne.addChild(registryBeforeConstructionOneOne);
        YoDouble variableBeforeConstructionOneOne = new YoDouble("variableBeforeConstructionOneOne", registryBeforeConstructionOneOne);
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        YoDouble variableAfterConstructionZero = new YoDouble("variableAfterConstructionZero", registryBeforeConstructionOne);
        YoRegistry registryAfterConstructionOne = new YoRegistry("RegistryAfterConstructionOne");
        YoDouble variableAfterConstructionOne = new YoDouble("variableAfterConstructionOne", registryAfterConstructionOne);
        scs.getRootRegistry().addChild(registryAfterConstructionOne);
        YoDouble variableAfterConstructionTwo = new YoDouble("variableAfterConstructionTwo", registryAfterConstructionOne);
        scs.startOnAThread();
        YoDouble variableAfterThreadZero = new YoDouble("variableAfterThreadZero", registryAfterConstructionOne);
        YoRegistry registryAfterThreadOne = new YoRegistry("RegistryAfterThreadOne");
        YoDouble variableAfterThreadOne = new YoDouble("variableAfterThreadOne", registryAfterThreadOne);
        registryAfterConstructionOne.addChild(registryAfterThreadOne);
        YoDouble variableAfterThreadTwo = new YoDouble("variableAfterThreadTwo", registryAfterThreadOne);
        YoRegistry rootRegistry = scs.getRootRegistry();
        Assert.assertTrue(variableBeforeConstructionOne == rootRegistry.findVariable("variableBeforeConstructionOne"));
        Assert.assertTrue(variableAfterConstructionZero == rootRegistry.findVariable("variableAfterConstructionZero"));
        Assert.assertTrue(variableAfterConstructionOne == rootRegistry.findVariable("variableAfterConstructionOne"));
        Assert.assertTrue(variableAfterConstructionTwo == rootRegistry.findVariable("variableAfterConstructionTwo"));
        Assert.assertTrue(variableAfterThreadZero == rootRegistry.findVariable("variableAfterThreadZero"));
        Assert.assertTrue(variableAfterThreadOne == rootRegistry.findVariable("variableAfterThreadOne"));
        Assert.assertTrue(variableAfterThreadTwo == rootRegistry.findVariable("variableAfterThreadTwo"));
        YoBuffer dataBuffer = scs.getDataBuffer();
        Assert.assertTrue(variableBeforeConstructionOne == dataBuffer.findVariable("variableBeforeConstructionOne"));
        Assert.assertTrue(variableAfterConstructionZero == dataBuffer.findVariable("variableAfterConstructionZero"));
        Assert.assertTrue(variableAfterConstructionOne == dataBuffer.findVariable("variableAfterConstructionOne"));
        Assert.assertTrue(variableAfterConstructionTwo == dataBuffer.findVariable("variableAfterConstructionTwo"));
        Assert.assertTrue(variableAfterThreadZero == dataBuffer.findVariable("variableAfterThreadZero"));
        Assert.assertTrue(variableAfterThreadOne == dataBuffer.findVariable("variableAfterThreadOne"));
        Assert.assertTrue(variableAfterThreadTwo == dataBuffer.findVariable("variableAfterThreadTwo"));
        scs.closeAndDispose();
    }

    private static void sleepForever() {
        while (true) {
            SimulationConstructionSetRootRegistryTest.sleep(10000L);
        }
    }

    private static void sleep(long sleepMillis) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

