/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.featherstone;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.physics.featherstone.RobotWithClosedFormDynamics;

public class DoublePendulumRobot
extends RobotWithClosedFormDynamics {
    private final double length1 = 0.7;
    private final double lengthCoM1 = 0.3;
    private final double lengthCoM2 = 0.25;
    private final double Ixx1CoM = 0.4;
    private final double Ixx2CoM = 0.5;
    private final double mass1 = 1.0;
    private final double mass2 = 1.5;
    private final double damping1 = 0.2;
    private final double damping2 = 0.1;
    private final Axis3D axis = Axis3D.X;
    private final PinJoint pinJoint1;
    private final PinJoint pinJoint2;
    private final DMatrixRMaj H = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj C = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj G = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj qd = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj qdd = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj rightHandSide = new DMatrixRMaj(2, 1);

    public DoublePendulumRobot(String name, double initialQFirstJoint, double initialQdFirstJoint, double initialQSecondJoint, double initialQdSecondJoint) {
        super(name);
        this.pinJoint1 = new PinJoint(name + "Joint1", (Tuple3DReadOnly)new Vector3D(), (Robot)this, (Vector3DReadOnly)this.axis);
        Link link1 = new Link(name + "Link1");
        link1.setMass(1.0);
        link1.setMomentOfInertia(0.4, 0.0, 0.0);
        link1.setComOffset(0.0, 0.0, -0.3);
        this.pinJoint1.setLink(link1);
        this.pinJoint1.setDamping(0.2);
        this.pinJoint2 = new PinJoint(name + "Joint2", (Tuple3DReadOnly)new Vector3D(0.0, 0.0, -0.7), (Robot)this, (Vector3DReadOnly)this.axis);
        Link link2 = new Link(name + "Link2");
        link2.setMass(1.5);
        link2.setMomentOfInertia(0.5, 0.0, 0.0);
        link2.setComOffset(0.0, 0.0, -0.25);
        this.pinJoint2.setLink(link2);
        this.pinJoint2.setDamping(0.1);
        this.pinJoint1.addJoint((Joint)this.pinJoint2);
        this.pinJoint1.setQ(initialQFirstJoint);
        this.pinJoint1.setQd(initialQdFirstJoint);
        this.pinJoint2.setQ(initialQSecondJoint);
        this.pinJoint2.setQd(initialQdSecondJoint);
        this.addRootJoint((Joint)this.pinJoint1);
    }

    @Override
    public void assertStateIsCloseToClosedFormCalculation(double epsilon) {
        double H01;
        double q1 = this.pinJoint1.getQ();
        double qd1 = this.pinJoint1.getQD();
        double qdd1 = this.pinJoint1.getQDD();
        double q2 = this.pinJoint2.getQ();
        double qd2 = this.pinJoint2.getQD();
        double qdd2 = this.pinJoint2.getQDD();
        double g = Math.abs(this.gravityZ.getDoubleValue());
        double Ixx1 = 1.0 * MathTools.square((double)0.3) + 0.4;
        double Ixx2 = 1.5 * MathTools.square((double)0.25) + 0.5;
        double H00 = Ixx1 + Ixx2 + 1.5 * MathTools.square((double)0.7) + 0.5249999999999999 * Math.cos(q2);
        double H10 = H01 = Ixx2 + 0.26249999999999996 * Math.cos(q2);
        double H11 = Ixx2;
        double C00 = -0.5249999999999999 * Math.sin(q2) * qd2 + 0.2;
        double C01 = -0.26249999999999996 * Math.sin(q2) * qd2;
        double C10 = 0.26249999999999996 * Math.sin(q2) * qd1;
        double C11 = 0.1;
        double G00 = 1.3499999999999999 * g * Math.sin(q1) + 1.5 * g * 0.25 * Math.sin(q1 + q2);
        double G10 = 1.5 * g * 0.25 * Math.sin(q1 + q2);
        this.H.set(0, 0, H00);
        this.H.set(0, 1, H01);
        this.H.set(1, 0, H10);
        this.H.set(1, 1, H11);
        this.C.set(0, 0, C00);
        this.C.set(0, 1, C01);
        this.C.set(1, 0, C10);
        this.C.set(1, 1, C11);
        this.G.set(0, 0, G00);
        this.G.set(1, 0, G10);
        this.qd.set(0, 0, qd1);
        this.qd.set(1, 0, qd2);
        this.rightHandSide.set((DMatrixD1)this.G);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.C, (DMatrix1Row)this.qd, (DMatrix1Row)this.rightHandSide);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.rightHandSide);
        CommonOps_DDRM.solve((DMatrixRMaj)this.H, (DMatrixRMaj)this.rightHandSide, (DMatrixRMaj)this.qdd);
        if (Math.abs(this.qdd.get(0, 0) - qdd1) > epsilon || Math.abs(this.qdd.get(1, 0) - qdd2) > epsilon) {
            throw new AssertionError((Object)("Joint accelerations from simulation and lagrangian don't match. \nAt t=" + this.getTime() + "\nSimulated joint accelerations: (" + qdd1 + ", " + qdd2 + ")\nLagrangian accelerations: (" + this.qdd.get(0, 0) + ", " + this.qdd.get(1, 0) + ")"));
        }
    }
}

