/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.JointPhysics;

public class CollisionResolutionTest {
    @Test
    public void testCollisionResolutionOne() throws UnreasonableAccelerationException {
        Robot robot = new Robot("TestCollisions");
        FloatingJoint floatingJoint = new FloatingJoint("base", (Tuple3DReadOnly)new Vector3D(), robot);
        Link link = new Link("baseLink");
        double mass = 0.005;
        double Ixx = 2.0E-5;
        double Iyy = 2.0E-5;
        double Izz = 4.0E-5;
        link.setMass(mass);
        link.setMomentOfInertia(Ixx, Iyy, Izz);
        link.setComOffset((Vector3DReadOnly)new Vector3D());
        floatingJoint.setLink(link);
        ExternalForcePoint externalForcePoint = new ExternalForcePoint("externalForcePoint", (Tuple3DReadOnly)new Vector3D(), robot);
        floatingJoint.addExternalForcePoint(externalForcePoint);
        robot.addRootJoint((Joint)floatingJoint);
        JointPhysics jointPhysics = floatingJoint.physics;
        double downwardVelocity = 1.4;
        Vector3D initialVelocity = new Vector3D(0.0, 0.0, -downwardVelocity);
        floatingJoint.setVelocity((Tuple3DReadOnly)initialVelocity);
        floatingJoint.setAngularVelocityInBody((Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0));
        robot.doDynamicsButDoNotIntegrate();
        RotationMatrix identityMatrix = new RotationMatrix();
        identityMatrix.setIdentity();
        Vector3D offsetFromCenterOfMass = new Vector3D(0.0, 0.0, 0.0);
        Matrix3D kiCollision = jointPhysics.computeKiCollision((Vector3DReadOnly)offsetFromCenterOfMass, (RotationMatrixReadOnly)identityMatrix);
        Matrix3D expectedKiCollision = new Matrix3D(1.0 / mass, 0.0, 0.0, 0.0, 1.0 / mass, 0.0, 0.0, 0.0, 1.0 / mass);
        EuclidCoreTestTools.assertMatrix3DEquals((String)("kiCollision = " + kiCollision), (Matrix3DReadOnly)expectedKiCollision, (Matrix3DReadOnly)kiCollision, (double)1.0E-7);
        Vector3D velocityOfOtherObjectInWorld = new Vector3D(0.0, 0.0, 0.0);
        Vector3D collisionNormalInWorld = new Vector3D(0.0, 0.0, 1.0);
        double epsilon = 1.0;
        double mu = 0.0;
        Vector3D impulseInWorldToPack = new Vector3D();
        externalForcePoint.resolveCollision((Vector3DReadOnly)velocityOfOtherObjectInWorld, (Vector3DReadOnly)collisionNormalInWorld, epsilon, mu, (Vector3DBasics)impulseInWorldToPack);
        double upwardVelocity = epsilon * downwardVelocity;
        double deltaVelocity = downwardVelocity + upwardVelocity;
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, mass * deltaVelocity), (EuclidGeometry)impulseInWorldToPack, (double)1.0E-7);
        Vector3D velocity = new Vector3D();
        floatingJoint.getVelocity((Tuple3DBasics)velocity);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, upwardVelocity), (EuclidGeometry)velocity, (double)1.0E-7);
        offsetFromCenterOfMass = new Vector3D(0.1, 0.04, -0.02);
        initialVelocity = new Vector3D(0.1, 0.07, -1.0);
        externalForcePoint.setOffsetJoint((Tuple3DReadOnly)offsetFromCenterOfMass);
        floatingJoint.setVelocity((Tuple3DReadOnly)initialVelocity);
        floatingJoint.setAngularVelocityInBody((Vector3DReadOnly)new Vector3D(0.13, 1.0, 0.11));
        robot.update();
        robot.updateVelocities();
        robot.doDynamicsButDoNotIntegrate();
        Vector3D initialVelocityAtImpactPoint = new Vector3D();
        externalForcePoint.getVelocity((Vector3DBasics)initialVelocityAtImpactPoint);
        double initialEnergy = this.computeEnergy(robot);
        kiCollision = jointPhysics.computeKiCollision((Vector3DReadOnly)offsetFromCenterOfMass, (RotationMatrixReadOnly)identityMatrix);
        expectedKiCollision = new Matrix3D(1.0 / mass, 0.0, 0.0, 0.0, 1.0 / mass, 0.0, 0.0, 0.0, 1.0 / mass);
        Matrix3D rTilde = new Matrix3D(0.0, -offsetFromCenterOfMass.getZ(), offsetFromCenterOfMass.getY(), offsetFromCenterOfMass.getZ(), 0.0, -offsetFromCenterOfMass.getX(), -offsetFromCenterOfMass.getY(), offsetFromCenterOfMass.getX(), 0.0);
        Matrix3D IInverse = new Matrix3D(Ixx, 0.0, 0.0, 0.0, Iyy, 0.0, 0.0, 0.0, Izz);
        IInverse.invert();
        Matrix3D expectedKiCollisionAngularPart = new Matrix3D((Matrix3DReadOnly)rTilde);
        expectedKiCollisionAngularPart.multiply((Matrix3DReadOnly)IInverse);
        expectedKiCollisionAngularPart.multiply((Matrix3DReadOnly)rTilde);
        expectedKiCollision.sub((Matrix3DReadOnly)expectedKiCollisionAngularPart);
        EuclidCoreTestTools.assertMatrix3DEquals((String)("kiCollision = " + kiCollision), (Matrix3DReadOnly)expectedKiCollision, (Matrix3DReadOnly)kiCollision, (double)1.0E-7);
        velocityOfOtherObjectInWorld = new Vector3D(0.0, 0.0, 0.0);
        collisionNormalInWorld = new Vector3D(0.0, 0.0, 1.0);
        epsilon = 0.7;
        mu = 0.3;
        impulseInWorldToPack = new Vector3D();
        externalForcePoint.resolveCollision((Vector3DReadOnly)velocityOfOtherObjectInWorld, (Vector3DReadOnly)collisionNormalInWorld, epsilon, mu, (Vector3DBasics)impulseInWorldToPack);
        Vector3D deltaV = new Vector3D((Tuple3DReadOnly)impulseInWorldToPack);
        kiCollision.transform((Tuple3DBasics)deltaV);
        Vector3D expectedFinalVelocity = new Vector3D((Tuple3DReadOnly)initialVelocityAtImpactPoint);
        expectedFinalVelocity.add((Tuple3DReadOnly)deltaV);
        Vector3D finalVelocityAtImpactPoint = new Vector3D();
        externalForcePoint.getVelocity((Vector3DBasics)finalVelocityAtImpactPoint);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedFinalVelocity, (EuclidGeometry)finalVelocityAtImpactPoint, (double)1.0E-7);
        double finalEnergy = this.computeEnergy(robot);
        Assert.assertTrue("initialEnergy = " + initialEnergy + ", finalEnergy = " + finalEnergy, finalEnergy <= initialEnergy);
    }

    private double computeEnergy(Robot robot) {
        double rotationalEnergy = robot.computeRotationalKineticEnergy();
        double translationalEnergy = robot.computeTranslationalKineticEnergy();
        double totalEnergy = rotationalEnergy + translationalEnergy;
        return totalEnergy;
    }
}

