/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.ControllerFailureException;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferProcessor;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoBufferProcessorTest {
    private static final boolean SHOW_GUI = false;

    @Test
    public void testSimpleDataProcessingFunction() throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, ControllerFailureException {
        final Robot robot = new Robot("DataProcessingFunctionTestRobot");
        YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
        final YoDouble variableOne = new YoDouble("variableOne", registry);
        final YoDouble variableTwo = new YoDouble("variableTwo", registry);
        final YoDouble variableThree = new YoDouble("variableThree", registry);
        robot.addYoRegistry(registry);
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        scs.setDT(0.001, 1);
        scs.startOnAThread();
        BlockingSimulationRunner runner = new BlockingSimulationRunner(scs, 100.0);
        runner.simulateAndBlock(2.0);
        YoBufferProcessor dataProcessingFunction = new YoBufferProcessor(){

            public void process(int startIndex, int endIndex, int currentIndex) {
                double time = robot.getTime();
                variableOne.set(time);
                variableTwo.set(1.1);
                variableThree.set(9.23);
            }
        };
        scs.tickAndReadFromBuffer(50);
        Assert.assertEquals(variableOne.getDoubleValue(), 0.0, 1.0E-7);
        Assert.assertEquals(variableTwo.getDoubleValue(), 0.0, 1.0E-7);
        Assert.assertEquals(variableThree.getDoubleValue(), 0.0, 1.0E-7);
        scs.applyDataProcessingFunction(dataProcessingFunction);
        scs.gotoInPointNow();
        scs.tickAndReadFromBuffer(500);
        Assert.assertEquals(variableOne.getDoubleValue(), 0.5, 1.0E-7);
        Assert.assertEquals(variableOne.getDoubleValue(), robot.getTime(), 1.0E-7);
        Assert.assertEquals(variableTwo.getDoubleValue(), 1.1, 1.0E-7);
        Assert.assertEquals(variableThree.getDoubleValue(), 9.23, 1.0E-7);
        scs.closeAndDispose();
    }
}

