/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.featherstone;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.UniversalJoint;
import us.ihmc.simulationconstructionset.physics.featherstone.RobotWithClosedFormDynamics;

public class UniversalJointRobot
extends RobotWithClosedFormDynamics {
    private final double mass = 1.2;
    private final double length = 0.4;
    private final UniversalJoint universalJoint;

    public UniversalJointRobot(String name, double initialQFirstJoint, double initialQdFirstJoint, double initialQSecondJoint, double initialQdSecondJoint) {
        super(name);
        this.universalJoint = new UniversalJoint(name + "Joint1", name + "Joint2", (Tuple3DReadOnly)new Vector3D(), (Robot)this, (Vector3DReadOnly)Axis3D.X, (Vector3DReadOnly)Axis3D.Y);
        Link link = new Link(name + "Link");
        link.setMass(1.2);
        link.setComOffset(0.0, 0.0, -0.4);
        this.universalJoint.setLink(link);
        this.universalJoint.getFirstJoint().setInitialState(initialQFirstJoint, initialQdFirstJoint);
        this.universalJoint.getSecondJoint().setInitialState(initialQSecondJoint, initialQdSecondJoint);
        this.addRootJoint((Joint)this.universalJoint);
    }

    @Override
    public void assertStateIsCloseToClosedFormCalculation(double epsilon) {
        double qx = this.universalJoint.getFirstJoint().getQ();
        double qddx = this.universalJoint.getFirstJoint().getQDD();
        double qy = this.universalJoint.getSecondJoint().getQ();
        double qddy = this.universalJoint.getSecondJoint().getQDD();
        double g = Math.abs(this.gravityZ.getDoubleValue());
        if (Math.abs(Math.cos(qy)) < 1.0E-4) {
            return;
        }
        double qddxLagrangian = -(g * Math.sin(qx)) / (0.4 * Math.cos(qy));
        double qddyLagrangian = -(g * Math.cos(qx) * Math.sin(qy)) / 0.4;
        if (Math.abs(qddxLagrangian - qddx) > epsilon || Math.abs(qddyLagrangian - qddy) > epsilon) {
            throw new AssertionError((Object)("Joint accelerations from simulation and lagrangian don't match. \nAt t=" + this.getTime() + "\nSimulated joint accelerations: (" + qddx + ", " + qddy + ")\nLagrangian accelerations: (" + qddxLagrangian + ", " + qddyLagrangian + ")"));
        }
    }
}

