/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.physics.CollisionShape;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;
import us.ihmc.simulationconstructionset.physics.CollisionShapeFactory;
import us.ihmc.simulationconstructionset.physics.Contacts;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.simple.SimpleCollisionDetector;

public class SimpleCollisionDetectorTest {
    @Test
    public void testSphereToSphereCollisions() {
        Point3D tempLocation;
        CollisionShape tempShape;
        SimpleCollisionDetector detector = new SimpleCollisionDetector();
        CollisionShapeFactory shapeFactory = detector.getShapeFactory();
        double radiusOne = 0.5;
        CollisionShapeDescription sphereOne = shapeFactory.createSphere(radiusOne);
        CollisionShapeDescription sphereTwo = shapeFactory.createSphere(radiusOne);
        CollisionShape collideableObjectOne = shapeFactory.addShape(sphereOne);
        CollisionShape collideableObjectTwo = shapeFactory.addShape(sphereTwo);
        RigidBodyTransform transformOne = new RigidBodyTransform();
        RigidBodyTransform transformTwo = new RigidBodyTransform();
        double delta = 0.01;
        transformOne.getTranslation().set(0.0, 0.0, 0.0);
        transformOne.getTranslation().set(1.0 + delta, 0.0, 0.0);
        collideableObjectOne.setTransformToWorld(transformOne);
        collideableObjectTwo.setTransformToWorld(transformTwo);
        CollisionDetectionResult result = new CollisionDetectionResult();
        detector.performCollisionDetection(result);
        Assert.assertEquals(0L, result.getNumberOfCollisions());
        transformOne.setRotationEulerAndZeroTranslation(0.3, 0.7, 0.9);
        transformOne.getTranslation().set(0.0, 0.0, 0.0);
        transformOne.getTranslation().set(1.0 - delta, 0.0, 0.0);
        collideableObjectOne.setTransformToWorld(transformOne);
        collideableObjectTwo.setTransformToWorld(transformTwo);
        result.clear();
        detector.performCollisionDetection(result);
        Assert.assertEquals(1L, result.getNumberOfCollisions());
        Contacts collision = result.getCollision(0);
        Assert.assertEquals(1L, collision.getNumberOfContacts());
        CollisionShape shapeA = collision.getShapeA();
        CollisionShape shapeB = collision.getShapeB();
        Point3D locationA = new Point3D();
        Point3D locationB = new Point3D();
        Vector3D normal = new Vector3D();
        double distance = collision.getDistance(0);
        collision.getWorldA(0, locationA);
        collision.getWorldB(0, locationB);
        collision.getWorldNormal(0, normal);
        if (!collision.isNormalOnA()) {
            normal.scale(-1.0);
        }
        if (shapeA != collideableObjectOne) {
            tempShape = shapeA;
            shapeA = shapeB;
            shapeB = tempShape;
            tempLocation = locationA;
            locationA = locationB;
            locationB = tempLocation;
            normal.scale(-1.0);
        }
        Assert.assertTrue(shapeA == collideableObjectOne);
        Assert.assertTrue(shapeB == collideableObjectTwo);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(-1.0, 0.0, 0.0), (Tuple3DReadOnly)normal, (double)1.0E-7);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(0.49, 0.0, 0.0), (Tuple3DReadOnly)locationA, (double)1.0E-7);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(0.5, 0.0, 0.0), (Tuple3DReadOnly)locationB, (double)1.0E-7);
        Assert.assertEquals(-delta, distance, 1.0E-7);
        transformOne.getTranslation().set(-0.7, -0.1, 0.13);
        transformOne.getTranslation().set(-0.4, 0.85, 0.3);
        collideableObjectOne.setTransformToWorld(transformOne);
        collideableObjectTwo.setTransformToWorld(transformTwo);
        result.clear();
        detector.performCollisionDetection(result);
        Assert.assertEquals(1L, result.getNumberOfCollisions());
        collision = result.getCollision(0);
        Assert.assertEquals(1L, collision.getNumberOfContacts());
        distance = collision.getDistance(0);
        collision.getWorldA(0, locationA);
        collision.getWorldB(0, locationB);
        collision.getWorldNormal(0, normal);
        if (!collision.isNormalOnA()) {
            normal.scale(-1.0);
        }
        if (shapeA != collideableObjectOne) {
            tempShape = shapeA;
            shapeA = shapeB;
            shapeB = tempShape;
            tempLocation = locationA;
            locationA = locationB;
            locationB = tempLocation;
            normal.scale(-1.0);
        }
        Assert.assertTrue(shapeA == collideableObjectOne);
        Assert.assertTrue(shapeB == collideableObjectTwo);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(0.40561610125071507, -0.8619342151577695, -0.3042120759380363), (Tuple3DReadOnly)normal, (double)1.0E-7);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(-0.1971919493746425, 0.41903289242111524, 0.14789396203098185), (Tuple3DReadOnly)locationA, (double)1.0E-7);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(-0.20280805062535753, 0.43096710757888473, 0.15210603796901814), (Tuple3DReadOnly)locationB, (double)1.0E-7);
        Assert.assertEquals(-0.013845853834199007, distance, 1.0E-7);
    }

    @Test
    public void testBoxToBoxCollisions() {
        Point3D tempLocation;
        CollisionShape tempShape;
        SimpleCollisionDetector detector = new SimpleCollisionDetector();
        CollisionShapeFactory shapeFactory = detector.getShapeFactory();
        double halfLengthX = 0.5;
        double halfWidthY = 0.6;
        double halfHeightZ = 0.7;
        CollisionShapeDescription boxOne = shapeFactory.createBox(halfLengthX, halfWidthY, halfHeightZ);
        CollisionShapeDescription boxTwo = shapeFactory.createBox(halfLengthX, halfWidthY, halfHeightZ);
        CollisionShape collideableObjectOne = shapeFactory.addShape(boxOne);
        CollisionShape collideableObjectTwo = shapeFactory.addShape(boxTwo);
        RigidBodyTransform transformOne = new RigidBodyTransform();
        RigidBodyTransform transformTwo = new RigidBodyTransform();
        double delta = 0.01;
        transformOne.getTranslation().set(0.0, 0.0, 0.0);
        transformTwo.getTranslation().set(1.0 + delta, 0.0, 0.0);
        collideableObjectOne.setTransformToWorld(transformOne);
        collideableObjectTwo.setTransformToWorld(transformTwo);
        CollisionDetectionResult result = new CollisionDetectionResult();
        detector.performCollisionDetection(result);
        Assert.assertEquals(0L, result.getNumberOfCollisions());
        transformOne.getTranslation().set(0.0, 0.0, 0.0);
        transformTwo.getTranslation().set(1.0 - delta, 0.0, 0.0);
        collideableObjectOne.setTransformToWorld(transformOne);
        collideableObjectTwo.setTransformToWorld(transformTwo);
        result.clear();
        detector.performCollisionDetection(result);
        Assert.assertEquals(1L, result.getNumberOfCollisions());
        Contacts collision = result.getCollision(0);
        Assert.assertEquals(1L, collision.getNumberOfContacts());
        CollisionShape shapeA = collision.getShapeA();
        CollisionShape shapeB = collision.getShapeB();
        Point3D locationA = new Point3D();
        Point3D locationB = new Point3D();
        Vector3D normal = new Vector3D();
        double distance = collision.getDistance(0);
        collision.getWorldA(0, locationA);
        collision.getWorldB(0, locationB);
        collision.getWorldNormal(0, normal);
        if (!collision.isNormalOnA()) {
            normal.scale(-1.0);
        }
        if (shapeA != collideableObjectOne) {
            tempShape = shapeA;
            shapeA = shapeB;
            shapeB = tempShape;
            tempLocation = locationA;
            locationA = locationB;
            locationB = tempLocation;
            normal.scale(-1.0);
        }
        Assert.assertTrue(shapeA == collideableObjectOne);
        Assert.assertTrue(shapeB == collideableObjectTwo);
        Assert.assertEquals(-delta, distance, 1.0E-7);
        transformOne.getTranslation().set(-0.7, -0.1, 0.13);
        transformTwo.getTranslation().set(-0.4, 0.85, 0.3);
        collideableObjectOne.setTransformToWorld(transformOne);
        collideableObjectTwo.setTransformToWorld(transformTwo);
        result.clear();
        detector.performCollisionDetection(result);
        Assert.assertEquals(1L, result.getNumberOfCollisions());
        collision = result.getCollision(0);
        Assert.assertEquals(1L, collision.getNumberOfContacts());
        distance = collision.getDistance(0);
        collision.getWorldA(0, locationA);
        collision.getWorldB(0, locationB);
        collision.getWorldNormal(0, normal);
        if (!collision.isNormalOnA()) {
            normal.scale(-1.0);
        }
        if (shapeA != collideableObjectOne) {
            tempShape = shapeA;
            shapeA = shapeB;
            shapeB = tempShape;
            tempLocation = locationA;
            locationA = locationB;
            locationB = tempLocation;
            normal.scale(-1.0);
        }
        Assert.assertTrue(shapeA == collideableObjectOne);
        Assert.assertTrue(shapeB == collideableObjectTwo);
        Assert.assertEquals(-0.25, distance, 1.0E-7);
    }
}

