/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.FloatingPlanarJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.RandomRobotGenerator;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.util.ControllerFailureException;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RobotTest {
    private static final double COORDINATE_SYSTEM_LENGTH = 0.3;
    private static final boolean SHOW_GUI = false;
    private static SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();

    @AfterAll
    public static void finishedAllTestsMessage() {
        System.out.println("Finished RobotTest, moving on.");
        System.out.flush();
        System.err.flush();
    }

    @Test
    public void testSwitchingRootJoint() throws InterruptedException, UnreasonableAccelerationException, BlockingSimulationRunner.SimulationExceededMaximumTimeException, ControllerFailureException {
        Random random = new Random(1765L);
        double l1 = 2.0;
        double l2 = 2.0;
        double r1 = 0.1;
        double r2 = 0.05;
        Robot robot1 = new Robot("r1");
        FloatingJoint root1 = new FloatingJoint("root1", (Tuple3DReadOnly)new Vector3D(), robot1);
        robot1.addRootJoint((Joint)root1);
        Link link11 = RobotTest.link11(random, l1, r1);
        root1.setLink(link11);
        Vector3D offset = new Vector3D(0.0, 0.0, l1);
        PinJoint pin1 = new PinJoint("pin1", (Tuple3DReadOnly)offset, robot1, (Vector3DReadOnly)Axis3D.Y);
        root1.addJoint((Joint)pin1);
        Link link21 = RobotTest.link21(random, l2, r2);
        pin1.setLink(link21);
        Robot robot2 = new Robot("r2");
        FloatingJoint root2 = new FloatingJoint("root2", (Tuple3DReadOnly)new Vector3D(), robot2);
        robot2.addRootJoint((Joint)root2);
        Link link22 = RobotTest.link22(link21);
        root2.setLink(link22);
        Vector3D jointAxis = new Vector3D();
        pin1.getJointAxis((Vector3DBasics)jointAxis);
        PinJoint pin2 = new PinJoint("pin2", (Tuple3DReadOnly)new Vector3D(), robot2, (Vector3DReadOnly)jointAxis);
        root2.addJoint((Joint)pin2);
        Link link12 = RobotTest.link12(link11, pin1);
        pin2.setLink(link12);
        robot1.setGravity(0.0);
        robot2.setGravity(0.0);
        pin1.setQ(random.nextDouble());
        pin2.setQ(-pin1.getQYoVariable().getDoubleValue());
        pin1.setQd(10.0);
        pin2.setQd(-pin1.getQDYoVariable().getDoubleValue());
        Vector3D angularVelocityInBody = new Vector3D(0.0, pin1.getQDYoVariable().getDoubleValue(), 0.0);
        root2.setAngularVelocityInBody((Vector3DReadOnly)angularVelocityInBody);
        pin1.setTau(random.nextDouble());
        pin2.setTau(-pin1.getTauYoVariable().getDoubleValue());
        robot1.update();
        RigidBodyTransform pin1ToWorld = new RigidBodyTransform();
        pin1.getTransformToWorld((RigidBodyTransformBasics)pin1ToWorld);
        root2.setRotationAndTranslation((RigidBodyTransformReadOnly)pin1ToWorld);
        root2.setPosition(root2.getQx().getDoubleValue(), root2.getQy().getDoubleValue(), root2.getQz().getDoubleValue());
        robot2.update();
        robot1.updateVelocities();
        robot2.updateVelocities();
        double epsilonBefore = 1.0E-8;
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)RobotTest.computeCoM(robot1), (Tuple3DReadOnly)RobotTest.computeCoM(robot2), (double)epsilonBefore);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)RobotTest.computeLinearMomentum(robot1), (Tuple3DReadOnly)RobotTest.computeLinearMomentum(robot2), (double)epsilonBefore);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)RobotTest.computeAngularMomentum(robot1), (Tuple3DReadOnly)RobotTest.computeAngularMomentum(robot2), (double)epsilonBefore);
        Assert.assertEquals(RobotTest.computeScalarInertiaAroundJointAxis(link11, pin1), RobotTest.computeScalarInertiaAroundJointAxis(link12, pin2), epsilonBefore);
        Assert.assertEquals(RobotTest.computeScalarInertiaAroundJointAxis(link21, pin1), RobotTest.computeScalarInertiaAroundJointAxis(link22, pin2), epsilonBefore);
        robot1.doDynamicsButDoNotIntegrate();
        robot2.doDynamicsButDoNotIntegrate();
        Assert.assertEquals(pin1.getQDDYoVariable().getDoubleValue(), pin1.getQDDYoVariable().getDoubleValue(), 1.0E-8);
        double simulateTime = 1.0;
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs = new SimulationConstructionSet(new Robot[]{robot1, robot2}, parameters);
        scs.setDT(1.0E-4, 10);
        scs.setGroundVisible(false);
        Thread simThread = new Thread((Runnable)scs, "sim thread");
        simThread.start();
        BlockingSimulationRunner simulationRunner = new BlockingSimulationRunner(scs, 50.0);
        simulationRunner.simulateAndBlock(simulateTime);
        this.sleepIfShowingGUI();
        double epsilonAfter = 1.0E-4;
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)RobotTest.computeCoM(robot1), (Tuple3DReadOnly)RobotTest.computeCoM(robot2), (double)epsilonAfter);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)RobotTest.computeLinearMomentum(robot1), (Tuple3DReadOnly)RobotTest.computeLinearMomentum(robot2), (double)epsilonAfter);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)RobotTest.computeAngularMomentum(robot1), (Tuple3DReadOnly)RobotTest.computeAngularMomentum(robot2), (double)epsilonAfter);
        Assert.assertEquals(RobotTest.computeScalarInertiaAroundJointAxis(link11, pin1), RobotTest.computeScalarInertiaAroundJointAxis(link12, pin2), epsilonAfter);
        Assert.assertEquals(RobotTest.computeScalarInertiaAroundJointAxis(link21, pin1), RobotTest.computeScalarInertiaAroundJointAxis(link22, pin2), epsilonAfter);
        scs.closeAndDispose();
    }

    @Test
    public void testSingleFloatingBodyWithCoMOffset() throws BlockingSimulationRunner.SimulationExceededMaximumTimeException, InterruptedException, UnreasonableAccelerationException, ControllerFailureException {
        Random random = new Random(1659L);
        Robot robot = new Robot("r1");
        robot.setGravity(0.0);
        FloatingJoint root1 = new FloatingJoint("root1", (Tuple3DReadOnly)new Vector3D(), robot);
        robot.addRootJoint((Joint)root1);
        Link floatingBody = RobotTest.randomBody(random);
        root1.setLink(floatingBody);
        Vector3D comOffset = floatingBody.getComOffset();
        Vector3D externalForcePointOffset = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
        ExternalForcePoint externalForcePoint = new ExternalForcePoint("efp", (Tuple3DReadOnly)externalForcePointOffset, robot.getRobotsYoRegistry());
        root1.addExternalForcePoint(externalForcePoint);
        Vector3D force = new Vector3D(random.nextDouble(), random.nextDouble(), random.nextDouble());
        externalForcePoint.setForce((Vector3DReadOnly)force);
        robot.doDynamicsButDoNotIntegrate();
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        root1.getTransformToWorld((RigidBodyTransformBasics)transformToWorld);
        RigidBodyTransform transformToBody = new RigidBodyTransform();
        transformToBody.setAndInvert((RigidBodyTransformReadOnly)transformToWorld);
        transformToBody.transform((Vector3DBasics)force);
        Vector3D moment = new Vector3D();
        moment.sub((Tuple3DReadOnly)externalForcePointOffset, (Tuple3DReadOnly)comOffset);
        moment.cross((Tuple3DReadOnly)moment, (Tuple3DReadOnly)force);
        Matrix3D momentOfInertia = new Matrix3D();
        floatingBody.getMomentOfInertia((Matrix3DBasics)momentOfInertia);
        Vector3D temp1 = new Vector3D();
        temp1.set(root1.getAngularAccelerationInBody());
        momentOfInertia.transform((Tuple3DBasics)temp1);
        Vector3D temp2 = new Vector3D();
        temp2.set(root1.getAngularVelocityInBody());
        momentOfInertia.transform((Tuple3DBasics)temp2);
        temp2.cross((Tuple3DReadOnly)root1.getAngularVelocityInBody(), (Tuple3DReadOnly)temp2);
        Vector3D angularMomentumDerivative = new Vector3D();
        angularMomentumDerivative.add((Tuple3DReadOnly)temp1, (Tuple3DReadOnly)temp2);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)angularMomentumDerivative, (Tuple3DReadOnly)moment, (double)1.0E-10);
        Vector3D linearMomentum0 = RobotTest.computeLinearMomentum(robot);
        double dt = 1.0E-8;
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        scs.setDT(1.0E-10, 10);
        scs.setGroundVisible(false);
        Thread simThread = new Thread((Runnable)scs, "sim thread");
        simThread.start();
        BlockingSimulationRunner simulationRunner = new BlockingSimulationRunner(scs, 50.0);
        simulationRunner.simulateAndBlock(dt);
        Vector3D linearMomentumDT = RobotTest.computeLinearMomentum(robot);
        Vector3D linearMomentumDerivativeNumerical = new Vector3D();
        linearMomentumDerivativeNumerical.sub((Tuple3DReadOnly)linearMomentumDT, (Tuple3DReadOnly)linearMomentum0);
        linearMomentumDerivativeNumerical.scale(1.0 / dt);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)linearMomentumDerivativeNumerical, (Tuple3DReadOnly)force, (double)1.0E-10);
        scs.closeAndDispose();
    }

    @Test
    public void testFloatingJointAndPinJointWithMassiveBody() throws UnreasonableAccelerationException {
        Random random = new Random(1659L);
        Robot robot = new Robot("r1");
        robot.setGravity(0.0);
        FloatingJoint root1 = new FloatingJoint("root1", (Tuple3DReadOnly)new Vector3D(), robot);
        robot.addRootJoint((Joint)root1);
        Link floatingBody = new Link("floatingBody");
        floatingBody.setMass(random.nextDouble());
        floatingBody.setComOffset(random.nextDouble(), random.nextDouble(), random.nextDouble());
        floatingBody.setMomentOfInertia((Matrix3DReadOnly)RobotTest.getRotationalInertiaMatrixOfSolidEllipsoid(floatingBody.getMass(), random.nextDouble(), random.nextDouble(), random.nextDouble()));
        root1.setLink(floatingBody);
        Vector3D offset = EuclidCoreRandomTools.nextVector3D((Random)random);
        PinJoint pin1 = new PinJoint("pin1", (Tuple3DReadOnly)offset, robot, (Vector3DReadOnly)EuclidCoreRandomTools.nextVector3D((Random)random));
        pin1.setLink(this.massiveLink());
        root1.addJoint((Joint)pin1);
        pin1.setTau(random.nextDouble());
        robot.doDynamicsButDoNotIntegrate();
        double scalarInertiaAboutJointAxis = RobotTest.computeScalarInertiaAroundJointAxis(floatingBody, pin1);
        double torqueFromDynamics = scalarInertiaAboutJointAxis * pin1.getQDDYoVariable().getDoubleValue();
        Assert.assertEquals(pin1.getTauYoVariable().getDoubleValue(), torqueFromDynamics, pin1.getTauYoVariable().getDoubleValue() * 0.001);
    }

    @Test
    public void testCalculateAngularMomentum() {
        double epsilon = 1.0E-7;
        Robot robot1 = new Robot("r1");
        FloatingJoint floatingJoint1 = new FloatingJoint("joint1", (Tuple3DReadOnly)new Vector3D(), robot1);
        robot1.addRootJoint((Joint)floatingJoint1);
        Link onlyLink = new Link("SphericalLink");
        onlyLink.setComOffset((Vector3DReadOnly)new Vector3D(0.0, 0.0, 0.0));
        onlyLink.setMass(1.0);
        onlyLink.setMomentOfInertia(1.0, 1.0, 1.0);
        floatingJoint1.setLink(onlyLink);
        floatingJoint1.setPosition((Tuple3DReadOnly)new Point3D(1.0, 1.0, 1.0));
        floatingJoint1.setAngularVelocityInBody((Vector3DReadOnly)new Vector3D(1.0, 0.0, 0.0));
        floatingJoint1.setVelocity(-1.0, 0.0, 0.0);
        Vector3D angularMomentumReturned = new Vector3D();
        robot1.computeAngularMomentum((Vector3DBasics)angularMomentumReturned);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), (Tuple3DReadOnly)angularMomentumReturned, (double)epsilon);
        robot1.update();
        robot1.computeAngularMomentum((Vector3DBasics)angularMomentumReturned);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(0.0, 0.0, 0.0), (Tuple3DReadOnly)angularMomentumReturned, (double)epsilon);
        robot1.updateVelocities();
        robot1.computeAngularMomentum((Vector3DBasics)angularMomentumReturned);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(1.0, -1.0, 1.0), (Tuple3DReadOnly)angularMomentumReturned, (double)epsilon);
        floatingJoint1.setPosition((Tuple3DReadOnly)new Vector3D());
    }

    @Test
    public void testCompareFloatingJointAndFLoatingPlanarJoint() throws UnreasonableAccelerationException, BlockingSimulationRunner.SimulationExceededMaximumTimeException, InterruptedException {
        long seed = 101L;
        Random random = new Random(seed);
        double gravity = 0.0;
        Vector3D offset = new Vector3D(random.nextDouble(), 0.0, random.nextDouble());
        Robot robot1 = new Robot("r1");
        FloatingJoint floatingJoint1 = new FloatingJoint("joint1", (Tuple3DReadOnly)new Vector3D(), robot1);
        robot1.addRootJoint((Joint)floatingJoint1);
        floatingJoint1.setLink(RobotTest.randomBodyNoYCoMOffset(random));
        PinJoint pin1 = new PinJoint("pin1", (Tuple3DReadOnly)offset, robot1, (Vector3DReadOnly)Axis3D.Y);
        floatingJoint1.addJoint((Joint)pin1);
        pin1.setLink(RobotTest.randomBodyNoYCoMOffset(random));
        Robot robot2 = new Robot("r2");
        FloatingPlanarJoint floatingJoint2 = new FloatingPlanarJoint("joint2", robot2);
        robot2.addRootJoint((Joint)floatingJoint2);
        floatingJoint2.setLink(new Link(floatingJoint1.getLink()));
        PinJoint pin2 = new PinJoint("pin2", (Tuple3DReadOnly)offset, robot2, (Vector3DReadOnly)Axis3D.Y);
        floatingJoint2.addJoint((Joint)pin2);
        pin2.setLink(new Link(pin1.getLink()));
        Robot[] robots = new Robot[]{robot1, robot2};
        OneDegreeOfFreedomJoint[] pinJoints = new OneDegreeOfFreedomJoint[]{pin1, pin2};
        for (Robot robot : robots) {
            robot.setGravity(gravity);
        }
        double q = random.nextDouble();
        double tau = random.nextDouble();
        for (OneDegreeOfFreedomJoint oneDegreeOfFreedomJoint : pinJoints) {
            oneDegreeOfFreedomJoint.setQ(q);
            oneDegreeOfFreedomJoint.setTau(tau);
        }
        for (OneDegreeOfFreedomJoint oneDegreeOfFreedomJoint : robots) {
            oneDegreeOfFreedomJoint.doDynamicsButDoNotIntegrate();
        }
        double epsilon = 1.0E-9;
        Assert.assertEquals(floatingJoint1.getQddx().getDoubleValue(), floatingJoint2.getQdd_t1().getDoubleValue(), epsilon);
        Assert.assertEquals(floatingJoint1.getQddy().getDoubleValue(), 0.0, epsilon);
        Assert.assertEquals(floatingJoint1.getQddz().getDoubleValue(), floatingJoint2.getQdd_t2().getDoubleValue(), epsilon);
        Assert.assertEquals(floatingJoint1.getAngularAccelerationX().getDoubleValue(), 0.0, epsilon);
        Assert.assertEquals(floatingJoint1.getAngularAccelerationY().getDoubleValue(), floatingJoint2.getQdd_rot().getDoubleValue(), epsilon);
        Assert.assertEquals(floatingJoint1.getAngularAccelerationZ().getDoubleValue(), 0.0, epsilon);
    }

    private static double computeScalarInertiaAroundJointAxis(Link link, PinJoint pinJoint) {
        Matrix3D momentOfInertia = new Matrix3D();
        link.getMomentOfInertia((Matrix3DBasics)momentOfInertia);
        Vector3D jointAxis = new Vector3D();
        pinJoint.getJointAxis((Vector3DBasics)jointAxis);
        Vector3D temp1 = new Vector3D((Tuple3DReadOnly)jointAxis);
        momentOfInertia.transform((Tuple3DBasics)temp1);
        double scalarInertiaAboutCoM = jointAxis.dot((Vector3DReadOnly)temp1);
        double mass = link.getMass();
        Vector3D offsetToCoM = new Vector3D((Tuple3DReadOnly)link.getComOffset());
        Vector3D offset = new Vector3D();
        pinJoint.getOffset((Vector3DBasics)offset);
        offsetToCoM.sub((Tuple3DReadOnly)offset);
        Vector3D temp3 = new Vector3D((Tuple3DReadOnly)jointAxis);
        temp3.scale(offsetToCoM.dot((Vector3DReadOnly)jointAxis));
        Vector3D comToJointAxis = new Vector3D();
        comToJointAxis.sub((Tuple3DReadOnly)offsetToCoM, (Tuple3DReadOnly)temp3);
        double distanceToJointAxis = comToJointAxis.length();
        double scalarInertiaAboutJointAxis = scalarInertiaAboutCoM + mass * distanceToJointAxis * distanceToJointAxis;
        return scalarInertiaAboutJointAxis;
    }

    private void sleepIfShowingGUI() throws InterruptedException {
    }

    private static Link link11(Random random, double l1, double r1) {
        Link ret = new Link("link11");
        ret.setMass(random.nextDouble());
        ret.setComOffset(0.0, 0.0, -l1 / 2.0);
        ret.setMomentOfInertia((Matrix3DReadOnly)RobotTest.getRotationalInertiaMatrixOfSolidEllipsoid(ret.getMass(), r1, r1, l1 / 2.0));
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        RobotTest.createInertiaEllipsoid(ret, linkGraphics, YoAppearance.Red());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    public static void createInertiaEllipsoid(Link ret, Graphics3DObject linkGraphics, AppearanceDefinition appearance) {
        Matrix3D momentOfInertia = new Matrix3D();
        ret.getMomentOfInertia((Matrix3DBasics)momentOfInertia);
        Vector3D comOffset = new Vector3D();
        ret.getComOffset((Vector3DBasics)comOffset);
        double mass = ret.getMass();
        linkGraphics.createInertiaEllipsoid((Matrix3DReadOnly)momentOfInertia, (Vector3DReadOnly)comOffset, mass, appearance);
    }

    private static Link link21(Random random, double l2, double r2) {
        Link ret = new Link("link2");
        ret.setMass(random.nextDouble());
        ret.setComOffset(0.0, 0.0, l2 / 2.0);
        ret.setMomentOfInertia((Matrix3DReadOnly)RobotTest.getRotationalInertiaMatrixOfSolidEllipsoid(ret.getMass(), r2, r2, l2 / 2.0));
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        RobotTest.createInertiaEllipsoid(ret, linkGraphics, YoAppearance.Orange());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private static Link link22(Link link21) {
        Link ret = new Link("link22");
        ret.setComOffset((Vector3DReadOnly)link21.getComOffset());
        ret.setMass(link21.getMass());
        Matrix3D link2moi = new Matrix3D();
        link21.getMomentOfInertia((Matrix3DBasics)link2moi);
        ret.setMomentOfInertia((Matrix3DReadOnly)link2moi);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        RobotTest.createInertiaEllipsoid(ret, linkGraphics, YoAppearance.Aqua());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private static Link link12(Link link11, PinJoint pin1) {
        Link ret = new Link("link12");
        Vector3D comOffset12 = new Vector3D((Tuple3DReadOnly)link11.getComOffset());
        Vector3D offset = new Vector3D();
        pin1.getOffset((Vector3DBasics)offset);
        comOffset12.sub((Tuple3DReadOnly)offset);
        ret.setComOffset((Vector3DReadOnly)comOffset12);
        ret.setMass(link11.getMass());
        Matrix3D link1moi = new Matrix3D();
        link11.getMomentOfInertia((Matrix3DBasics)link1moi);
        ret.setMomentOfInertia((Matrix3DReadOnly)link1moi);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        RobotTest.createInertiaEllipsoid(ret, linkGraphics, YoAppearance.Blue());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private static Link randomBody(Random random) {
        Link ret = new Link("floatingBody");
        ret.setMass(random.nextDouble());
        ret.setComOffset(random.nextDouble(), random.nextDouble(), random.nextDouble());
        ret.setMomentOfInertia((Matrix3DReadOnly)RobotTest.getRotationalInertiaMatrixOfSolidEllipsoid(ret.getMass(), random.nextDouble(), random.nextDouble(), random.nextDouble()));
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        RobotTest.createInertiaEllipsoid(ret, linkGraphics, YoAppearance.Orange());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private static Link randomBodyNoYCoMOffset(Random random) {
        Link ret = new Link("floatingBody");
        ret.setMass(random.nextDouble());
        ret.setComOffset(random.nextDouble(), 0.0, random.nextDouble());
        ret.setMomentOfInertia((Matrix3DReadOnly)RobotTest.getRotationalInertiaMatrixOfSolidEllipsoid(ret.getMass(), random.nextDouble(), random.nextDouble(), random.nextDouble()));
        Graphics3DObject linkGraphics = new Graphics3DObject();
        linkGraphics.addCoordinateSystem(0.3);
        RobotTest.createInertiaEllipsoid(ret, linkGraphics, YoAppearance.Orange());
        ret.setLinkGraphics(linkGraphics);
        return ret;
    }

    private Link massiveLink() {
        Link ret = new Link("massiveLink");
        ret.setMass(1.0E12);
        ret.setMomentOfInertia(1.0E8, 1.0E8, 1.0E8);
        return ret;
    }

    private static Point3D computeCoM(Robot robot) {
        Point3D com = new Point3D();
        robot.computeCenterOfMass((Point3DBasics)com);
        return com;
    }

    private static Vector3D computeLinearMomentum(Robot robot) {
        Vector3D linearMomentum = new Vector3D();
        robot.computeLinearMomentum((Vector3DBasics)linearMomentum);
        return linearMomentum;
    }

    private static Vector3D computeAngularMomentum(Robot robot) {
        Vector3D angularMomentum = new Vector3D();
        robot.computeAngularMomentum((Vector3DBasics)angularMomentum);
        return angularMomentum;
    }

    @Test
    public void testFreezeJointAtZero() throws UnreasonableAccelerationException {
        Robot robot = new Robot("robot");
        Vector3D jointOffset1 = new Vector3D(0.12, 1.17, 3.125);
        double mass1 = 1.12;
        Vector3D comOffset1 = new Vector3D(0.1, 1.11, 3.79);
        Matrix3D momentOfInertia1 = new Matrix3D();
        momentOfInertia1.setM00(1.95);
        momentOfInertia1.setM11(3.93);
        momentOfInertia1.setM22(7.91);
        Vector3D jointOffset2 = new Vector3D(-0.4, 1.76, 1.1);
        double mass2 = 1.12;
        Vector3D comOffset2 = new Vector3D();
        Matrix3D momentOfInertia2 = new Matrix3D();
        momentOfInertia1.setM00(51.95);
        momentOfInertia1.setM11(0.93);
        momentOfInertia1.setM22(7.51);
        SliderJoint joint1 = new SliderJoint("joint1", (Tuple3DReadOnly)jointOffset1, robot, (Vector3DReadOnly)Axis3D.X);
        Link link1 = new Link("link1");
        link1.setMass(mass1);
        link1.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia1);
        link1.setComOffset((Vector3DReadOnly)comOffset1);
        joint1.setLink(link1);
        PinJoint joint2 = new PinJoint("joint2", (Tuple3DReadOnly)jointOffset2, robot, (Vector3DReadOnly)Axis3D.X);
        Link link2 = new Link("link2");
        link2.setMass(mass2);
        link2.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia2);
        link2.setComOffset((Vector3DReadOnly)comOffset2);
        joint2.setLink(link2);
        robot.addRootJoint((Joint)joint1);
        joint1.addJoint((Joint)joint2);
        robot.freezeJointAtZero((Joint)joint2);
        Point3D comPoint = new Point3D();
        double totalMass = robot.computeCenterOfMass((Point3DBasics)comPoint);
        double epsilon = 1.0E-7;
        Assert.assertEquals(mass1 + mass2, totalMass, epsilon);
        Vector3D jointOffset = new Vector3D();
        joint1.getOffset((Vector3DBasics)jointOffset);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)jointOffset1, (Tuple3DReadOnly)jointOffset, (double)epsilon);
        Link link = joint1.getLink();
        Vector3D comOffset = new Vector3D();
        link.getComOffset((Vector3DBasics)comOffset);
        Vector3D temp = new Vector3D((Tuple3DReadOnly)comOffset1);
        temp.scale(mass1);
        Vector3D expectedCoMOffset = new Vector3D((Tuple3DReadOnly)temp);
        temp.set(comOffset2);
        temp.add((Tuple3DReadOnly)jointOffset2);
        temp.scale(mass2);
        expectedCoMOffset.add((Tuple3DReadOnly)temp);
        expectedCoMOffset.scale(1.0 / (mass1 + mass2));
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)expectedCoMOffset, (Tuple3DReadOnly)comOffset, (double)epsilon);
        Matrix3D momentOfInertia = new Matrix3D();
        link.getMomentOfInertia((Matrix3DBasics)momentOfInertia);
        Matrix3D expectedMomentOfInertia = new Matrix3D();
        Vector3D deltaR1 = new Vector3D();
        deltaR1.sub((Tuple3DReadOnly)comOffset, (Tuple3DReadOnly)comOffset1);
        Matrix3D tempMatrix = new Matrix3D();
        this.parallelAxisTheorem(momentOfInertia1, mass1, deltaR1, tempMatrix);
        expectedMomentOfInertia.set(tempMatrix);
        Vector3D deltaR2 = new Vector3D();
        deltaR2.sub((Tuple3DReadOnly)comOffset, (Tuple3DReadOnly)comOffset2);
        deltaR2.sub((Tuple3DReadOnly)jointOffset2);
        this.parallelAxisTheorem(momentOfInertia2, mass2, deltaR2, tempMatrix);
        expectedMomentOfInertia.add((Matrix3DReadOnly)tempMatrix);
        EuclidCoreTestTools.assertMatrix3DEquals((String)"", (Matrix3DReadOnly)expectedMomentOfInertia, (Matrix3DReadOnly)momentOfInertia, (double)epsilon);
        Robot expectedRobot = new Robot("expectedRobot");
        SliderJoint expectedJoint = new SliderJoint("expected", (Tuple3DReadOnly)jointOffset, expectedRobot, (Vector3DReadOnly)Axis3D.X);
        Link expectedLink = new Link("expectedLink");
        expectedLink.setMass(totalMass);
        expectedLink.setComOffset((Vector3DReadOnly)expectedCoMOffset);
        expectedLink.setMomentOfInertia((Matrix3DReadOnly)expectedMomentOfInertia);
        expectedJoint.setLink(expectedLink);
        expectedRobot.addRootJoint((Joint)expectedJoint);
        double qInitial = 0.35;
        double qdInitial = -1.11;
        expectedJoint.setInitialState(qInitial, qdInitial);
        joint1.setInitialState(qInitial, qdInitial);
        double dt = 1.0E-4;
        for (int i = 0; i < 1000; ++i) {
            robot.doDynamicsAndIntegrate(dt);
            expectedRobot.doDynamicsAndIntegrate(dt);
        }
        Assert.assertFalse(Double.isNaN(expectedJoint.getQYoVariable().getDoubleValue()));
        Assert.assertEquals(expectedJoint.getQYoVariable().getDoubleValue(), joint1.getQYoVariable().getDoubleValue(), epsilon);
        Assert.assertEquals(expectedJoint.getQDYoVariable().getDoubleValue(), joint1.getQDYoVariable().getDoubleValue(), epsilon);
        Assert.assertEquals(expectedJoint.getQDDYoVariable().getDoubleValue(), joint1.getQDDYoVariable().getDoubleValue(), epsilon);
    }

    @Test
    public void testFreezeJointAtZeroTwo() throws UnreasonableAccelerationException {
        Robot robotOne = this.createTestRobot();
        Robot robotTwo = this.createTestRobot();
        FloatingJoint rootJointOne = (FloatingJoint)robotOne.getRootJoints().get(0);
        ArrayList childrenJointsOne = new ArrayList();
        rootJointOne.getChildrenJoints(childrenJointsOne);
        robotOne.freezeJointAtZero((Joint)childrenJointsOne.get(0));
        robotOne.freezeJointAtZero((Joint)childrenJointsOne.get(1));
        FloatingJoint rootJointTwo = (FloatingJoint)robotTwo.getRootJoints().get(0);
        ArrayList childrenJointsTwo = new ArrayList();
        rootJointTwo.getChildrenJoints(childrenJointsTwo);
        robotOne.freezeJointAtZero((Joint)childrenJointsTwo.get(0));
        robotOne.freezeJointAtZero((Joint)childrenJointsTwo.get(1));
        Vector3D positionOne = new Vector3D(3.4, 5.7, 2.2);
        Vector3D velocityOne = new Vector3D(12.4, 15.9, 0.2);
        rootJointOne.setPosition((Tuple3DReadOnly)positionOne);
        rootJointOne.setVelocity((Tuple3DReadOnly)velocityOne);
        Vector3D positionTwo = new Vector3D((Tuple3DReadOnly)positionOne);
        Vector3D velocityTwo = new Vector3D((Tuple3DReadOnly)velocityOne);
        rootJointTwo.setPosition((Tuple3DReadOnly)positionTwo);
        rootJointTwo.setVelocity((Tuple3DReadOnly)velocityTwo);
        double dt = 1.0E-4;
        double epsilon = 1.0E-7;
        for (int i = 0; i < 1000; ++i) {
            robotOne.doDynamicsAndIntegrate(dt);
            robotTwo.doDynamicsAndIntegrate(dt);
        }
        rootJointOne.getPositionAndVelocity((Tuple3DBasics)positionOne, (Tuple3DBasics)velocityOne);
        rootJointTwo.getPositionAndVelocity((Tuple3DBasics)positionTwo, (Tuple3DBasics)velocityTwo);
        Assert.assertFalse(Double.isNaN(positionOne.getX()));
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)positionOne, (Tuple3DReadOnly)positionTwo, (double)epsilon);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)velocityOne, (Tuple3DReadOnly)velocityTwo, (double)epsilon);
    }

    private Robot createTestRobot() {
        Robot robot = new Robot("robot");
        Vector3D rootOffset = new Vector3D(5.12, 6.17, 7.125);
        double rootMass = 10.12;
        Vector3D rootCoMOffset = new Vector3D(2.1, -1.11, 3.72);
        Matrix3D rootMomentOfInertia = new Matrix3D();
        rootMomentOfInertia.setM00(71.95);
        rootMomentOfInertia.setM11(83.93);
        rootMomentOfInertia.setM22(97.91);
        FloatingJoint rootJoint = new FloatingJoint("root", (Tuple3DReadOnly)rootOffset, robot);
        Link rootLink = new Link("rootLink");
        rootLink.setMass(rootMass);
        rootLink.setComOffset((Vector3DReadOnly)rootCoMOffset);
        rootLink.setMomentOfInertia((Matrix3DReadOnly)rootMomentOfInertia);
        rootJoint.setLink(rootLink);
        robot.addRootJoint((Joint)rootJoint);
        Vector3D jointOffset1 = new Vector3D(0.12, 1.17, 3.125);
        double mass1 = 1.12;
        Vector3D comOffset1 = new Vector3D(0.1, 1.11, 3.79);
        Matrix3D momentOfInertia1 = new Matrix3D();
        momentOfInertia1.setM00(1.95);
        momentOfInertia1.setM11(3.93);
        momentOfInertia1.setM22(7.91);
        Vector3D jointOffset2 = new Vector3D(-0.4, 1.76, 1.1);
        double mass2 = 1.12;
        Vector3D comOffset2 = new Vector3D();
        Matrix3D momentOfInertia2 = new Matrix3D();
        momentOfInertia1.setM00(51.95);
        momentOfInertia1.setM11(0.93);
        momentOfInertia1.setM22(7.51);
        PinJoint joint1 = new PinJoint("joint1", (Tuple3DReadOnly)jointOffset1, robot, (Vector3DReadOnly)Axis3D.X);
        Link link1 = new Link("link1");
        link1.setMass(mass1);
        link1.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia1);
        link1.setComOffset((Vector3DReadOnly)comOffset1);
        joint1.setLink(link1);
        PinJoint joint2 = new PinJoint("joint2", (Tuple3DReadOnly)jointOffset2, robot, (Vector3DReadOnly)Axis3D.X);
        Link link2 = new Link("link2");
        link2.setMass(mass2);
        link2.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia2);
        link2.setComOffset((Vector3DReadOnly)comOffset2);
        joint2.setLink(link2);
        rootJoint.addJoint((Joint)joint1);
        rootJoint.addJoint((Joint)joint2);
        return robot;
    }

    private void parallelAxisTheorem(Matrix3D inputInertia, double mass, Vector3D vector1, Matrix3D outputInertia) {
        outputInertia.set(inputInertia);
        double dotProduct = vector1.dot((Vector3DReadOnly)vector1);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double elementValueAdjustment = 0.0;
                if (i == j) {
                    elementValueAdjustment = dotProduct;
                }
                elementValueAdjustment -= this.getElement(i, (Tuple3DBasics)vector1) * this.getElement(j, (Tuple3DBasics)vector1);
                double elementValue = outputInertia.getElement(i, j);
                outputInertia.setElement(i, j, elementValue += (elementValueAdjustment *= mass));
            }
        }
    }

    private double getElement(int index, Tuple3DBasics tuple) {
        if (index == 0) {
            return tuple.getX();
        }
        if (index == 1) {
            return tuple.getY();
        }
        if (index == 2) {
            return tuple.getZ();
        }
        throw new RuntimeException();
    }

    @Test
    public void testChangeLinkParameters() throws UnreasonableAccelerationException {
        Vector3D jointOffset1 = new Vector3D(0.12, 1.17, 3.125);
        double mass1 = 1.12;
        Vector3D comOffset1 = new Vector3D(0.1, 1.11, 3.79);
        Matrix3D momentOfInertia1 = new Matrix3D();
        momentOfInertia1.setM00(1.95);
        momentOfInertia1.setM11(3.93);
        momentOfInertia1.setM22(7.91);
        Vector3D jointOffset2 = new Vector3D(-0.4, 1.76, 1.1);
        double mass2 = 3.14;
        Vector3D comOffset2 = new Vector3D(0.1, 0.2, -1.79);
        Matrix3D momentOfInertia2 = new Matrix3D();
        momentOfInertia2.setM00(5.95);
        momentOfInertia2.setM11(0.93);
        momentOfInertia2.setM22(7.51);
        Vector3D jointOffset3 = new Vector3D(-0.33, 1.71, 2.1);
        double mass3 = 4.12;
        Vector3D comOffset3 = new Vector3D(0.2, 0.3, 12.79);
        Matrix3D momentOfInertia3 = new Matrix3D();
        momentOfInertia3.setM00(3.33);
        momentOfInertia3.setM11(7.7);
        momentOfInertia3.setM22(0.8);
        Robot robotOne = new Robot("robotOne");
        PinJoint joint1 = new PinJoint("joint1", (Tuple3DReadOnly)jointOffset1, robotOne, (Vector3DReadOnly)Axis3D.X);
        Link link1 = new Link("link1");
        link1.setMass(mass1);
        link1.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia1);
        link1.setComOffset((Vector3DReadOnly)comOffset1);
        joint1.setLink(link1);
        PinJoint joint2 = new PinJoint("joint2", (Tuple3DReadOnly)jointOffset2, robotOne, (Vector3DReadOnly)Axis3D.Y);
        Link link2 = new Link("link2");
        link2.setMass(mass2);
        link2.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia2);
        link2.setComOffset((Vector3DReadOnly)comOffset2);
        joint2.setLink(link2);
        PinJoint joint3 = new PinJoint("joint3", (Tuple3DReadOnly)jointOffset3, robotOne, (Vector3DReadOnly)Axis3D.Y);
        Link link3 = new Link("link3");
        link3.setMass(mass3);
        link3.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia3);
        link3.setComOffset((Vector3DReadOnly)comOffset3);
        joint3.setLink(link3);
        robotOne.addRootJoint((Joint)joint1);
        joint1.addJoint((Joint)joint2);
        joint2.addJoint((Joint)joint3);
        jointOffset1.scale(0.77);
        joint1.setOffset((Tuple3DReadOnly)jointOffset1);
        comOffset1.scale(0.33);
        momentOfInertia1.scale(0.789);
        link1.setMass(mass1 *= 1.5);
        link1.setComOffset((Vector3DReadOnly)comOffset1);
        link1.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia1);
        jointOffset2.scale(3.33);
        joint2.setOffset((Tuple3DReadOnly)jointOffset2);
        comOffset2.scale(3.91);
        momentOfInertia2.scale(3.33);
        Link newLink2 = new Link(joint2.getLink().getName());
        newLink2.setMass(mass2 += 4.5);
        newLink2.setComOffset((Vector3DReadOnly)comOffset2);
        newLink2.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia2);
        joint2.setLink(newLink2);
        jointOffset3.scale(0.33);
        joint3.setOffset((Tuple3DReadOnly)jointOffset3);
        comOffset3.scale(2.33);
        momentOfInertia3.scale(4.789);
        link3.setMass(mass3 += 11.5);
        link3.setComOffset((Vector3DReadOnly)comOffset3);
        link3.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia3);
        Robot robotTwo = new Robot("robotTwo");
        PinJoint joint1B = new PinJoint("joint1", (Tuple3DReadOnly)jointOffset1, robotTwo, (Vector3DReadOnly)Axis3D.X);
        Link link1B = new Link("link1");
        link1B.setMass(mass1);
        link1B.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia1);
        link1B.setComOffset((Vector3DReadOnly)comOffset1);
        joint1B.setLink(link1B);
        PinJoint joint2B = new PinJoint("joint2", (Tuple3DReadOnly)jointOffset2, robotTwo, (Vector3DReadOnly)Axis3D.Y);
        Link link2B = new Link("link2");
        link2B.setMass(mass2);
        link2B.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia2);
        link2B.setComOffset((Vector3DReadOnly)comOffset2);
        joint2B.setLink(link2B);
        PinJoint joint3B = new PinJoint("joint3", (Tuple3DReadOnly)jointOffset3, robotTwo, (Vector3DReadOnly)Axis3D.Y);
        Link link3B = new Link("link3");
        link3B.setMass(mass3);
        link3B.setMomentOfInertia((Matrix3DReadOnly)momentOfInertia3);
        link3B.setComOffset((Vector3DReadOnly)comOffset3);
        joint3B.setLink(link3B);
        robotTwo.addRootJoint((Joint)joint1B);
        joint1B.addJoint((Joint)joint2B);
        joint2B.addJoint((Joint)joint3B);
        joint1.setInitialState(0.11, 0.33);
        joint2.setInitialState(0.15, 0.34);
        joint1.setTau(7.7);
        joint2.setTau(4.0);
        joint1B.setInitialState(0.11, 0.33);
        joint2B.setInitialState(0.15, 0.34);
        joint1B.setTau(7.7);
        joint2B.setTau(4.0);
        double DT = 1.0E-5;
        for (int i = 0; i < 100; ++i) {
            robotOne.doDynamicsAndIntegrate(DT);
            robotTwo.doDynamicsAndIntegrate(DT);
        }
        double epsilon = 1.0E-7;
        Assert.assertFalse(Double.isNaN(joint1.getQYoVariable().getDoubleValue()));
        Assert.assertEquals(joint1.getQYoVariable().getDoubleValue(), joint1B.getQYoVariable().getDoubleValue(), epsilon);
        Assert.assertEquals(joint1.getQDYoVariable().getDoubleValue(), joint1B.getQDYoVariable().getDoubleValue(), epsilon);
        Assert.assertEquals(joint1.getQDDYoVariable().getDoubleValue(), joint1B.getQDDYoVariable().getDoubleValue(), epsilon);
        Assert.assertEquals(joint2.getQYoVariable().getDoubleValue(), joint2B.getQYoVariable().getDoubleValue(), epsilon);
        Assert.assertEquals(joint2.getQDYoVariable().getDoubleValue(), joint2B.getQDYoVariable().getDoubleValue(), epsilon);
        Assert.assertEquals(joint2.getQDDYoVariable().getDoubleValue(), joint2B.getQDDYoVariable().getDoubleValue(), epsilon);
    }

    @Test
    public void testConservationOfEnergyAndMomentum() throws UnreasonableAccelerationException {
        String name = "robot";
        boolean startWithFloatingJoint = true;
        int numberOfPinJoints = 4;
        Random random = new Random(1776L);
        Robot robot = RandomRobotGenerator.generateRandomLinearChainRobot((String)name, (boolean)startWithFloatingJoint, (int)numberOfPinJoints, (Random)random);
        robot.setGravity(0.0, 0.0, 0.0);
        RandomRobotGenerator.setRandomJointPositions((Robot)robot, (Random)random);
        RandomRobotGenerator.setRandomJointVelocities((Robot)robot, (Random)random);
        double simulateDT = 1.0E-5;
        int numberOfTicksToSimulate = 8000;
        Object scs = null;
        Vector3D angularMomentumStart = new Vector3D();
        Vector3D linearMomentumStart = new Vector3D();
        robot.doDynamicsAndIntegrate(simulateDT);
        robot.update();
        robot.computeAngularMomentum((Vector3DBasics)angularMomentumStart);
        robot.computeLinearMomentum((Vector3DBasics)linearMomentumStart);
        double translationalKineticEnergyStart = robot.computeTranslationalKineticEnergy();
        double rotationalKineticEnergyStart = robot.computeRotationalKineticEnergy();
        double totalEnergyStart = translationalKineticEnergyStart + rotationalKineticEnergyStart;
        YoRegistry registry = robot.getRobotsYoRegistry();
        YoDouble translationalKineticEnergy = new YoDouble("translationalKineticEnergy", registry);
        YoDouble rotationalKineticEnergy = new YoDouble("rotationalKineticEnergy", registry);
        YoDouble totalEnergy = new YoDouble("totalEnergy", registry);
        YoFrameVector3D angularMomentum = new YoFrameVector3D("angularMomentum", ReferenceFrame.getWorldFrame(), registry);
        YoFrameVector3D linearMomentum = new YoFrameVector3D("linearMomentum", ReferenceFrame.getWorldFrame(), registry);
        Vector3D temp = new Vector3D();
        for (int i = 0; i < numberOfTicksToSimulate; ++i) {
            translationalKineticEnergy.set(robot.computeTranslationalKineticEnergy());
            rotationalKineticEnergy.set(robot.computeRotationalKineticEnergy());
            totalEnergy.set(translationalKineticEnergy.getDoubleValue() + rotationalKineticEnergy.getDoubleValue());
            robot.computeAngularMomentum((Vector3DBasics)temp);
            angularMomentum.set((Tuple3DReadOnly)temp);
            robot.computeLinearMomentum((Vector3DBasics)temp);
            linearMomentum.set((Tuple3DReadOnly)temp);
            robot.updateVelocities();
            robot.doDynamicsAndIntegrate(simulateDT);
            robot.update();
        }
        Vector3D angularMomentumEnd = new Vector3D();
        Vector3D linearMomentumEnd = new Vector3D();
        robot.computeAngularMomentum((Vector3DBasics)angularMomentumEnd);
        robot.computeLinearMomentum((Vector3DBasics)linearMomentumEnd);
        double translationalKineticEnergyEnd = robot.computeTranslationalKineticEnergy();
        double rotationalKineticEnergyEnd = robot.computeRotationalKineticEnergy();
        double totalEnergyEnd = translationalKineticEnergyEnd + rotationalKineticEnergyEnd;
        double epsilon = 1.0E-7;
        Assert.assertEquals("Total energy must be conserved", totalEnergyStart, totalEnergyEnd, epsilon);
        epsilon = 6.0E-5;
        EuclidCoreTestTools.assertTuple3DEquals((String)"Angular momentum should be conserved", (Tuple3DReadOnly)angularMomentumStart, (Tuple3DReadOnly)angularMomentumEnd, (double)epsilon);
        EuclidCoreTestTools.assertTuple3DEquals((String)"Linear momentum should be conserved", (Tuple3DReadOnly)linearMomentumStart, (Tuple3DReadOnly)linearMomentumEnd, (double)epsilon);
    }

    public static Matrix3D getRotationalInertiaMatrixOfSolidEllipsoid(double mass, double xRadius, double yRadius, double zRadius) {
        double ixx = 0.2 * mass * (yRadius * yRadius + zRadius * zRadius);
        double iyy = 0.2 * mass * (zRadius * zRadius + xRadius * xRadius);
        double izz = 0.2 * mass * (xRadius * xRadius + yRadius * yRadius);
        Matrix3D ret = new Matrix3D();
        ret.setM00(ixx);
        ret.setM11(iyy);
        ret.setM22(izz);
        return ret;
    }
}

