/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.ShipCorridorGroundProfile;

public class ShipCorridorGroundProfileTest {
    private ShipCorridorGroundProfile groundProfile;
    private final double epsilon = 1.0E-6;
    private final boolean debug = false;

    @BeforeEach
    public void setUp() {
        this.groundProfile = new ShipCorridorGroundProfile(100.0, -10.0, 5.0, -5.0, 0.8, -0.8, 0.0, 3.0, Math.toRadians(2.0));
    }

    @Test
    public void testSurfaceNormalAlongYAxis() {
        int nSteps = 1000;
        BoundingBox3D boundingBox = this.groundProfile.getBoundingBox();
        double yStep = (boundingBox.getMaxY() - boundingBox.getMinY()) / (double)nSteps;
        double dy = 1.0E-8;
        double x = (boundingBox.getMaxX() - boundingBox.getMinX()) / 2.0;
        double z = 0.0;
        double y = -2.5;
        for (int i = 0; i < nSteps; ++i) {
            double initialHeight = this.groundProfile.heightAt(x, y += yStep, z);
            double finalHeight = this.groundProfile.heightAt(x, y + yStep, z);
            if (!(y + yStep < 5.0)) continue;
            double dzdy = (this.groundProfile.heightAt(x, y + yStep, z) - this.groundProfile.heightAt(x, y, z)) / yStep;
            Vector3D numericalSurfaceNormal = new Vector3D(0.0, -dzdy, 1.0);
            numericalSurfaceNormal.normalize();
            Vector3D surfaceNormalFromGroundProfile = new Vector3D();
            Point3D intersection = new Point3D();
            this.groundProfile.closestIntersectionAndNormalAt(x, y, z, (Point3DBasics)intersection, (Vector3DBasics)surfaceNormalFromGroundProfile);
            if (initialHeight == 3.0 && finalHeight != 3.0 || initialHeight != 3.0 && finalHeight == 3.0 || initialHeight != 0.0 && finalHeight == 0.0 || initialHeight == 0.0 && finalHeight != 0.0) {
                surfaceNormalFromGroundProfile.setX(0.0);
                surfaceNormalFromGroundProfile.setY(0.0);
                surfaceNormalFromGroundProfile.setZ(1.0);
                numericalSurfaceNormal.setX(0.0);
                numericalSurfaceNormal.setY(0.0);
                numericalSurfaceNormal.setZ(1.0);
            }
            EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)numericalSurfaceNormal, (Tuple3DReadOnly)surfaceNormalFromGroundProfile, (double)1.0E-6);
        }
    }
}

