/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.microbenchmarks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import us.ihmc.commons.Conversions;

public class BenchmarkFieldOrArrayAccess {
    private static final int ITERATIONS = 1000000;
    private static final int TESTS = 100;
    private static final boolean USE_COMMON_STORAGE = true;
    private final long[] randomVariables = new long[1000000];
    private final Access[] testLongAccess = new Access[1000000];
    private final int[] accessArray = new int[1000000];

    public static void main(String[] args) {
        new BenchmarkFieldOrArrayAccess();
    }

    public BenchmarkFieldOrArrayAccess() {
        int i;
        Class[] classes = new Class[]{ArrayAccess.class, PrimitiveAccess.class};
        ArrayList<Integer> access = new ArrayList<Integer>();
        for (i = 0; i < 1000000; ++i) {
            access.add(i);
        }
        Collections.shuffle(access);
        for (i = 0; i < 1000000; ++i) {
            this.accessArray[i] = (Integer)access.get(i);
        }
        String res = new String();
        for (Class clazz : classes) {
            long writeTime = 0L;
            long readTime = 0L;
            for (int i2 = 0; i2 < 100; ++i2) {
                this.generateData(clazz);
                long start = System.nanoTime();
                this.testWriteAccess();
                if (i2 >= 50) {
                    writeTime += System.nanoTime() - start;
                }
                start = System.nanoTime();
                long testValue = this.testReadAccess();
                if (i2 >= 50) {
                    readTime += System.nanoTime() - start;
                }
                System.out.println("Test " + i2 + " returned " + testValue);
            }
            res = res + "Writing 1000000 of " + clazz.getSimpleName() + " averaged " + Conversions.nanosecondsToSeconds((long)(writeTime / 50L)) + "s" + System.lineSeparator();
            res = res + "Reading 1000000 of " + clazz.getSimpleName() + " averaged " + Conversions.nanosecondsToSeconds((long)(readTime / 50L)) + "s" + System.lineSeparator();
        }
        System.out.println(res);
    }

    private void generateData(Class<?> clazz) {
        Random random = new Random();
        for (int i = 0; i < this.randomVariables.length; ++i) {
            this.randomVariables[i] = random.nextLong();
            try {
                this.testLongAccess[i] = (Access)clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            random = new Random();
        }
        if (clazz == ArrayAccess.class) {
            long[] backingArray = new long[this.randomVariables.length];
            for (int i = 0; i < this.randomVariables.length; ++i) {
                ((ArrayAccess)this.testLongAccess[i]).setBackingArray(backingArray, i);
            }
        }
    }

    public void testWriteAccess() {
        for (int i = 0; i < this.randomVariables.length; ++i) {
            this.testLongAccess[this.accessArray[i]].setValue(this.randomVariables[i]);
        }
    }

    public long testReadAccess() {
        long xor = 0L;
        for (int i = 0; i < this.randomVariables.length; ++i) {
            xor ^= this.testLongAccess[this.accessArray[i]].getValue();
        }
        return xor;
    }

    public static class ArrayAccess
    implements Access {
        private int index = 0;
        private long[] value = new long[1];

        @Override
        public void setValue(long value) {
            this.value[this.index] = value;
        }

        @Override
        public long getValue() {
            return this.value[this.index];
        }

        public void setBackingArray(long[] backingArray, int index) {
            this.value = backingArray;
            this.index = index;
        }
    }

    public static class PrimitiveAccess
    implements Access {
        private long value;

        @Override
        public void setValue(long value) {
            this.value = value;
        }

        @Override
        public long getValue() {
            return this.value;
        }
    }

    public static interface Access {
        public void setValue(long var1);

        public long getValue();
    }
}

