/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem;

import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.CrossFourBarJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.yoVariables.multiBodySystem.YoCrossFourBarJoint;
import us.ihmc.scs2.definition.robot.CrossFourBarJointDefinition;
import us.ihmc.scs2.simulation.robot.SimJointAuxiliaryData;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimCrossFourBarJoint
extends YoCrossFourBarJoint
implements SimOneDoFJointBasics,
CrossFourBarJointBasics {
    private final YoRegistry registry;
    private final SimJointAuxiliaryData auxiliaryData;
    private final TwistReadOnly jointDeltaTwist;
    private final YoDouble deltaQd;
    private final YoBoolean isPinned;
    private final YoDouble damping;

    public SimCrossFourBarJoint(CrossFourBarJointDefinition definition, SimRigidBodyBasics predecessor) {
        this(definition.getName(), predecessor, definition.getJointNameA(), definition.getJointNameB(), definition.getJointNameC(), definition.getJointNameD(), definition.getBodyDA().getName(), definition.getBodyBC().getName(), (RigidBodyTransformReadOnly)definition.getTransformAToPredecessor(), (RigidBodyTransformReadOnly)definition.getTransformBToPredecessor(), (RigidBodyTransformReadOnly)definition.getTransformCToB(), (RigidBodyTransformReadOnly)definition.getTransformDToA(), (Matrix3DReadOnly)definition.getBodyDA().getMomentOfInertia(), (Matrix3DReadOnly)definition.getBodyBC().getMomentOfInertia(), definition.getBodyDA().getMass(), definition.getBodyBC().getMass(), (RigidBodyTransformReadOnly)definition.getBodyDA().getInertiaPose(), (RigidBodyTransformReadOnly)definition.getBodyBC().getInertiaPose(), definition.getActuatedJointIndex(), definition.getLoopClosureJointIndex(), (Vector3DReadOnly)definition.getAxis());
        this.setJointLimits(definition.getPositionLowerLimit(), definition.getPositionUpperLimit());
        this.setVelocityLimits(definition.getVelocityLowerLimit(), definition.getVelocityUpperLimit());
        this.setEffortLimits(definition.getEffortLowerLimit(), definition.getEffortUpperLimit());
        this.setDamping(definition.getDamping());
    }

    public SimCrossFourBarJoint(String name, SimRigidBodyBasics predecessor, String jointNameA, String jointNameB, String jointNameC, String jointNameD, String bodyNameDA, String bodyNameBC, RigidBodyTransformReadOnly transformAToPredecessor, RigidBodyTransformReadOnly transformBToPredecessor, RigidBodyTransformReadOnly transformCToB, RigidBodyTransformReadOnly transformDToA, Matrix3DReadOnly bodyInertiaDA, Matrix3DReadOnly bodyInertiaBC, double bodyMassDA, double bodyMassBC, RigidBodyTransformReadOnly bodyInertiaPoseDA, RigidBodyTransformReadOnly bodyInertiaPoseBC, int actuatedJointIndex, int loopClosureJointIndex, Vector3DReadOnly jointAxis) {
        super(name, (RigidBodyBasics)predecessor, jointNameA, jointNameB, jointNameC, jointNameD, bodyNameDA, bodyNameBC, transformAToPredecessor, transformBToPredecessor, transformDToA, transformCToB, bodyInertiaDA, bodyInertiaBC, bodyMassDA, bodyMassBC, bodyInertiaPoseDA, bodyInertiaPoseBC, actuatedJointIndex, loopClosureJointIndex, jointAxis, predecessor.getRegistry());
        this.registry = predecessor.getRegistry();
        this.auxiliaryData = new SimJointAuxiliaryData(this);
        this.deltaQd = new YoDouble("qd_delta_" + this.getName(), this.registry);
        this.jointDeltaTwist = MecanoFactories.newTwistReadOnly(this::getDeltaQd, (TwistReadOnly)this.getUnitJointTwist());
        this.isPinned = new YoBoolean("is_" + this.getName() + "_pinned", this.registry);
        this.damping = new YoDouble("damping_" + this.getName(), this.registry);
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public SimJointAuxiliaryData getAuxiliaryData() {
        return this.auxiliaryData;
    }

    public void setSuccessor(RigidBodyBasics successor) {
        if (!(successor instanceof SimRigidBodyBasics)) {
            throw new IllegalArgumentException("Can only set a " + SimRigidBodyBasics.class.getSimpleName() + " as successor of a " + this.getClass().getSimpleName());
        }
        super.setSuccessor(successor);
    }

    @Override
    public SimRigidBodyBasics getPredecessor() {
        return (SimRigidBodyBasics)super.getPredecessor();
    }

    @Override
    public SimRigidBodyBasics getSuccessor() {
        return (SimRigidBodyBasics)super.getSuccessor();
    }

    public void setQ(double q) {
        if (!Double.isFinite(q)) {
            throw new IllegalStateException("Invalid joint configuration: " + q);
        }
        super.setQ(q);
    }

    public double computeActuatedJointQ(double q) {
        if (!Double.isFinite(q)) {
            throw new IllegalStateException("Invalid joint configuration: " + q);
        }
        double actuatedJointQ = super.computeActuatedJointQ(q);
        if (!Double.isFinite(actuatedJointQ)) {
            throw new IllegalStateException("Invalid joint configuration: " + actuatedJointQ);
        }
        return actuatedJointQ;
    }

    public double computeActuatedJointQdd(double qdd) {
        if (!Double.isFinite(qdd)) {
            throw new IllegalStateException("Invalid joint acceleration: " + qdd);
        }
        double actuatedJointQdd = super.computeActuatedJointQdd(qdd);
        if (!Double.isFinite(actuatedJointQdd)) {
            throw new IllegalStateException("Invalid joint acceleration: " + actuatedJointQdd);
        }
        return actuatedJointQdd;
    }

    @Override
    public double getDamping() {
        return this.damping.getValue();
    }

    @Override
    public void setDamping(double damping) {
        this.damping.set(damping);
    }

    @Override
    public double getDeltaQd() {
        return this.deltaQd.getValue();
    }

    @Override
    public void setDeltaQd(double deltaQd) {
        this.deltaQd.set(deltaQd);
    }

    @Override
    public void setJointAngularDeltaVelocity(Vector3DReadOnly jointAngularDeltaVelocity) {
        this.setDeltaQd(this.getJointAxis().dot((Tuple3DReadOnly)jointAngularDeltaVelocity));
    }

    @Override
    public void setJointLinearDeltaVelocity(Vector3DReadOnly jointLinearDeltaVelocity) {
    }

    @Override
    public TwistReadOnly getJointDeltaTwist() {
        return this.jointDeltaTwist;
    }

    @Override
    public void setPinned(boolean isPinned) {
        this.isPinned.set(isPinned);
    }

    @Override
    public boolean isPinned() {
        return this.isPinned.getValue();
    }
}

