/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.controller;

import us.ihmc.euclid.interfaces.Transformable;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.TupleTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.scs2.definition.controller.interfaces.Controller;
import us.ihmc.scs2.definition.robot.ExternalWrenchPointDefinition;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.trackers.ExternalWrenchPoint;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class LoopClosureSoftConstraintController
implements Controller {
    private String name;
    private YoVector3D proportionalGains;
    private YoVector3D derivativeGains;
    private final ExternalWrenchPointDefinition constraintDefinitionA;
    private final ExternalWrenchPointDefinition constraintDefinitionB;
    private ExternalWrenchPoint constraintA;
    private ExternalWrenchPoint constraintB;
    private YoDouble positionErrorMagnitude;
    private YoDouble rotationErrorMagnitude;
    private YoVector3D positionError;
    private YoVector3D rotationError;
    private YoVector3D linearVelocityError;
    private YoVector3D angularVelocityError;
    private YoVector3D feedForwardForce;
    private YoVector3D feedForwardMoment;
    private final Matrix3D constraintForceSubSpace = new Matrix3D();
    private final Matrix3D constraintMomentSubSpace = new Matrix3D();
    private final Vector3D proportionalTermLinear = new Vector3D();
    private final Vector3D derivativeTermLinear = new Vector3D();
    private final Vector3D proportionalTermAngular = new Vector3D();
    private final Vector3D derivativeTermAngular = new Vector3D();
    private SimJointBasics parentJoint;
    private final Quaternion quaternionDifference = new Quaternion();
    private final Vector3D force = new Vector3D();
    private final Vector3D moment = new Vector3D();
    private boolean isFirstUpdate = true;

    public LoopClosureSoftConstraintController(String name, RigidBodyTransformReadOnly transformToParentJoint, RigidBodyTransformReadOnly transformToSuccessorParentJoint, Matrix3DReadOnly constraintForceSubSpace, Matrix3DReadOnly constraintMomentSubSpace) {
        this.name = name;
        this.constraintForceSubSpace.set(constraintForceSubSpace);
        this.constraintMomentSubSpace.set(constraintMomentSubSpace);
        this.constraintDefinitionA = new ExternalWrenchPointDefinition(name + "A", transformToParentJoint);
        this.constraintDefinitionB = new ExternalWrenchPointDefinition(name + "B", transformToSuccessorParentJoint);
    }

    public void setGains(double proportionalGain, double derivativeGain) {
        this.proportionalGains.set(proportionalGain, proportionalGain, proportionalGain);
        this.derivativeGains.set(derivativeGain, derivativeGain, derivativeGain);
    }

    public void setGains(Tuple3DReadOnly proportionalGains, Tuple3DReadOnly derivativeGains) {
        this.proportionalGains.set(proportionalGains);
        this.derivativeGains.set(derivativeGains);
    }

    public void setParentJoint(SimJointBasics parentJoint) {
        this.parentJoint = parentJoint;
        this.constraintA = parentJoint.getAuxiliaryData().addExternalWrenchPoint(this.constraintDefinitionA);
        YoRegistry registry = parentJoint.getRegistry();
        this.proportionalGains = new YoVector3D(this.name + "ProportionalGain", registry);
        this.derivativeGains = new YoVector3D(this.name + "DerivativeGain", registry);
        this.positionErrorMagnitude = new YoDouble(this.name + "PositionErrorMagnitude", registry);
        this.rotationErrorMagnitude = new YoDouble(this.name + "RotationErrorMagnitude", registry);
        this.positionError = new YoVector3D(this.name + "PositionError", registry);
        this.rotationError = new YoVector3D(this.name + "RotationError", registry);
        this.linearVelocityError = new YoVector3D(this.name + "LinearVelocityError", registry);
        this.angularVelocityError = new YoVector3D(this.name + "AngularVelocityError", registry);
        this.feedForwardForce = new YoVector3D(this.name + "FeedForwardForce", registry);
        this.feedForwardMoment = new YoVector3D(this.name + "FeedForwardMoment", registry);
    }

    public void setSuccessor(SimRigidBodyBasics rigidBody) {
        this.constraintB = rigidBody.getParentJoint().getAuxiliaryData().addExternalWrenchPoint(this.constraintDefinitionB);
    }

    public void doControl() {
        if (this.isFirstUpdate) {
            if (this.proportionalGains.containsNaN() || this.derivativeGains.containsNaN()) {
                throw new IllegalArgumentException("The gains for the loop closure constraint: " + this.name + " have not been configured. If created from description, see: " + LoopClosureSoftConstraintController.class.getSimpleName());
            }
            if (TupleTools.isTupleZero((Tuple3DReadOnly)this.proportionalGains, (double)0.0) || TupleTools.isTupleZero((Tuple3DReadOnly)this.derivativeGains, (double)0.0)) {
                LogTools.warn((String)("The gains for the loop closure constraint: " + this.name + " have not been configured. If created from description, see: " + LoopClosureSoftConstraintController.class.getSimpleName()));
            }
            this.isFirstUpdate = false;
        }
        MovingReferenceFrame jointFrame = this.parentJoint.getFrameAfterJoint();
        ReferenceFrame rootFrame = jointFrame.getRootFrame();
        MovingReferenceFrame frameA = this.constraintA.getFrame();
        MovingReferenceFrame frameB = this.constraintB.getFrame();
        this.positionError.sub((Tuple3DReadOnly)this.constraintB.getPose().getPosition(), (Tuple3DReadOnly)this.constraintA.getPose().getPosition());
        rootFrame.transformFromThisToDesiredFrame((ReferenceFrame)frameA, (Transformable)this.positionError);
        this.constraintForceSubSpace.transform((Tuple3DBasics)this.positionError);
        this.positionErrorMagnitude.set(this.positionError.norm());
        this.quaternionDifference.difference((QuaternionReadOnly)this.constraintA.getPose().getOrientation(), (QuaternionReadOnly)this.constraintB.getPose().getOrientation());
        this.quaternionDifference.normalizeAndLimitToPi();
        this.quaternionDifference.getRotationVector((Vector3DBasics)this.rotationError);
        this.constraintMomentSubSpace.transform((Tuple3DBasics)this.rotationError);
        this.rotationErrorMagnitude.set(this.rotationError.norm());
        this.linearVelocityError.set((Tuple3DReadOnly)this.constraintB.getTwist().getLinearPart());
        frameB.transformFromThisToDesiredFrame((ReferenceFrame)frameA, (Transformable)this.linearVelocityError);
        this.linearVelocityError.sub((Tuple3DReadOnly)this.constraintA.getTwist().getLinearPart());
        this.constraintForceSubSpace.transform((Tuple3DBasics)this.linearVelocityError);
        this.angularVelocityError.set((Tuple3DReadOnly)this.constraintB.getTwist().getAngularPart());
        frameB.transformFromThisToDesiredFrame((ReferenceFrame)frameA, (Transformable)this.angularVelocityError);
        this.angularVelocityError.sub((Tuple3DReadOnly)this.constraintA.getTwist().getAngularPart());
        this.constraintMomentSubSpace.transform((Tuple3DBasics)this.angularVelocityError);
        this.proportionalTermLinear.set((Tuple3DReadOnly)this.positionError);
        this.proportionalTermLinear.scale(this.proportionalGains.getX(), this.proportionalGains.getY(), this.proportionalGains.getZ());
        this.proportionalTermAngular.set((Tuple3DReadOnly)this.rotationError);
        this.proportionalTermAngular.scale(this.proportionalGains.getX(), this.proportionalGains.getY(), this.proportionalGains.getZ());
        this.derivativeTermLinear.set((Tuple3DReadOnly)this.linearVelocityError);
        this.derivativeTermLinear.scale(this.derivativeGains.getX(), this.derivativeGains.getY(), this.derivativeGains.getZ());
        this.derivativeTermAngular.set((Tuple3DReadOnly)this.angularVelocityError);
        this.derivativeTermAngular.scale(this.derivativeGains.getX(), this.derivativeGains.getY(), this.derivativeGains.getZ());
        this.force.set(this.proportionalTermLinear);
        this.force.add((Tuple3DReadOnly)this.derivativeTermLinear);
        this.force.add((Tuple3DReadOnly)this.feedForwardForce);
        this.moment.set(this.proportionalTermAngular);
        this.moment.add((Tuple3DReadOnly)this.derivativeTermAngular);
        this.moment.add((Tuple3DReadOnly)this.feedForwardMoment);
        this.constraintA.getWrench().set((Vector3DReadOnly)this.moment, (Vector3DReadOnly)this.force);
        frameA.transformFromThisToDesiredFrame((ReferenceFrame)frameB, (Transformable)this.force);
        frameA.transformFromThisToDesiredFrame((ReferenceFrame)frameB, (Transformable)this.moment);
        this.force.negate();
        this.moment.negate();
        this.constraintB.getWrench().set((Vector3DReadOnly)this.moment, (Vector3DReadOnly)this.force);
    }

    public void setFeedForward(Vector3DReadOnly force, Vector3DReadOnly moment) {
        this.constraintForceSubSpace.transform((Tuple3DReadOnly)force, (Tuple3DBasics)this.feedForwardForce);
        this.constraintMomentSubSpace.transform((Tuple3DReadOnly)moment, (Tuple3DBasics)this.feedForwardMoment);
    }

    public String getName() {
        return this.name;
    }
}

