/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.screwTools;

import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FixedJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointBasics;
import us.ihmc.mecano.spatial.SpatialVector;
import us.ihmc.mecano.spatial.interfaces.FixedFrameSpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.FixedFrameTwistBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimFixedJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSphericalJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimMultiBodySystemBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;

public class SingleRobotFirstOrderIntegrator {
    private final Vector3D deltaPosition = new Vector3D();
    private final Vector3D rotationVector = new Vector3D();
    private final Quaternion orientationChange = new Quaternion();
    private final FrameVector3D linearAcceleration = new FrameVector3D();
    private final SpatialVector spatialVelocityChange = new SpatialVector();
    private final FrameVector3D angularVelocityChange = new FrameVector3D();

    public void integrate(double dt, SimMultiBodySystemBasics input) {
        List<? extends SimJointBasics> jointsToConsider = input.getJointsToConsider();
        for (SimJointBasics simJointBasics : jointsToConsider) {
            if (simJointBasics instanceof SimOneDoFJointBasics) {
                this.integrateOneDoFJoint(dt, (SimOneDoFJointBasics)simJointBasics);
                continue;
            }
            if (simJointBasics instanceof SimFloatingJointBasics) {
                this.integrateFloatingJoint(dt, (SimFloatingJointBasics)simJointBasics);
                continue;
            }
            if (simJointBasics instanceof SimSphericalJoint) {
                this.integrateSphericalJoint(dt, (SimSphericalJoint)simJointBasics);
                continue;
            }
            if (simJointBasics instanceof SimFixedJoint) continue;
            throw new UnsupportedOperationException("Unsupported joint " + String.valueOf(simJointBasics));
        }
    }

    public void integrate(double dt, DMatrixRMaj velocityChangeMatrix, MultiBodySystemBasics input) {
        List jointsToConsider = input.getJointsToConsider();
        int startIndex = 0;
        for (JointBasics joint : jointsToConsider) {
            if (joint instanceof OneDoFJointBasics) {
                double velocityChange = velocityChangeMatrix == null ? 0.0 : velocityChangeMatrix.get(startIndex);
                this.integrateOneDoFJoint(dt, (OneDoFJointBasics)joint, velocityChange);
            } else if (joint instanceof FloatingJointBasics) {
                if (velocityChangeMatrix == null) {
                    this.spatialVelocityChange.setToZero((ReferenceFrame)joint.getFrameAfterJoint());
                } else {
                    this.spatialVelocityChange.setIncludingFrame((ReferenceFrame)joint.getFrameAfterJoint(), startIndex, (DMatrix)velocityChangeMatrix);
                }
                this.integrateFloatingJoint(dt, (FloatingJointBasics)joint, (SpatialVectorReadOnly)this.spatialVelocityChange);
            } else if (joint instanceof SphericalJointBasics) {
                if (velocityChangeMatrix == null) {
                    this.angularVelocityChange.setToZero((ReferenceFrame)joint.getFrameAfterJoint());
                } else {
                    this.angularVelocityChange.setIncludingFrame((ReferenceFrame)joint.getFrameAfterJoint(), startIndex, (DMatrix)velocityChangeMatrix);
                }
                this.integrateSphericalJoint(dt, (SphericalJointBasics)joint, (FrameVector3DReadOnly)this.angularVelocityChange);
            } else if (!(joint instanceof FixedJointBasics)) {
                throw new UnsupportedOperationException("Unsupported joint " + String.valueOf(joint));
            }
            startIndex += joint.getDegreesOfFreedom();
        }
    }

    public void integrateOneDoFJoint(double dt, SimOneDoFJointBasics joint) {
        if (!joint.isPinned()) {
            this.integrateOneDoFJoint(dt, joint, joint.getDeltaQd());
        }
    }

    public void integrateOneDoFJoint(double dt, OneDoFJointBasics joint, double velocityChange) {
        double qdd = joint.getQdd();
        double qd = joint.getQd() + qdd * dt + velocityChange;
        double q = joint.getQ() + (joint.getQd() + 0.5 * velocityChange) * dt + 0.5 * joint.getQdd() * dt * dt;
        joint.setQ(q);
        joint.setQd(qd);
        joint.setQdd(qdd);
    }

    public void integrateSphericalJoint(double dt, SimSphericalJoint joint) {
        if (!joint.isPinned()) {
            this.integrateSphericalJoint(dt, (SphericalJointBasics)joint, (FrameVector3DReadOnly)joint.getJointAngularDeltaVelocity());
        }
    }

    public void integrateSphericalJoint(double dt, SphericalJointBasics joint, FrameVector3DReadOnly angularVelocityChange) {
        QuaternionBasics orientation = joint.getJointOrientation();
        FixedFrameVector3DBasics angularVelocity = joint.getJointAngularVelocity();
        FixedFrameVector3DBasics angularAcceleration = joint.getJointAngularAcceleration();
        this.rotationVector.setAndScale(dt, (Tuple3DReadOnly)angularVelocity);
        this.rotationVector.scaleAdd(0.5 * dt, (Tuple3DReadOnly)angularVelocityChange, (Tuple3DReadOnly)this.rotationVector);
        this.rotationVector.scaleAdd(0.5 * dt * dt, (Tuple3DReadOnly)angularAcceleration, (Tuple3DReadOnly)this.rotationVector);
        this.orientationChange.setRotationVector((Vector3DReadOnly)this.rotationVector);
        angularVelocity.scaleAdd(dt, (FrameTuple3DReadOnly)angularAcceleration, (FrameTuple3DReadOnly)angularVelocity);
        angularVelocity.add((FrameTuple3DReadOnly)angularVelocityChange);
        orientation.append((Orientation3DReadOnly)this.orientationChange);
    }

    public void integrateFloatingJoint(double dt, SimFloatingJointBasics joint) {
        if (!joint.isPinned()) {
            this.integrateFloatingJoint(dt, joint, (SpatialVectorReadOnly)joint.getJointDeltaTwist());
        }
    }

    public void integrateFloatingJoint(double dt, FloatingJointBasics joint, SpatialVectorReadOnly spatialVelocityChange) {
        FrameVector3DReadOnly angularVelocityChange = spatialVelocityChange.getAngularPart();
        FrameVector3DReadOnly linearVelocityChange = spatialVelocityChange.getLinearPart();
        Pose3DBasics pose = joint.getJointPose();
        QuaternionBasics orientation = pose.getOrientation();
        Point3DBasics position = pose.getPosition();
        FixedFrameTwistBasics twist = joint.getJointTwist();
        FixedFrameVector3DBasics angularVelocity = twist.getAngularPart();
        FixedFrameVector3DBasics linearVelocity = twist.getLinearPart();
        FixedFrameSpatialAccelerationBasics spatialAcceleration = joint.getJointAcceleration();
        FixedFrameVector3DBasics angularAcceleration = spatialAcceleration.getAngularPart();
        spatialAcceleration.getLinearAccelerationAtBodyOrigin((TwistReadOnly)twist, (FrameVector3DBasics)this.linearAcceleration);
        this.rotationVector.setAndScale(dt, (Tuple3DReadOnly)angularVelocity);
        this.rotationVector.scaleAdd(0.5 * dt, (Tuple3DReadOnly)angularVelocityChange, (Tuple3DReadOnly)this.rotationVector);
        this.rotationVector.scaleAdd(0.5 * dt * dt, (Tuple3DReadOnly)angularAcceleration, (Tuple3DReadOnly)this.rotationVector);
        this.orientationChange.setRotationVector((Vector3DReadOnly)this.rotationVector);
        angularVelocity.scaleAdd(dt, (FrameTuple3DReadOnly)angularAcceleration, (FrameTuple3DReadOnly)angularVelocity);
        angularVelocity.add((FrameTuple3DReadOnly)angularVelocityChange);
        this.deltaPosition.setAndScale(dt, (Tuple3DReadOnly)linearVelocity);
        this.deltaPosition.scaleAdd(0.5 * dt, (Tuple3DReadOnly)linearVelocityChange, (Tuple3DReadOnly)this.deltaPosition);
        this.deltaPosition.scaleAdd(0.5 * dt * dt, (Tuple3DReadOnly)this.linearAcceleration, (Tuple3DReadOnly)this.deltaPosition);
        orientation.transform((Tuple3DBasics)this.deltaPosition);
        position.add((Tuple3DReadOnly)this.deltaPosition);
        linearVelocity.scaleAdd(dt, (FrameTuple3DReadOnly)this.linearAcceleration, (FrameTuple3DReadOnly)linearVelocity);
        linearVelocity.add((FrameTuple3DReadOnly)linearVelocityChange);
        this.orientationChange.inverseTransform((Tuple3DBasics)linearVelocity);
        this.orientationChange.inverseTransform((Tuple3DBasics)this.linearAcceleration);
        spatialAcceleration.setBasedOnOriginAcceleration((FrameVector3DReadOnly)angularAcceleration, (FrameVector3DReadOnly)this.linearAcceleration, (TwistReadOnly)twist);
        orientation.append((Orientation3DReadOnly)this.orientationChange);
    }
}

