/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.state;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.state.OneDoFJointState;
import us.ihmc.scs2.definition.state.interfaces.JointStateReadOnly;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateBasics;
import us.ihmc.scs2.definition.state.interfaces.OneDoFJointStateReadOnly;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoOneDoFJointState
implements OneDoFJointStateBasics {
    private final YoDouble configuration;
    private final YoDouble velocity;
    private final YoDouble acceleration;
    private final YoDouble effort;
    private final DMatrixRMaj temp = new DMatrixRMaj(1, 1);

    public YoOneDoFJointState(String namePrefix, String nameSuffix, YoRegistry registry) {
        if (namePrefix == null) {
            namePrefix = "";
        } else if (!((String)namePrefix).isEmpty() && !((String)namePrefix).endsWith("_")) {
            namePrefix = (String)namePrefix + "_";
        }
        if (nameSuffix == null) {
            nameSuffix = "";
        } else if (!((String)nameSuffix).isEmpty() && !((String)nameSuffix).startsWith("_")) {
            nameSuffix = "_" + (String)nameSuffix;
        }
        this.configuration = new YoDouble((String)namePrefix + "q" + (String)nameSuffix, registry);
        this.velocity = new YoDouble((String)namePrefix + "qd" + (String)nameSuffix, registry);
        this.acceleration = new YoDouble((String)namePrefix + "qdd" + (String)nameSuffix, registry);
        this.effort = new YoDouble((String)namePrefix + "tau" + (String)nameSuffix, registry);
        this.clear();
    }

    public void set(JointStateReadOnly jointStateReadOnly) {
        if (jointStateReadOnly instanceof OneDoFJointStateReadOnly) {
            super.set((OneDoFJointStateReadOnly)jointStateReadOnly);
        } else {
            if (jointStateReadOnly.getConfigurationSize() != this.getConfigurationSize() || jointStateReadOnly.getDegreesOfFreedom() != this.getDegreesOfFreedom()) {
                throw new IllegalArgumentException("Dimension mismatch");
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.CONFIGURATION)) {
                jointStateReadOnly.getConfiguration(0, (DMatrix)this.temp);
                this.setConfiguration(0, (DMatrix)this.temp);
            } else {
                this.configuration.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.VELOCITY)) {
                jointStateReadOnly.getVelocity(0, (DMatrix)this.temp);
                this.setVelocity(0, (DMatrix)this.temp);
            } else {
                this.velocity.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.ACCELERATION)) {
                jointStateReadOnly.getAcceleration(0, (DMatrix)this.temp);
                this.setAcceleration(0, (DMatrix)this.temp);
            } else {
                this.acceleration.setToNaN();
            }
            if (jointStateReadOnly.hasOutputFor(JointStateType.EFFORT)) {
                jointStateReadOnly.getEffort(0, (DMatrix)this.temp);
                this.setEffort(0, (DMatrix)this.temp);
            } else {
                this.effort.setToNaN();
            }
        }
    }

    public OneDoFJointState copy() {
        return new OneDoFJointState((JointStateReadOnly)this);
    }

    public double getConfiguration() {
        return this.configuration.getValue();
    }

    public double getVelocity() {
        return this.velocity.getValue();
    }

    public double getAcceleration() {
        return this.acceleration.getValue();
    }

    public double getEffort() {
        return this.effort.getValue();
    }

    public void setConfiguration(double q) {
        this.configuration.set(q);
    }

    public void setVelocity(double qd) {
        this.velocity.set(qd);
    }

    public void setAcceleration(double qdd) {
        this.acceleration.set(qdd);
    }

    public void setEffort(double tau) {
        this.effort.set(tau);
    }

    public String toString() {
        Object ret = "1-DoF joint state";
        if (this.hasOutputFor(JointStateType.CONFIGURATION)) {
            ret = (String)ret + ", q: " + String.valueOf(this.configuration);
        }
        if (this.hasOutputFor(JointStateType.VELOCITY)) {
            ret = (String)ret + ", qd: " + String.valueOf(this.velocity);
        }
        if (this.hasOutputFor(JointStateType.ACCELERATION)) {
            ret = (String)ret + ", qdd: " + String.valueOf(this.acceleration);
        }
        if (this.hasOutputFor(JointStateType.EFFORT)) {
            ret = (String)ret + ", tau: " + String.valueOf(this.effort);
        }
        return ret;
    }
}

