/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.controller;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RobotOneDoFJointDampingCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final List<JointCalculator> jointCalculators = new ArrayList<JointCalculator>();
    private final JointMatrixIndexProvider jointMatrixIndexProvider;

    public RobotOneDoFJointDampingCalculator(RobotInterface robot) {
        this.jointMatrixIndexProvider = robot.getJointMatrixIndexProvider();
        for (SimJointBasics simJointBasics : robot.getJointsToConsider()) {
            if (!(simJointBasics instanceof SimOneDoFJointBasics)) continue;
            this.jointCalculators.add(new JointCalculator((SimOneDoFJointBasics)simJointBasics, this.registry));
        }
    }

    public void compute(DMatrix tauToAppendTo) {
        for (JointCalculator calculator : this.jointCalculators) {
            calculator.doControl();
            int jointIndex = this.jointMatrixIndexProvider.getJointDoFIndices((JointReadOnly)calculator.joint)[0];
            double currentValue = tauToAppendTo.get(jointIndex, 0);
            tauToAppendTo.set(jointIndex, 0, currentValue + calculator.dampingEffort.getDoubleValue());
        }
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    private static class JointCalculator {
        private final SimOneDoFJointBasics joint;
        private final YoDouble dampingEffort;

        public JointCalculator(SimOneDoFJointBasics joint, YoRegistry registry) {
            this.joint = joint;
            this.dampingEffort = new YoDouble("tau_damping_" + joint.getName(), registry);
        }

        public void doControl() {
            double tauDamping = -this.joint.getDamping() * this.joint.getQd();
            this.dampingEffort.set(tauDamping);
        }
    }
}

