/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.sensors;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.scs2.definition.robot.CameraSensorDefinition;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimSensor;
import us.ihmc.yoVariables.euclid.YoVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;

public class SimCameraSensor
extends SimSensor {
    private final YoBoolean enable;
    private final YoDouble fieldOfView;
    private final YoDouble clipNear;
    private final YoDouble clipFar;
    private final YoInteger imageWidth;
    private final YoInteger imageHeight;
    private final YoVector3D depthAxis;
    private final YoVector3D upAxis;
    private final List<CameraFrameConsumer> cameraFrameConsumers = new ArrayList<CameraFrameConsumer>();
    private final AtomicBoolean notifyDefinitionConsumers = new AtomicBoolean(false);
    private final List<CameraDefinitionConsumer> cameraDefinitionConsumers = new ArrayList<CameraDefinitionConsumer>();

    public SimCameraSensor(CameraSensorDefinition definition, SimJointBasics parentJoint) {
        this(definition.getName(), parentJoint, (RigidBodyTransformReadOnly)definition.getTransformToJoint());
        this.setEnable(definition.getEnable());
        this.setResolution(definition.getImageWidth(), definition.getImageHeight());
        this.setFieldOfView(definition.getFieldOfView());
        this.setClip(definition.getClipNear(), definition.getClipFar());
        this.setSamplingRate(SimCameraSensor.toSamplingRate(definition.getUpdatePeriod()));
    }

    public SimCameraSensor(String name, SimJointBasics parentJoint, RigidBodyTransformReadOnly transformToParent) {
        super(name, parentJoint, transformToParent);
        YoRegistry registry = parentJoint.getRegistry();
        this.enable = new YoBoolean(name + "Enable", registry);
        this.fieldOfView = new YoDouble(name + "FieldOfView", registry);
        this.clipNear = new YoDouble(name + "ClipNear", registry);
        this.clipFar = new YoDouble(name + "ClipFar", registry);
        this.imageWidth = new YoInteger(name + "ImageWidth", registry);
        this.imageHeight = new YoInteger(name + "ImageHeight", registry);
        this.depthAxis = new YoVector3D(name + "DepthAxis", registry);
        this.depthAxis.set((Tuple3DReadOnly)Axis3D.X);
        this.upAxis = new YoVector3D(name + "UpAxis", registry);
        this.upAxis.set((Tuple3DReadOnly)Axis3D.Z);
        this.enable.addListener(v -> this.notifyDefinitionConsumers.set(true));
        this.fieldOfView.addListener(v -> this.notifyDefinitionConsumers.set(true));
        this.clipNear.addListener(v -> this.notifyDefinitionConsumers.set(true));
        this.clipFar.addListener(v -> this.notifyDefinitionConsumers.set(true));
        this.imageWidth.addListener(v -> this.notifyDefinitionConsumers.set(true));
        this.imageHeight.addListener(v -> this.notifyDefinitionConsumers.set(true));
        this.getOffset().attachVariableChangedListener(v -> this.notifyDefinitionConsumers.set(true));
        this.getSamplingRate().addListener(v -> this.notifyDefinitionConsumers.set(true));
    }

    @Override
    public void update(RobotPhysicsOutput robotPhysicsOutput) {
        super.update(robotPhysicsOutput);
        if (this.notifyDefinitionConsumers.getAndSet(false)) {
            CameraSensorDefinition newDefinition = this.toCameraSensorDefinition();
            for (CameraDefinitionConsumer cameraDefinitionConsumer : this.cameraDefinitionConsumers) {
                cameraDefinitionConsumer.nextDefinition(newDefinition);
            }
        }
    }

    public CameraSensorDefinition toCameraSensorDefinition() {
        CameraSensorDefinition newDefinition = new CameraSensorDefinition(this.getName(), (RigidBodyTransformReadOnly)this.getFrame().getTransformToParent());
        newDefinition.setEnable(this.enable.getValue());
        newDefinition.setFieldOfView(this.fieldOfView.getValue());
        newDefinition.setClipNear(this.clipNear.getValue());
        newDefinition.setClipFar(this.clipFar.getValue());
        newDefinition.setImageWidth(this.imageWidth.getValue());
        newDefinition.setImageHeight(this.imageHeight.getValue());
        if (this.getSamplingRate().getValue() == Double.POSITIVE_INFINITY) {
            newDefinition.setUpdatePeriod(0);
        } else {
            newDefinition.setUpdatePeriod((int)(1000.0 / this.getSamplingRate().getValue()));
        }
        newDefinition.setDepthAxis((Vector3DReadOnly)this.depthAxis);
        newDefinition.setUpAxis((Vector3DReadOnly)this.upAxis);
        return newDefinition;
    }

    public void setEnable(boolean enable) {
        this.enable.set(enable);
    }

    public void setImageWidth(int imageWidth) {
        this.imageWidth.set(imageWidth);
    }

    public void setImageHeight(int imageHeight) {
        this.imageHeight.set(imageHeight);
    }

    public void setResolution(int width, int height) {
        this.imageWidth.set(width);
        this.imageHeight.set(height);
    }

    public void setFieldOfView(double fieldOfView) {
        this.fieldOfView.set(fieldOfView);
    }

    public void setClipNear(double clipNear) {
        this.clipNear.set(clipNear);
    }

    public void setClipFar(double clipFar) {
        this.clipFar.set(clipFar);
    }

    public void setClip(double clipNear, double clipFar) {
        this.clipNear.set(clipNear);
        this.clipFar.set(clipFar);
    }

    public void addCameraFrameConsumer(CameraFrameConsumer cameraFrameConsumer) {
        this.cameraFrameConsumers.add(cameraFrameConsumer);
    }

    public boolean removeCameraFrameConsumer(CameraFrameConsumer cameraFrameConsumer) {
        return this.cameraFrameConsumers.remove(cameraFrameConsumer);
    }

    public void addCameraDefinitionConsumer(CameraDefinitionConsumer cameraDefinitionConsumer) {
        this.cameraDefinitionConsumers.add(cameraDefinitionConsumer);
    }

    public boolean removeCameraDefinitionConsumer(CameraDefinitionConsumer cameraDefinitionConsumer) {
        return this.cameraDefinitionConsumers.remove(cameraDefinitionConsumer);
    }

    public YoBoolean getEnable() {
        return this.enable;
    }

    public YoInteger getImageWidth() {
        return this.imageWidth;
    }

    public YoInteger getImageHeight() {
        return this.imageHeight;
    }

    public YoDouble getFieldOfView() {
        return this.fieldOfView;
    }

    public YoDouble getClipNear() {
        return this.clipNear;
    }

    public YoDouble getClipFar() {
        return this.clipFar;
    }

    public List<CameraFrameConsumer> getCameraFrameConsumers() {
        return this.cameraFrameConsumers;
    }

    public List<CameraDefinitionConsumer> getCameraDefinitionConsumers() {
        return this.cameraDefinitionConsumers;
    }

    public static interface CameraDefinitionConsumer {
        public void nextDefinition(CameraSensorDefinition var1);
    }

    public static interface CameraFrameConsumer {
        public void nextFrame(long var1, BufferedImage var3);
    }
}

