/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.sensors;

import us.ihmc.commons.MathTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.scs2.definition.robot.SensorDefinition;
import us.ihmc.scs2.session.YoFixedMovingReferenceFrameUsingYawPitchRoll;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.variable.YoDouble;

public abstract class SimSensor {
    private final String name;
    private final SimJointBasics parentJoint;
    private final YoFixedMovingReferenceFrameUsingYawPitchRoll frame;
    private final YoDouble samplingRate;
    public static final double ANTIALIASING_FILTER_RATIO = 0.25;

    public static double computeLowPassFilterAlpha(double breakFrequency, double dt) {
        if (Double.isInfinite(breakFrequency)) {
            return 0.0;
        }
        double halfOmegaDT = Math.PI * breakFrequency * dt;
        return MathTools.clamp((double)((1.0 - halfOmegaDT) / (1.0 + halfOmegaDT)), (double)0.0, (double)1.0);
    }

    public SimSensor(SensorDefinition definition, SimJointBasics parentJoint) {
        this(definition.getName(), parentJoint, (RigidBodyTransformReadOnly)definition.getTransformToJoint());
        this.setSamplingRate(SimSensor.toSamplingRate(definition.getUpdatePeriod()));
    }

    public SimSensor(String name, SimJointBasics parentJoint, RigidBodyTransformReadOnly transformToParent) {
        this.name = name;
        this.parentJoint = parentJoint;
        this.frame = new YoFixedMovingReferenceFrameUsingYawPitchRoll(name + "Frame", name + "Offset", (ReferenceFrame)parentJoint.getFrameAfterJoint(), parentJoint.getRegistry());
        this.frame.getOffset().set(transformToParent);
        this.samplingRate = new YoDouble(name + "SamplingRate", parentJoint.getRegistry());
        this.samplingRate.set(Double.POSITIVE_INFINITY);
    }

    public static double toSamplingRate(int updatePeriod) {
        if (updatePeriod <= 0) {
            return Double.POSITIVE_INFINITY;
        }
        return 1000.0 / (double)updatePeriod;
    }

    public void update(RobotPhysicsOutput robotPhysicsOutput) {
        this.frame.update();
    }

    public void setSamplingRate(double samplingRate) {
        this.samplingRate.set(samplingRate);
    }

    public String getName() {
        return this.name;
    }

    public SimJointBasics getParentJoint() {
        return this.parentJoint;
    }

    public MovingReferenceFrame getFrame() {
        return this.frame;
    }

    public YoFramePoseUsingYawPitchRoll getOffset() {
        return this.frame.getOffset();
    }

    public YoDouble getSamplingRate() {
        return this.samplingRate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " - " + this.getName();
    }
}

