/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.simulation.RobotJointWrenchCalculator;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.FrameShapePosePredictor;
import us.ihmc.scs2.simulation.physicsEngine.YoMatrix;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedRobot;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.RobotJointLimitImpulseBasedCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.SingleContactImpulseCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.YoRobotJointLimitImpulseBasedCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.YoSingleContactImpulseCalculatorPool;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.controller.RobotOneDoFJointDampingCalculator;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.screwTools.RigidBodyDeltaTwistCalculator;
import us.ihmc.scs2.simulation.screwTools.RigidBodyImpulseRegistry;
import us.ihmc.scs2.simulation.screwTools.RigidBodyWrenchRegistry;
import us.ihmc.scs2.simulation.screwTools.SimJointStateType;
import us.ihmc.scs2.simulation.screwTools.SimMultiBodySystemTools;
import us.ihmc.scs2.simulation.screwTools.SingleRobotFirstOrderIntegrator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ImpulseBasedRobotPhysics {
    private static final String ContactCalculatorNameSuffix = SingleContactImpulseCalculator.class.getSimpleName();
    private final RobotInterface owner;
    private final ReferenceFrame inertialFrame;
    private final YoRegistry environmentContactCalculatorRegistry = new YoRegistry("Environment" + ContactCalculatorNameSuffix);
    private final YoRegistry interRobotContactCalculatorRegistry = new YoRegistry("InterRobot" + ContactCalculatorNameSuffix);
    private final YoRegistry selfContactCalculatorRegistry = new YoRegistry("Self" + ContactCalculatorNameSuffix);
    private final DMatrixRMaj jointDeltaVelocityMatrix;
    private final RigidBodyDeltaTwistCalculator rigidBodyDeltaTwistCalculator;
    private final RigidBodyTwistProvider rigidBodyDeltaTwistProvider;
    private final RigidBodyWrenchRegistry rigidBodyWrenchRegistry = new RigidBodyWrenchRegistry();
    private final RigidBodyImpulseRegistry rigidBodyImpulseRegistry = new RigidBodyImpulseRegistry();
    private final List<Collidable> collidables;
    private final ForwardDynamicsCalculator forwardDynamicsCalculator;
    private RobotJointWrenchCalculator jointWrenchCalculator;
    private final RobotJointLimitImpulseBasedCalculator jointLimitConstraintCalculator;
    private final YoSingleContactImpulseCalculatorPool environmentContactConstraintCalculatorPool;
    private final YoSingleContactImpulseCalculatorPool selfContactConstraintCalculatorPool;
    private final Map<RigidBodyBasics, YoSingleContactImpulseCalculatorPool> interRobotContactConstraintCalculatorPools = new HashMap<RigidBodyBasics, YoSingleContactImpulseCalculatorPool>();
    private final RobotOneDoFJointDampingCalculator robotOneDoFJointDampingCalculator;
    private final YoMatrix jointsTauLowLevelController;
    private final YoMatrix jointsTau;
    private final SingleRobotFirstOrderIntegrator integrator;
    private final RobotPhysicsOutput physicsOutput;

    public ImpulseBasedRobotPhysics(RobotInterface owner, YoRegistry robotPhysicsRegistry) {
        this.owner = owner;
        this.inertialFrame = owner.getInertialFrame();
        this.jointDeltaVelocityMatrix = new DMatrixRMaj(MultiBodySystemTools.computeDegreesOfFreedom(owner.getJointsToConsider()), 1);
        this.rigidBodyDeltaTwistCalculator = new RigidBodyDeltaTwistCalculator(this.inertialFrame, owner.getJointMatrixIndexProvider(), this.jointDeltaVelocityMatrix);
        this.rigidBodyDeltaTwistProvider = this.rigidBodyDeltaTwistCalculator.getDeltaTwistProvider();
        SimRigidBodyBasics rootBody = owner.getRootBody();
        this.collidables = rootBody.subtreeStream().filter(body -> owner.getJointsToConsider().contains(body.getParentJoint())).flatMap(body -> body.getCollidables().stream()).collect(Collectors.toList());
        this.forwardDynamicsCalculator = new ForwardDynamicsCalculator((MultiBodySystemReadOnly)owner);
        FrameShapePosePredictor frameShapePosePredictor = new FrameShapePosePredictor(this.forwardDynamicsCalculator);
        this.collidables.forEach(collidable -> collidable.setFrameShapePosePredictor(frameShapePosePredictor));
        YoRegistry jointLimitConstraintCalculatorRegistry = new YoRegistry(RobotJointLimitImpulseBasedCalculator.class.getSimpleName());
        this.jointLimitConstraintCalculator = new YoRobotJointLimitImpulseBasedCalculator(owner, this.forwardDynamicsCalculator, jointLimitConstraintCalculatorRegistry);
        this.robotOneDoFJointDampingCalculator = new RobotOneDoFJointDampingCalculator(owner);
        this.environmentContactConstraintCalculatorPool = new YoSingleContactImpulseCalculatorPool(20, owner.getName() + "Single", this.inertialFrame, rootBody, this.forwardDynamicsCalculator, null, null, this.environmentContactCalculatorRegistry);
        this.selfContactConstraintCalculatorPool = new YoSingleContactImpulseCalculatorPool(8, owner.getName() + "Self", this.inertialFrame, rootBody, this.forwardDynamicsCalculator, rootBody, this.forwardDynamicsCalculator, this.selfContactCalculatorRegistry);
        this.jointsTauLowLevelController = SimMultiBodySystemTools.createYoMatrixForJointsState("tau_llc", "Joint torque contribution from low-level control", owner.getJointsToConsider(), SimJointStateType.EFFORT, owner.getRegistry());
        this.jointsTau = SimMultiBodySystemTools.createYoMatrixForJointsState("tau_total", "Total joint torque, sum of controller contribution and low-level control contribution", owner.getJointsToConsider(), SimJointStateType.EFFORT, owner.getRegistry());
        this.integrator = new SingleRobotFirstOrderIntegrator();
        this.physicsOutput = new RobotPhysicsOutput(this.forwardDynamicsCalculator.getAccelerationProvider(), this.rigidBodyDeltaTwistProvider, this.rigidBodyWrenchRegistry, this.rigidBodyImpulseRegistry);
        robotPhysicsRegistry.addChild(jointLimitConstraintCalculatorRegistry);
        robotPhysicsRegistry.addChild(this.environmentContactCalculatorRegistry);
        robotPhysicsRegistry.addChild(this.interRobotContactCalculatorRegistry);
        robotPhysicsRegistry.addChild(this.selfContactCalculatorRegistry);
        robotPhysicsRegistry.addChild(this.robotOneDoFJointDampingCalculator.getRegistry());
    }

    public void enableJointWrenchCalculator() {
        if (this.jointWrenchCalculator != null) {
            return;
        }
        this.jointWrenchCalculator = new RobotJointWrenchCalculator(this.physicsOutput, this.forwardDynamicsCalculator, this.owner.getRegistry());
    }

    public void resetCalculators() {
        this.jointDeltaVelocityMatrix.zero();
        this.forwardDynamicsCalculator.setExternalWrenchesToZero();
        this.rigidBodyDeltaTwistCalculator.reset();
        this.rigidBodyWrenchRegistry.reset();
        this.rigidBodyImpulseRegistry.reset();
        this.environmentContactConstraintCalculatorPool.clear();
        this.selfContactConstraintCalculatorPool.clear();
        this.interRobotContactConstraintCalculatorPools.forEach((rigidBodyBasics, calculators) -> calculators.clear());
    }

    public void computeJointLowLevelControl() {
        this.jointsTauLowLevelController.zero();
        this.robotOneDoFJointDampingCalculator.compute(this.jointsTauLowLevelController);
    }

    public void addJointVelocityChange(DMatrixRMaj velocityChange) {
        if (velocityChange == null) {
            return;
        }
        CommonOps_DDRM.addEquals((DMatrixD1)this.jointDeltaVelocityMatrix, (DMatrixD1)velocityChange);
    }

    public void addRigidBodyExternalWrench(RigidBodyReadOnly target, WrenchReadOnly wrenchToAdd) {
        this.rigidBodyWrenchRegistry.addWrench(target, wrenchToAdd);
    }

    public void addRigidBodyExternalImpulse(RigidBodyReadOnly target, SpatialImpulseReadOnly wrenchToAdd) {
        this.rigidBodyImpulseRegistry.addImpulse(target, wrenchToAdd);
    }

    public void updateCollidableBoundingBoxes() {
        this.collidables.forEach(collidable -> collidable.updateBoundingBox(this.inertialFrame));
    }

    public List<Collidable> getCollidables() {
        return this.collidables;
    }

    public ForwardDynamicsCalculator getForwardDynamicsCalculator() {
        return this.forwardDynamicsCalculator;
    }

    public void doForwardDynamics(Vector3DReadOnly gravity) {
        this.forwardDynamicsCalculator.setGravitationalAcceleration((Tuple3DReadOnly)gravity);
        this.forwardDynamicsCalculator.setJointSourceModes(joint -> {
            SimJointBasics simJoint = (SimJointBasics)joint;
            if (simJoint.isPinned()) {
                simJoint.setJointTwistToZero();
                simJoint.setJointAccelerationToZero();
            }
            return simJoint.isPinned() ? ForwardDynamicsCalculator.JointSourceMode.ACCELERATION_SOURCE : ForwardDynamicsCalculator.JointSourceMode.EFFORT_SOURCE;
        });
        this.sumJointTauContributions();
        this.forwardDynamicsCalculator.compute((DMatrix)this.jointsTau);
    }

    public void writeJointAccelerations() {
        List<? extends SimJointBasics> joints = this.owner.getJointsToConsider();
        DMatrixRMaj jointAccelerationMatrix = this.forwardDynamicsCalculator.getJointAccelerationMatrix();
        DMatrixRMaj jointTauMatrix = this.forwardDynamicsCalculator.getJointTauMatrix();
        SimMultiBodySystemTools.insertJointsStateWithBackup(joints, SimJointReadOnly::isPinned, SimJointStateType.EFFORT, (DMatrix)jointTauMatrix, Double.POSITIVE_INFINITY, false, SimJointStateType.ACCELERATION, (DMatrix)jointAccelerationMatrix, 1.0E12, true);
    }

    public void writeJointDeltaVelocities() {
        SimMultiBodySystemTools.insertJointsState(this.owner.getJointsToConsider(), SimJointStateType.VELOCITY_CHANGE, (DMatrix)this.jointDeltaVelocityMatrix, 1.0E7, true);
    }

    public void computeJointWrenches(double dt) {
        if (this.jointWrenchCalculator == null) {
            return;
        }
        this.jointWrenchCalculator.update(dt);
    }

    public void integrateState(double dt) {
        this.physicsOutput.setDT(dt);
        this.integrator.integrate(dt, this.owner);
    }

    public RobotPhysicsOutput getPhysicsOutput() {
        return this.physicsOutput;
    }

    public RobotJointLimitImpulseBasedCalculator getJointLimitConstraintCalculator() {
        return this.jointLimitConstraintCalculator;
    }

    public SingleContactImpulseCalculator getOrCreateEnvironmentContactConstraintCalculator() {
        return this.environmentContactConstraintCalculatorPool.nextAvailable();
    }

    public SingleContactImpulseCalculator getOrCreateSelfContactConstraintCalculator() {
        return this.selfContactConstraintCalculatorPool.nextAvailable();
    }

    public SingleContactImpulseCalculator getOrCreateInterRobotContactConstraintCalculator(ImpulseBasedRobot otherRobot) {
        if (otherRobot == null) {
            return this.getOrCreateEnvironmentContactConstraintCalculator();
        }
        if (otherRobot == this.owner) {
            return this.getOrCreateSelfContactConstraintCalculator();
        }
        YoSingleContactImpulseCalculatorPool calculators = this.interRobotContactConstraintCalculatorPools.get(otherRobot.getRootBody());
        if (calculators == null) {
            calculators = new YoSingleContactImpulseCalculatorPool(8, this.owner.getName() + otherRobot.getName() + "Dual", this.inertialFrame, this.owner.getRootBody(), this.forwardDynamicsCalculator, otherRobot.getRootBody(), otherRobot.getForwardDynamicsCalculator(), this.interRobotContactCalculatorRegistry);
            this.interRobotContactConstraintCalculatorPools.put(otherRobot.getRootBody(), calculators);
        }
        return calculators.nextAvailable();
    }

    public RigidBodyTwistProvider getRigidBodyTwistChangeProvider() {
        return this.rigidBodyDeltaTwistProvider;
    }

    private void sumJointTauContributions() {
        MultiBodySystemTools.extractJointsState(this.owner.getJointsToConsider(), (JointStateType)JointStateType.EFFORT, (DMatrix)this.jointsTau);
        this.jointsTau.add(this.jointsTauLowLevelController);
    }
}

