/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.contactPointBased;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.scs2.definition.robot.OneDoFJointDefinition;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class RobotOneDoFJointSoftLimitCalculator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final List<JointCalculator> jointCalculators = new ArrayList<JointCalculator>();
    private final JointMatrixIndexProvider jointMatrixIndexProvider;

    public RobotOneDoFJointSoftLimitCalculator(RobotInterface robot) {
        this.jointMatrixIndexProvider = robot.getJointMatrixIndexProvider();
        for (SimJointBasics simJointBasics : robot.getJointsToConsider()) {
            if (!(simJointBasics instanceof SimOneDoFJointBasics)) continue;
            SimOneDoFJointBasics oneDoFJoint = (SimOneDoFJointBasics)simJointBasics;
            OneDoFJointDefinition jointDefinition = (OneDoFJointDefinition)robot.getRobotDefinition().getJointDefinition(oneDoFJoint.getName());
            if (!RobotOneDoFJointSoftLimitCalculator.hasPositionLimit(oneDoFJoint) || !RobotOneDoFJointSoftLimitCalculator.hasSoftLimitStopGains(jointDefinition)) continue;
            this.jointCalculators.add(new JointCalculator(oneDoFJoint, jointDefinition, this.registry));
        }
    }

    public void compute(DMatrix tauToAppendTo) {
        for (JointCalculator calculator : this.jointCalculators) {
            calculator.compute();
            int jointIndex = this.jointMatrixIndexProvider.getJointDoFIndices((JointReadOnly)calculator.joint)[0];
            double currentValue = tauToAppendTo.get(jointIndex, 0);
            tauToAppendTo.set(jointIndex, 0, currentValue + calculator.jointLimitEffort.getDoubleValue());
        }
    }

    private static boolean hasPositionLimit(OneDoFJointReadOnly joint) {
        double lower = joint.getJointLimitLower();
        double upper = joint.getJointLimitUpper();
        if (!Double.isFinite(lower) || !Double.isFinite(upper)) {
            return false;
        }
        return lower < upper;
    }

    private static boolean hasSoftLimitStopGains(OneDoFJointDefinition jointDefinition) {
        double kp = jointDefinition.getKpSoftLimitStop();
        double kd = jointDefinition.getKdSoftLimitStop();
        if (Double.isFinite(kp) && kp > 0.0) {
            return true;
        }
        return Double.isFinite(kd) && kd > 0.0;
    }

    public YoRegistry getRegistry() {
        return this.registry;
    }

    private static class JointCalculator {
        private final SimOneDoFJointBasics joint;
        private final YoDouble kp;
        private final YoDouble kd;
        private final YoDouble jointLimitEffort;

        public JointCalculator(SimOneDoFJointBasics joint, OneDoFJointDefinition jointDefinition, YoRegistry registry) {
            this.joint = joint;
            this.kp = new YoDouble("kp_soft_limit_stop_" + joint.getName(), registry);
            this.kd = new YoDouble("kd_soft_limit_stop_" + joint.getName(), registry);
            if (Double.isFinite(jointDefinition.getKpSoftLimitStop()) && jointDefinition.getKpSoftLimitStop() > 0.0) {
                this.kp.set(jointDefinition.getKpSoftLimitStop());
            }
            if (Double.isFinite(jointDefinition.getKdSoftLimitStop()) && jointDefinition.getKdSoftLimitStop() > 0.0) {
                this.kd.set(jointDefinition.getKdSoftLimitStop());
            }
            this.jointLimitEffort = new YoDouble("tau_soft_limit_stop_" + joint.getName(), registry);
        }

        public void compute() {
            double q = this.joint.getQ();
            double qd = this.joint.getQd();
            double min = this.joint.getJointLimitLower();
            double max = this.joint.getJointLimitUpper();
            double kp = this.kp.getValue();
            double kd = this.kd.getValue();
            double tau = 0.0;
            if (q < min) {
                tau = Math.max(0.0, kp * (min - q) - kd * qd);
            } else if (q > max) {
                tau = Math.min(0.0, kp * (max - q) - kd * qd);
            }
            this.jointLimitEffort.set(tau);
        }
    }
}

