/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointReadOnly;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyReadOnly;
import us.ihmc.scs2.simulation.screwTools.SimMultiBodySystemFactories;
import us.ihmc.yoVariables.registry.YoRegistry;

public interface SimMultiBodySystemReadOnly
extends MultiBodySystemReadOnly {
    public YoRegistry getRegistry();

    public SimRigidBodyReadOnly getRootBody();

    default public List<? extends SimJointReadOnly> getAllJoints() {
        return SubtreeStreams.fromChildren(SimJointReadOnly.class, (RigidBodyReadOnly)this.getRootBody()).collect(Collectors.toList());
    }

    default public List<? extends SimJointReadOnly> getJointsToConsider() {
        return this.getAllJoints();
    }

    default public List<? extends SimJointReadOnly> getJointsToIgnore() {
        return this.getAllJoints().stream().filter(joint -> !this.getJointsToConsider().contains(joint)).collect(Collectors.toList());
    }

    default public SimJointReadOnly findJoint(String jointName) {
        return (SimJointReadOnly)super.findJoint(jointName);
    }

    default public SimRigidBodyReadOnly findRigidBody(String rigidBodyName) {
        return (SimRigidBodyReadOnly)super.findRigidBody(rigidBodyName);
    }

    public static SimMultiBodySystemReadOnly toMultiBodySystemInput(SimRigidBodyReadOnly rootBody) {
        return SimMultiBodySystemReadOnly.toMultiBodySystemInput(rootBody, Collections.emptyList());
    }

    public static SimMultiBodySystemReadOnly toMultiBodySystemInput(SimRigidBodyReadOnly rootBody, SimJointReadOnly[] jointsToIgnore) {
        return SimMultiBodySystemReadOnly.toMultiBodySystemInput(rootBody, Arrays.asList(jointsToIgnore));
    }

    public static SimMultiBodySystemReadOnly toMultiBodySystemInput(final SimRigidBodyReadOnly rootBody, final List<? extends SimJointReadOnly> jointsToIgnore) {
        final List allJoints = SubtreeStreams.fromChildren(SimJointReadOnly.class, (RigidBodyReadOnly)rootBody).collect(Collectors.toList());
        final List<? extends SimJointReadOnly> jointsToConsider = SimMultiBodySystemReadOnly.extractJointsToConsider(rootBody, jointsToIgnore);
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new SimMultiBodySystemReadOnly(){

            @Override
            public YoRegistry getRegistry() {
                return rootBody.getRegistry();
            }

            @Override
            public SimRigidBodyReadOnly getRootBody() {
                return rootBody;
            }

            @Override
            public List<? extends SimJointReadOnly> getAllJoints() {
                return allJoints;
            }

            @Override
            public List<? extends SimJointReadOnly> getJointsToConsider() {
                return jointsToConsider;
            }

            @Override
            public List<? extends SimJointReadOnly> getJointsToIgnore() {
                return jointsToIgnore;
            }

            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static SimMultiBodySystemReadOnly toMultiBodySystemReadOnly(SimJointReadOnly[] jointsToConsider) {
        return SimMultiBodySystemReadOnly.toMultiBodySystemInput(Arrays.asList(jointsToConsider));
    }

    public static SimMultiBodySystemReadOnly toMultiBodySystemInput(final List<? extends SimJointReadOnly> jointsToConsider) {
        final SimRigidBodyReadOnly rootBody = (SimRigidBodyReadOnly)MultiBodySystemReadOnly.getClosestJointToRoot(jointsToConsider).getPredecessor();
        final List allJoints = SubtreeStreams.fromChildren(SimJointReadOnly.class, (RigidBodyReadOnly)rootBody).collect(Collectors.toList());
        final List jointsToIgnore = SubtreeStreams.fromChildren(SimJointReadOnly.class, (RigidBodyReadOnly)rootBody).filter(joint -> !jointsToConsider.contains(joint)).collect(Collectors.toList());
        final JointMatrixIndexProvider jointMatrixIndexProvider = JointMatrixIndexProvider.toIndexProvider(jointsToConsider);
        return new SimMultiBodySystemReadOnly(){

            @Override
            public YoRegistry getRegistry() {
                return rootBody.getRegistry();
            }

            @Override
            public SimRigidBodyReadOnly getRootBody() {
                return rootBody;
            }

            @Override
            public List<? extends SimJointReadOnly> getAllJoints() {
                return allJoints;
            }

            @Override
            public List<? extends SimJointReadOnly> getJointsToConsider() {
                return jointsToConsider;
            }

            @Override
            public List<? extends SimJointReadOnly> getJointsToIgnore() {
                return jointsToIgnore;
            }

            public JointMatrixIndexProvider getJointMatrixIndexProvider() {
                return jointMatrixIndexProvider;
            }
        };
    }

    public static List<? extends SimJointReadOnly> extractJointsToConsider(SimRigidBodyReadOnly rootBody, List<? extends SimJointReadOnly> jointsToIgnore) {
        return SubtreeStreams.fromChildren(SimJointReadOnly.class, (RigidBodyReadOnly)rootBody).filter(candidate -> !MultiBodySystemReadOnly.isJointToBeIgnored((JointReadOnly)candidate, (List)jointsToIgnore)).collect(Collectors.toList());
    }

    public static SimMultiBodySystemReadOnly clone(MultiBodySystemReadOnly original, ReferenceFrame cloneRootFrame, YoRegistry cloneRegistry, YoRegistry cloneSecondaryRegistry) {
        SimRigidBodyReadOnly cloneRootBody = (SimRigidBodyReadOnly)MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)original.getRootBody(), (ReferenceFrame)cloneRootFrame, (String)"", (MultiBodySystemFactories.RigidBodyBuilder)new SimMultiBodySystemFactories.SimRigidBodyBuilder(cloneRegistry, cloneSecondaryRegistry), (MultiBodySystemFactories.JointBuilder)new SimMultiBodySystemFactories.SimJointBuilder());
        Set namesOfJointsToConsider = SubtreeStreams.fromChildren(SimJointReadOnly.class, (RigidBodyReadOnly)original.getRootBody()).map(JointReadOnly::getName).collect(Collectors.toSet());
        List jointsToConsider = SubtreeStreams.fromChildren(SimJointReadOnly.class, (RigidBodyReadOnly)cloneRootBody).filter(joint -> namesOfJointsToConsider.contains(joint.getName())).collect(Collectors.toList());
        return SimMultiBodySystemReadOnly.toMultiBodySystemInput(jointsToConsider);
    }
}

