/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem;

import java.util.function.BiConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialAcceleration;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSixDoFJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimFloatingRootJoint
extends SimSixDoFJoint
implements SimJointBasics,
SimFloatingJointBasics {
    private final YoRegistry registry;
    private final YoFrameYawPitchRoll jointYawPitchRoll;
    private final YoFrameVector3D jointLinearVelocity;
    private final YoFrameVector3D jointLinearAcceleration;

    public SimFloatingRootJoint(SixDoFJointDefinition definition, SimRigidBodyBasics predecessor) {
        this(definition.getName(), predecessor, (RigidBodyTransformReadOnly)definition.getTransformToParent());
    }

    public SimFloatingRootJoint(String name, SimRigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public SimFloatingRootJoint(String name, SimRigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, predecessor, transformToParent);
        this.registry = predecessor.getRegistry();
        Object varName = !name.isEmpty() ? "_" + name + "_" : "_";
        this.jointYawPitchRoll = new YoFrameYawPitchRoll("q" + (String)varName, (ReferenceFrame)this.beforeJointFrame, this.registry);
        YoFrameQuaternion jointQuaternion = this.getJointPose().getOrientation();
        SimFloatingRootJoint.buildOrientationListeners(jointQuaternion, this.jointYawPitchRoll);
        this.jointLinearVelocity = new YoFrameVector3D("qd" + (String)varName + "world_", (ReferenceFrame)this.beforeJointFrame, this.registry);
        YoFixedFrameTwist jointTwist = this.getJointTwist();
        SimFloatingRootJoint.buildVectorListeners(jointQuaternion, jointTwist.getLinearPart(), this.jointLinearVelocity, (arg_0, arg_1) -> ((YoFrameQuaternion)jointQuaternion).transform(arg_0, arg_1), (arg_0, arg_1) -> ((YoFrameQuaternion)jointQuaternion).inverseTransform(arg_0, arg_1));
        this.jointLinearAcceleration = new YoFrameVector3D("qdd" + (String)varName + "world_", (ReferenceFrame)this.beforeJointFrame, this.registry);
        YoFixedFrameSpatialAcceleration jointSpatialAcceleration = this.getJointAcceleration();
        SimFloatingRootJoint.buildVectorListeners(jointQuaternion, jointSpatialAcceleration.getLinearPart(), this.jointLinearAcceleration, (a, b) -> SimFloatingRootJoint.transformLinearAcceleration((QuaternionReadOnly)jointQuaternion, (TwistReadOnly)jointTwist, a, b), (b, a) -> SimFloatingRootJoint.inverseTransformLinearAcceleration((QuaternionReadOnly)jointQuaternion, (TwistReadOnly)jointTwist, b, a));
    }

    private static void inverseTransformLinearAcceleration(QuaternionReadOnly quaternion, TwistReadOnly twist, Vector3DReadOnly linearAccelerationOriginal, Vector3DBasics linearAccelerationTransformed) {
        quaternion.inverseTransform((Tuple3DReadOnly)linearAccelerationOriginal, (Tuple3DBasics)linearAccelerationTransformed);
        MecanoTools.addCrossToVector((Tuple3DReadOnly)twist.getLinearPart(), (Tuple3DReadOnly)twist.getAngularPart(), (Vector3DBasics)linearAccelerationTransformed);
    }

    private static void transformLinearAcceleration(QuaternionReadOnly quaternion, TwistReadOnly twist, Vector3DReadOnly linearAccelerationOriginal, Vector3DBasics linearAccelerationTransformed) {
        linearAccelerationTransformed.set((Tuple3DReadOnly)linearAccelerationOriginal);
        MecanoTools.addCrossToVector((Tuple3DReadOnly)twist.getAngularPart(), (Tuple3DReadOnly)twist.getLinearPart(), (Vector3DBasics)linearAccelerationTransformed);
        quaternion.transform((Tuple3DBasics)linearAccelerationTransformed);
    }

    private static void buildOrientationListeners(YoFrameQuaternion quaternion, YoFrameYawPitchRoll yawPitchRoll) {
        MutableBoolean updatingYPR = new MutableBoolean(false);
        MutableBoolean updatingQuat = new MutableBoolean(false);
        quaternion.getYoQs().addListener(v -> {
            if (updatingQuat.booleanValue()) {
                return;
            }
            updatingYPR.setTrue();
            try {
                yawPitchRoll.set((FrameOrientation3DReadOnly)quaternion);
            }
            finally {
                updatingYPR.setFalse();
            }
        });
        double updateThreshold = 1.0E-6;
        yawPitchRoll.getYoYaw().addListener(v -> {
            if (updatingYPR.booleanValue()) {
                return;
            }
            updatingQuat.setTrue();
            try {
                if (!EuclidCoreTools.epsilonEquals((double)quaternion.getYaw(), (double)yawPitchRoll.getYaw(), (double)updateThreshold)) {
                    quaternion.setYawPitchRoll(yawPitchRoll.getYaw(), quaternion.getPitch(), quaternion.getRoll());
                }
            }
            finally {
                updatingQuat.setFalse();
            }
        });
        yawPitchRoll.getYoPitch().addListener(v -> {
            if (updatingYPR.booleanValue()) {
                return;
            }
            updatingQuat.setTrue();
            try {
                if (!EuclidCoreTools.epsilonEquals((double)quaternion.getPitch(), (double)yawPitchRoll.getPitch(), (double)updateThreshold)) {
                    quaternion.setYawPitchRoll(quaternion.getYaw(), yawPitchRoll.getPitch(), quaternion.getRoll());
                }
            }
            finally {
                updatingQuat.setFalse();
            }
        });
        yawPitchRoll.getYoRoll().addListener(v -> {
            if (updatingYPR.booleanValue()) {
                return;
            }
            updatingQuat.setTrue();
            try {
                if (!EuclidCoreTools.epsilonEquals((double)quaternion.getRoll(), (double)yawPitchRoll.getRoll(), (double)updateThreshold)) {
                    quaternion.setYawPitchRoll(quaternion.getYaw(), quaternion.getPitch(), yawPitchRoll.getRoll());
                }
            }
            finally {
                updatingQuat.setFalse();
            }
        });
    }

    private static void buildVectorListeners(YoFrameQuaternion quaternion, YoFrameVector3D vectorA, YoFrameVector3D vectorB, BiConsumer<Vector3DReadOnly, Vector3DBasics> transformAToB, BiConsumer<Vector3DReadOnly, Vector3DBasics> transformBToA) {
        MutableBoolean updatingA = new MutableBoolean(false);
        MutableBoolean updatingB = new MutableBoolean(false);
        vectorA.attachVariableChangedListener(v -> {
            if (updatingA.booleanValue()) {
                return;
            }
            updatingB.setTrue();
            try {
                transformAToB.accept((Vector3DReadOnly)vectorA, (Vector3DBasics)vectorB);
            }
            finally {
                updatingB.setFalse();
            }
        });
        quaternion.getYoQs().addListener(v -> transformAToB.accept((Vector3DReadOnly)vectorA, (Vector3DBasics)vectorB));
        double updateThreshold = 1.0E-6;
        Vector3D intermediateVector = new Vector3D();
        vectorB.attachVariableChangedListener(v -> {
            if (updatingB.booleanValue()) {
                return;
            }
            updatingA.setTrue();
            try {
                Axis3D axis;
                transformAToB.accept((Vector3DReadOnly)vectorA, (Vector3DBasics)intermediateVector);
                Axis3D axis3D = v == vectorB.getYoX() ? Axis3D.X : (axis = v == vectorB.getYoY() ? Axis3D.Y : Axis3D.Z);
                if (!EuclidCoreTools.epsilonEquals((double)intermediateVector.getElement(axis), (double)vectorB.getElement(axis), (double)updateThreshold)) {
                    intermediateVector.setElement(axis, vectorB.getElement(axis));
                    transformBToA.accept((Vector3DReadOnly)intermediateVector, (Vector3DBasics)vectorA);
                }
            }
            finally {
                updatingA.setFalse();
            }
        });
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }
}

