/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.algorithms.ForwardDynamicsCalculator;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialImpulse;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialVector;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameWrench;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class RobotJointWrenchCalculator {
    private final YoRegistry registry;
    private final Map<JointReadOnly, FixedFrameWrenchBasics> jointWrenchMap;
    private final RobotPhysicsOutput robotPhysicsOutput;
    private final ForwardDynamicsCalculator forwardDynamicsCalculator;

    public RobotJointWrenchCalculator(RobotPhysicsOutput physicsOutput, ForwardDynamicsCalculator forwardDynamicsCalculator, YoRegistry parentRegistry) {
        this.robotPhysicsOutput = physicsOutput;
        this.forwardDynamicsCalculator = forwardDynamicsCalculator;
        this.registry = new YoRegistry(this.getClass().getSimpleName());
        parentRegistry.addChild(this.registry);
        this.jointWrenchMap = new LinkedHashMap<JointReadOnly, FixedFrameWrenchBasics>();
        for (JointReadOnly joint : forwardDynamicsCalculator.getInput().getJointsToConsider()) {
            MovingReferenceFrame successorFrame = joint.getSuccessor().getBodyFixedFrame();
            MovingReferenceFrame frameAfterJoint = joint.getFrameAfterJoint();
            YoFrameVector3D torquePart = new YoFrameVector3D(joint.getName() + "FullTorque", (ReferenceFrame)frameAfterJoint, this.registry);
            YoFrameVector3D forcePart = new YoFrameVector3D(joint.getName() + "FullForce", (ReferenceFrame)frameAfterJoint, this.registry);
            this.jointWrenchMap.put(joint, (FixedFrameWrenchBasics)new YoFixedFrameWrench((ReferenceFrame)successorFrame, new YoFixedFrameSpatialVector(torquePart, forcePart)));
        }
    }

    public void update(double dt) {
        if (this.jointWrenchMap == null) {
            return;
        }
        this.jointWrenchMap.forEach((joint, wrench) -> wrench.set(this.forwardDynamicsCalculator.getJointWrench(joint)));
        if (this.robotPhysicsOutput.getExternalImpulseProvider() != null) {
            LinkedHashMap<JointReadOnly, SpatialImpulseReadOnly> externalImpulseMap = new LinkedHashMap<JointReadOnly, SpatialImpulseReadOnly>();
            this.computeExternalImpulseMap(this.forwardDynamicsCalculator.getInput().getRootBody().getChildrenJoints(), externalImpulseMap);
            SpatialForce tempWrench = new SpatialForce();
            for (JointReadOnly joint2 : externalImpulseMap.keySet()) {
                FixedFrameWrenchBasics jointWrench = this.jointWrenchMap.get(joint2);
                SpatialImpulseReadOnly externalImpulse = (SpatialImpulseReadOnly)externalImpulseMap.get(joint2);
                if (externalImpulse == null) continue;
                tempWrench.setIncludingFrame((SpatialVectorReadOnly)externalImpulse);
                tempWrench.changeFrame(jointWrench.getReferenceFrame());
                tempWrench.scale(dt);
                jointWrench.add((SpatialVectorReadOnly)tempWrench);
            }
        }
    }

    private void computeExternalImpulseMap(Collection<? extends JointReadOnly> joints, Map<JointReadOnly, SpatialImpulseReadOnly> externalImpulseMapToPack) {
        for (JointReadOnly jointReadOnly : joints) {
            this.computeExternalImpulseMap(jointReadOnly, externalImpulseMapToPack);
        }
    }

    private void computeExternalImpulseMap(JointReadOnly joint, Map<JointReadOnly, SpatialImpulseReadOnly> externalImpulseMapToPack) {
        for (JointReadOnly childJoint : joint.getPredecessor().getChildrenJoints()) {
            this.computeExternalImpulseMap(childJoint, externalImpulseMapToPack);
        }
        SpatialImpulse subtreeImpulse = null;
        SpatialImpulseReadOnly externalImpulse = this.robotPhysicsOutput.getExternalImpulseProvider().apply(joint.getSuccessor());
        if (externalImpulse != null) {
            subtreeImpulse = new SpatialImpulse(externalImpulse);
            subtreeImpulse.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
        }
        SpatialImpulse tempImpulse = new SpatialImpulse();
        for (JointReadOnly childJoint : joint.getSuccessor().getChildrenJoints()) {
            SpatialImpulseReadOnly childImpulse = externalImpulseMapToPack.get(childJoint);
            if (childImpulse == null) continue;
            if (subtreeImpulse == null) {
                subtreeImpulse = new SpatialImpulse(childImpulse);
                subtreeImpulse.changeFrame((ReferenceFrame)joint.getFrameAfterJoint());
                continue;
            }
            tempImpulse.setIncludingFrame(childImpulse);
            tempImpulse.changeFrame(subtreeImpulse.getReferenceFrame());
            subtreeImpulse.add((SpatialImpulseReadOnly)tempImpulse);
        }
    }
}

