/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.multiBodySystem;

import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.mecano.tools.MecanoTools;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameSpatialAcceleration;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameTwist;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.simulation.robot.multiBodySystem.SimSixDoFJoint;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimFloatingJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimFloatingRootJoint
extends SimSixDoFJoint
implements SimJointBasics,
SimFloatingJointBasics {
    private final YoRegistry registry;
    private final YoFrameYawPitchRoll jointYawPitchRoll;
    private final YoFrameVector3D jointLinearVelocity;
    private final YoFrameVector3D jointLinearAcceleration;

    public SimFloatingRootJoint(SixDoFJointDefinition definition, SimRigidBodyBasics predecessor) {
        this(definition.getName(), predecessor, (RigidBodyTransformReadOnly)definition.getTransformToParent());
    }

    public SimFloatingRootJoint(String name, SimRigidBodyBasics predecessor) {
        this(name, predecessor, null);
    }

    public SimFloatingRootJoint(String name, SimRigidBodyBasics predecessor, RigidBodyTransformReadOnly transformToParent) {
        super(name, predecessor, transformToParent);
        this.registry = predecessor.getRegistry();
        Object varName = !name.isEmpty() ? "_" + name + "_" : "_";
        this.jointYawPitchRoll = new YoFrameYawPitchRoll("q" + (String)varName, (ReferenceFrame)this.beforeJointFrame, this.registry);
        YoFrameQuaternion jointQuaternion = this.getJointPose().getOrientation();
        MutableBoolean updatingYPR = new MutableBoolean(false);
        MutableBoolean updatingQuat = new MutableBoolean(false);
        jointQuaternion.getYoQs().addListener(v -> {
            if (updatingQuat.booleanValue()) {
                return;
            }
            updatingYPR.setTrue();
            try {
                this.jointYawPitchRoll.set((FrameOrientation3DReadOnly)jointQuaternion);
            }
            finally {
                updatingYPR.setFalse();
            }
        });
        this.jointYawPitchRoll.attachVariableChangedListener(v -> {
            if (updatingYPR.booleanValue()) {
                return;
            }
            updatingQuat.setTrue();
            try {
                jointQuaternion.set((FrameOrientation3DReadOnly)this.jointYawPitchRoll);
            }
            finally {
                updatingQuat.setFalse();
            }
        });
        this.jointLinearVelocity = new YoFrameVector3D("qd" + (String)varName + "world_", (ReferenceFrame)this.beforeJointFrame, this.registry);
        YoFixedFrameTwist jointTwist = this.getJointTwist();
        MutableBoolean updatingLinVel = new MutableBoolean(false);
        MutableBoolean updatingTwist = new MutableBoolean(false);
        jointTwist.getLinearPart().attachVariableChangedListener(v -> {
            if (updatingTwist.booleanValue()) {
                return;
            }
            updatingLinVel.setTrue();
            jointQuaternion.transform((Tuple3DReadOnly)jointTwist.getLinearPart(), (Tuple3DBasics)this.jointLinearVelocity);
            updatingLinVel.setFalse();
        });
        this.jointLinearVelocity.attachVariableChangedListener(v -> {
            if (updatingLinVel.booleanValue()) {
                return;
            }
            updatingTwist.setTrue();
            jointQuaternion.inverseTransform((Tuple3DReadOnly)this.jointLinearVelocity, (Tuple3DBasics)jointTwist.getLinearPart());
            updatingTwist.setFalse();
        });
        this.jointLinearAcceleration = new YoFrameVector3D("qdd" + (String)varName + "world_", (ReferenceFrame)this.beforeJointFrame, this.registry);
        YoFixedFrameSpatialAcceleration jointSpatialAcceleration = this.getJointAcceleration();
        MutableBoolean updatingLinAcc = new MutableBoolean(false);
        MutableBoolean updatingSpAcc = new MutableBoolean(false);
        jointSpatialAcceleration.getLinearPart().attachVariableChangedListener(v -> {
            if (updatingSpAcc.booleanValue()) {
                return;
            }
            updatingLinAcc.setTrue();
            this.jointLinearAcceleration.set((Tuple3DReadOnly)jointSpatialAcceleration.getLinearPart());
            MecanoTools.addCrossToVector((Tuple3DReadOnly)jointTwist.getAngularPart(), (Tuple3DReadOnly)jointTwist.getLinearPart(), (Vector3DBasics)this.jointLinearAcceleration);
            jointQuaternion.transform((Tuple3DBasics)this.jointLinearAcceleration);
            updatingLinAcc.setFalse();
        });
        this.jointLinearAcceleration.attachVariableChangedListener(v -> {
            if (updatingLinAcc.booleanValue()) {
                return;
            }
            updatingSpAcc.setTrue();
            jointQuaternion.inverseTransform((Tuple3DReadOnly)jointSpatialAcceleration.getLinearPart(), (Tuple3DBasics)this.jointLinearAcceleration);
            jointSpatialAcceleration.addCrossToLinearPart((Tuple3DReadOnly)jointTwist.getLinearPart(), (Tuple3DReadOnly)jointTwist.getAngularPart());
            updatingSpAcc.setFalse();
        });
    }

    @Override
    public YoRegistry getRegistry() {
        return this.registry;
    }
}

