/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointMatrixIndexProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SphericalJointReadOnly;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.state.interfaces.JointStateBasics;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotInterface;
import us.ihmc.scs2.simulation.robot.controller.RobotControllerManager;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.state.YoJointState;
import us.ihmc.scs2.simulation.robot.state.YoOneDoFJointState;
import us.ihmc.scs2.simulation.robot.state.YoSixDoFJointState;
import us.ihmc.scs2.simulation.robot.state.YoSphericalJointState;
import us.ihmc.yoVariables.registry.YoRegistry;

public abstract class RobotExtension
implements RobotInterface {
    private final Robot robot;
    private final YoRegistry robotPhysicsRegistry;
    private final RobotState robotBeforePhysicsState;

    public RobotExtension(Robot robot, YoRegistry physicsRegistry) {
        this.robot = robot;
        this.robotPhysicsRegistry = new YoRegistry(robot.getName() + "Physics");
        physicsRegistry.addChild(this.robotPhysicsRegistry);
        this.robotBeforePhysicsState = new RobotState("beforePhysics", this.getRootBody(), this.robotPhysicsRegistry);
    }

    public RobotExtension(RobotDefinition robotDefinition, ReferenceFrame inertialFrame, YoRegistry physicsRegistry) {
        this(new Robot(robotDefinition, inertialFrame), physicsRegistry);
    }

    public Robot getRobot() {
        return this.robot;
    }

    public YoRegistry getRobotPhysicsRegistry() {
        return this.robotPhysicsRegistry;
    }

    public void saveRobotBeforePhysicsState() {
        this.robotBeforePhysicsState.readState();
    }

    public RobotStateDefinition getRobotBeforePhysicsStateDefinition() {
        return this.robotBeforePhysicsState.toRobotStateDefinition(this.robot.getName());
    }

    @Override
    public String getName() {
        return this.robot.getName();
    }

    @Override
    public RobotDefinition getRobotDefinition() {
        return this.robot.getRobotDefinition();
    }

    @Override
    public RobotControllerManager getControllerManager() {
        return this.robot.getControllerManager();
    }

    @Override
    public void resetState() {
        this.robot.resetState();
    }

    @Override
    public void initializeState() {
        this.robot.initializeState();
    }

    @Override
    public SimRigidBodyBasics getRootBody() {
        return this.robot.getRootBody();
    }

    @Override
    public SimRigidBodyBasics getRigidBody(String name) {
        return this.robot.getRigidBody(name);
    }

    @Override
    public SimJointBasics getJoint(String name) {
        return this.robot.getJoint(name);
    }

    @Override
    public List<? extends SimJointBasics> getAllJoints() {
        return this.robot.getAllJoints();
    }

    public ReferenceFrame getInertialFrame() {
        return this.robot.getInertialFrame();
    }

    public JointMatrixIndexProvider getJointMatrixIndexProvider() {
        return this.robot.getJointMatrixIndexProvider();
    }

    @Override
    public List<? extends SimJointBasics> getJointsToConsider() {
        return this.robot.getJointsToConsider();
    }

    @Override
    public List<? extends SimJointBasics> getJointsToIgnore() {
        return this.robot.getJointsToIgnore();
    }

    @Override
    public YoRegistry getRegistry() {
        return this.robot.getRegistry();
    }

    public YoRegistry getSecondaryRegistry() {
        return this.robot.getSecondaryRegistry();
    }

    protected static class RobotState {
        private final List<JointReadOnly> joints = new ArrayList<JointReadOnly>();
        private final List<JointStateBasics> jointStates = new ArrayList<JointStateBasics>();

        public RobotState(String namePrefix, RigidBodyReadOnly rootBody, YoRegistry registry) {
            for (JointReadOnly joint : rootBody.childrenSubtreeIterable()) {
                this.joints.add(joint);
                if (joint instanceof OneDoFJointReadOnly) {
                    this.jointStates.add((JointStateBasics)new YoOneDoFJointState(namePrefix, joint.getName(), registry));
                    continue;
                }
                if (joint instanceof SixDoFJointReadOnly) {
                    this.jointStates.add((JointStateBasics)new YoSixDoFJointState(namePrefix, joint.getName(), registry));
                    continue;
                }
                if (joint instanceof SphericalJointReadOnly) {
                    this.jointStates.add((JointStateBasics)new YoSphericalJointState(namePrefix, joint.getName(), registry));
                    continue;
                }
                this.jointStates.add(new YoJointState(namePrefix, joint.getName(), joint.getConfigurationMatrixSize(), joint.getDegreesOfFreedom(), registry));
            }
        }

        public void readState() {
            for (int i = 0; i < this.joints.size(); ++i) {
                this.jointStates.get(i).set(this.joints.get(i));
            }
        }

        public RobotStateDefinition toRobotStateDefinition(String robotName) {
            RobotStateDefinition definition = new RobotStateDefinition();
            definition.setRobotName(robotName);
            ArrayList<RobotStateDefinition.JointStateEntry> entries = new ArrayList<RobotStateDefinition.JointStateEntry>();
            for (int i = 0; i < this.joints.size(); ++i) {
                entries.add(new RobotStateDefinition.JointStateEntry(this.joints.get(i).getName(), this.jointStates.get(i).copy()));
            }
            definition.setJointStateEntries(entries);
            return definition;
        }
    }
}

