/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyTwistProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class CombinedRigidBodyTwistProviders
implements RigidBodyTwistProvider {
    private final ReferenceFrame inertialFrame;
    private final List<RigidBodyTwistProvider> rigidBodyTwistProviders = new ArrayList<RigidBodyTwistProvider>();
    private final Twist combinedTwist = new Twist();
    private final Twist twist = new Twist();
    private final FrameVector3D linearVelocity = new FrameVector3D();

    public CombinedRigidBodyTwistProviders(ReferenceFrame inertialFrame) {
        this.inertialFrame = inertialFrame;
    }

    public CombinedRigidBodyTwistProviders(CombinedRigidBodyTwistProviders other) {
        this.inertialFrame = other.inertialFrame;
        this.rigidBodyTwistProviders.addAll(other.rigidBodyTwistProviders);
    }

    public void addAll(CombinedRigidBodyTwistProviders other) {
        this.inertialFrame.checkReferenceFrameMatch(other.inertialFrame);
        this.rigidBodyTwistProviders.addAll(other.rigidBodyTwistProviders);
    }

    public void addAll(Collection<? extends RigidBodyTwistProvider> rigidBodyTwistProviders) {
        rigidBodyTwistProviders.forEach(this::add);
    }

    public void add(RigidBodyTwistProvider rigidBodyTwistProvider) {
        if (rigidBodyTwistProvider != null) {
            this.rigidBodyTwistProviders.add(rigidBodyTwistProvider);
        }
    }

    public void removeAll(CombinedRigidBodyTwistProviders other) {
        this.rigidBodyTwistProviders.removeAll(other.rigidBodyTwistProviders);
    }

    public void removeAll(Collection<? extends RigidBodyTwistProvider> rigidBodyTwistProviders) {
        rigidBodyTwistProviders.forEach(this::remove);
    }

    public void remove(RigidBodyTwistProvider rigidBodyTwistProvider) {
        if (rigidBodyTwistProvider != null) {
            this.rigidBodyTwistProviders.remove(rigidBodyTwistProvider);
        }
    }

    public TwistReadOnly getTwistOfBody(RigidBodyReadOnly body) {
        this.combinedTwist.setToZero((ReferenceFrame)body.getBodyFixedFrame(), this.getInertialFrame(), (ReferenceFrame)body.getBodyFixedFrame());
        for (RigidBodyTwistProvider provider : this.rigidBodyTwistProviders) {
            TwistReadOnly singleTwist = provider.getTwistOfBody(body);
            if (singleTwist == null) continue;
            this.combinedTwist.add((SpatialVectorReadOnly)singleTwist);
        }
        return this.combinedTwist;
    }

    public TwistReadOnly getRelativeTwist(RigidBodyReadOnly base, RigidBodyReadOnly body) {
        MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
        TwistReadOnly immutableBaseTwist = this.getTwistOfBody(base);
        if (immutableBaseTwist == null) {
            return null;
        }
        this.twist.setIncludingFrame((SpatialMotionReadOnly)immutableBaseTwist);
        TwistReadOnly immutableBodyTwist = this.getTwistOfBody(body);
        if (immutableBodyTwist == null) {
            return null;
        }
        this.twist.changeFrame((ReferenceFrame)bodyFrame);
        this.twist.sub(immutableBodyTwist);
        this.twist.invert();
        return this.twist;
    }

    public FrameVector3DReadOnly getLinearVelocityOfBodyFixedPoint(RigidBodyReadOnly base, RigidBodyReadOnly body, FramePoint3DReadOnly bodyFixedPoint) {
        if (base != null) {
            this.getRelativeTwist(base, body).getLinearVelocityAt(bodyFixedPoint, (FrameVector3DBasics)this.linearVelocity);
        } else {
            this.getTwistOfBody(body).getLinearVelocityAt(bodyFixedPoint, (FrameVector3DBasics)this.linearVelocity);
        }
        return this.linearVelocity;
    }

    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }
}

